/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;

public final class ObservableError<T>
extends Observable<T> {
    final Supplier<? extends Throwable> errorSupplier;

    public ObservableError(Supplier<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        Throwable error;
        try {
            error = ExceptionHelper.nullCheck(this.errorSupplier.get(), "Supplier returned a null Throwable.");
        }
        catch (Throwable t2) {
            Exceptions.throwIfFatal(t2);
            error = t2;
        }
        EmptyDisposable.error(error, observer);
    }
}

