/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableRetryPredicate<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super Throwable> predicate;
    final long count;

    public ObservableRetryPredicate(Observable<T> source, long count, Predicate<? super Throwable> predicate) {
        super(source);
        this.predicate = predicate;
        this.count = count;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        SequentialDisposable sa = new SequentialDisposable();
        observer.onSubscribe(sa);
        RepeatObserver<T> rs = new RepeatObserver<T>(observer, this.count, this.predicate, sa, this.source);
        rs.subscribeNext();
    }

    static final class RepeatObserver<T>
    extends AtomicInteger
    implements Observer<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Observer<? super T> downstream;
        final SequentialDisposable upstream;
        final ObservableSource<? extends T> source;
        final Predicate<? super Throwable> predicate;
        long remaining;

        RepeatObserver(Observer<? super T> actual, long count, Predicate<? super Throwable> predicate, SequentialDisposable sa, ObservableSource<? extends T> source) {
            this.downstream = actual;
            this.upstream = sa;
            this.source = source;
            this.predicate = predicate;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.upstream.replace(d);
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r == 0L) {
                this.downstream.onError(t2);
            } else {
                boolean b;
                try {
                    b = this.predicate.test(t2);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.downstream.onError(new CompositeException(t2, e));
                    return;
                }
                if (!b) {
                    this.downstream.onError(t2);
                    return;
                }
                this.subscribeNext();
            }
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.upstream.isDisposed()) {
                        return;
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

