/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableThrottleLatest<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean emitLast;
    final Consumer<? super T> onDropped;

    public ObservableThrottleLatest(Observable<T> source, long timeout, TimeUnit unit, Scheduler scheduler, boolean emitLast, Consumer<? super T> onDropped) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new ThrottleLatestObserver<T>(observer, this.timeout, this.unit, this.scheduler.createWorker(), this.emitLast, this.onDropped));
    }

    static final class ThrottleLatestObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -8296689127439125014L;
        final Observer<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final boolean emitLast;
        final AtomicReference<T> latest;
        final Consumer<? super T> onDropped;
        Disposable upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        volatile boolean timerFired;
        boolean timerRunning;

        ThrottleLatestObserver(Observer<? super T> downstream, long timeout, TimeUnit unit, Scheduler.Worker worker, boolean emitLast, Consumer<? super T> onDropped) {
            this.downstream = downstream;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.emitLast = emitLast;
            this.latest = new AtomicReference();
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            T old = this.latest.getAndSet(t2);
            if (this.onDropped != null && old != null) {
                try {
                    this.onDropped.accept(old);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.dispose();
                    this.error = ex;
                    this.done = true;
                }
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.clear();
            }
        }

        void clear() {
            if (this.onDropped != null) {
                Object v = this.latest.getAndSet(null);
                if (v != null) {
                    try {
                        this.onDropped.accept(v);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        RxJavaPlugins.onError(ex);
                    }
                }
            } else {
                this.latest.lazySet(null);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void run() {
            this.timerFired = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<T> latest = this.latest;
            Observer<T> downstream = this.downstream;
            while (true) {
                boolean empty;
                T v;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                boolean d = this.done;
                Throwable error = this.error;
                if (d && error != null) {
                    if (this.onDropped != null) {
                        v = latest.getAndSet(null);
                        if (v != null) {
                            try {
                                this.onDropped.accept(v);
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                error = new CompositeException(error, ex);
                            }
                        }
                    } else {
                        latest.lazySet(null);
                    }
                    downstream.onError(error);
                    this.worker.dispose();
                    return;
                }
                v = latest.get();
                boolean bl = empty = v == null;
                if (d) {
                    if (!empty) {
                        v = latest.getAndSet(null);
                        if (this.emitLast) {
                            downstream.onNext(v);
                        } else if (this.onDropped != null) {
                            try {
                                this.onDropped.accept(v);
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                downstream.onError(ex);
                                this.worker.dispose();
                                return;
                            }
                        }
                    }
                    downstream.onComplete();
                    this.worker.dispose();
                    return;
                }
                if (empty) {
                    if (this.timerFired) {
                        this.timerRunning = false;
                        this.timerFired = false;
                    }
                } else if (!this.timerRunning || this.timerFired) {
                    v = latest.getAndSet(null);
                    downstream.onNext(v);
                    this.timerFired = false;
                    this.timerRunning = true;
                    this.worker.schedule(this, this.timeout, this.unit);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

