/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.observers.SerializedObserver;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWithLatestFrom<T, U, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final ObservableSource<? extends U> other;

    public ObservableWithLatestFrom(ObservableSource<T> source, BiFunction<? super T, ? super U, ? extends R> combiner, ObservableSource<? extends U> other) {
        super(source);
        this.combiner = combiner;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super R> t2) {
        SerializedObserver<R> serial = new SerializedObserver<R>(t2);
        WithLatestFromObserver<? super T, ? super U, ? extends R> wlf = new WithLatestFromObserver<T, U, R>(serial, this.combiner);
        serial.onSubscribe(wlf);
        this.other.subscribe(new WithLatestFromOtherObserver(wlf));
        this.source.subscribe(wlf);
    }

    final class WithLatestFromOtherObserver
    implements Observer<U> {
        private final WithLatestFromObserver<T, U, R> parent;

        WithLatestFromOtherObserver(WithLatestFromObserver<T, U, R> parent) {
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.parent.setOther(d);
        }

        @Override
        public void onNext(U t2) {
            this.parent.lazySet(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.otherError(t2);
        }

        @Override
        public void onComplete() {
        }
    }

    static final class WithLatestFromObserver<T, U, R>
    extends AtomicReference<U>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -312246233408980075L;
        final Observer<? super R> downstream;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final AtomicReference<Disposable> upstream = new AtomicReference();
        final AtomicReference<Disposable> other = new AtomicReference();

        WithLatestFromObserver(Observer<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
            this.downstream = actual;
            this.combiner = combiner;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.upstream, d);
        }

        @Override
        public void onNext(T t2) {
            Object u = this.get();
            if (u != null) {
                R r;
                try {
                    r = Objects.requireNonNull(this.combiner.apply(t2, u), "The combiner returned a null value");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.dispose();
                    this.downstream.onError(e);
                    return;
                }
                this.downstream.onNext(r);
            }
        }

        @Override
        public void onError(Throwable t2) {
            DisposableHelper.dispose(this.other);
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.other);
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this.other);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        public boolean setOther(Disposable o) {
            return DisposableHelper.setOnce(this.other, o);
        }

        public void otherError(Throwable e) {
            DisposableHelper.dispose(this.upstream);
            this.downstream.onError(e);
        }
    }
}

