/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import java.util.Objects;

public final class SingleMap<T, R>
extends Single<R> {
    final SingleSource<? extends T> source;
    final Function<? super T, ? extends R> mapper;

    public SingleMap(SingleSource<? extends T> source, Function<? super T, ? extends R> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> t2) {
        this.source.subscribe(new MapSingleObserver<T, R>(t2, this.mapper));
    }

    static final class MapSingleObserver<T, R>
    implements SingleObserver<T> {
        final SingleObserver<? super R> t;
        final Function<? super T, ? extends R> mapper;

        MapSingleObserver(SingleObserver<? super R> t2, Function<? super T, ? extends R> mapper) {
            this.t = t2;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.t.onSubscribe(d);
        }

        @Override
        public void onSuccess(T value) {
            R v;
            try {
                v = Objects.requireNonNull(this.mapper.apply(value), "The mapper function returned a null value.");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.onError(e);
                return;
            }
            this.t.onSuccess(v);
        }

        @Override
        public void onError(Throwable e) {
            this.t.onError(e);
        }
    }
}

