/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SerializedObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> downstream;
    final boolean delayError;
    static final int QUEUE_LINK_SIZE = 4;
    Disposable upstream;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    public SerializedObserver(@NonNull Observer<? super T> downstream) {
        this(downstream, false);
    }

    public SerializedObserver(@NonNull Observer<? super T> actual, boolean delayError) {
        this.downstream = actual;
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d) {
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.done = true;
        this.upstream.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(@NonNull T t2) {
        if (this.done) {
            return;
        }
        if (t2 == null) {
            this.upstream.dispose();
            this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.next(t2));
                return;
            }
            this.emitting = true;
        }
        this.downstream.onNext(t2);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(@NonNull Throwable t2) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                reportError = true;
            } else {
                if (this.emitting) {
                    this.done = true;
                    AppendOnlyLinkedArrayList<Object> q = this.queue;
                    if (q == null) {
                        q = new AppendOnlyLinkedArrayList(4);
                        this.queue = q;
                    }
                    Object err = NotificationLite.error(t2);
                    if (this.delayError) {
                        q.add(err);
                    } else {
                        q.setFirst(err);
                    }
                    return;
                }
                this.done = true;
                this.emitting = true;
                reportError = false;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.downstream.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.complete());
                return;
            }
            this.done = true;
            this.emitting = true;
        }
        this.downstream.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        AppendOnlyLinkedArrayList<Object> q;
        do {
            SerializedObserver serializedObserver = this;
            synchronized (serializedObserver) {
                q = this.queue;
                if (q == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
        } while (!q.accept(this.downstream));
    }
}

