/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class PublishProcessor<@NonNull T>
extends FlowableProcessor<T> {
    static final PublishSubscription[] TERMINATED = new PublishSubscription[0];
    static final PublishSubscription[] EMPTY = new PublishSubscription[0];
    final AtomicReference<PublishSubscription<T>[]> subscribers = new AtomicReference<PublishSubscription[]>(EMPTY);
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static <T> PublishProcessor<T> create() {
        return new PublishProcessor<T>();
    }

    PublishProcessor() {
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super T> t2) {
        PublishSubscription<T> ps = new PublishSubscription<T>(t2, this);
        t2.onSubscribe(ps);
        if (this.add(ps)) {
            if (ps.isCancelled()) {
                this.remove(ps);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                t2.onError(ex);
            } else {
                t2.onComplete();
            }
        }
    }

    boolean add(PublishSubscription<T> ps) {
        PublishSubscription[] b;
        PublishSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new PublishSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(PublishSubscription<T> ps) {
        PublishSubscription[] b;
        PublishSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                return;
            }
            int n = a.length;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new PublishSubscription[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    @Override
    public void onSubscribe(@NonNull Subscription s2) {
        if (this.subscribers.get() == TERMINATED) {
            s2.cancel();
            return;
        }
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(@NonNull T t2) {
        ExceptionHelper.nullCheck(t2, "onNext called with a null value.");
        for (PublishSubscription<T> s2 : this.subscribers.get()) {
            s2.onNext(t2);
        }
    }

    @Override
    public void onError(@NonNull Throwable t2) {
        ExceptionHelper.nullCheck(t2, "onError called with a null Throwable.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        for (PublishSubscription s2 : this.subscribers.getAndSet(TERMINATED)) {
            s2.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (PublishSubscription s2 : this.subscribers.getAndSet(TERMINATED)) {
            s2.onComplete();
        }
    }

    @CheckReturnValue
    public boolean offer(@NonNull T t2) {
        PublishSubscription<T>[] array;
        ExceptionHelper.nullCheck(t2, "offer called with a null value.");
        for (PublishSubscription<T> s2 : array = this.subscribers.get()) {
            if (!s2.isFull()) continue;
            return false;
        }
        for (PublishSubscription<T> s2 : array) {
            s2.onNext(t2);
        }
        return true;
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        if (this.subscribers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    static final class PublishSubscription<@NonNull T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = 3562861878281475070L;
        final Subscriber<? super T> downstream;
        final PublishProcessor<T> parent;

        PublishSubscription(Subscriber<? super T> actual, PublishProcessor<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        public void onNext(T t2) {
            long r = this.get();
            if (r == Long.MIN_VALUE) {
                return;
            }
            if (r != 0L) {
                this.downstream.onNext(t2);
                BackpressureHelper.producedCancel(this, 1L);
            } else {
                this.cancel();
                this.downstream.onError(MissingBackpressureException.createDefault());
            }
        }

        public void onError(Throwable t2) {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onError(t2);
            } else {
                RxJavaPlugins.onError(t2);
            }
        }

        public void onComplete() {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.addCancel(this, n);
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }

        boolean isFull() {
            return this.get() == 0L;
        }
    }
}

