/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.babelfish;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumMap;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTranslatingConnection;
import oracle.jdbc.babelfish.BabelfishGenericProxy;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.GetProxy;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;

@ProxyFor(value={Connection.class, OracleConnection.class, oracle.jdbc.internal.OracleConnection.class})
@ProxyLocale
public abstract class BabelfishConnection
extends BabelfishGenericProxy
implements OracleTranslatingConnection {
    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @GetProxy
    protected abstract Object proxify(Object var1, Object var2);

    @Override
    @OnError(value=SQLException.class)
    protected Object translateError(Method m4, SQLException ex) throws SQLException {
        throw this.translator.translateError(ex);
    }

    @Override
    @Post
    protected Object post_Methods(Method m4, Object result) {
        if (result instanceof BabelfishGenericProxy) {
            ((BabelfishGenericProxy)result).setTranslator(this.translator);
        }
        return result;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            PreparedStatement pstmt = (PreparedStatement)this.proxify(((Connection)this.getDelegate()).prepareStatement(translatedSql), this);
            ((BabelfishGenericProxy)((Object)pstmt)).setTranslator(this.translator);
            return pstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            PreparedStatement pstmt = (PreparedStatement)this.proxify(((Connection)this.getDelegate()).prepareStatement(translatedSql, autoGeneratedKeys), this);
            ((BabelfishGenericProxy)((Object)pstmt)).setTranslator(this.translator);
            return pstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            PreparedStatement pstmt = (PreparedStatement)this.proxify(((Connection)this.getDelegate()).prepareStatement(translatedSql, columnIndexes), this);
            ((BabelfishGenericProxy)((Object)pstmt)).setTranslator(this.translator);
            return pstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            PreparedStatement pstmt = (PreparedStatement)this.proxify(((Connection)this.getDelegate()).prepareStatement(translatedSql, columnNames), this);
            ((BabelfishGenericProxy)((Object)pstmt)).setTranslator(this.translator);
            return pstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            PreparedStatement pstmt = (PreparedStatement)this.proxify(((Connection)this.getDelegate()).prepareStatement(translatedSql, resultSetType, resultSetConcurrency), this);
            ((BabelfishGenericProxy)((Object)pstmt)).setTranslator(this.translator);
            return pstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            PreparedStatement pstmt = (PreparedStatement)this.proxify(((Connection)this.getDelegate()).prepareStatement(translatedSql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
            ((BabelfishGenericProxy)((Object)pstmt)).setTranslator(this.translator);
            return pstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            CallableStatement cstmt = (CallableStatement)this.proxify(((Connection)this.getDelegate()).prepareCall(translatedSql), this);
            ((BabelfishGenericProxy)((Object)cstmt)).setTranslator(this.translator);
            return cstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            CallableStatement cstmt = (CallableStatement)this.proxify(((Connection)this.getDelegate()).prepareCall(translatedSql, resultSetType, resultSetConcurrency), this);
            ((BabelfishGenericProxy)((Object)cstmt)).setTranslator(this.translator);
            return cstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            CallableStatement cstmt = (CallableStatement)this.proxify(((Connection)this.getDelegate()).prepareCall(translatedSql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
            ((BabelfishGenericProxy)((Object)cstmt)).setTranslator(this.translator);
            return cstmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Connection)this.getDelegate()).nativeSQL(translatedSql);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public void close() throws SQLException {
        this.translator.deactivateServerTranslation();
        ((Connection)this.getDelegate()).close();
    }

    public Statement createStatement() throws SQLException {
        try {
            Statement stmt = (Statement)this.proxify(((Connection)this.getDelegate()).createStatement(), this);
            ((BabelfishGenericProxy)((Object)stmt)).setTranslator(this.translator);
            return stmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    @Override
    public Statement createStatement(boolean translation) throws SQLException {
        Statement stmt = !translation ? ((Connection)this.getDelegate()).createStatement() : this.createStatement();
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            Statement stmt = (Statement)this.proxify(((Connection)this.getDelegate()).createStatement(resultSetType, resultSetConcurrency), this);
            ((BabelfishGenericProxy)((Object)stmt)).setTranslator(this.translator);
            return stmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, boolean translation) throws SQLException {
        Statement stmt = !translation ? ((Connection)this.getDelegate()).createStatement(resultSetType, resultSetConcurrency) : this.createStatement(resultSetType, resultSetConcurrency);
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            Statement stmt = (Statement)this.proxify(((Connection)this.getDelegate()).createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
            ((BabelfishGenericProxy)((Object)stmt)).setTranslator(this.translator);
            return stmt;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean translation) throws SQLException {
        Statement stmt = !translation ? ((Connection)this.getDelegate()).createStatement(resultSetType, resultSetConcurrency, resultSetHoldability) : this.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, boolean translation) throws SQLException {
        PreparedStatement pstmt = !translation ? ((Connection)this.getDelegate()).prepareStatement(sql) : this.prepareStatement(sql);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys, boolean translation) throws SQLException {
        PreparedStatement pstmt = !translation ? ((Connection)this.getDelegate()).prepareStatement(sql, autoGeneratedKeys) : this.prepareStatement(sql, autoGeneratedKeys);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes, boolean translation) throws SQLException {
        PreparedStatement pstmt = !translation ? ((Connection)this.getDelegate()).prepareStatement(sql, columnIndexes) : this.prepareStatement(sql, columnIndexes);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames, boolean translation) throws SQLException {
        PreparedStatement pstmt = !translation ? ((Connection)this.getDelegate()).prepareStatement(sql, columnNames) : this.prepareStatement(sql, columnNames);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, boolean translation) throws SQLException {
        PreparedStatement pstmt = !translation ? ((Connection)this.getDelegate()).prepareStatement(sql, resultSetType, resultSetConcurrency) : this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean translation) throws SQLException {
        PreparedStatement pstmt = !translation ? ((Connection)this.getDelegate()).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability) : this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return pstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, boolean translation) throws SQLException {
        CallableStatement cstmt = !translation ? ((Connection)this.getDelegate()).prepareCall(sql) : this.prepareCall(sql);
        return cstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, boolean translation) throws SQLException {
        CallableStatement cstmt = !translation ? ((Connection)this.getDelegate()).prepareCall(sql, resultSetType, resultSetConcurrency) : this.prepareCall(sql, resultSetType, resultSetConcurrency);
        return cstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean translation) throws SQLException {
        CallableStatement cstmt = !translation ? ((Connection)this.getDelegate()).prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability) : this.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return cstmt;
    }

    @Override
    public Map<OracleTranslatingConnection.SqlTranslationVersion, String> getSqlTranslationVersions(String sql, boolean suppressExceptions) throws SQLException {
        EnumMap<OracleTranslatingConnection.SqlTranslationVersion, String> translationMap = new EnumMap<OracleTranslatingConnection.SqlTranslationVersion, String>(OracleTranslatingConnection.SqlTranslationVersion.class);
        translationMap.put(OracleTranslatingConnection.SqlTranslationVersion.ORIGINAL_SQL, sql);
        String tempStr = this.translator.convertParameterMarkersToOracleStyle(sql);
        translationMap.put(OracleTranslatingConnection.SqlTranslationVersion.JDBC_MARKER_CONVERTED, tempStr);
        try {
            tempStr = this.translator.translateQuery(sql);
            translationMap.put(OracleTranslatingConnection.SqlTranslationVersion.TRANSLATED, tempStr);
        }
        catch (SQLException ex) {
            if (suppressExceptions) {
                translationMap.put(OracleTranslatingConnection.SqlTranslationVersion.TRANSLATED, null);
            }
            throw ex;
        }
        return translationMap;
    }
}

