/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.AbstractTrueCacheConnection;
import oracle.jdbc.driver.AbstractTrueCachePreparedStatement;
import oracle.jdbc.driver.AbstractTrueCacheStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@ProxyFor(value={OracleCallableStatement.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractTrueCacheCallableStatement
extends AbstractTrueCachePreparedStatement {
    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @GetDelegate
    protected abstract Statement getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Statement var1);

    public void setArray(String parameterName, Array x) throws SQLException {
        this.setArrayAtName(parameterName, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimalAtName(parameterName, x);
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlobAtName(parameterName, x);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBooleanAtName(parameterName, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByteAtName(parameterName, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytesAtName(parameterName, x);
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClobAtName(parameterName, x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDateAtName(parameterName, x);
    }

    public void setDate(String parameterName, Date x, Calendar y) throws SQLException {
        this.setDateAtName(parameterName, x, y);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDoubleAtName(parameterName, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloatAtName(parameterName, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setIntAtName(parameterName, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.setLongAtName(parameterName, x);
    }

    public void setNClob(String parameterName, NClob x) throws SQLException {
        this.setNClobAtName(parameterName, x);
    }

    public void setNString(String parameterName, String x) throws SQLException {
        this.setNStringAtName(parameterName, x);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObjectAtName(parameterName, x);
    }

    public void setObject(String parameterName, Object x, int y) throws SQLException {
        this.setObjectAtName(parameterName, x, y);
    }

    public void setRef(String parameterName, Ref x) throws SQLException {
        this.setRefAtName(parameterName, x);
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.setRowIdAtName(parameterName, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShortAtName(parameterName, x);
    }

    public void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        this.setSQLXMLAtName(parameterName, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setStringAtName(parameterName, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTimeAtName(parameterName, x);
    }

    public void setTime(String parameterName, Time x, Calendar y) throws SQLException {
        this.setTimeAtName(parameterName, x, y);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestampAtName(parameterName, x);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar y) throws SQLException {
        this.setTimestampAtName(parameterName, x, y);
    }

    public void setURL(String parameterName, URL x) throws SQLException {
        this.setURLAtName(parameterName, x);
    }

    public void setARRAY(String parameterName, ARRAY x) throws SQLException {
        this.setARRAYAtName(parameterName, x);
    }

    public void setBFILE(String parameterName, BFILE x) throws SQLException {
        this.setBFILEAtName(parameterName, x);
    }

    public void setBfile(String parameterName, BFILE x) throws SQLException {
        this.setBfileAtName(parameterName, x);
    }

    public void setBinaryFloat(String parameterName, float x) throws SQLException {
        this.setBinaryFloatAtName(parameterName, x);
    }

    public void setBinaryFloat(String parameterName, BINARY_FLOAT x) throws SQLException {
        this.setBinaryFloatAtName(parameterName, x);
    }

    public void setBinaryDouble(String parameterName, double x) throws SQLException {
        this.setBinaryDoubleAtName(parameterName, x);
    }

    public void setBinaryDouble(String parameterName, BINARY_DOUBLE x) throws SQLException {
        this.setBinaryDoubleAtName(parameterName, x);
    }

    public void setBLOB(String parameterName, BLOB x) throws SQLException {
        this.setBLOBAtName(parameterName, x);
    }

    public void setCHAR(String parameterName, CHAR x) throws SQLException {
        this.setCHARAtName(parameterName, x);
    }

    public void setCLOB(String parameterName, CLOB x) throws SQLException {
        this.setCLOBAtName(parameterName, x);
    }

    public void setCursor(String parameterName, ResultSet x) throws SQLException {
        this.setCursorAtName(parameterName, x);
    }

    public void setDATE(String parameterName, DATE x) throws SQLException {
        this.setDATEAtName(parameterName, x);
    }

    public void setFixedCHAR(String parameterName, String x) throws SQLException {
        this.setFixedCHARAtName(parameterName, x);
    }

    public void setINTERVALDS(String parameterName, INTERVALDS x) throws SQLException {
        this.setINTERVALDSAtName(parameterName, x);
    }

    public void setINTERVALYM(String parameterName, INTERVALYM x) throws SQLException {
        this.setINTERVALYMAtName(parameterName, x);
    }

    public void setNUMBER(String parameterName, NUMBER x) throws SQLException {
        this.setNUMBERAtName(parameterName, x);
    }

    public void setOPAQUE(String parameterName, OPAQUE x) throws SQLException {
        this.setOPAQUEAtName(parameterName, x);
    }

    public void setOracleObject(String parameterName, Datum x) throws SQLException {
        this.setOracleObjectAtName(parameterName, x);
    }

    public void setORAData(String parameterName, ORAData x) throws SQLException {
        this.setORADataAtName(parameterName, x);
    }

    public void setRAW(String parameterName, RAW x) throws SQLException {
        this.setRAWAtName(parameterName, x);
    }

    public void setREF(String parameterName, REF x) throws SQLException {
        this.setREFAtName(parameterName, x);
    }

    public void setRefType(String parameterName, REF x) throws SQLException {
        this.setRefTypeAtName(parameterName, x);
    }

    public void setROWID(String parameterName, ROWID x) throws SQLException {
        this.setROWIDAtName(parameterName, x);
    }

    public void setSTRUCT(String parameterName, STRUCT x) throws SQLException {
        this.setSTRUCTAtName(parameterName, x);
    }

    public void setTIMESTAMPLTZ(String parameterName, TIMESTAMPLTZ x) throws SQLException {
        this.setTIMESTAMPLTZAtName(parameterName, x);
    }

    public void setTIMESTAMPTZ(String parameterName, TIMESTAMPTZ x) throws SQLException {
        this.setTIMESTAMPTZAtName(parameterName, x);
    }

    public void setTIMESTAMP(String parameterName, TIMESTAMP x) throws SQLException {
        this.setTIMESTAMPAtName(parameterName, x);
    }

    public void setCustomDatum(String parameterName, CustomDatum x) throws SQLException {
        this.setCustomDatumAtName(parameterName, x);
    }

    public void setBlob(String parameterName, InputStream x) throws SQLException {
        this.setBlobAtName(parameterName, x);
    }

    public void setBlob(String parameterName, InputStream x, long y) throws SQLException {
        this.setBlobAtName(parameterName, x, y);
    }

    public void setClob(String parameterName, Reader x) throws SQLException {
        this.setClobAtName(parameterName, x);
    }

    public void setClob(String parameterName, Reader x, long y) throws SQLException {
        this.setClobAtName(parameterName, x, y);
    }

    public void setNClob(String parameterName, Reader x) throws SQLException {
        this.setNClobAtName(parameterName, x);
    }

    public void setNClob(String parameterName, Reader x, long y) throws SQLException {
        this.setNClobAtName(parameterName, x, y);
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStreamAtName(parameterName, x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int y) throws SQLException {
        this.setAsciiStreamAtName(parameterName, x, y);
    }

    public void setAsciiStream(String parameterName, InputStream x, long y) throws SQLException {
        this.setAsciiStreamAtName(parameterName, x, y);
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStreamAtName(parameterName, x);
    }

    public void setBinaryStream(String parameterName, InputStream x, int y) throws SQLException {
        this.setBinaryStreamAtName(parameterName, x, y);
    }

    public void setBinaryStream(String parameterName, InputStream x, long y) throws SQLException {
        this.setBinaryStreamAtName(parameterName, x, y);
    }

    public void setCharacterStream(String parameterName, Reader x) throws SQLException {
        this.setCharacterStreamAtName(parameterName, x);
    }

    public void setCharacterStream(String parameterName, Reader x, int y) throws SQLException {
        this.setCharacterStreamAtName(parameterName, x, y);
    }

    public void setCharacterStream(String parameterName, Reader x, long y) throws SQLException {
        this.setCharacterStreamAtName(parameterName, x, y);
    }

    public void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        this.setNCharacterStreamAtName(parameterName, x);
    }

    public void setNCharacterStream(String parameterName, Reader x, long y) throws SQLException {
        this.setNCharacterStreamAtName(parameterName, x, y);
    }

    public void setUnicodeStream(String parameterName, InputStream x, int y) throws SQLException {
        this.setUnicodeStreamAtName(parameterName, x, y);
    }

    public void setNull(String parameterName, int x, String y) throws SQLException {
        this.setNullAtName(parameterName, x, y);
    }

    public void setNull(String parameterName, int x) throws SQLException {
        this.setNullAtName(parameterName, x);
    }

    public void setStructDescriptor(String parameterName, StructDescriptor x) throws SQLException {
        this.setStructDescriptorAtName(parameterName, x);
    }

    public void setStringForClob(String parameterName, String x) throws SQLException {
        this.setStringForClobAtName(parameterName, x);
    }

    public void setBytesForBlob(String parameterName, byte[] x) throws SQLException {
        this.setBytesForBlobAtName(parameterName, x);
    }

    public void registerOutParameter(int paramIndex, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y, z};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameterBytes(int paramIndex, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterBytes";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y, z};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameterChars(int paramIndex, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterChars";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y, z};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameter(int paramIndex, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameter(int paramIndex, int x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameter(int paramIndex, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerIndexTableOutParameter(int paramIndex, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerIndexTableOutParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y, z};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameter(String parameterName, int x, int y, int z) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y, z};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameterAtName(String parameterName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameterAtName(String parameterName, int x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameterAtName(String parameterName, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameterAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, String.class};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameter(String parameterName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{String.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameter(String parameterName, int x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public void registerOutParameter(String parameterName, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerOutParameter";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, String.class};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.addToBindMap(paramIndex, entry);
        }
    }

    public ARRAY getARRAY(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                ARRAY aRRAY = cstmt.getARRAY(paramIndex);
                return aRRAY;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public InputStream getAsciiStream(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                InputStream inputStream = cstmt.getAsciiStream(paramIndex);
                return inputStream;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public BFILE getBFILE(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                BFILE bFILE = cstmt.getBFILE(paramIndex);
                return bFILE;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public BFILE getBfile(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                BFILE bFILE = cstmt.getBfile(paramIndex);
                return bFILE;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public InputStream getBinaryStream(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                InputStream inputStream = cstmt.getBinaryStream(paramIndex);
                return inputStream;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public BLOB getBLOB(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                BLOB bLOB = cstmt.getBLOB(paramIndex);
                return bLOB;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public CHAR getCHAR(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                CHAR cHAR = cstmt.getCHAR(paramIndex);
                return cHAR;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Reader getCharacterStream(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Reader reader = cstmt.getCharacterStream(paramIndex);
                return reader;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public CLOB getCLOB(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                CLOB cLOB = cstmt.getCLOB(paramIndex);
                return cLOB;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getCustomDatum(int paramIndex, CustomDatumFactory y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getCustomDatum(paramIndex, y);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getORAData(int paramIndex, ORADataFactory y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getORAData(paramIndex, y);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getObject(int paramIndex, OracleDataFactory y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getObject(paramIndex, y);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getAnyDataEmbeddedObject(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getAnyDataEmbeddedObject(paramIndex);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public DATE getDATE(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                DATE dATE = cstmt.getDATE(paramIndex);
                return dATE;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public NUMBER getNUMBER(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                NUMBER nUMBER = cstmt.getNUMBER(paramIndex);
                return nUMBER;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public OPAQUE getOPAQUE(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                OPAQUE oPAQUE = cstmt.getOPAQUE(paramIndex);
                return oPAQUE;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Datum getOracleObject(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Datum datum = cstmt.getOracleObject(paramIndex);
                return datum;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public RAW getRAW(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                RAW rAW = cstmt.getRAW(paramIndex);
                return rAW;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public REF getREF(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                REF rEF = cstmt.getREF(paramIndex);
                return rEF;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public ROWID getROWID(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                ROWID rOWID = cstmt.getROWID(paramIndex);
                return rOWID;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public STRUCT getSTRUCT(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                STRUCT sTRUCT = cstmt.getSTRUCT(paramIndex);
                return sTRUCT;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public INTERVALYM getINTERVALYM(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                INTERVALYM iNTERVALYM = cstmt.getINTERVALYM(paramIndex);
                return iNTERVALYM;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public INTERVALDS getINTERVALDS(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                INTERVALDS iNTERVALDS = cstmt.getINTERVALDS(paramIndex);
                return iNTERVALDS;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public TIMESTAMP getTIMESTAMP(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                TIMESTAMP tIMESTAMP = cstmt.getTIMESTAMP(paramIndex);
                return tIMESTAMP;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                TIMESTAMPTZ tIMESTAMPTZ = cstmt.getTIMESTAMPTZ(paramIndex);
                return tIMESTAMPTZ;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                TIMESTAMPLTZ tIMESTAMPLTZ = cstmt.getTIMESTAMPLTZ(paramIndex);
                return tIMESTAMPLTZ;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public InputStream getUnicodeStream(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                InputStream inputStream = cstmt.getUnicodeStream(paramIndex);
                return inputStream;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getPlsqlIndexTable(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getPlsqlIndexTable(paramIndex);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getPlsqlIndexTable(int paramIndex, Class<?> y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getPlsqlIndexTable(paramIndex, y);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Datum[] getOraclePlsqlIndexTable(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Datum[] datumArray = cstmt.getOraclePlsqlIndexTable(paramIndex);
                return datumArray;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Array getArray(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Array array = cstmt.getArray(paramIndex);
                return array;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public BigDecimal getBigDecimal(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                BigDecimal bigDecimal = cstmt.getBigDecimal(paramIndex);
                return bigDecimal;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public BigDecimal getBigDecimal(int paramIndex, int y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                BigDecimal bigDecimal = cstmt.getBigDecimal(paramIndex, y);
                return bigDecimal;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Blob getBlob(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Blob blob = cstmt.getBlob(paramIndex);
                return blob;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean getBoolean(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                boolean bl = cstmt.getBoolean(paramIndex);
                return bl;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public byte getByte(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                byte by = cstmt.getByte(paramIndex);
                return by;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public byte[] getBytes(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                byte[] byArray = cstmt.getBytes(paramIndex);
                return byArray;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Clob getClob(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Clob clob = cstmt.getClob(paramIndex);
                return clob;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Date getDate(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Date date = cstmt.getDate(paramIndex);
                return date;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Date getDate(int paramIndex, Calendar y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Date date = cstmt.getDate(paramIndex, y);
                return date;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public double getDouble(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                double d = cstmt.getDouble(paramIndex);
                return d;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public float getFloat(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                float f = cstmt.getFloat(paramIndex);
                return f;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public int getInt(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                int n = cstmt.getInt(paramIndex);
                return n;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public long getLong(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                long l = cstmt.getLong(paramIndex);
                return l;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Reader getNCharacterStream(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Reader reader = cstmt.getNCharacterStream(paramIndex);
                return reader;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public NClob getNClob(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                NClob nClob = cstmt.getNClob(paramIndex);
                return nClob;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String getNString(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                String string = cstmt.getNString(paramIndex);
                return string;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getObject(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getObject(paramIndex);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getObject(int paramIndex, Map<String, Class<?>> y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getObject(paramIndex, y);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Ref getRef(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Ref ref = cstmt.getRef(paramIndex);
                return ref;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public RowId getRowId(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                RowId rowId = cstmt.getRowId(paramIndex);
                return rowId;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public SQLXML getSQLXML(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                SQLXML sQLXML = cstmt.getSQLXML(paramIndex);
                return sQLXML;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public short getShort(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                short s2 = cstmt.getShort(paramIndex);
                return s2;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String getString(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                String string = cstmt.getString(paramIndex);
                return string;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Time getTime(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Time time = cstmt.getTime(paramIndex);
                return time;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Time getTime(int paramIndex, Calendar y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Time time = cstmt.getTime(paramIndex, y);
                return time;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Timestamp getTimestamp(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Timestamp timestamp = cstmt.getTimestamp(paramIndex);
                return timestamp;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Timestamp getTimestamp(int paramIndex, Calendar y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Timestamp timestamp = cstmt.getTimestamp(paramIndex, y);
                return timestamp;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public URL getURL(int paramIndex) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                URL uRL = cstmt.getURL(paramIndex);
                return uRL;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public InputStream getAsciiStream(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                InputStream inputStream = cstmt.getAsciiStream(parameterName);
                return inputStream;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public InputStream getBinaryStream(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                InputStream inputStream = cstmt.getBinaryStream(parameterName);
                return inputStream;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Reader getCharacterStream(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Reader reader = cstmt.getCharacterStream(parameterName);
                return reader;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public InputStream getUnicodeStream(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                InputStream inputStream = cstmt.getUnicodeStream(parameterName);
                return inputStream;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Array getArray(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Array array = cstmt.getArray(parameterName);
                return array;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                BigDecimal bigDecimal = cstmt.getBigDecimal(parameterName);
                return bigDecimal;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public BigDecimal getBigDecimal(String parameterName, int y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                BigDecimal bigDecimal = cstmt.getBigDecimal(parameterName, y);
                return bigDecimal;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Blob getBlob(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Blob blob = cstmt.getBlob(parameterName);
                return blob;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                boolean bl = cstmt.getBoolean(parameterName);
                return bl;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public byte getByte(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                byte by = cstmt.getByte(parameterName);
                return by;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                byte[] byArray = cstmt.getBytes(parameterName);
                return byArray;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Clob getClob(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Clob clob = cstmt.getClob(parameterName);
                return clob;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Date getDate(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Date date = cstmt.getDate(parameterName);
                return date;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Date getDate(String parameterName, Calendar y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Date date = cstmt.getDate(parameterName, y);
                return date;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public double getDouble(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                double d = cstmt.getDouble(parameterName);
                return d;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public float getFloat(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                float f = cstmt.getFloat(parameterName);
                return f;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public int getInt(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                int n = cstmt.getInt(parameterName);
                return n;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public long getLong(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                long l = cstmt.getLong(parameterName);
                return l;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Reader getNCharacterStream(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Reader reader = cstmt.getNCharacterStream(parameterName);
                return reader;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public NClob getNClob(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                NClob nClob = cstmt.getNClob(parameterName);
                return nClob;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String getNString(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                String string = cstmt.getNString(parameterName);
                return string;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getObject(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getObject(parameterName);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getObject(String parameterName, Map<String, Class<?>> y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Object object = cstmt.getObject(parameterName, y);
                return object;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Ref getRef(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Ref ref = cstmt.getRef(parameterName);
                return ref;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public RowId getRowId(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                RowId rowId = cstmt.getRowId(parameterName);
                return rowId;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public SQLXML getSQLXML(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                SQLXML sQLXML = cstmt.getSQLXML(parameterName);
                return sQLXML;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public short getShort(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                short s2 = cstmt.getShort(parameterName);
                return s2;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String getString(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                String string = cstmt.getString(parameterName);
                return string;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Time getTime(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Time time = cstmt.getTime(parameterName);
                return time;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Time getTime(String parameterName, Calendar y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Time time = cstmt.getTime(parameterName, y);
                return time;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Timestamp timestamp = cstmt.getTimestamp(parameterName);
                return timestamp;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Timestamp getTimestamp(String parameterName, Calendar y) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                Timestamp timestamp = cstmt.getTimestamp(parameterName, y);
                return timestamp;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public URL getURL(String parameterName) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                URL uRL = cstmt.getURL(parameterName);
                return uRL;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public byte[] privateGetBytes(int parameterIndex) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                byte[] byArray = cstmt.privateGetBytes(parameterIndex);
                return byArray;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean wasNull() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                boolean bl = cstmt.wasNull();
                return bl;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObjectAtName(parameterName, x, targetSqlType, scale);
    }

    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                T t2 = cstmt.getObject(parameterIndex, type);
                return t2;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            OracleCallableStatement cstmt = (OracleCallableStatement)this.getDelegate();
            if (cstmt != null) {
                T t2 = cstmt.getObject(parameterName, type);
                return t2;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        ResultSet result;
        block14: {
            result = null;
            try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
                OracleCallableStatement callableStatement = (OracleCallableStatement)this.getDelegate();
                if (callableStatement != null) {
                    result = callableStatement.getCursor(parameterIndex);
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                    }
                    break block14;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="execute", args={}), @Signature(name="executeUpdate", args={})})
    protected void prePstmtExecuteQuery(Method m4, Object receiver, Object ... args) {
        super.prePstmtExecuteQuery(m4, receiver, args);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={})})
    protected ResultSet postPstmtExecuteQuery(Method m4, ResultSet result) {
        return super.postPstmtExecuteQuery(m4, result);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="executeUpdate", args={})})
    protected Object postPstmtExecuteUpdate(Method m4, Object result) {
        return super.postPstmtExecuteUpdate(m4, result);
    }

    @OnError(value=SQLException.class)
    protected Object onErrorCstmt(Method m4, SQLException e) throws SQLException {
        return super.onErrorPstmt(m4, e);
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={String.class}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preStmtExecuteQuery(Method m4, Object receiver, Object ... args) {
        super.preStmtExecuteQuery(m4, receiver, args);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={String.class})})
    protected ResultSet postStmtExecuteQuery(Method m4, ResultSet result) {
        return super.postStmtExecuteQuery(m4, result);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected Object postStmtExecuteUpdate(Method m4, Object result) {
        return super.postStmtExecuteUpdate(m4, result);
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={}), @Signature(name="setShardingKeyRpnTokens", args={byte[].class}), @Signature(name="getShardingKeyRpnTokens", args={}), @Signature(name="setCursorName", args={String.class}), @Signature(name="getserverCursor", args={})})
    protected void preUnsupportedStatementMethods(Method m4, Object receiver, Object ... args) {
        super.preUnsupportedStatementMethods(m4, receiver, args);
    }

    @Override
    protected OraclePreparedStatement createPreparedStatement(OracleConnection connection, String sql) throws SQLException {
        return (OraclePreparedStatement)((Object)connection.prepareCall(sql, this.resultSetType.getType(), this.resultSetType.getConcur()));
    }
}

