/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.OutputStream;
import java.net.SocketException;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.spec.InvalidKeySpecException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.transaction.xa.XAResource;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.ClosedConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.jdbc.internal.DatabaseSessionState;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.PDBChangeEventListener;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.internal.ResultSetCache;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.internal.XSSessionParameters;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;

public class LogicalConnection
extends OracleConnection {
    private static final String CLASS_NAME = LogicalConnection.class.getName();
    static final ClosedConnection closedConnection = new ClosedConnection();
    protected oracle.jdbc.internal.OracleConnection internalConnection;
    OraclePooledConnection pooledConnection;
    boolean closed;
    OracleCloseCallback closeCallback = null;
    Object privateData = null;
    LogicalTransactionId ltxidBeforeLogicalClose = null;
    static final boolean jtaWLSEnabled = "true".equals(LogicalConnection.getSystemProperty("oracle.ucp.wls.jta", "false"));
    private static final boolean DEBUG = false;

    protected LogicalConnection(OraclePooledConnection _pooledConnection, oracle.jdbc.internal.OracleConnection _internalConnection, boolean autoCommit) throws SQLException {
        this.internalConnection = _internalConnection;
        this.pooledConnection = _pooledConnection;
        this.connection = this.internalConnection;
        this.connection.setWrapper(this);
        this.closed = false;
        this.internalConnection.setAutoCommit(autoCommit);
    }

    @Override
    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        return this.internalConnection;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.internalConnection;
    }

    public void registerCloseCallback(OracleCloseCallback occ, Object privData) {
        try (Monitor.CloseableLock lock = this.internalConnection.acquireCloseableLock();){
            this.closeCallback = occ;
            this.privateData = privData;
        }
    }

    @Override
    public Connection _getPC() {
        return this.internalConnection;
    }

    @Override
    public boolean isLogicalConnection() {
        return true;
    }

    @Override
    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this.internalConnection;
    }

    @Override
    public Connection getLogicalConnection(OraclePooledConnection pc, boolean autoCommit) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153).fillInStackTrace();
    }

    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153).fillInStackTrace();
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.internalConnection.acquireCloseableLock();){
            this.doClose();
        }
    }

    private void doClose() throws SQLException {
        this.beginNonRequestCalls();
        boolean flag = true;
        try {
            flag = this.internalConnection.isUsable();
        }
        catch (Throwable err) {
            flag = false;
        }
        finally {
            this.endNonRequestCalls();
        }
        if (jtaWLSEnabled) {
            Transaction tx = (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
            this.testlog("##### LogicalConnection.close(): successfully got Transaction object from WLS");
            if (tx != null) {
                this.delist(tx, this.getXAResource());
            }
        }
        this.closeInternal(flag);
    }

    private void delist(Transaction tx, XAResource xar) throws SQLException {
        SQLException se = null;
        try {
            Properties delistProps = new Properties();
            delistProps.put("weblogic.transaction.eager.end.on.delist", (Object)true);
            tx.delistResourceWithProperties(xar, 0x4000000, (Map)delistProps);
            this.testlog("##### LogicalConnection.close(): successfully delisted XAResource with WLS: " + xar);
        }
        catch (Exception ex) {
            this.testlog("##### LogicalConnection.close(): failed to delist XAResource from WLS: ", ex);
            CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "delist", "failed to delist XAResource from WLS:", null, ex);
            se = new SQLException("Unexpected exception: " + ex.getMessage());
        }
        if (se != null) {
            throw se;
        }
    }

    @Override
    public void closeInternal(boolean putPhysicalConnBackInCache) throws SQLException {
        String propVal;
        if (this.closed) {
            return;
        }
        if (this.closeCallback != null) {
            this.closeCallback.beforeClose(this, this.privateData);
        }
        if ((propVal = LogicalConnection.getSystemProperty("oracle.jdbc.noImplicitBeginRequest", "false")).equalsIgnoreCase("false") && !this.internalConnection.isProxySession() && !this.internalConnection.isDRCPEnabled()) {
            this.internalConnection.endRequest();
        }
        this.internalConnection.closeLogicalConnection();
        this.closed = true;
        if (this.pooledConnection != null) {
            this.pooledConnection.logicalClose(putPhysicalConnBackInCache);
        }
        try {
            this.ltxidBeforeLogicalClose = this.internalConnection.getLogicalTransactionId();
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        this.internalConnection = closedConnection;
        this.connection = closedConnection;
        if (this.closeCallback != null) {
            this.closeCallback.afterClose(this.privateData);
        }
    }

    @Override
    public void cleanupAndClose(boolean putPhysicalConnBackInCache) throws SQLException {
        try (Monitor.CloseableLock lock = this.internalConnection.acquireCloseableLock();){
            if (this.closed) {
                return;
            }
            this.closed = true;
            oracle.jdbc.internal.OracleConnection iconn = this.internalConnection;
            OraclePooledConnection pc = this.pooledConnection;
            this.internalConnection = closedConnection;
            this.connection = closedConnection;
            if (this.closeCallback != null) {
                this.closeCallback.beforeClose(this, this.privateData);
            }
            iconn.cleanupAndClose();
            iconn.closeLogicalConnection();
            if (pc != null && putPhysicalConnBackInCache) {
                pc.logicalClose();
            }
            if (this.closeCallback != null) {
                this.closeCallback.afterClose(this.privateData);
            }
        }
    }

    @Override
    public void abort() throws SQLException {
        try (Monitor.CloseableLock lock = this.internalConnection.acquireCloseableLock();){
            if (this.closed) {
                return;
            }
            this.internalConnection.abort();
            this.closed = true;
            this.internalConnection = closedConnection;
            this.connection = closedConnection;
        }
    }

    @Override
    public void close(int opt) throws SQLException {
        try (Monitor.CloseableLock lock = this.internalConnection.acquireCloseableLock();){
            if ((opt & 0x1000) != 0) {
                if (this.pooledConnection != null) {
                    this.pooledConnection.closeOption = opt;
                }
                this.doClose();
                return;
            }
            if ((opt & 1) != 0) {
                this.internalConnection.close(1);
            }
            return;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try (Monitor.CloseableLock lock = this.internalConnection.acquireCloseableLock();){
            boolean bl = this.closed || this.internalConnection.isClosed();
            return bl;
        }
    }

    @Override
    public String getDatabaseTimeZone() throws SQLException {
        return this.internalConnection.getDatabaseTimeZone();
    }

    @Override
    public ZoneId getDatabaseZoneId() throws SQLException {
        return this.internalConnection.getDatabaseZoneId();
    }

    @Override
    public String getSessionTimeZone() {
        return this.internalConnection.getSessionTimeZone();
    }

    @Override
    public ZoneId getSessionZoneId() {
        return this.internalConnection.getSessionZoneId();
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getServerSessionInfo() throws SQLException {
        return this.connection.getServerSessionInfo();
    }

    @Override
    @Blind
    public String getServerSessionInfo(String key) throws SQLException {
        return this.connection.getServerSessionInfo(key);
    }

    @Override
    public Object getClientData(Object key) {
        return ((ClientDataSupport)((Object)this.internalConnection)).getClientData(key);
    }

    @Override
    public Object setClientData(Object key, Object value) {
        return ((ClientDataSupport)((Object)this.internalConnection)).setClientData(key, value);
    }

    @Override
    public Object removeClientData(Object key) {
        return ((ClientDataSupport)((Object)this.internalConnection)).removeClientData(key);
    }

    @Override
    public void setClientIdentifier(String clientId) throws SQLException {
        this.internalConnection.setClientIdentifier(clientId);
    }

    @Override
    public void clearClientIdentifier(String clientId) throws SQLException {
        this.internalConnection.clearClientIdentifier(clientId);
    }

    @Override
    public short getStructAttrNCsId() throws SQLException {
        return this.internalConnection.getStructAttrNCsId();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.internalConnection.getTypeMap();
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getDBAccessProperties() throws SQLException {
        return this.internalConnection.getDBAccessProperties();
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getOCIHandles() throws SQLException {
        return this.internalConnection.getOCIHandles();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.internalConnection.getDatabaseProductVersion();
    }

    @Override
    public void cancel() throws SQLException {
        this.internalConnection.cancel();
    }

    @Override
    public String getURL() throws SQLException {
        return this.internalConnection.getURL();
    }

    @Override
    public boolean getIncludeSynonyms() {
        return this.internalConnection.getIncludeSynonyms();
    }

    @Override
    public boolean getRemarksReporting() {
        return this.internalConnection.getRemarksReporting();
    }

    @Override
    public boolean getRestrictGetTables() {
        return this.internalConnection.getRestrictGetTables();
    }

    @Override
    public short getVersionNumber() throws SQLException {
        return this.internalConnection.getVersionNumber();
    }

    @Override
    public int getMajorVersionNumber() throws SQLException {
        return this.internalConnection.getMajorVersionNumber();
    }

    @Override
    public int getMinorVersionNumber() throws SQLException {
        return this.internalConnection.getMinorVersionNumber();
    }

    @Override
    public Map<String, Class<?>> getJavaObjectTypeMap() {
        return this.internalConnection.getJavaObjectTypeMap();
    }

    @Override
    public void setJavaObjectTypeMap(Map<String, Class<?>> map) {
        this.internalConnection.setJavaObjectTypeMap(map);
    }

    @Override
    public BfileDBAccess createBfileDBAccess() throws SQLException {
        return this.internalConnection.createBfileDBAccess();
    }

    @Override
    public BlobDBAccess createBlobDBAccess() throws SQLException {
        return this.internalConnection.createBlobDBAccess();
    }

    @Override
    public ClobDBAccess createClobDBAccess() throws SQLException {
        return this.internalConnection.createClobDBAccess();
    }

    @Override
    public void setDefaultFixedString(boolean fixedString) {
        this.internalConnection.setDefaultFixedString(fixedString);
    }

    @Override
    public boolean getTimestamptzInGmt() {
        return this.internalConnection.getTimestamptzInGmt();
    }

    @Override
    public boolean getUse1900AsYearForTime() {
        return this.internalConnection.getUse1900AsYearForTime();
    }

    @Override
    public boolean getDefaultFixedString() {
        return this.internalConnection.getDefaultFixedString();
    }

    @Override
    public oracle.jdbc.OracleConnection getWrapper() {
        return this;
    }

    @Override
    public Class<?> classForNameAndSchema(String name, String schemaName) throws ClassNotFoundException {
        return this.internalConnection.classForNameAndSchema(name, schemaName);
    }

    @Override
    public void setFDO(byte[] fdo) throws SQLException {
        this.internalConnection.setFDO(fdo);
    }

    @Override
    public byte[] getFDO(boolean init) throws SQLException {
        return this.internalConnection.getFDO(init);
    }

    @Override
    public boolean getBigEndian() throws SQLException {
        return this.internalConnection.getBigEndian();
    }

    @Override
    public Object getDescriptor(byte[] toid) {
        return this.internalConnection.getDescriptor(toid);
    }

    @Override
    public void putDescriptor(byte[] toid, Object desc) throws SQLException {
        this.internalConnection.putDescriptor(toid, desc);
    }

    @Override
    public void removeDescriptor(String sql_name) {
        this.connection.removeDescriptor(sql_name);
    }

    @Override
    public void removeDescriptor(byte[] toid) {
        this.connection.removeDescriptor(toid);
    }

    @Override
    public void removeAllDescriptor() {
        this.connection.removeAllDescriptor();
    }

    @Override
    public int numberOfDescriptorCacheEntries() {
        return this.internalConnection.numberOfDescriptorCacheEntries();
    }

    @Override
    public Enumeration<String> descriptorCacheKeys() {
        return this.internalConnection.descriptorCacheKeys();
    }

    @Override
    public short getDbCsId() throws SQLException {
        return this.internalConnection.getDbCsId();
    }

    @Override
    public short getJdbcCsId() throws SQLException {
        return this.internalConnection.getJdbcCsId();
    }

    @Override
    public short getNCharSet() {
        return this.internalConnection.getNCharSet();
    }

    @Override
    public ResultSet newArrayDataResultSet(Datum[] data, long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.internalConnection.newArrayDataResultSet(data, index, count, map);
    }

    @Override
    public ResultSet newArrayDataResultSet(OracleArray array, long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.internalConnection.newArrayDataResultSet(array, index, count, map);
    }

    @Override
    public ResultSet newArrayLocatorResultSet(ArrayDescriptor desc, byte[] locator, long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.internalConnection.newArrayLocatorResultSet(desc, locator, index, count, map);
    }

    @Override
    public ResultSetMetaData newStructMetaData(StructDescriptor desc) throws SQLException {
        return this.internalConnection.newStructMetaData(desc);
    }

    @Override
    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
        this.internalConnection.getForm(otypeADT, otype, attrIndex);
    }

    @Override
    public int CHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        return this.internalConnection.CHARBytesToJavaChars(bytes, nbytes, chars);
    }

    @Override
    public int NCHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        return this.internalConnection.NCHARBytesToJavaChars(bytes, nbytes, chars);
    }

    @Override
    public boolean IsNCharFixedWith() {
        return this.internalConnection.IsNCharFixedWith();
    }

    @Override
    public short getDriverCharSet() {
        return this.internalConnection.getDriverCharSet();
    }

    @Override
    public CharacterSet getDbCharSet() {
        return this.internalConnection.getDbCharSet();
    }

    @Override
    public int getC2SNlsRatio() {
        return this.internalConnection.getC2SNlsRatio();
    }

    @Override
    public int getMaxCharSize() throws SQLException {
        return this.internalConnection.getMaxCharSize();
    }

    @Override
    public int getMaxCharbyteSize() {
        return this.internalConnection.getMaxCharbyteSize();
    }

    @Override
    public int getMaxNCharbyteSize() {
        return this.internalConnection.getMaxNCharbyteSize();
    }

    @Override
    public boolean isCharSetMultibyte(short charSet) {
        return this.internalConnection.isCharSetMultibyte(charSet);
    }

    @Override
    public int javaCharsToCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        return this.internalConnection.javaCharsToCHARBytes(chars, nchars, bytes);
    }

    @Override
    public int javaCharsToNCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        return this.internalConnection.javaCharsToNCHARBytes(chars, nchars, bytes);
    }

    @Override
    public int getStmtCacheSize() {
        return this.internalConnection.getStmtCacheSize();
    }

    @Override
    public int getStatementCacheSize() throws SQLException {
        return this.internalConnection.getStatementCacheSize();
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.internalConnection.getImplicitCachingEnabled();
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.internalConnection.getExplicitCachingEnabled();
    }

    @Override
    public void purgeImplicitCache() throws SQLException {
        this.internalConnection.purgeImplicitCache();
    }

    @Override
    public void purgeExplicitCache() throws SQLException {
        this.internalConnection.purgeExplicitCache();
    }

    @Override
    public PreparedStatement getStatementWithKey(String key) throws SQLException {
        return this.internalConnection.getStatementWithKey(key);
    }

    @Override
    public CallableStatement getCallWithKey(String key) throws SQLException {
        return this.internalConnection.getCallWithKey(key);
    }

    @Override
    public boolean isStatementCacheInitialized() {
        return this.internalConnection.isStatementCacheInitialized();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.internalConnection.setTypeMap(map);
    }

    @Override
    public String getProtocolType() {
        return this.internalConnection.getProtocolType();
    }

    @Override
    public void setTxnMode(int mode) {
        this.internalConnection.setTxnMode(mode);
    }

    @Override
    public int getTxnMode() {
        return this.internalConnection.getTxnMode();
    }

    @Override
    public int getHeapAllocSize() throws SQLException {
        return this.internalConnection.getHeapAllocSize();
    }

    @Override
    public int getOCIEnvHeapAllocSize() throws SQLException {
        return this.internalConnection.getOCIEnvHeapAllocSize();
    }

    @Override
    public CLOB createClob(byte[] locator_bytes) throws SQLException {
        return this.internalConnection.createClob(locator_bytes);
    }

    @Override
    public CLOB createClobWithUnpickledBytes(byte[] locator_bytes) throws SQLException {
        return this.internalConnection.createClobWithUnpickledBytes(locator_bytes);
    }

    @Override
    public CLOB createClob(byte[] locator_bytes, short csform) throws SQLException {
        return this.internalConnection.createClob(locator_bytes, csform);
    }

    @Override
    public BLOB createBlob(byte[] locator_bytes) throws SQLException {
        return this.internalConnection.createBlob(locator_bytes);
    }

    @Override
    public BLOB createBlobWithUnpickledBytes(byte[] locator_bytes) throws SQLException {
        return this.internalConnection.createBlobWithUnpickledBytes(locator_bytes);
    }

    @Override
    public BFILE createBfile(byte[] locator_bytes) throws SQLException {
        return this.internalConnection.createBfile(locator_bytes);
    }

    @Override
    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection conn) throws SQLException {
        return this.internalConnection.isDescriptorSharable(conn);
    }

    @Override
    public OracleStatement refCursorCursorToStatement(int cursorNumber) throws SQLException {
        return this.internalConnection.refCursorCursorToStatement(cursorNumber);
    }

    @Override
    public long getTdoCState(String schemaName, String typeName) throws SQLException {
        return this.internalConnection.getTdoCState(schemaName, typeName);
    }

    @Override
    public long getTdoCState(String typeName) throws SQLException {
        return this.internalConnection.getTdoCState(typeName);
    }

    @Override
    public Datum toDatum(CustomDatum inObject) throws SQLException {
        return this.internalConnection.toDatum(inObject);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.pooledConnection.getXAResource();
    }

    @Override
    public void setApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        this.internalConnection.setApplicationContext(nameSpace, attribute, value);
    }

    @Override
    public void clearAllApplicationContext(String nameSpace) throws SQLException {
        this.internalConnection.clearAllApplicationContext(nameSpace);
    }

    @Override
    @Deprecated
    public boolean isV8Compatible() throws SQLException {
        return this.getMapDateToTimestamp();
    }

    @Override
    public boolean getMapDateToTimestamp() {
        return this.internalConnection.getMapDateToTimestamp();
    }

    @Override
    public boolean getJDBCStandardBehavior() {
        return this.internalConnection.getJDBCStandardBehavior();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.internalConnection.abort(executor);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.internalConnection.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.internalConnection.getSchema();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.internalConnection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.internalConnection.setSchema(schema);
    }

    @Override
    public byte[] createLightweightSession(String userName, KeywordValueLong[] inKeyVal, int inFlags, KeywordValueLong[][] outKeyVal, int[] outFlags) throws SQLException {
        return this.internalConnection.createLightweightSession(userName, inKeyVal, inFlags, outKeyVal, outFlags);
    }

    @Override
    public void executeLightweightSessionPiggyback(int functionId, byte[] sessionId, KeywordValueLong[] inKeyVal, int inFlags) throws SQLException {
        this.internalConnection.executeLightweightSessionPiggyback(functionId, sessionId, inKeyVal, inFlags);
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSNamespace[][] returnedNamespaces, XSSecureId secureId) throws SQLException {
        this.internalConnection.doXSNamespaceOp(operationCode, sessionId, namespaces, returnedNamespaces, secureId);
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSSecureId secureId) throws SQLException {
        this.internalConnection.doXSNamespaceOp(operationCode, sessionId, namespaces, secureId);
    }

    @Override
    public void doXSSessionAttachOp(int opCode, byte[] sessionId, XSSecureId sidp, byte[] cookie, XSPrincipal username, String[] disabledRoles, String[] enabledRoles, String[] externalRoles, XSNamespace[] namespaces, XSNamespace[] cacheNamespace, XSNamespace[] deleteNamespace, TIMESTAMPTZ midTierTimestamp, TIMESTAMPTZ authtime, int roleVersion, long inputFlag, XSKeyval Kv, int[] roleVersionOutput) throws SQLException {
        this.internalConnection.doXSSessionAttachOp(opCode, sessionId, sidp, cookie, username, disabledRoles, enabledRoles, externalRoles, namespaces, cacheNamespace, deleteNamespace, midTierTimestamp, authtime, roleVersion, inputFlag, Kv, roleVersionOutput);
    }

    @Override
    public void doXSSessionChangeOp(OracleConnection.XSSessionSetOperationCode opCode, byte[] sessionId, XSSecureId sidp, XSSessionParameters sessParam) throws SQLException {
        this.internalConnection.doXSSessionChangeOp(opCode, sessionId, sidp, sessParam);
    }

    @Override
    public byte[] doXSSessionCreateOp(OracleConnection.XSSessionOperationCode opcode, XSSecureId sidp, byte[] cookie, XSPrincipal username, String tenant, XSNamespace[] namespaces, OracleConnection.XSSessionModeFlag mode, XSKeyval Kv) throws SQLException {
        return this.internalConnection.doXSSessionCreateOp(opcode, sidp, cookie, username, tenant, namespaces, mode, Kv);
    }

    @Override
    public void doXSSessionDestroyOp(byte[] sessionId, XSSecureId sidp, byte[] cookie) throws SQLException {
        this.internalConnection.doXSSessionDestroyOp(sessionId, sidp, cookie);
    }

    @Override
    public void doXSSessionDetachOp(int opcode, byte[] sessionId, XSSecureId sidp, boolean roundTripRPC) throws SQLException {
        this.internalConnection.doXSSessionDetachOp(opcode, sessionId, sidp, roundTripRPC);
    }

    public BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        return this.internalConnection.createBlobDBAccess().createTemporaryBlob(conn, cache, duration);
    }

    public CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException {
        return this.internalConnection.createClobDBAccess().createTemporaryClob(conn, cache, duration, form_of_use);
    }

    @Override
    public String getDefaultSchemaNameForNamedTypes() throws SQLException {
        return this.internalConnection.getDefaultSchemaNameForNamedTypes();
    }

    @Override
    public boolean isUsable() {
        return this.isUsable(true);
    }

    @Override
    public boolean isUsable(boolean draining) {
        return !this.closed && this.internalConnection.isUsable(draining);
    }

    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        return this.internalConnection.getInstanceProperty(whatProperty);
    }

    @Override
    public void setUsable(boolean isUsable) {
        this.internalConnection.setUsable(isUsable);
    }

    @Override
    public int getTimezoneVersionNumber() throws SQLException {
        return this.internalConnection.getTimezoneVersionNumber();
    }

    @Override
    public TIMEZONETAB getTIMEZONETAB() throws SQLException {
        return this.internalConnection.getTIMEZONETAB();
    }

    @Override
    public void setPDBChangeEventListener(PDBChangeEventListener listener) throws SQLException {
        this.internalConnection.setPDBChangeEventListener(listener);
    }

    @Override
    public void setPDBChangeEventListener(PDBChangeEventListener listener, Executor executor) throws SQLException {
        this.internalConnection.setPDBChangeEventListener(listener, executor);
    }

    @Override
    public void addXSEventListener(XSEventListener listener) throws SQLException {
        this.internalConnection.addXSEventListener(listener);
    }

    @Override
    public void addXSEventListener(XSEventListener listener, Executor executor) throws SQLException {
        this.internalConnection.addXSEventListener(listener, executor);
    }

    @Override
    public void removeXSEventListener(XSEventListener listener) throws SQLException {
        this.internalConnection.removeXSEventListener(listener);
    }

    @Override
    public void removeAllXSEventListener() throws SQLException {
        this.internalConnection.removeAllXSEventListener();
    }

    @Override
    public OracleConnection.BufferCacheStatistics getByteBufferCacheStatistics() {
        return this.internalConnection.getByteBufferCacheStatistics();
    }

    @Override
    public OracleConnection.BufferCacheStatistics getCharBufferCacheStatistics() {
        return this.internalConnection.getCharBufferCacheStatistics();
    }

    @Override
    public boolean isDataInLocatorEnabled() throws SQLException {
        return this.internalConnection.isDataInLocatorEnabled();
    }

    @Override
    public boolean isLobStreamPosStandardCompliant() throws SQLException {
        return this.internalConnection.isLobStreamPosStandardCompliant();
    }

    @Override
    public long getCurrentSCN() throws SQLException {
        return this.internalConnection.getCurrentSCN();
    }

    @Override
    public EnumSet<OracleConnection.TransactionState> getTransactionState() throws SQLException {
        return this.internalConnection.getTransactionState();
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException, SQLException {
        return this.internalConnection.isConnectionSocketKeepAlive();
    }

    @Override
    public boolean isConnectionBigTZTC() throws SQLException {
        return this.internalConnection.isConnectionBigTZTC();
    }

    @Override
    public boolean serverSupportsRequestBoundaries() throws SQLException {
        return this.internalConnection.serverSupportsRequestBoundaries();
    }

    @Override
    public boolean serverSupportsExplicitBoundaryBit() throws SQLException {
        return this.internalConnection.serverSupportsExplicitBoundaryBit();
    }

    @Override
    public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener) throws SQLException {
        this.connection.removeLogicalTransactionIdEventListener(listener);
    }

    @Override
    public void setReplayOperations(EnumSet<OracleConnection.ReplayOperation> ops) throws SQLException {
        this.internalConnection.setReplayOperations(ops);
    }

    @Override
    public void beginNonRequestCalls() throws SQLException {
        this.internalConnection.beginNonRequestCalls();
    }

    @Override
    public void endNonRequestCalls() throws SQLException {
        this.internalConnection.endNonRequestCalls();
    }

    @Override
    public void setReplayContext(ReplayContext[] contexts) throws SQLException {
        this.internalConnection.setReplayContext(contexts);
    }

    @Override
    public void registerEndReplayCallback(OracleConnection.EndReplayCallback callback) throws SQLException {
        this.internalConnection.registerEndReplayCallback(callback);
    }

    @Override
    public int getEOC() throws SQLException {
        return this.internalConnection.getEOC();
    }

    @Override
    public ReplayContext[] getReplayContext() throws SQLException {
        return this.internalConnection.getReplayContext();
    }

    @Override
    public ReplayContext getLastReplayContext() throws SQLException {
        return this.internalConnection.getLastReplayContext();
    }

    @Override
    public void setLastReplayContext(ReplayContext cxt) throws SQLException {
        this.internalConnection.setLastReplayContext(cxt);
    }

    @Override
    public byte[] getDerivedKeyInternal(byte[] dhKey, int mode) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        return this.internalConnection.getDerivedKeyInternal(dhKey, mode);
    }

    @Override
    public short getExecutingRPCFunctionCode() {
        return this.internalConnection.getExecutingRPCFunctionCode();
    }

    @Override
    public String getExecutingRPCSQL() {
        return this.internalConnection.getExecutingRPCSQL();
    }

    @Override
    public void setReplayingMode(boolean isReplaying) throws SQLException {
        this.internalConnection.setReplayingMode(isReplaying);
    }

    @Override
    public TraceEventListener getTraceEventListener() {
        return this.internalConnection.getTraceEventListener();
    }

    @Override
    public void jmsEnqueue(String queueName, JMSEnqueueOptions enqueueOpt, JMSMessage mesg, AQMessageProperties aqMesgProp) throws SQLException {
        this.internalConnection.jmsEnqueue(queueName, enqueueOpt, mesg, aqMesgProp);
    }

    @Override
    public void jmsEnqueue(String queueName, JMSEnqueueOptions enqueueOpt, JMSMessage[] mesgs, AQMessageProperties[] aqMesgProps) throws SQLException {
        this.internalConnection.jmsEnqueue(queueName, enqueueOpt, mesgs, aqMesgProps);
    }

    @Override
    public JMSMessage jmsDequeue(String queueName, JMSDequeueOptions opt) throws SQLException {
        JMSMessage jmsMessage = this.internalConnection.jmsDequeue(queueName, opt);
        return jmsMessage;
    }

    @Override
    public JMSMessage[] jmsDequeue(String queueName, JMSDequeueOptions opt, int size) throws SQLException {
        JMSMessage[] jmsMessage = this.internalConnection.jmsDequeue(queueName, opt, size);
        return jmsMessage;
    }

    @Override
    public JMSMessage jmsDequeue(String queueName, JMSDequeueOptions opt, OutputStream os) throws SQLException {
        JMSMessage jmsMessage = this.internalConnection.jmsDequeue(queueName, opt, os);
        return jmsMessage;
    }

    @Override
    public JMSMessage jmsDequeue(String queueName, JMSDequeueOptions opt, String typeName) throws SQLException {
        JMSMessage jmsMessage = this.internalConnection.jmsDequeue(queueName, opt, typeName);
        return jmsMessage;
    }

    @Override
    public Map<String, JMSNotificationRegistration> registerJMSNotification(String[] name, Map<String, Properties> options, String selector) throws SQLException {
        Map<String, JMSNotificationRegistration> registrations = this.internalConnection.registerJMSNotification(name, options, selector);
        return registrations;
    }

    @Override
    public Map<String, JMSNotificationRegistration> registerJMSNotification(String[] name, Map<String, Properties> options) throws SQLException {
        Map<String, JMSNotificationRegistration> registrations = this.internalConnection.registerJMSNotification(name, options);
        return registrations;
    }

    @Override
    public void unregisterJMSNotification(JMSNotificationRegistration registration) throws SQLException {
        this.internalConnection.unregisterJMSNotification(registration);
    }

    @Override
    public void startJMSNotification(JMSNotificationRegistration registration) throws SQLException {
        this.internalConnection.startJMSNotification(registration);
    }

    @Override
    public void stopJMSNotification(JMSNotificationRegistration registration) throws SQLException {
        this.internalConnection.stopJMSNotification(registration);
    }

    @Override
    public void ackJMSNotification(JMSNotificationRegistration registration, byte[] messageId, JMSNotificationRegistration.Directive directive) throws SQLException {
        this.internalConnection.ackJMSNotification(registration, messageId, directive);
    }

    @Override
    public void ackJMSNotification(ArrayList<JMSNotificationRegistration> regList, byte[][] lastMessageIds, JMSNotificationRegistration.Directive directive) throws SQLException {
        this.internalConnection.ackJMSNotification(regList, lastMessageIds, directive);
    }

    @Override
    public boolean isDRCPEnabled() throws SQLException {
        return this.internalConnection.isDRCPEnabled();
    }

    @Override
    public boolean isDRCPMultitagEnabled() throws SQLException {
        return this.internalConnection.isDRCPMultitagEnabled();
    }

    @Override
    public String getDRCPReturnTag() throws SQLException {
        return this.internalConnection.getDRCPReturnTag();
    }

    @Override
    public String getDRCPPLSQLCallbackName() throws SQLException {
        return this.internalConnection.getDRCPPLSQLCallbackName();
    }

    @Override
    public boolean attachServerConnection() throws SQLException {
        return this.internalConnection.attachServerConnection();
    }

    @Override
    public void detachServerConnection(String tag) throws SQLException {
        this.internalConnection.detachServerConnection(tag);
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames) throws SQLException {
        return this.internalConnection.prepareDirectPath(schemaName, tableName, colNames);
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, String partitionName) throws SQLException {
        return this.internalConnection.prepareDirectPath(schemaName, tableName, colNames, partitionName);
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps) throws SQLException {
        return this.internalConnection.prepareDirectPath(schemaName, tableName, colNames, dpStmtProps);
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, String partitionName, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps) throws SQLException {
        return this.internalConnection.prepareDirectPath(schemaName, tableName, colNames, dpStmtProps);
    }

    @Override
    public byte[] beginSaga(String initiatorName, int timeout, String currentUser, int version, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        return this.internalConnection.beginSaga(initiatorName, timeout, currentUser, version, opcode, flags, spareNumeric, spareText);
    }

    @Override
    public Integer joinSaga(String participantName, byte[] sagaId, String coordinatorName, String initiatorName, int timeout, int version, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        return this.internalConnection.joinSaga(participantName, sagaId, coordinatorName, initiatorName, timeout, version, opcode, flags, spareNumeric, spareText);
    }

    @Override
    public Integer commitRollbackSaga(String participantName, byte[] sagaId, String currentUser, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        return this.internalConnection.commitRollbackSaga(participantName, sagaId, currentUser, opcode, flags, spareNumeric, spareText);
    }

    @Override
    public boolean needToPurgeStatementCache() throws SQLException {
        return this.internalConnection.needToPurgeStatementCache();
    }

    @Override
    public int getNegotiatedSDU() throws SQLException {
        return this.internalConnection.getNegotiatedSDU();
    }

    @Override
    public byte getNegotiatedTTCVersion() throws SQLException {
        return this.internalConnection.getNegotiatedTTCVersion();
    }

    @Override
    public int getVarTypeMaxLenCompat() throws SQLException {
        return this.internalConnection.getVarTypeMaxLenCompat();
    }

    @Override
    public void setChecksumMode(OracleConnection.ChecksumMode mode) throws SQLException {
        this.internalConnection.setChecksumMode(mode);
    }

    @Override
    public ResultSetCache getResultSetCache() throws SQLException {
        return this.internalConnection.getResultSetCache();
    }

    @Override
    public void cleanupAndClose() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153).fillInStackTrace();
    }

    @Override
    public void closeLogicalConnection() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153).fillInStackTrace();
    }

    @Override
    public boolean isLifecycleOpen() throws SQLException {
        return this.internalConnection.isLifecycleOpen();
    }

    @Override
    public void clearDrcpTagName() throws SQLException {
        this.internalConnection.clearDrcpTagName();
    }

    @Override
    public void beginRequest() throws SQLException {
        this.internalConnection.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.internalConnection.endRequest();
    }

    @Override
    public void endRequest(boolean implicit) throws SQLException {
        this.internalConnection.endRequest(implicit);
    }

    @Override
    public void sendRequestFlags() throws SQLException {
        this.internalConnection.sendRequestFlags();
    }

    @Override
    public int freeTemporaryBlobsAndClobs() throws SQLException {
        return this.internalConnection.freeTemporaryBlobsAndClobs();
    }

    @Override
    public HAManager getHAManager() {
        return this.internalConnection.getHAManager();
    }

    @Override
    public void setHAManager(HAManager haManager) throws SQLException {
        this.internalConnection.setHAManager(haManager);
    }

    @Override
    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        return this.internalConnection != closedConnection ? this.internalConnection.getLogicalTransactionId() : this.ltxidBeforeLogicalClose;
    }

    @Override
    public void setChunkInfo(OracleShardingKey key, OracleShardingKey superKey, String chunkName) throws SQLException {
        this.internalConnection.setChunkInfo(key, superKey, chunkName);
    }

    @Override
    public void setShardingKey(OracleShardingKey key, OracleShardingKey superKey) throws SQLException {
        this.internalConnection.setShardingKey(key, superKey);
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey key, OracleShardingKey superKey, int timeout) throws SQLException {
        return this.internalConnection.setShardingKeyIfValid(key, superKey, timeout);
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey shardingKey, int timeout) throws SQLException {
        return this.internalConnection.setShardingKeyIfValid(shardingKey, timeout);
    }

    @Override
    public void setShardingKey(OracleShardingKey shardingKey) throws SQLException {
        this.internalConnection.setShardingKey(shardingKey);
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this.internalConnection.isNetworkCompressionEnabled();
    }

    @Override
    public NetStat getNetworkStat() {
        return this.internalConnection.getNetworkStat();
    }

    @Override
    public int getOutboundConnectTimeout() {
        return this.internalConnection.getOutboundConnectTimeout();
    }

    private static String getSystemProperty(String str, String defaultValue) {
        if (str != null) {
            final String fstr = str;
            final String fdefaultValue = defaultValue;
            final String[] rets = new String[]{defaultValue};
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    rets[0] = System.getProperty(fstr, fdefaultValue);
                    return null;
                }
            });
            return rets[0].trim().toLowerCase();
        }
        return defaultValue;
    }

    @Override
    public boolean hasNoOpenHandles() throws SQLException {
        return this.internalConnection.hasNoOpenHandles();
    }

    @Override
    public DatabaseSessionState getDatabaseSessionState() throws SQLException {
        return this.internalConnection.getDatabaseSessionState();
    }

    @Override
    public void setDatabaseSessionState(DatabaseSessionState obj) throws SQLException {
        this.internalConnection.setDatabaseSessionState(obj);
    }

    @Override
    public boolean isSafelyClosed() throws SQLException {
        return this.internalConnection.isSafelyClosed();
    }

    @Override
    public void setSafelyClosed(boolean closed) throws SQLException {
        this.internalConnection.setSafelyClosed(closed);
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getClientInfoInternal() throws SQLException {
        return this.internalConnection.getClientInfoInternal();
    }

    @Override
    public boolean getAutoCommitInternal() throws SQLException {
        return this.internalConnection.getAutoCommitInternal();
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getJavaNetProperties() throws SQLException {
        return this.internalConnection.getJavaNetProperties();
    }

    @Override
    public double getPercentageQueryExecutionOnDirectShard() {
        return this.internalConnection.getPercentageQueryExecutionOnDirectShard();
    }

    @Override
    public void addLargeObject(OracleLargeObject lob) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153).fillInStackTrace();
    }

    @Override
    public void removeLargeObject(OracleLargeObject lob) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153).fillInStackTrace();
    }

    @Override
    public void addBfile(OracleBfile bfile) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153).fillInStackTrace();
    }

    @Override
    public void removeBfile(OracleBfile bfile) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 153).fillInStackTrace();
    }

    @Override
    public void flushRemoteDatabaseTTCCookieCache() {
    }

    @Override
    public void addFeature(OracleConnection.ClientFeature cf) throws SQLException {
        this.internalConnection.addFeature(cf);
    }

    @Override
    public void enableDiagnoseFirstFailureDump(boolean enableDump) throws SQLException {
        this.internalConnection.enableDiagnoseFirstFailureDump(enableDump);
    }

    @Override
    public String getNetConnectionId() throws SQLException {
        return this.internalConnection.getNetConnectionId();
    }

    private void testlog(String mesg) {
    }

    private void testlog(String mesg, Throwable exc) {
    }
}

