/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.zip.CRC32;
import oracle.jdbc.AccessToken;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DatabaseSessionState;
import oracle.jdbc.driver.DirectPathBufferMarshaler;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.JMSMessagePropertiesI;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNConnection;
import oracle.jdbc.driver.NTFDCNConnectionGroup;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFJMSConnectionGroup;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFLTXIDEvent;
import oracle.jdbc.driver.NTFPDBChangeEvent;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.PasswordAuthentication;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.driver.ReplayContext;
import oracle.jdbc.driver.ResultSetCache;
import oracle.jdbc.driver.ResultSetCacheManager;
import oracle.jdbc.driver.StateSignatures;
import oracle.jdbc.driver.T4C7Ocommoncall;
import oracle.jdbc.driver.T4C7Oversion;
import oracle.jdbc.driver.T4C8Kpcdsc;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4C8Oclose;
import oracle.jdbc.driver.T4C8Odscrarr;
import oracle.jdbc.driver.T4C8Odsy;
import oracle.jdbc.driver.T4C8TTIBfile;
import oracle.jdbc.driver.T4C8TTIBlob;
import oracle.jdbc.driver.T4C8TTIClob;
import oracle.jdbc.driver.T4C8TTIJson;
import oracle.jdbc.driver.T4C8TTIdty;
import oracle.jdbc.driver.T4C8TTIpro;
import oracle.jdbc.driver.T4CDirectPathPreparedStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMAREngineNIO;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.driver.T4CTTCaqa;
import oracle.jdbc.driver.T4CTTICookie;
import oracle.jdbc.driver.T4CTTICookieCache;
import oracle.jdbc.driver.T4CTTICookieMsg;
import oracle.jdbc.driver.T4CTTIInitMsg;
import oracle.jdbc.driver.T4CTTIOqcsta;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.driver.T4CTTIkpdnrdeq;
import oracle.jdbc.driver.T4CTTIkscn;
import oracle.jdbc.driver.T4CTTIkscn8;
import oracle.jdbc.driver.T4CTTIoappcontreplay;
import oracle.jdbc.driver.T4CTTIoaqdeq;
import oracle.jdbc.driver.T4CTTIoaqenq;
import oracle.jdbc.driver.T4CTTIoauthenticate;
import oracle.jdbc.driver.T4CTTIochunkinfo;
import oracle.jdbc.driver.T4CTTIoclfeatures;
import oracle.jdbc.driver.T4CTTIocsessret;
import oracle.jdbc.driver.T4CTTIodpls;
import oracle.jdbc.driver.T4CTTIodpmop;
import oracle.jdbc.driver.T4CTTIodpp;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.T4CTTIoer19;
import oracle.jdbc.driver.T4CTTIokeyval;
import oracle.jdbc.driver.T4CTTIokpn;
import oracle.jdbc.driver.T4CTTIoping;
import oracle.jdbc.driver.T4CTTIoplbgn;
import oracle.jdbc.driver.T4CTTIoplend;
import oracle.jdbc.driver.T4CTTIoqcid;
import oracle.jdbc.driver.T4CTTIosaga;
import oracle.jdbc.driver.T4CTTIoscid;
import oracle.jdbc.driver.T4CTTIoses;
import oracle.jdbc.driver.T4CTTIosessget;
import oracle.jdbc.driver.T4CTTIosessrls;
import oracle.jdbc.driver.T4CTTIosesstate;
import oracle.jdbc.driver.T4CTTIosesstemplate;
import oracle.jdbc.driver.T4CTTIoxsatt;
import oracle.jdbc.driver.T4CTTIoxscre;
import oracle.jdbc.driver.T4CTTIoxsdes;
import oracle.jdbc.driver.T4CTTIoxsdet;
import oracle.jdbc.driver.T4CTTIoxsns;
import oracle.jdbc.driver.T4CTTIoxsscs;
import oracle.jdbc.driver.T4CTTIoxsset;
import oracle.jdbc.driver.T4CTTIoxsspo;
import oracle.jdbc.driver.T4CTTIoxssro;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.T4CTTIspfp;
import oracle.jdbc.driver.T4CTTIsto;
import oracle.jdbc.driver.T4CTTIxsnsop;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.driver.T4Caqdq;
import oracle.jdbc.driver.T4Caqe;
import oracle.jdbc.driver.TemplateOverflow;
import oracle.jdbc.driver.XSSessionParametersI;
import oracle.jdbc.driver.oauth.AccessTokenBuilder;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.driver.utils.StringUtils;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.internal.XSSessionParameters;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NSProtocolNIO;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.TimeUnitSuffixUtility;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.Datum;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

class T4CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final short MIN_TTCVER_SUPPORTED = 4;
    static final short V8_TTCVER_SUPPORTED = 5;
    static final short MAX_TTCVER_SUPPORTED = 6;
    static final long RESULTSET_CACHE_BLOCK_SIZE_FOR_STAT = 512L;
    private static final String CLASS_NAME = T4CConnection.class.getName();
    static final int DEFAULT_LONG_PREFETCH_SIZE = 4080;
    static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    static final String DEFAULT_CACHE_LOCATION = "net8://?PR=0";
    static final int REFCURSOR_SIZE = 5;
    static final byte[] EMPTY_BYTE = new byte[0];
    boolean isTTIRENEGReceived;
    boolean isLoggedOn;
    ConnectionPath currentConnectionPath = ConnectionPath.NORMAL;
    private boolean useZeroCopyIO;
    boolean useLobPrefetch;
    private boolean svrSupportsRequests;
    private boolean svrSupportsExplicitRequestBit;
    private OpaqueString password;
    private Communication net;
    int eocs;
    private NTFEventListener[] ltxidListeners = new NTFEventListener[0];
    private final Monitor ltxidListenersMonitor = Monitor.newInstance();
    private NTFEventListener[] xsListeners = new NTFEventListener[0];
    private final Monitor xsListenersMonitor = Monitor.newInstance();
    boolean readAsNonStream;
    T4CTTIoer11 oer;
    T4CMAREngine mare;
    T4C8TTIpro pro;
    T4C8TTIdty dty;
    T4CTTIrxd rxd;
    T4CTTIsto sto;
    T4CTTIspfp spfp;
    T4CTTIoauthenticate auth;
    T4C8Odscrarr describe;
    T4C8Odsy describeTbl;
    T4C8Oall all8;
    T4C8Oclose close8;
    T4CTTIoclfeatures oclFeatures;
    T4C7Ocommoncall commoncall;
    T4Caqe aqe;
    T4Caqdq aqdq;
    T4CTTIoaqenq oaqenq;
    T4CTTIoaqdeq oaqdeq;
    T4CTTIkpdnrdeq kpdnrdeq;
    T4CTTCaqa aqa;
    T4C8TTIBfile bfileMsg;
    T4C8TTIBlob blobMsg;
    T4C8TTIClob clobMsg;
    T4C8TTIJson jsonMsg;
    T4C8TTIBlob lobMsg;
    T4CTTIoses oses;
    T4CTTIoping oping;
    T4CTTIokpn okpn;
    T4CTTIOtxen otxen;
    T4CTTIOtxse otxse;
    T4CTTIk2rpc k2rpc;
    T4CTTIoscid oscid;
    T4CTTIokeyval okeyval;
    T4CTTIoxsscs oxsscs;
    T4CTTIoxssro oxssro;
    T4CTTIoxsspo oxsspo;
    T4CTTIxsnsop xsnsop;
    T4CTTIosesstate osesstate;
    T4CTTIoappcontreplay oappcontreplay;
    T4CTTIosesstemplate osesstemplate;
    T4CTTIoxsns xsnsop2;
    T4CTTIoxscre oxscre;
    T4CTTIoxsdes oxsdes;
    T4CTTIoxsdet oxsdet;
    T4CTTIoxsatt oxsatt;
    T4CTTIoxsset oxsset;
    T4CTTIosessrls osessrls;
    T4CTTIosessget osessget;
    T4CTTIocsessret ocsessret;
    T4CTTIoqcid oqcid;
    T4CTTIkscn kpdqidcscn;
    T4CTTIOqcsta oqcsta;
    T4CTTIochunkinfo ochunkinfo;
    T4CTTIochunkinfo piggyBackOchunkinfo;
    T4CTTIodpp odpp;
    T4CTTIodpmop odpmop;
    T4CTTIodpls odpls;
    T4CTTIosaga osaga;
    int[] cursorToClose;
    int cursorToCloseOffset = 0;
    int lastCursorToCloseOffset;
    int[] queryToClose;
    int queryToCloseOffset = 0;
    byte[] tempLobsToFree;
    int tempLobFreeOffset = 0;
    int tempLobFreeCount = 0;
    int[] lusFunctionId2;
    byte[][] lusSessionId2;
    KeywordValueLong[][] lusInKeyVal2;
    int[] lusInFlags2;
    int lusOffset2 = 0;
    private long osessstateFlags = -1L;
    boolean shardingDriverMode;
    boolean tcDriverMode;
    static final int DIRECTIVE_REPLAY_ENABLED = 4;
    EnumSet<ReplayMode> replayModes;
    OracleConnection.EndReplayCallback endReplayCallback = null;
    oracle.jdbc.internal.ReplayContext[] oappcontreplayContextsArr = null;
    int oappcontreplayOffset = 0;
    ReplayContext nonRequestDisableReplayCxt;
    DatabaseSessionState sessionState = null;
    DatabaseSessionState sessionStateOut = null;
    int sessionId;
    int serialNumber;
    private boolean switchFromProxySession;
    private boolean disableCommitOptimizationOnPDBChange = false;
    byte negotiatedTTCversion;
    byte[] serverRuntimeCapabilities;
    private byte[] serverCompileTimeCapabilities;
    Hashtable<String, Namespace> namespaces;
    byte[] internalName;
    byte[] externalName;
    static final int FREE = -1;
    static final int SEND = 1;
    static final int RECEIVE = 2;
    int pipeState = -1;
    boolean sentCancel = false;
    int maxNonStreamBindByteSize;
    boolean statementCancel = true;
    String databaseUniqueIdentifier;
    String versionNumberString = null;
    int majorNumber = 0;
    int minorNumber = 0;
    protected short lastExecutedFunCode = 0;
    static final Map<String, String[]> cachedVersionTable = new Hashtable<String, String[]>();
    private static final T4CTTICookieCache DATABASE_NEGOTIATED_INFORMATION;
    byte currentTTCSeqNumber = 0;
    byte lastPiggyBackCursorCloseSeqNumber = 0;
    short[] ttiList;
    final byte[] tmpBytes128 = new byte[128];
    boolean isO7L_MRExposed = true;
    private short executingRPCFunctionCode = 0;
    String shardingKey = null;
    String superShardingKey = null;
    String chunkName = null;
    private boolean isDatabaseShutdown = false;
    private boolean isProxySessionLogoff = false;
    private boolean isFeatureTrackingSupported = false;
    int releasedSessID;
    int releasedSerial;
    boolean writeBufferIsDirty;
    T4CDirectPathPreparedStatement dppstmt = null;
    boolean isHybrid = false;
    private Pipeline pipeline;
    private int asyncCursorCount;
    private int maximumCursorCount;
    private int computedAsyncCursorLimit;
    private String executingRPCSQL = null;
    private static final String UCP_THREAD_NAME_PREFIX = "UCP-worker-thread-";
    private final CRC32 checksumEngine = new CRC32();
    private final Hashtable<Long, Integer> tempLobRefCount = new Hashtable();
    private boolean needsToBeClosed;
    static final int MAX_SIZE_VSESSION_OSUSER = 30;
    static final int MAX_SIZE_VSESSION_PROCESS = 24;
    static final int MAX_SIZE_VSESSION_MACHINE = 64;
    static final int MAX_SIZE_VSESSION_TERMINAL = 30;
    static final int MAX_SIZE_VSESSION_PROGRAM = 48;
    private ResultSetCache resultSetCache;
    private ArrayList<Long> resultSetCacheLocalInvalidations;
    boolean isServerBigSCN = false;

    @Override
    public short getExecutingRPCFunctionCode() {
        return this.executingRPCFunctionCode;
    }

    void setExecutingRPCFunctionCode(short executingRPCFunctionCode) {
        this.executingRPCFunctionCode = executingRPCFunctionCode;
    }

    void setExecutingRPCSQL(String executingRPCSQL) {
        this.executingRPCSQL = executingRPCSQL;
    }

    @Override
    public String getExecutingRPCSQL() {
        return this.executingRPCSQL;
    }

    T4CConnection(String url, @Blind(value=PropertiesBlinder.class) Properties info, OracleDriverExtension ext) throws SQLException {
        super(url, info, ext);
        this.cursorToClose = new int[4];
        this.queryToClose = new int[10];
        this.tempLobsToFree = new byte[2048];
        this.lusFunctionId2 = new int[10];
        this.lusSessionId2 = new byte[10][];
        this.lusInKeyVal2 = new KeywordValueLong[10][];
        this.lusInFlags2 = new int[10];
        this.replayModes = EnumSet.noneOf(ReplayMode.class);
        this.minVcsBindSize = 0;
        this.namespaces = new Hashtable(5);
        this.currentSchema = null;
        this.ttiList = new short[128];
        if (info != null) {
            String tempval = info.getProperty("InternalShardingDriverMode");
            this.shardingDriverMode = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = info.getProperty("InternalTrueCacheDriverMode");
            this.tcDriverMode = tempval != null && tempval.equals("true");
        }
    }

    @Override
    final void initializePassword(OpaqueString p) {
        this.password = p;
    }

    private T4CTTICookie getTTCCookie() {
        assert (this.net.getSessionAttributes().getDatabaseUUID().length() > 0) : "Should not be called without a databse uuid";
        Optional<T4CTTICookie> cachedCookie = DATABASE_NEGOTIATED_INFORMATION.get(this.net.getSessionAttributes().getDatabaseUUID());
        return cachedCookie.orElse(null);
    }

    @Override
    public void flushRemoteDatabaseTTCCookieCache() {
        DATABASE_NEGOTIATED_INFORMATION.flush();
    }

    private void negotiateTTC(boolean isCookieOptimizationEnabled, T4CTTICookie cookie, boolean ttiInitOptimizationEnabled) throws IOException, SQLException {
        if (isCookieOptimizationEnabled && cookie != null) {
            this.currentConnectionPath = ConnectionPath.COOKIE;
            this.begin(Metrics.ConnectionEvent.TTC_TTICOOKIE_OPTIMIZATION);
            this.cookieBasedNegotiateSession(cookie);
        } else if (ttiInitOptimizationEnabled) {
            this.currentConnectionPath = ConnectionPath.TTIINIT;
            this.begin(Metrics.ConnectionEvent.TTC_TTIINIT_OPTIMIZATION);
            this.ttiInitBasedNegotiateSession();
        } else {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "negotiateTTC", "do normal connect to database", null, null);
            T4CTTICookie newCookie = this.negotiateSession();
            if (isCookieOptimizationEnabled) {
                if (this.isLoggable(Level.FINER)) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "negotiateTTC", "new cookie for server {0}: {1} ", (String)null, null, (Object)StringUtils.byteArrayToHexUnicode(this.net.getSessionAttributes().getDatabaseUUID().getBytes()), (Object)newCookie);
                }
                try {
                    DATABASE_NEGOTIATED_INFORMATION.post(this.net.getSessionAttributes().getDatabaseUUID(), newCookie);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private final void checkConnectionProperties() {
        if (this.net.getSessionAttributes().getNTAdapter().getNetworkAdapterType() == NTAdapter.NetworkAdapterType.BEQ) {
            if (this.fanEnabled) {
                this.debug(Level.FINE, SecurityLabel.INTERNAL, CLASS_NAME, "logon", "Disabling {0} as this is not supported when using BEQ", (String)null, null, (Object)"oracle.jdbc.fanEnabled");
                this.fanEnabled = false;
            }
            if (this.inbandNotification) {
                this.debug(Level.FINE, SecurityLabel.INTERNAL, CLASS_NAME, "logon", "Disabling {0} as this is not supported when using BEQ", (String)null, null, (Object)"oracle.jdbc.inbandNotification");
                this.inbandNotification = false;
            }
        }
    }

    @Override
    final void logon(AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        long authStartTime = 0L;
        TimerTask timeoutTask = this.startLogonTimeout();
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                if (this.isLoggedOn) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 428).fillInStackTrace();
                }
                if (this.database == null) {
                    this.database = DEFAULT_CONNECT_STRING;
                }
                this.net = new NSProtocolNIO(this.database, this.createNSProperties(builder), builder == null ? null : builder.getSSLContext(), builder == null ? null : builder.getHostnameResolver(), this.nsDirectBuffer, this.getDiagnosable(), this.getTraceEventListener());
                this.net.setDriverResources(this.getDriverResources());
                AccessToken accessToken = this.getAccessToken(builder, this.net.getConnectDescriptions());
                this.connectNetworkSessionProtocol(builder);
                this.checkConnectionProperties();
                if (accessToken == null && this.net.getConnectDescriptions().size() > 1) {
                    accessToken = this.configureAccessTokenBuilder(builder, this.net.getConnectedDescription()).build();
                }
                boolean isCookieOptimizationAvailable = false;
                T4CTTICookie cachedCookie = null;
                if (this.getSecurityInformation().getAuthenticationAdaptor() != SecurityInformation.AuthenticationAdaptorType.RADIUS && this.ttcCookieOptimizationEnabled && this.net.getSessionAttributes().isTTCCookieEnabled() && !this.forceAL32UTF8ForCombinedRoundtrips) {
                    isCookieOptimizationAvailable = true;
                    cachedCookie = this.getTTCCookie();
                }
                this.debug(Level.FINE, SecurityLabel.INTERNAL, CLASS_NAME, "logon", "cookie optimization enabled? {0}, TTIINIT optimization enabled? {1}", (String)null, null, (Object)this.ttcCookieOptimizationEnabled, (Object)this.combinedInitializationRoundtrips);
                if (this.isLoggable(Level.FINER)) {
                    this.debug(Level.FINER, SecurityLabel.INTERNAL, CLASS_NAME, "logon", "session attributes {0}", (String)null, null, (Object)this.net.getSessionAttributes());
                    this.debug(Level.FINER, SecurityLabel.INTERNAL, CLASS_NAME, "logon", "cookie found? {0}", (String)null, null, cachedCookie != null ? cachedCookie : "no");
                }
                if (this.isDRCPEnabled() && !this.isClientInitiatedNTFConnection() && this.net().isTLSEnabled()) {
                    this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "logon", "Initiating the TLS renegotiation with pooled auth server before performing authentication.", null, null);
                    this.net().getSessionAttributes().initTLSRenegotiation();
                }
                this.negotiateTTC(isCookieOptimizationAvailable, cachedCookie, this.combinedInitializationRoundtrips && this.net.getSessionAttributes().isFastAuthenticationOptimizationEnabled());
                this.initializeTTC();
                authStartTime = System.currentTimeMillis();
                this.authenticateUserForLogon(accessToken);
                authStartTime = 0L;
                if (this.isDRCPEnabled() && !this.isClientInitiatedNTFConnection() && this.net().isTLSEnabled()) {
                    this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "logon", "Initializing TLS renegotiation with pooled server after successful logon.", null, null);
                    this.net().getSessionAttributes().initTLSRenegotiation();
                }
                this.initializeSessionInfoAfterLogon();
                if (this.versionNumberString == null) {
                    this.initializeDatabaseVersionInfo();
                }
                this.initializeAfterLogon();
                if (isCookieOptimizationAvailable && this.getTTCCookie() == null && this.combinedInitializationRoundtrips && this.net.getSessionAttributes().isFastAuthenticationOptimizationEnabled()) {
                    try {
                        DATABASE_NEGOTIATED_INFORMATION.post(this.net.getSessionAttributes().getDatabaseUUID(), T4CTTICookie.builder().databaseRuntimeCapabilities(this.pro.getServerRuntimeCapabilities()).databaseCompileTimeCapabilities(this.pro.getServerCompileTimeCapabilities()).connectionProtocolVersion(this.pro.getProtocolVersion()).databaseCharSet(this.pro.getCharacterSet()).databaseNCharSet(this.pro.getncharCHARSET()).databaseCharSetFlag(this.pro.getFlags()).databasePortage(this.pro.getSvrPortDescription()).build());
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
            catch (InterruptedIOException interruptFailure) {
                throw this.handleLogonInterruptedIOException(interruptFailure, timeoutTask != null && !timeoutTask.cancel(), authStartTime);
            }
            catch (NetException e) {
                throw this.handleLogonNetException(e);
            }
            catch (IOException ex) {
                throw this.handleLogonIOException(ex, authStartTime);
            }
            catch (SQLException se) {
                throw this.handleLogonSQLException(se);
            }
            finally {
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                }
                this.logConnectionInfoAfterLogonAlways();
                this.initializeResultSetCacheAfterLogonAlways();
                this.initializeDRCPAfterLogonAlways();
            }
        }
    }

    private void cookieBasedNegotiateSession(T4CTTICookie cookie) throws SQLException, IOException {
        assert (cookie != null) : "cookie cannot be null";
        this.begin(Metrics.ConnectionEvent.TTC_NEGOTIATION);
        this.serverRuntimeCapabilities = cookie.getDatabaseRuntimeCapabilities();
        this.serverCompileTimeCapabilities = cookie.getDatabaseCompileTimeCapabilities();
        this.getMarshalEngine().proSvrVer = cookie.getConnectionProtocolVersion();
        this.pro = new T4C8TTIpro(this);
        this.pro.initFrom(cookie);
        this.pro.marshal();
        this.doCharSetNegotiation(this.pro.oVersion, cookie.getDatabaseCharSet(), cookie.getDatabaseNCharSet());
        this.setCLRBigChunksCapability();
        new T4CTTICookieMsg(this).marshal(cookie);
        this.dty = new T4C8TTIdty(this, cookie.getDatabaseRuntimeCapabilities(), this.logonCap != null && this.logonCap.trim().equals("o3"), this.thinNetUseZeroCopyIO);
        this.dty.marshal();
        this.setNegotiatedTTCVersion(this.serverCompileTimeCapabilities);
    }

    private void ttiInitBasedNegotiateSession() throws SQLException, IOException {
        this.mare.conv = new DBConversion(873, 873, 2000);
        this.mare.proSvrVer = (short)6;
        this.mare.types.setFlags((byte)1);
        this.pro = new T4C8TTIpro(this);
        if (!this.forceAL32UTF8ForCombinedRoundtrips) {
            T4CTTIInitMsg.builder().connection(this).protocolMessage(this.pro).assumedDBServerCharset((short)873).assumedDBServernCharset((short)2000).build().marshal();
        } else {
            T4CTTIInitMsg.builder().connection(this).protocolMessage(this.pro).build().marshal();
        }
        this.serverRuntimeCapabilities = T4CTTIInitMsg.ASSUMED_SRV_RT_CAPS;
        this.serverCompileTimeCapabilities = T4CTTIInitMsg.ASSUMED_SRV_CT_CAPS;
        this.dty = new T4C8TTIdty(this, this.serverRuntimeCapabilities, this.logonCap != null && this.logonCap.trim().equals("o3"), this.thinNetUseZeroCopyIO);
        this.dty.marshal();
        this.conversion = this.mare.conv;
        this.setNegotiatedTTCVersion(T4CTTIInitMsg.ASSUMED_SRV_CT_CAPS);
        this.setCLRBigChunksCapability();
    }

    @Override
    final CompletionStage<Void> logonAsync(AbstractConnectionBuilder<?, ?> builder) {
        if (this.isLoggedOn) {
            return CompletionStageUtil.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 428).fillInStackTrace());
        }
        AsyncOutboundTimeoutHandler loginTimeoutHandler = this.loginTimeout < 1 ? null : AsyncOutboundTimeoutHandler.newScheduledInstance(null, Duration.ofSeconds(this.loginTimeout), new InterruptedIOException("Socket read interrupted"));
        try {
            this.net = new NSProtocolNIO(this.database, this.createNSProperties(builder), builder == null ? null : builder.getSSLContext(), builder == null ? null : builder.getHostnameResolver(), this.nsDirectBuffer, this.getDiagnosable(), this.getTraceEventListener());
        }
        catch (NetException netException) {
            try {
                return CompletionStageUtil.failedStage(this.handleLogonNetException(netException));
            }
            catch (SQLException sqlException) {
                return CompletionStageUtil.failedStage(sqlException);
            }
        }
        long authStartTime = System.currentTimeMillis();
        return this.connectSessionAsync(builder, loginTimeoutHandler).thenCompose(CompletionStageUtil.normalCompletionHandler(nil -> {
            this.initializeTTC();
            return this.authenticateUserForLogonAsync(this.configureAccessTokenBuilder(builder, this.net.getConnectedDescription()).build());
        })).thenCompose(nil -> {
            this.initializeSessionInfoAfterLogon();
            return this.versionNumberString == null ? this.initializeDatabaseVersionInfoAsync() : CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
            this.initializeAfterLogon();
            return null;
        })).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(Exception.class, logonException -> {
            if (logonException instanceof InterruptedIOException) {
                InterruptedIOException interruptFailure = (InterruptedIOException)logonException;
                boolean isInterruptedByLoginTimeout = loginTimeoutHandler != null && !loginTimeoutHandler.cancelTimeout();
                throw this.handleLogonInterruptedIOException(interruptFailure, isInterruptedByLoginTimeout, authStartTime);
            }
            if (logonException instanceof NetException) {
                throw this.handleLogonNetException((NetException)logonException);
            }
            if (logonException instanceof IOException) {
                throw this.handleLogonIOException((IOException)logonException, 0L);
            }
            if (logonException instanceof SQLException) {
                throw this.handleLogonSQLException((SQLException)logonException);
            }
            throw logonException;
        })).handle(CompletionStageUtil.completionHandler(() -> {
            if (loginTimeoutHandler != null) {
                loginTimeoutHandler.cancelTimeout();
            }
            this.logConnectionInfoAfterLogonAlways();
            this.initializeResultSetCacheAfterLogonAlways();
            this.initializeDRCPAfterLogonAlways();
            if (this.net.getSessionAttributes().isConnected()) {
                this.net.restoreBlockingMode();
            }
        }));
    }

    private void initializeAfterLogon() throws SQLException, IOException {
        this.isLoggedOn = true;
        this.disableTempLobRefCntForOracle10();
        this.initializeResultSetCacheAfterLogon();
        int rowPrefetchDirective = Integer.parseInt(this.sessionProperties.getProperty("AUTH_CLIENT_PREFETCH_ROWS", "-1"));
        if (rowPrefetchDirective != -1 && !this.isRowPrefetchSetExplicitly) {
            this.defaultRowPrefetch = rowPrefetchDirective;
        }
        this.doAddFeature(OracleConnection.ClientFeature.THIN_DRIVER);
        Properties properties = new Properties();
        properties.setProperty("DatabaseProductVersion", String.valueOf(this.versionNumber));
        properties.setProperty("URL", this.getURL());
        this.debug(Level.CONFIG, SecurityLabel.CONFIG, CLASS_NAME, "initializeAfterLogon", "properties={0}. ", (String)null, null, (Object)new PropertiesBlinder().blind(properties));
        this.connectionDiagnosable.addConfig(properties);
        this.initializePipeline();
    }

    private TimerTask startLogonTimeout() {
        if (this.loginTimeout < 1) {
            return null;
        }
        Thread logonThread = Thread.currentThread();
        return TimeoutInterruptHandler.scheduleTask(logonThread::interrupt, (long)this.loginTimeout * 1000L);
    }

    private SQLException handleLogonInterruptedIOException(InterruptedIOException logonFailure, boolean isInterruptedByLoginTimeout, long authStartTime) {
        if (isInterruptedByLoginTimeout) {
            Thread.interrupted();
            SQLException timeoutException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1714).fillInStackTrace();
            timeoutException.initCause(logonFailure);
            return timeoutException;
        }
        return this.handleLogonIOException(logonFailure, authStartTime);
    }

    private SQLException handleLogonNetException(NetException logonFailure) throws SQLException {
        if ((logonFailure.getErrorNumber() == 17902 || logonFailure.getErrorNumber() == 17800 || logonFailure.getErrorNumber() == 17909) && this.net != null && this.net.getSessionAttributes().getcOption() != null) {
            int localPort;
            String serverType = "unknown";
            try {
                NVPair nvp = new NVFactory().createNVPair(this.net.getSessionAttributes().getcOption().conn_data.toString());
                NVNavigator nav = new NVNavigator();
                NVPair connDataNVP = nav.findNVPair(nvp, "CONNECT_DATA");
                NVPair servernvp = nav.findNVPair(connDataNVP, "SERVER");
                if (servernvp != null) {
                    serverType = servernvp.getAtom();
                }
            }
            catch (NLException nvp) {
                // empty catch block
            }
            InetAddress localAddr = null;
            try {
                localAddr = this.net.getSessionAttributes().getNTAdapter().getSocketChannel().socket().getLocalAddress();
                localPort = this.net.getSessionAttributes().getNTAdapter().getSocketChannel().socket().getLocalPort();
            }
            catch (UnsupportedOperationException e) {
                localAddr = InetAddress.getLoopbackAddress();
                localPort = 0;
            }
            logonFailure = (NetException)new NetException(3113, null, false, "client", localAddr, String.valueOf(localPort), this.net.getSessionAttributes().getcOption().host, String.valueOf(this.net.getSessionAttributes().getcOption().port), this.net.getSessionAttributes().getcOption().protocol, this.net.getSessionAttributes().getcOption().service_name, "client", serverType, this.thinVsessionProgram, this.sessionProperties != null ? this.getServerSessionInfo("AUTH_SERVER_PID") : null, this.sessionProperties != null ? this.getServerSessionInfo("AUTH_SESSION_ID") : null, this.sessionProperties != null ? this.getServerSessionInfo("AUTH_SERIAL_NUM") : null, this.getUserName() != null ? this.getUserName() : null, this.lastExecutedFunCode != 0 ? T4CTTIfun.getFunCodeDescription(this.lastExecutedFunCode) : null, this.getNetConnectionId(), this.getSecurityInformation() != null ? ", nne_encryption=" + this.getSecurityInformation().getEncryptionAlgorithm() + ", nne_checksumming=" + this.getSecurityInformation().getChecksummingAlgorithm() + ", authentication=" + (Object)((Object)this.getSecurityInformation().getAuthenticationAdaptor()) : null).initCause(logonFailure).fillInStackTrace();
        }
        try {
            logonFailure.setNetConnectionId(this.getNetConnectionId());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
        }
        return (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), logonFailure).fillInStackTrace();
    }

    private SQLException handleLogonIOException(IOException logonFailure, long authStartTime) {
        try {
            this.handleIOException(logonFailure);
        }
        catch (SQLException handlingFailure) {
            return handlingFailure;
        }
        long authenticationLapse = authStartTime == 0L ? 0L : System.currentTimeMillis() - authStartTime;
        String authenticationLapseMessage = String.format("%s, Authentication lapse %d ms.", logonFailure.getMessage(), authenticationLapse);
        IOException newEx = new IOException(authenticationLapseMessage, logonFailure);
        return (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), newEx).fillInStackTrace();
    }

    private void initializeTTC() throws SQLException, IOException {
        this.all8 = new T4C8Oall(this);
        this.okpn = new T4CTTIokpn(this);
        this.close8 = new T4C8Oclose(this);
        this.oclFeatures = new T4CTTIoclfeatures(this);
        this.sto = new T4CTTIsto(this);
        this.spfp = new T4CTTIspfp(this);
        this.commoncall = new T4C7Ocommoncall(this);
        this.describe = new T4C8Odscrarr(this);
        this.describeTbl = new T4C8Odsy(this);
        this.bfileMsg = new T4C8TTIBfile(this);
        this.blobMsg = new T4C8TTIBlob(this);
        this.clobMsg = new T4C8TTIClob(this);
        this.jsonMsg = new T4C8TTIJson(this);
        this.lobMsg = new T4C8TTIBlob(this);
        this.otxen = new T4CTTIOtxen(this);
        this.otxse = new T4CTTIOtxse(this);
        this.oping = new T4CTTIoping(this);
        this.k2rpc = new T4CTTIk2rpc(this);
        this.oses = new T4CTTIoses(this);
        this.okeyval = new T4CTTIokeyval(this);
        this.oxssro = new T4CTTIoxssro(this);
        this.oxsspo = new T4CTTIoxsspo(this);
        this.oxsscs = new T4CTTIoxsscs(this);
        this.oxscre = new T4CTTIoxscre(this);
        this.oxsdes = new T4CTTIoxsdes(this);
        this.oxsatt = new T4CTTIoxsatt(this);
        this.xsnsop = new T4CTTIxsnsop(this);
        this.xsnsop2 = new T4CTTIoxsns(this);
        this.oxsdet = new T4CTTIoxsdet(this);
        this.oxsset = new T4CTTIoxsset(this);
        this.aqe = new T4Caqe(this);
        this.aqdq = new T4Caqdq(this);
        this.oscid = new T4CTTIoscid(this);
        this.osessrls = new T4CTTIosessrls(this);
        this.ocsessret = new T4CTTIocsessret(this);
        this.osessget = new T4CTTIosessget(this);
        this.oaqenq = new T4CTTIoaqenq(this);
        this.oaqdeq = new T4CTTIoaqdeq(this);
        this.aqa = new T4CTTCaqa(this);
        this.kpdnrdeq = new T4CTTIkpdnrdeq(this);
        this.osesstate = new T4CTTIosesstate(this);
        this.oappcontreplay = new T4CTTIoappcontreplay(this);
        this.osesstemplate = new T4CTTIosesstemplate(this);
        this.kpdqidcscn = this.kscnForByteLength();
        this.oqcid = new T4CTTIoqcid(this);
        this.ochunkinfo = new T4CTTIochunkinfo(this);
        this.piggyBackOchunkinfo = new T4CTTIochunkinfo(this);
        this.odpp = new T4CTTIodpp(this);
        this.odpmop = new T4CTTIodpmop(this);
        this.odpls = new T4CTTIodpls(this);
        this.osaga = new T4CTTIosaga(this);
    }

    private AccessToken getAccessToken(AbstractConnectionBuilder<?, ?> connectionBuilder, List<ConnectDescription> descriptors) throws SQLException {
        ConnectDescription firstDescriptor = descriptors.get(0);
        for (int i = 1; i < descriptors.size(); ++i) {
            ConnectDescription nextDescriptor = descriptors.get(i);
            if (firstDescriptor.isTokenAuthenticationEqual(nextDescriptor)) continue;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getAccessToken", "Deferring access token request: Multiple descriptors found having conflicting configurations.", null, null);
            return null;
        }
        AccessTokenBuilder builder = this.configureAccessTokenBuilder(connectionBuilder, firstDescriptor);
        return builder.build();
    }

    private AccessTokenBuilder configureAccessTokenBuilder(AbstractConnectionBuilder<?, ?> connectionBuilder, ConnectDescription descriptor) {
        return new AccessTokenBuilder(this.getDiagnosable()).tokenSupplier(connectionBuilder.getTokenSupplier()).accessToken(this.accessToken).driverResources(this.getDriverResources()).tokenAuthentication(descriptor.getTokenAuthentication() != null ? descriptor.getTokenAuthentication() : this.tokenAuthentication).tokenLocation(descriptor.getTokenLocation() != null ? descriptor.getTokenLocation() : this.tokenLocation).passwordAuthentication(descriptor.getPasswordAuthentication() != null ? descriptor.getPasswordAuthentication() : this.passwordAuthentication).isSepsCredentials(this.isSepsCredentials).userName(this.userName).password(this.password).tlsConfig(this.getTlsConfig(descriptor)).ociIamUrl(descriptor.getOciIamUrl() != null ? descriptor.getOciIamUrl() : this.ociIamUrl).ociConfigFile(descriptor.getOciConfigFile() != null ? descriptor.getOciConfigFile() : this.ociConfigFile).ociProfile(descriptor.getOciProfile() != null ? descriptor.getOciProfile() : this.ociProfile).ociTenancy(descriptor.getOciTenancy() != null ? descriptor.getOciTenancy() : this.ociTenancy).ociCompartment(descriptor.getOciCompartment() != null ? descriptor.getOciCompartment() : this.ociCompartment).ociDatabase(descriptor.getOciDatabase() != null ? descriptor.getOciDatabase() : this.ociDatabase).azureDatabaseApplicationIdUri(descriptor.getAzureDbAppIdUri() != null ? descriptor.getAzureDbAppIdUri() : this.azureDatabaseApplicationIdUri).tenantId(descriptor.getTenantId() != null ? descriptor.getTenantId() : this.tenantId).clientId(descriptor.getClientId() != null ? descriptor.getClientId() : this.clientId).clientSecret(this.clientSecret).clientCertificate(descriptor.getClientCertificate() != null ? descriptor.getClientCertificate() : this.clientCertificate).clientCertificatePassword(this.clientCertificatePassword).redirectUri(descriptor.getRedirectUri() != null ? descriptor.getRedirectUri() : this.redirectUri);
    }

    private Properties getTlsConfig(ConnectDescription descriptor) {
        String walletLocation;
        Properties tlsConfig = new Properties();
        String string = walletLocation = descriptor.getWalletLocation() != null ? descriptor.getWalletLocation() : this.walletLocation;
        if (walletLocation != null) {
            tlsConfig.put((Object)5, walletLocation);
        }
        if (!OpaqueString.isNull(this.walletPassword)) {
            tlsConfig.put((Object)16, this.walletPassword);
        }
        if (this.thinSslCertificateAlias != null) {
            tlsConfig.put((Object)29, this.thinSslCertificateAlias);
        }
        if (this.thinSslCertificateThumbprint != null) {
            tlsConfig.put((Object)44, this.thinSslCertificateThumbprint);
        }
        if (this.thinJavaxNetSslKeystore != null) {
            tlsConfig.put((Object)8, this.thinJavaxNetSslKeystore);
        }
        if (this.thinJavaxNetSslKeystoretype != null) {
            tlsConfig.put((Object)9, this.thinJavaxNetSslKeystoretype);
        }
        if (!OpaqueString.isNull(this.thinJavaxNetSslKeystorepassword)) {
            tlsConfig.put((Object)10, this.thinJavaxNetSslKeystorepassword);
        }
        if (this.thinSslKeymanagerfactoryAlgorithm != null) {
            tlsConfig.put((Object)14, this.thinSslKeymanagerfactoryAlgorithm);
        }
        if (this.thinJavaxNetSslTruststore != null) {
            tlsConfig.put((Object)11, this.thinJavaxNetSslTruststore);
        }
        if (this.thinJavaxNetSslTruststoretype != null) {
            tlsConfig.put((Object)12, this.thinJavaxNetSslTruststoretype);
        }
        if (OpaqueString.isNull(this.thinJavaxNetSslTruststorepassword)) {
            tlsConfig.put((Object)13, this.thinJavaxNetSslTruststorepassword);
        }
        if (this.thinSslTrustmanagerfactoryAlgorithm != null) {
            tlsConfig.put((Object)15, this.thinSslTrustmanagerfactoryAlgorithm);
        }
        if (this.sslContextProtocol != null) {
            tlsConfig.put((Object)38, this.sslContextProtocol);
        }
        return tlsConfig;
    }

    private final void authenticateUserForLogon(@Blind AccessToken accessToken) throws SQLException, IOException {
        this.begin(Metrics.ConnectionEvent.AUTH);
        this.auth = new T4CTTIoauthenticate(this, this.resourceManagerId);
        long logonMode = this.getLogonMode();
        if (accessToken == null) {
            this.authenticateWithPassword(logonMode);
        } else {
            this.auth.doOAUTH(accessToken, logonMode);
        }
        this.end(Metrics.ConnectionEvent.AUTH);
    }

    private void authenticateWithPassword(long logonMode) throws IOException, SQLException {
        SQLException ora1017Exception = null;
        try {
            String authenticationAdaptor = this.net().getAuthenticationAdaptorName();
            boolean isKerberosAuthentication = "KERBEROS5".equals(authenticationAdaptor);
            if (!this.net.getSessionAttributes().isTwoFactorAuthenticationDone() && !isKerberosAuthentication && this.userName != null && this.userName.length() != 0) {
                try {
                    this.auth.doOSESSKEY(this.userName, logonMode);
                    this.initializeResultSetCache();
                }
                catch (SQLException qe) {
                    if (qe.getErrorCode() == 1017) {
                        ora1017Exception = qe;
                        this.userName = null;
                    }
                    throw qe;
                }
            }
            this.auth.doOAUTH(this.userName, this.password.get(), this.newPasswordValue.get(), logonMode);
            if (this.newPasswordValue != OpaqueString.NULL) {
                this.initializePassword(this.newPasswordValue);
                this.newPasswordValue = OpaqueString.NULL;
            }
        }
        catch (SQLException sqlE) {
            if (ora1017Exception != null) {
                sqlE.initCause(ora1017Exception);
            }
            throw sqlE;
        }
    }

    private final CompletionStage<Void> authenticateUserForLogonAsync(AccessToken accessToken) {
        if (accessToken != null) {
            return CompletionStageUtil.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Asynchronous connection creation does not support token-based authentication").fillInStackTrace());
        }
        long logonMode = this.getLogonMode();
        try {
            this.auth = new T4CTTIoauthenticate(this, this.resourceManagerId);
        }
        catch (SQLException preAuthenticationFailure) {
            return CompletionStageUtil.failedStage(preAuthenticationFailure);
        }
        this.pipeline = Pipeline.createHalfDuplex(this.net, this.getMonitorLock(), this.getAsyncExecutor(), this.getDiagnosable());
        CompletionStage<Object> osesskeyStage = this.userName != null && this.userName.length() != 0 ? this.auth.doOSESSKEYAsync(this.userName, logonMode).thenApply(nil -> null).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(SQLException.class, osesskeySQLFailure -> {
            if (osesskeySQLFailure.getErrorCode() == 1017) {
                this.userName = null;
                return osesskeySQLFailure;
            }
            throw osesskeySQLFailure;
        })) : CompletionStageUtil.completedStage(null);
        return osesskeyStage.thenCompose(ora1017Exception -> this.auth.doOAUTHAsync(this.userName, this.password.get(), this.newPasswordValue.get(), logonMode).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(SQLException.class, oauthSQLFailure -> {
            if (ora1017Exception != null) {
                oauthSQLFailure.initCause((Throwable)ora1017Exception);
            }
            throw oauthSQLFailure;
        }))).thenRun(() -> {
            if (this.newPasswordValue != OpaqueString.NULL) {
                this.initializePassword(this.newPasswordValue);
                this.newPasswordValue = OpaqueString.NULL;
            }
        });
    }

    private final long getLogonMode() {
        long logonMode = 0L;
        if (this.internalLogon != null) {
            if (this.internalLogon.equalsIgnoreCase("sysoper")) {
                logonMode = 64L;
            } else if (this.internalLogon.equalsIgnoreCase("sysdba")) {
                logonMode = 32L;
            } else if (this.internalLogon.equalsIgnoreCase("sysasm")) {
                logonMode = 0x400000L;
            } else if (this.internalLogon.equalsIgnoreCase("sysbackup")) {
                logonMode = 0x1000000L;
            } else if (this.internalLogon.equalsIgnoreCase("sysdg")) {
                logonMode = 0x2000000L;
            } else if (this.internalLogon.equalsIgnoreCase("syskm")) {
                logonMode = 0x4000000L;
            }
        }
        if (this.prelimAuth) {
            logonMode |= 0x80L;
        }
        return logonMode;
    }

    private final void initializeResultSetCache() {
        if (this.isResultSetCacheEnabled && this.sessionProperties != null) {
            String dbId = this.sessionProperties.getProperty("AUTH_GLOBALLY_UNIQUE_DBID", "");
            long qcacheMaxSize = Long.parseLong(this.sessionProperties.getProperty("AUTH_QCACHE_MAXSIZE", "0"));
            int qcacheLag = Integer.parseInt(this.sessionProperties.getProperty("AUTH_QCACHE_CACHELAG", "0"));
            if (this.queryResultCacheMaxSize >= 0L && this.queryResultCacheMaxSize < 32768L) {
                this.isResultSetCacheEnabled = false;
            } else if (qcacheMaxSize > 0L) {
                qcacheMaxSize = this.queryResultCacheMaxSize >= 32768L ? this.queryResultCacheMaxSize : qcacheMaxSize;
                qcacheLag = this.queryResultCacheMaxLag > 0 ? this.queryResultCacheMaxLag : qcacheLag;
                this.resultSetCache = ResultSetCacheManager.getResultSetCache(dbId, qcacheMaxSize, qcacheLag);
                this.resultSetCache.registerConnection(this);
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeResultSetCache", "resultSetState={0}, dbId={1}, qcacheMaxSize={2}, qcacheLag={3}. ", (String)null, null, (Object)this.resultSetCache.getState(), this.secure(dbId), (Object)qcacheMaxSize, (Object)qcacheLag);
                this.resultSetCacheLocalInvalidations = new ArrayList();
            } else {
                this.isResultSetCacheEnabled = false;
            }
        } else {
            this.isResultSetCacheEnabled = false;
        }
    }

    private final void initializeSessionInfoAfterLogon() {
        this.sessionId = this.getSessionId();
        this.serialNumber = this.getSerialNumber();
        this.internalName = this.auth.internalName;
        this.externalName = this.auth.externalName;
        this.instanceName = this.sessionProperties.getProperty("AUTH_INSTANCENAME");
        this.dbName = this.sessionProperties.getProperty("AUTH_DBNAME");
        this.databaseUniqueIdentifier = this.sessionProperties.getProperty("AUTH_DB_ID");
        this.versionNumberString = this.sessionProperties.getProperty("AUTH_VERSION_NO");
        if (this.versionNumberString != null) {
            long verNum = Long.parseLong(this.versionNumberString);
            this.majorNumber = T4C7Oversion.serverReleaseRel(verNum);
            this.minorNumber = T4C7Oversion.serverReleaseRelUpd(verNum);
            int ver = 0;
            if ((ver += this.majorNumber * 1000) < 18000) {
                ver += T4C7Oversion.serverReleaseRelUpd(verNum) * 100;
            }
            this.versionNumber = (short)ver;
        }
        this.updateMaximumCursorCount(this.sessionProperties.getProperty("AUTH_MAX_OPEN_CURSORS"));
    }

    private final void initializeDatabaseVersionInfo() throws SQLException, IOException {
        String instanceStartTime = (String)this.sessionProperties.get("AUTH_SC_INSTANCE_START_TIME");
        String[] cacheValue = null;
        if (this.databaseUniqueIdentifier != null) {
            cacheValue = cachedVersionTable.get(this.databaseUniqueIdentifier + instanceStartTime);
        }
        if (!this.prelimAuth && !this.jmsNotificationConnection && cacheValue == null) {
            T4C7Oversion ver = new T4C7Oversion(this);
            ver.doOVERSION();
            byte[] resultBytes = ver.getVersion();
            this.databaseProductVersion = new String(resultBytes, StandardCharsets.UTF_8);
            this.versionNumber = ver.getVersionNumber();
            this.majorNumber = ver.getMajorVersionNumber();
            this.minorNumber = ver.getMinorVersionNumber();
            if (this.databaseUniqueIdentifier != null) {
                cacheValue = new String[]{this.databaseProductVersion, String.valueOf(this.versionNumber), String.valueOf(this.majorNumber), String.valueOf(this.minorNumber)};
                cachedVersionTable.put(this.databaseUniqueIdentifier + instanceStartTime, cacheValue);
            }
        } else if (cacheValue == null) {
            this.versionNumber = 0;
        } else {
            this.databaseProductVersion = cacheValue[0];
            this.versionNumber = Short.parseShort(cacheValue[1]);
            this.majorNumber = Short.parseShort(cacheValue[2]);
            this.minorNumber = Short.parseShort(cacheValue[3]);
        }
    }

    private final CompletionStage<Void> initializeDatabaseVersionInfoAsync() {
        String instanceStartTime = (String)this.sessionProperties.get("AUTH_SC_INSTANCE_START_TIME");
        String[] cacheValue = null;
        if (this.drcpEnabled && this.databaseUniqueIdentifier != null) {
            cacheValue = cachedVersionTable.get(this.databaseUniqueIdentifier + instanceStartTime);
        }
        if (!this.prelimAuth && !this.jmsNotificationConnection && cacheValue == null) {
            T4C7Oversion ver = new T4C7Oversion(this);
            return ver.doOVERSIONAsync().thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                byte[] resultBytes = ver.getVersion();
                this.databaseProductVersion = new String(resultBytes, StandardCharsets.UTF_8);
                this.versionNumber = ver.getVersionNumber();
                this.majorNumber = ver.getMajorVersionNumber();
                this.minorNumber = ver.getMinorVersionNumber();
                if (this.drcpEnabled && this.databaseUniqueIdentifier != null) {
                    String[] versionInfo = new String[]{this.databaseProductVersion, String.valueOf(this.versionNumber), String.valueOf(this.majorNumber), String.valueOf(this.minorNumber)};
                    cachedVersionTable.put(this.databaseUniqueIdentifier + instanceStartTime, versionInfo);
                }
                return null;
            }));
        }
        if (cacheValue == null) {
            this.versionNumber = 0;
        } else {
            this.databaseProductVersion = cacheValue[0];
            this.versionNumber = Short.parseShort((String)cacheValue[1]);
            this.majorNumber = Short.parseShort(cacheValue[2]);
            this.minorNumber = Short.parseShort(cacheValue[3]);
        }
        return CompletableFuture.completedFuture(null);
    }

    private final void disableTempLobRefCntForOracle10() throws SQLException {
        if (this.getVersionNumber() < 11000) {
            this.enableTempLobRefCnt = false;
        }
    }

    private final SQLException handleLogonSQLException(SQLException logonFailure) {
        try {
            this.net.disconnect();
        }
        catch (Exception e) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "handleLogonSQLException", null, null, e);
        }
        this.isLoggedOn = false;
        return logonFailure;
    }

    private final void logConnectionInfoAfterLogonAlways() throws SQLException {
        this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "logConnectionInfoAfterLogonAlways", "Operating System Process Identifier SPID={0}, DRCP Enabled={1}. ", (String)null, (Throwable)null, (Object)(this.sessionProperties == null ? "null" : this.sessionProperties.getProperty("AUTH_SERVER_PID")), (Object)this.isDRCPEnabled());
    }

    private final void initializeResultSetCacheAfterLogon() throws SQLException {
        if (this.isResultSetCacheEnabled && this.resultSetCache != null) {
            ResultSetCache.ResultSetCacheState state = this.resultSetCache.getState();
            if (state == ResultSetCache.ResultSetCacheState.STARTING) {
                long registrationId = this.registerInbandNotification(this.resultSetCache.getCacheLag(), DEFAULT_CACHE_LOCATION);
                this.resultSetCache.setRegistrationId(registrationId);
                this.doPingDatabase();
                this.oqcsta = new T4CTTIOqcsta(this, registrationId);
                this.oqcsta.connection = null;
                this.oqcsta.meg = null;
                this.resultSetCache.setOQCSTA(this.oqcsta);
                this.resultSetCache.setState(ResultSetCache.ResultSetCacheState.STARTED);
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeResultSetCacheAfterLogon", "resultSetCacheState={0}. ", (String)null, null, (Object)this.resultSetCache.getState());
            }
            this.oqcsta = this.resultSetCache.getOQCSTA();
        }
    }

    private final void deregisterResultSetCacheBeforeLogoff() throws SQLException {
        if (this.isResultSetCacheEnabled && this.resultSetCache != null) {
            try (Monitor.CloseableLock lock = this.resultSetCache.acquireCloseableLock();){
                if (this.resultSetCache.deregisterConnection(this)) {
                    this.doUnregisterDatabaseChangeNotification(this.resultSetCache.getRegistrationId(), DEFAULT_CACHE_LOCATION);
                    this.resultSetCache.setState(ResultSetCache.ResultSetCacheState.CLOSED);
                }
            }
            this.resultSetCache = null;
        }
    }

    private final void initializeResultSetCacheAfterLogonAlways() {
        if (this.isResultSetCacheEnabled && this.resultSetCache != null) {
            if (this.resultSetCache.getState() == ResultSetCache.ResultSetCacheState.STARTING) {
                this.resultSetCache.setState(ResultSetCache.ResultSetCacheState.STARTUP_FAILED);
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeResultSetCacheAfterLogonAlways", "resultSetCacheState={0}. ", (String)null, null, (Object)this.resultSetCache.getState());
                try (Monitor.CloseableLock lock = this.resultSetCache.acquireCloseableLock();){
                    this.resultSetCache.monitorNotifyAll();
                }
            }
        } else {
            this.isResultSetCacheEnabled = false;
        }
    }

    private final void initializeDRCPAfterLogonAlways() throws SQLException {
        if (this.drcpEnabled && this.isLoggedOn && this.drcpState != OracleConnection.DRCPState.DETACHED) {
            this.detachServerConnection(this.drcpTagName);
        }
    }

    T4CTTIkscn kscnForByteLength() {
        T4CTTIkscn kscn = null;
        kscn = this.isServerBigSCN ? new T4CTTIkscn8(this) : new T4CTTIkscn(this);
        return kscn;
    }

    void handleIOException(IOException ea) throws SQLException {
        if (ea instanceof NetException && ((NetException)ea).getErrorNumber() == 56611) {
            SQLException ex = (SQLException)DatabaseError.createSqlException(298).fillInStackTrace();
            ex.initCause(ea);
            throw ex;
        }
        try (Monitor.CloseableLock lock = this.cancelInProgressLockForThin.acquireCloseableLock();){
            this.pipeState = -1;
            this.net.disconnect();
        }
        catch (Exception e) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "handleIOException", null, null, e);
        }
        this.isLoggedOn = false;
        this.setLifecycle(4);
    }

    @Override
    void logoff() throws SQLException {
        this.assertLockHeldByCurrentThread();
        try {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "logoff", null, null, null);
            this.assertLoggedOn("T4CConnection.logoff");
            if (this.getLifecycle() == 8) {
                return;
            }
            this.net.cancelTimeout();
            this.deregisterResultSetCacheBeforeLogoff();
            this.commoncall.doOLOGOFF();
            this.net.disconnect();
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            if (this.getLifecycle() != 8) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
        finally {
            try {
                if (this.net.getSessionAttributes().isConnected()) {
                    this.net.disconnect();
                }
            }
            catch (Exception e) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "logoff", null, null, e);
            }
            this.isLoggedOn = false;
        }
    }

    T4CMAREngine getMarshalEngine() {
        return this.mare;
    }

    @Override
    void doCommit(int flags) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            block22: {
                this.assertLoggedOn("T4CConnection.do_commit");
                try {
                    EnumSet<OracleConnection.TransactionState> transactionState = this.getTransactionState();
                    if (this.disableCommitOptimizationOnPDBChange || this.isDRCPEnabled() || transactionState.size() != 1 || !transactionState.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) break block22;
                    return;
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
            }
            this.disableCommitOptimizationOnPDBChange = false;
            if (this.dppstmt != null) {
                this.directPathFinish();
            } else if (flags == 0) {
                this.commoncall.doOCOMMIT();
            } else {
                this.doCommitWithOptions(flags);
            }
        }
    }

    private final void doCommitWithOptions(int optionFlags) throws SQLException, IOException {
        int otxenFlags = this.getOTXENFlagsFromCommitOption(optionFlags);
        this.otxen.doOTXEN(1, null, null, 0, 0, 0, 0, 4, otxenFlags);
        int outState = this.otxen.getOutStateFromServer();
        if (outState == 2 || outState != 4) {
            // empty if block
        }
    }

    private final int getOTXENFlagsFromCommitOption(int optionFlags) {
        int txnflgs = 0;
        if ((optionFlags & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0) {
            txnflgs = txnflgs | 2 | 1;
        } else if ((optionFlags & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0) {
            txnflgs |= 2;
        }
        if ((optionFlags & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
            txnflgs = txnflgs | 8 | 4;
        } else if ((optionFlags & OracleConnection.CommitOption.WAIT.getCode()) != 0) {
            txnflgs |= 8;
        }
        return txnflgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doRollback() throws SQLException {
        block20: {
            boolean isUCPWorker = Thread.currentThread().getName().startsWith(UCP_THREAD_NAME_PREFIX);
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                try {
                    this.assertLoggedOn("T4CConnection.do_rollback");
                    if (this.dppstmt == null) {
                        if (isUCPWorker && this.replayModes.contains((Object)ReplayMode.RUNTIME_REPLAY_ENABLED)) {
                            this.beginNonRequestCalls();
                        }
                        try {
                            this.commoncall.doOROLLBACK();
                            break block20;
                        }
                        finally {
                            if (isUCPWorker && this.replayModes.contains((Object)ReplayMode.RUNTIME_REPLAY_ENABLED)) {
                                this.endNonRequestCalls();
                            }
                        }
                    }
                    this.directPathAbort();
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
            }
        }
    }

    @Override
    void doSetAutoCommit(boolean on) throws SQLException {
        this.assertLockHeldByCurrentThread();
        if (this.autoCommitSpecCompliant && on && this.getTransactionState().contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
            this.commit();
        }
        this.autocommit = on;
    }

    @Override
    void open(OracleStatement stmt) throws SQLException {
        this.assertLoggedOn("T4CConnection.open");
        stmt.setCursorId(0);
    }

    void incrementAsyncCursorCount() {
        ++this.asyncCursorCount;
    }

    void decrementAsyncCursorCount() {
        --this.asyncCursorCount;
    }

    int asyncCursorCount() {
        return this.asyncCursorCount;
    }

    int asyncCursorLimit() {
        return this.computedAsyncCursorLimit;
    }

    int maximumCursorCount() {
        return this.maximumCursorCount;
    }

    private void updateMaximumCursorCount(String value) {
        try {
            int existingCount = this.maximumCursorCount;
            this.maximumCursorCount = Integer.parseInt(value);
            if (existingCount == this.maximumCursorCount) {
                return;
            }
        }
        catch (NullPointerException | NumberFormatException exception) {
            this.maximumCursorCount = Integer.MAX_VALUE;
            this.computedAsyncCursorLimit = Integer.MAX_VALUE;
            return;
        }
        int existingLimit = this.computedAsyncCursorLimit;
        this.computedAsyncCursorLimit = this.asyncCursorLimit != (float)((int)this.asyncCursorLimit) ? (int)(this.asyncCursorLimit * (float)this.maximumCursorCount) : (this.asyncCursorLimit == 0.0f ? Integer.MAX_VALUE : (this.asyncCursorLimit < 0.0f ? this.maximumCursorCount + (int)this.asyncCursorLimit : (int)this.asyncCursorLimit));
        this.computedAsyncCursorLimit = Math.max(this.computedAsyncCursorLimit, 1);
    }

    @Override
    String doGetDatabaseProductVersion() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("T4CConnection.do_getDatabaseProductVersion");
            T4C7Oversion ver = new T4C7Oversion(this);
            try {
                ver.doOVERSION();
            }
            catch (IOException e) {
                this.handleIOException(e);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
            }
            String databaseProductVersion = null;
            byte[] resultBytes = ver.getVersion();
            try {
                databaseProductVersion = new String(resultBytes, "UTF8");
            }
            catch (UnsupportedEncodingException ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
            String string = databaseProductVersion;
            return string;
        }
    }

    @Override
    short doGetVersionNumber() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("T4CConnection.doGetVersionNumber");
            T4C7Oversion ver = new T4C7Oversion(this);
            try {
                ver.doOVERSION();
            }
            catch (IOException e) {
                this.handleIOException(e);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
            }
            short s2 = ver.getVersionNumber();
            return s2;
        }
    }

    @Override
    int doGetMajorVersionNumber() throws SQLException {
        return this.majorNumber;
    }

    @Override
    int doGetMinorVersionNumber() throws SQLException {
        return this.minorNumber;
    }

    @Override
    OracleStatement RefCursorBytesToStatement(byte[] bytes, OracleStatement parent) throws SQLException {
        T4CStatement newstmt = new T4CStatement(this, OracleResultSet.ResultSetType.UNKNOWN);
        try {
            int cursor = this.mare.unmarshalRefCursor(bytes);
            newstmt.setCursorId(cursor);
            newstmt.isOpen = true;
            newstmt.sqlObject = parent.sqlObject;
            newstmt.serverCursor = true;
            parent.addChild(newstmt);
            newstmt.prepareForNewResults(true, false, true);
        }
        catch (IOException e) {
            this.handleIOException(e);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
        newstmt.needToParse = false;
        return newstmt;
    }

    @Override
    OracleStatement createImplicitResultSetStatement(OracleStatement parent) throws SQLException {
        T4CStatement newstmt = new T4CStatement(this, OracleResultSet.ResultSetType.UNKNOWN);
        newstmt.setPrefetchInternal(parent.defaultRowPrefetch, false, false);
        newstmt.sqlObject = parent.sqlObject;
        newstmt.sqlKind = OracleStatement.SqlKind.SELECT;
        newstmt.numberOfDefinePositions = parent.numberOfDefinePositions;
        newstmt.isOpen = parent.isOpen;
        newstmt.prepareForNewResults(true, false, true);
        parent.addImplicitResultSetStmt(newstmt);
        return newstmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void cancelOperationOnServer(boolean isStatementCancel) throws SQLException {
        try (Monitor.CloseableLock lock = this.cancelInProgressLockForThin.acquireCloseableLock();){
            if (this.cancelInProgressFlag) return;
            try {
                switch (this.pipeState) {
                    case -1: {
                        if (this.pipeline.cancel()) break;
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "cancelOperationOnServer", "pipeState=FREE, aborting cancel. ", null, null);
                        return;
                    }
                    case 1: {
                        this.net.sendBreak();
                        break;
                    }
                    case 2: {
                        this.net.sendInterrupt();
                        break;
                    }
                }
                this.sentCancel = true;
            }
            catch (NetException ne) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne).fillInStackTrace();
            }
            catch (IOException ne) {
                this.handleIOException(ne);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne).fillInStackTrace();
            }
            this.cancelInProgressFlag = true;
            this.statementCancel = isStatementCancel;
            return;
        }
    }

    Communication net() {
        return this.net;
    }

    void connectNetworkSessionProtocol(AbstractConnectionBuilder<?, ?> builder) throws IOException, SQLException, InterruptedIOException {
        assert (this.net != null) : "NSProtocol object must be instantiated before calling this method";
        this.begin(Metrics.ConnectionEvent.NET_SESSION_ESTABLISHMENT);
        this.net.connect(builder == null ? null : builder.getGSSCredential(), this.dmsParent);
        this.end(Metrics.ConnectionEvent.NET_SESSION_ESTABLISHMENT);
        this.mare = new T4CMAREngineNIO(this.net, this);
        this.mare.setConnectionDuringExceptionHandling(this);
    }

    private void postTTIdtyInitialization(T4C8TTIdty dty) throws SQLException {
        if (dty == null) {
            throw new IllegalArgumentException("dty cannot be null");
        }
        this.setNegotiatedTTCVersion(dty.jdbcThinCompileTimeCapabilities);
        this.setZeroCopyIOCapability();
        this.setLobPrefetchCapability(dty.jdbcThinCompileTimeCapabilities);
        this.set32kVarcharCapability();
        this.setFeatureTrackingCapability();
        this.setRequestBoundariesCapability();
    }

    private T4CTTICookie negotiateSession() throws IOException, SQLException, InterruptedIOException {
        this.begin(Metrics.ConnectionEvent.TTC_NEGOTIATION);
        this.pro = new T4C8TTIpro(this);
        this.begin(Metrics.ConnectionEvent.TTC_TTIPRO);
        this.pro.doRPC();
        this.end(Metrics.ConnectionEvent.TTC_TTIPRO);
        this.serverCompileTimeCapabilities = this.pro.getServerCompileTimeCapabilities();
        this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
        this.validateServerLogonCapability();
        this.doCharSetNegotiation(this.pro.oVersion, this.pro.getCharacterSet(), this.pro.getncharCHARSET());
        this.setCLRBigChunksCapability();
        this.dty = new T4C8TTIdty(this, this.serverRuntimeCapabilities, this.logonCap != null && this.logonCap.trim().equals("o3"), this.thinNetUseZeroCopyIO);
        this.begin(Metrics.ConnectionEvent.TTC_TTIDTY);
        this.dty.doRPC();
        this.end(Metrics.ConnectionEvent.TTC_TTIDTY);
        this.postTTIdtyInitialization(this.dty);
        this.end(Metrics.ConnectionEvent.TTC_NEGOTIATION);
        return T4CTTICookie.builder().databaseRuntimeCapabilities(this.serverRuntimeCapabilities).databaseCompileTimeCapabilities(this.serverCompileTimeCapabilities).connectionProtocolVersion(this.pro.getProtocolVersion()).databaseCharSet(this.pro.getCharacterSet()).databaseNCharSet(this.pro.getncharCHARSET()).databaseCharSetFlag(this.pro.getFlags()).databasePortage(this.pro.getSvrPortDescription()).build();
    }

    private final CompletionStage<Void> connectSessionAsync(AbstractConnectionBuilder<?, ?> builder, AsyncOutboundTimeoutHandler loginTimeoutHandler) {
        if (!this.javaNetNio) {
            return CompletionStageUtil.failedStage(new SQLException("Asynchronous connection is not supported when  oracle.jdbc.javaNetNio=false"));
        }
        Executor executor = this.getAsyncExecutor();
        return this.net.connectAsync(builder == null ? null : builder.getGSSCredential(), this.dmsParent, loginTimeoutHandler, executor).thenCompose(CompletionStageUtil.normalCompletionHandler(nil -> {
            this.mare = new T4CMAREngineNIO(this.net, this);
            this.mare.setConnectionDuringExceptionHandling(this);
            this.pro = new T4C8TTIpro(this);
            this.pro.marshal();
            return this.pro.receiveAsync(executor);
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(proReceived -> {
            this.serverCompileTimeCapabilities = proReceived;
            this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
            this.validateServerLogonCapability();
            this.doCharSetNegotiation(this.pro.oVersion, this.pro.getCharacterSet(), this.pro.getncharCHARSET());
            this.setCLRBigChunksCapability();
            boolean downgradeToO3Logon = this.logonCap != null && this.logonCap.trim().equals("o3");
            this.dty = new T4C8TTIdty(this, this.serverRuntimeCapabilities, downgradeToO3Logon, this.thinNetUseZeroCopyIO);
            return this.dty.doRPCAsync(executor).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                this.postTTIdtyInitialization(this.dty);
                return null;
            }));
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINER)
    @Blind(value=PropertiesBlinder.class)
    private final Properties createNSProperties(AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        try {
            void builder;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CConnection", "createNSProperties", "entering args ({0})", (String)null, null, new Object[]{abstractConnectionBuilder});
            Properties nsProperties = new Properties();
            if (this.isUseTcpFastOpen) {
                nsProperties.setProperty("oracle.net.useTcpFastOpen", "true");
            }
            if (this.thinNetProfile != null) {
                nsProperties.setProperty("oracle.net.profile", this.thinNetProfile);
            }
            if (this.thinNetSetFIPSMode != null) {
                nsProperties.setProperty("oracle.net.setFIPSMode", this.thinNetSetFIPSMode);
            }
            if (this.thinNetAuthenticationServices != null) {
                nsProperties.setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
                if (this.thinNetAuthenticationServices.toUpperCase().contains("RADIUS")) {
                    Object handler = null;
                    if (builder != null && builder.getRadiusChallengeResponseHandler() != null) {
                        handler = builder.getRadiusChallengeResponseHandler();
                    } else if (this.thinNetRadiusCRHandler != null) {
                        handler = this.thinNetRadiusCRHandler;
                    }
                    if (handler != null) {
                        nsProperties.put("oracle.net.radius_challenge_response_handler", handler);
                        if (this.userName != null) {
                            nsProperties.setProperty("oracle.net.radius_user", this.userName);
                        }
                        if (this.password != null) {
                            nsProperties.put("oracle.net.radius_password", this.password);
                        }
                    }
                }
                if (this.thinNetAuthenticationServices.toUpperCase().contains("KERBEROS5")) {
                    if (this.userName != null) {
                        nsProperties.setProperty("oracle.net.kerberos5_user", this.userName);
                    }
                    if (this.password != null) {
                        nsProperties.put("oracle.net.kerberos5_password", this.password);
                    }
                }
            }
            if (this.thinNetAuthenticationKrb5Mutual != null) {
                nsProperties.setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
            }
            if (this.thinNetAuthenticationKrb5CcName != null) {
                nsProperties.setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
            }
            if (this.thinNetAuthenticationKrbJaasLoginModule != null) {
                nsProperties.setProperty("oracle.net.KerberosJaasLoginModule", this.thinNetAuthenticationKrbJaasLoginModule);
            }
            if (this.thinNetAllowWeakCrypto != Boolean.valueOf("true")) {
                nsProperties.setProperty("oracle.net.allow_weak_crypto", Boolean.toString(this.thinNetAllowWeakCrypto));
            }
            if (this.thinNetEncryptionLevel != null) {
                nsProperties.setProperty("oracle.net.encryption_client", this.thinNetEncryptionLevel);
            }
            if (this.thinNetEncryptionTypes != null) {
                nsProperties.setProperty("oracle.net.encryption_types_client", this.thinNetEncryptionTypes);
            }
            if (this.thinNetChecksumLevel != null) {
                nsProperties.setProperty("oracle.net.crypto_checksum_client", this.thinNetChecksumLevel);
            }
            if (this.thinNetChecksumTypes != null) {
                nsProperties.setProperty("oracle.net.crypto_checksum_types_client", this.thinNetChecksumTypes);
            }
            if (this.thinNetCryptoSeed != null) {
                nsProperties.setProperty("oracle.net.crypto_seed", this.thinNetCryptoSeed);
            }
            if (this.thinNetAuthenticationKrbRealm != null) {
                nsProperties.setProperty("oracle.net.KerberosRealm", this.thinNetAuthenticationKrbRealm);
            }
            if (this.thinTcpNoDelay) {
                nsProperties.setProperty("TCP.NODELAY", "YES");
            }
            if (this.thinReadTimeout != null) {
                nsProperties.setProperty("oracle.net.READ_TIMEOUT", String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(this.thinReadTimeout, false, 0)));
            }
            if (this.thinNetConnectTimeout != null) {
                nsProperties.setProperty("oracle.net.CONNECT_TIMEOUT", this.thinNetConnectTimeout);
            }
            if (this.thinSslServerDnMatch != null) {
                nsProperties.setProperty("oracle.net.ssl_server_dn_match", this.thinSslServerDnMatch);
            }
            if (this.thinSslAllowWeakDnMatch != null) {
                nsProperties.setProperty("oracle.net.ssl_allow_weak_dn_match", this.thinSslAllowWeakDnMatch);
            }
            if (this.thinSslServerCertDn != null) {
                nsProperties.setProperty("oracle.net.ssl_server_cert_dn", this.thinSslServerCertDn);
            }
            if (this.walletLocation != null) {
                nsProperties.setProperty("oracle.net.wallet_location", this.walletLocation);
            }
            if (this.walletPassword != null && this.walletPassword != OpaqueString.NULL) {
                nsProperties.put("oracle.net.wallet_password", this.walletPassword);
            }
            if (this.thinSslVersion != null) {
                nsProperties.setProperty("oracle.net.ssl_version", this.thinSslVersion);
            }
            if (this.thinSslCipherSuites != null) {
                nsProperties.setProperty("oracle.net.ssl_cipher_suites", this.thinSslCipherSuites);
            }
            if (this.thinSslCertificateAlias != null) {
                nsProperties.setProperty("oracle.net.ssl_certificate_alias", this.thinSslCertificateAlias);
            }
            if (this.thinSslCertificateThumbprint != null) {
                nsProperties.setProperty("oracle.net.ssl_certificate_thumbprint", this.thinSslCertificateThumbprint);
            }
            if (this.thinJavaxNetSslKeystore != null) {
                nsProperties.setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
            }
            if (this.thinJavaxNetSslKeystoretype != null) {
                nsProperties.setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
            }
            if (this.thinJavaxNetSslKeystorepassword != null && this.thinJavaxNetSslKeystorepassword != OpaqueString.NULL) {
                nsProperties.put("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword);
            }
            if (this.thinJavaxNetSslTruststore != null) {
                nsProperties.setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
            }
            if (this.thinJavaxNetSslTruststoretype != null) {
                nsProperties.setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
            }
            if (this.thinJavaxNetSslTruststorepassword != null && this.thinJavaxNetSslTruststorepassword != OpaqueString.NULL) {
                nsProperties.put("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword);
            }
            if (this.thinSslKeymanagerfactoryAlgorithm != null) {
                nsProperties.setProperty("ssl.keyManagerFactory.algorithm", this.thinSslKeymanagerfactoryAlgorithm);
            }
            if (this.thinSslTrustmanagerfactoryAlgorithm != null) {
                nsProperties.setProperty("ssl.trustManagerFactory.algorithm", this.thinSslTrustmanagerfactoryAlgorithm);
            }
            if (this.thinNetOldsyntax != null) {
                nsProperties.setProperty("oracle.net.oldSyntax", this.thinNetOldsyntax);
            }
            if (this.thinJndiLdapConnectTimeout != null) {
                nsProperties.setProperty("com.sun.jndi.ldap.connect.timeout", this.thinJndiLdapConnectTimeout);
            }
            if (this.thinJndiLdapReadTimeout != null) {
                nsProperties.setProperty("com.sun.jndi.ldap.read.timeout", this.thinJndiLdapReadTimeout);
            }
            if (this.thinLdapSslCipherSuites != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.supportedCiphers", this.thinLdapSslCipherSuites);
            }
            if (this.thinLdapSslVersions != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.supportedVersions", this.thinLdapSslVersions);
            }
            if (this.thinLdapSslKeyStore != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.keyStore", this.thinLdapSslKeyStore);
            }
            if (this.thinLdapSslKeyStoreType != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.keyStoreType", this.thinLdapSslKeyStoreType);
            }
            if (this.thinLdapSslKeyStorePwd != null && this.thinLdapSslKeyStorePwd != OpaqueString.NULL) {
                nsProperties.put("oracle.net.ldap.ssl.keyStorePassword", this.thinLdapSslKeyStorePwd);
            }
            if (this.thinLdapSslKeyManagerFactoryAlgo != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm", this.thinLdapSslKeyManagerFactoryAlgo);
            }
            if (this.thinLdapSslTrustStore != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.trustStore", this.thinLdapSslTrustStore);
            }
            if (this.thinLdapSslTrustStoreType != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.trustStoreType", this.thinLdapSslTrustStoreType);
            }
            if (this.thinLdapSslTrustStorePassword != null && this.thinLdapSslTrustStorePassword != OpaqueString.NULL) {
                nsProperties.put("oracle.net.ldap.ssl.trustStorePassword", this.thinLdapSslTrustStorePassword);
            }
            if (this.thinLdapSslTrustManagerFactoryAlgo != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm", this.thinLdapSslTrustManagerFactoryAlgo);
            }
            if (this.thinLdapSslWalletLocation != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.walletLocation", this.thinLdapSslWalletLocation);
            }
            if (this.thinLdapSslWalletPassword != null && this.thinLdapSslWalletPassword != OpaqueString.NULL) {
                nsProperties.put("oracle.net.ldap.ssl.walletPassword", this.thinLdapSslWalletPassword);
            }
            if (this.thinLdapSecurityAuthentication != null) {
                nsProperties.setProperty("oracle.net.ldap.security.authentication", this.thinLdapSecurityAuthentication);
            }
            if (this.thinLdapSecurityPrincipal != null) {
                nsProperties.setProperty("oracle.net.ldap.security.principal", this.thinLdapSecurityPrincipal);
            }
            if (this.thinLdapSecurityCredetials != null && !this.thinLdapSecurityCredetials.isNull()) {
                nsProperties.put("oracle.net.ldap.security.credentials", this.thinLdapSecurityCredetials);
            }
            if (this.thinLdapsslContextProtocol != null) {
                nsProperties.setProperty("oracle.net.ldap.ssl.ssl_context_protocol", this.thinLdapsslContextProtocol);
            }
            if (this.thinNetConnectionIdPrefix != null) {
                nsProperties.setProperty("oracle.net.connectionIdPrefix", this.thinNetConnectionIdPrefix);
            }
            if (this.thinHttpsProxyHost != null) {
                nsProperties.setProperty("oracle.net.httpsProxyHost", this.thinHttpsProxyHost);
                nsProperties.setProperty("oracle.net.httpsProxyPort", Integer.toString(this.thinHttpsProxyPort));
            }
            if (this.tnsAdmin != null) {
                nsProperties.setProperty("oracle.net.tns_admin", this.tnsAdmin);
            }
            if (this.thinNetDisableOutOfBandBreak) {
                nsProperties.setProperty("DISABLE_OOB", "" + this.thinNetDisableOutOfBandBreak);
            }
            nsProperties.setProperty("USE_ZERO_COPY_IO", "" + this.thinNetUseZeroCopyIO);
            nsProperties.setProperty("FORCE_DNS_LOAD_BALANCING", "" + this.thinForceDnsLoadBalancing);
            if (this.thinOutboundConnectTimeout != null) {
                nsProperties.setProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT", this.thinOutboundConnectTimeout);
            }
            nsProperties.setProperty("oracle.jdbc.v$session.osuser", this.thinVsessionOsuser);
            nsProperties.setProperty("oracle.jdbc.v$session.program", this.thinVsessionProgram);
            nsProperties.setProperty("T4CConnection.hashCode", Integer.toHexString(this.hashCode()).toUpperCase());
            nsProperties.setProperty("oracle.net.keepAlive", Boolean.toString(this.keepAlive));
            nsProperties.setProperty("oracle.jdbc.useNio", Boolean.toString(this.javaNetNio));
            if (this.javaNetLocalIPForMsgq != null) {
                nsProperties.setProperty("oracle.jdbc.javaNetLocalIPForMsgq", this.javaNetLocalIPForMsgq);
            }
            if (this.javaNetMsgqTransport != null) {
                nsProperties.setProperty("oracle.jdbc.javaNetMsgqTransport", this.javaNetMsgqTransport);
            }
            nsProperties.setProperty("oracle.jdbc.javaNetMsgqBusyWait", "" + this.javaNetMsgqBusyWait);
            nsProperties.setProperty("oracle.jdbc.javaNetMsgqKernelWait", "" + this.javaNetMsgqKernelWait);
            nsProperties.setProperty("oracle.net.DOWN_HOSTS_TIMEOUT", "" + this.downHostsTimeout);
            if (this.targetInstanceName != null) {
                nsProperties.setProperty("oracle.jdbc.targetInstanceName", this.targetInstanceName);
            }
            if (this.targetServiceName != null) {
                nsProperties.setProperty("oracle.jdbc.targetServiceName", this.targetServiceName);
            }
            if (this.targetShardingKey != null) {
                nsProperties.setProperty("oracle.jdbc.targetShardingKey", this.targetShardingKey);
            }
            if (this.targetSuperShardingKey != null) {
                nsProperties.setProperty("oracle.jdbc.targetSuperShardingKey", this.targetSuperShardingKey);
            }
            if (this.readOnlyInstanceAllowed) {
                nsProperties.setProperty("oracle.jdbc.readOnlyInstanceAllowed", String.valueOf(this.readOnlyInstanceAllowed));
            }
            if (this.websocketUser != null) {
                nsProperties.setProperty("oracle.net.websocketUser", this.websocketUser);
                if (this.websocketPassword != null && this.websocketPassword != OpaqueString.NULL) {
                    nsProperties.put("oracle.net.websocketPassword", this.websocketPassword);
                } else {
                    nsProperties.put("oracle.net.websocketPassword", OpaqueString.EMPTY);
                }
            }
            if (this.socksProxyHost != null) {
                nsProperties.setProperty("oracle.net.socksProxyHost", this.socksProxyHost);
                nsProperties.setProperty("oracle.net.socksProxyPort", this.socksProxyPort + "");
            }
            if (this.proxyRemoteDNS != null) {
                nsProperties.setProperty("oracle.net.proxyRemoteDNS", Boolean.valueOf(this.proxyRemoteDNS) + "");
            } else if (this.socksRemoteDNS != null) {
                nsProperties.setProperty("oracle.net.proxyRemoteDNS", Boolean.valueOf(this.socksRemoteDNS) + "");
            }
            nsProperties.setProperty("oracle.net.networkCompression", this.networkCompression);
            nsProperties.setProperty("oracle.net.networkCompressionLevels", this.networkCompressionLevels);
            nsProperties.setProperty("oracle.net.networkCompressionThreshold", Integer.toString(this.networkCompressionThreshold));
            if (this.tcpKeepIdle != -1) {
                nsProperties.setProperty("oracle.net.TCP_KEEPIDLE", Integer.toString(this.tcpKeepIdle));
            }
            if (this.tcpKeepInterval != -1) {
                nsProperties.setProperty("oracle.net.TCP_KEEPINTERVAL", Integer.toString(this.tcpKeepInterval));
            }
            if (this.tcpKeepCount != -1) {
                nsProperties.setProperty("oracle.net.TCP_KEEPCOUNT", Integer.toString(this.tcpKeepCount));
            }
            nsProperties.setProperty("oracle.net.ssl_context_protocol", this.sslContextProtocol == null ? "TLS" : this.sslContextProtocol);
            nsProperties.setProperty("oracle.net.ssl_server_dn_match_default", Boolean.toString(builder.getTokenSupplier() != null || !OpaqueString.isNull(this.accessToken) || this.getDriverResources().isProviderConfigured(ResourceType.ACCESS_TOKEN) || this.tokenAuthentication != null || PasswordAuthentication.OCI_TOKEN.name().equalsIgnoreCase(this.passwordAuthentication) || PasswordAuthentication.AZURE_TOKEN.name().equalsIgnoreCase(this.passwordAuthentication)));
            if (this.tokenAuthentication != null) {
                nsProperties.setProperty("oracle.jdbc.tokenAuthentication", this.tokenAuthentication);
            }
            if (this.passwordAuthentication != null) {
                nsProperties.setProperty("oracle.jdbc.passwordAuthentication", this.passwordAuthentication);
            }
            if (this.localHostName != null) {
                nsProperties.setProperty("oracle.jdbc.localhostName", this.localHostName);
            }
            Properties properties = nsProperties;
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CConnection", "createNSProperties", "returning {0}", (String)null, null, new Object[]{new PropertiesBlinder().blind(properties)});
            return properties;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINER, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CConnection", "createNSProperties", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private final void validateServerLogonCapability() throws SQLException {
        if (this.allowedLogonVersion.equals("12a")) {
            if (!this.hasServerCompileTimeCapability(4, 32)) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
            }
        } else {
            try {
                int allowedLogonVersionInteger = Integer.parseInt(this.allowedLogonVersion);
                switch (allowedLogonVersionInteger) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 10: 
                    case 11: {
                        if (!this.hasServerCompileTimeCapability(4, 8)) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                        }
                        break;
                    }
                    case 12: {
                        if (!this.hasServerCompileTimeCapability(4, 2)) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                        }
                        break;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 293).fillInStackTrace();
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 293).fillInStackTrace();
            }
        }
    }

    private void doCharSetNegotiation(short oracleVersion, short characterSet, short ncharacterSet) throws SQLException {
        short accessCharSet = DBConversion.findDriverCharSet(characterSet, oracleVersion);
        this.conversion = new DBConversion(characterSet, accessCharSet, ncharacterSet, this.isStrictAsciiConversion, this.isQuickAsciiConversion, this::getByteBuffer, this::cacheBuffer, this::getCharBuffer, this::cacheBuffer);
        this.mare.types.setServerConversion(accessCharSet != characterSet);
        if (DBConversion.isCharSetMultibyte(accessCharSet)) {
            if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet())) {
                this.mare.types.setFlags((byte)1);
            } else {
                this.mare.types.setFlags((byte)2);
            }
        } else {
            this.mare.types.setFlags(this.pro.getFlags());
        }
        this.mare.conv = this.conversion;
    }

    private final void setCLRBigChunksCapability() {
        if (this.hasServerCompileTimeCapability(37, 32)) {
            this.mare.setUseCLRBigChunks(true);
        }
    }

    private final void setNegotiatedTTCVersion(byte[] jdbcCapabilities) {
        byte serverVersion = this.serverCompileTimeCapabilities[7];
        this.oer = serverVersion >= 14 ? new T4CTTIoer(this) : (serverVersion >= 7 ? new T4CTTIoer19(this) : new T4CTTIoer11(this));
        byte jdbcThinVersion = jdbcCapabilities[7];
        this.negotiatedTTCversion = jdbcThinVersion < serverVersion ? jdbcThinVersion : serverVersion;
    }

    private final void setZeroCopyIOCapability() throws SQLException {
        this.useZeroCopyIO = this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > 6 && (this.serverRuntimeCapabilities[6] & T4C8TTIdty.KPCCAP_RTB_TTC_ZCPY) != 0 && this.thinNetUseZeroCopyIO && (this.net.getSessionAttributes().getNegotiatedOptions() & 0x40) != 0 && this.getDataIntegrityAlgorithmName().equals("") && this.getEncryptionAlgorithmName().equals("");
    }

    private final void setLobPrefetchCapability(byte[] jdbcCapabilities) {
        this.useLobPrefetch = this.hasServerCompileTimeCapability(23, 64) && T4CConnection.bit(jdbcCapabilities[23], 64);
    }

    private final void set32kVarcharCapability() {
        if (this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > T4C8TTIdty.KPCCAP_RTB_TTC && T4CConnection.bit(this.serverRuntimeCapabilities[T4C8TTIdty.KPCCAP_RTB_TTC], T4C8TTIdty.KPCCAP_RTB_TTC_32K)) {
            this.maxNonStreamBindByteSize = Short.MAX_VALUE;
            this.varTypeMaxLenCompat = 2;
        } else {
            this.maxNonStreamBindByteSize = 4000;
            this.varTypeMaxLenCompat = 1;
        }
    }

    private final void setFeatureTrackingCapability() {
        if (this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > T4C8TTIdty.KPCCAP_RTB_TTC && T4CConnection.bit(this.serverRuntimeCapabilities[T4C8TTIdty.KPCCAP_RTB_TTC], T4C8TTIdty.KPCCAP_RTB_TTC_FEATURE_TRACK)) {
            this.isFeatureTrackingSupported = true;
        }
    }

    private final void setRequestBoundariesCapability() {
        this.svrSupportsRequests = this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > T4C8TTIdty.KPCCAP_RTB_TTC && T4CConnection.bit(this.serverRuntimeCapabilities[T4C8TTIdty.KPCCAP_RTB_TTC], T4C8TTIdty.KPCCAP_RTB_TTC_SESSSTATEOPS);
        this.svrSupportsExplicitRequestBit = this.svrSupportsRequests && this.hasServerCompileTimeCapability(40, 64);
    }

    @Override
    public boolean serverSupportsRequestBoundaries() throws SQLException {
        return this.svrSupportsRequests;
    }

    @Override
    public boolean serverSupportsExplicitBoundaryBit() throws SQLException {
        return this.svrSupportsExplicitRequestBit;
    }

    private void initializePipeline() throws IOException {
        String isPipelineDisabled = System.getProperty("oracle.jdbc.disablePipeline");
        this.pipeline = "true".equalsIgnoreCase(isPipelineDisabled) || this.getTTCVersion() < 18 || !this.hasServerCompileTimeCapability(44, 4) || this.net.getSessionAttributes().getNTAdapter().getNetworkAdapterType() == NTAdapter.NetworkAdapterType.BEQ || "2".equals(this.sessionProperties.getProperty("AUTH_SERVER_TYPE")) || isPipelineDisabled == null && !this.net.isOutOfBandDataEnabled() ? Pipeline.createHalfDuplex(this.net, this.getMonitorLock(), this.getAsyncExecutor(), this.getDiagnosable()) : Pipeline.createFullDuplex(this.net, this.getMonitorLock(), this.getAsyncExecutor(), this.getDiagnosable(), new T4CTTIoplbgn(this), new T4CTTIoplend(this));
    }

    void reNegotiateTTCProDty() throws SQLException, IOException {
        this.serverCompileTimeCapabilities = this.pro.receivePacket();
        this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
        this.validateServerLogonCapability();
        this.doCharSetNegotiation(this.pro.oVersion, this.pro.getCharacterSet(), this.pro.getncharCHARSET());
        this.dty = new T4C8TTIdty(this, this.serverRuntimeCapabilities, this.logonCap != null && this.logonCap.trim().equals("o3"), this.thinNetUseZeroCopyIO);
        this.dty.doRPC();
        this.postTTIdtyInitialization(this.dty);
        if (!this.isLoggedOn) {
            DATABASE_NEGOTIATED_INFORMATION.get(this.net.getSessionAttributes().getDatabaseUUID()).ifPresent(cookie -> {
                T4CTTICookie updatedCookie = T4CTTICookie.builder().databaseRuntimeCapabilities(this.pro.getServerRuntimeCapabilities()).databaseCompileTimeCapabilities(this.pro.getServerCompileTimeCapabilities()).connectionProtocolVersion(this.pro.getProtocolVersion()).databaseCharSet(this.pro.getCharacterSet()).databaseNCharSet(this.pro.getncharCHARSET()).databaseCharSetFlag(this.pro.getFlags()).databasePortage(this.pro.getSvrPortDescription()).build();
                this.debug(Level.FINER, SecurityLabel.INTERNAL, CLASS_NAME, "reNegotiateTTCProDty", "update cookie for server {0}: {1} ", (String)null, null, (Object)StringUtils.byteArrayToHexUnicode(this.net.getSessionAttributes().getDatabaseUUID().getBytes()), (Object)updatedCookie);
                DATABASE_NEGOTIATED_INFORMATION.put(this.net.getSessionAttributes().getDatabaseUUID(), updatedCookie);
            });
        }
    }

    void processTTIDtyResponse() throws SQLException, IOException {
        this.dty.receivePayload();
        this.postTTIdtyInitialization(this.dty);
    }

    void processTTIProResponse() throws SQLException, IOException {
        this.pro.receivePayload();
        this.validateServerLogonCapability();
        this.serverCompileTimeCapabilities = this.pro.getServerCompileTimeCapabilities();
        this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
    }

    boolean isZeroCopyIOEnabled() {
        return this.useZeroCopyIO;
    }

    final T4CTTIoer11 getT4CTTIoer() {
        return this.oer;
    }

    final byte getTTCVersion() {
        return this.negotiatedTTCversion;
    }

    @Override
    void doStartup(int mode) throws SQLException {
        try {
            int stomode = 0;
            if (mode == OracleConnection.DatabaseStartupMode.FORCE.getMode()) {
                stomode = 16;
            } else if (mode == OracleConnection.DatabaseStartupMode.RESTRICT.getMode()) {
                stomode = 1;
            }
            this.spfp.doOSPFPPUT();
            this.sto.doOV6STRT(stomode);
            this.isDatabaseShutdown = false;
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    @Override
    void doShutdown(int mode) throws SQLException {
        try {
            int stomode = 4;
            if (mode == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL.getMode()) {
                stomode = 128;
            } else if (mode == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL.getMode()) {
                stomode = 256;
            } else if (mode == OracleConnection.DatabaseShutdownMode.IMMEDIATE.getMode()) {
                stomode = 2;
            } else if (mode == OracleConnection.DatabaseShutdownMode.FINAL.getMode()) {
                stomode = 8;
            } else if (mode == OracleConnection.DatabaseShutdownMode.ABORT.getMode()) {
                stomode = 64;
            }
            this.sto.doOV6STOP(stomode);
            this.isDatabaseShutdown = true;
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkEndReplayCallback() throws SQLException {
        if (this.endReplayCallback != null && this.oappcontreplayContextsArr == null) {
            boolean isRndTrpAtOutageNonReq = this.replayModes.contains((Object)ReplayMode.NONREQUEST);
            if (isRndTrpAtOutageNonReq) {
                this.replayModes.remove((Object)ReplayMode.NONREQUEST);
            }
            OracleConnection.EndReplayCallback localCopy = this.endReplayCallback;
            this.endReplayCallback = null;
            T4C8Oall tempAll8 = new T4C8Oall(this);
            T4C8Oall savedAll8 = this.all8;
            this.all8 = tempAll8;
            try {
                localCopy.executeCallback();
            }
            finally {
                this.all8 = savedAll8;
                if (isRndTrpAtOutageNonReq) {
                    this.replayModes.add(ReplayMode.NONREQUEST);
                }
            }
        }
    }

    void redoCursorClose() {
        if (this.cursorToCloseOffset == 0 && this.lastCursorToCloseOffset != 0) {
            this.cursorToCloseOffset = this.lastCursorToCloseOffset;
            this.lastCursorToCloseOffset = 0;
        }
    }

    void sendPiggyBackedMessages() throws SQLException, IOException {
        ResultSetCache.ResultSetCacheState state;
        ResultSetCache cache;
        int i;
        if (this.switchFromProxySession) {
            this.oses.doO80SES(this.sessionId, this.serialNumber, 1);
            this.switchFromProxySession = false;
        }
        if (this.queryToCloseOffset > 0) {
            this.close8.doOCANA(this.queryToClose, this.queryToCloseOffset);
            this.queryToCloseOffset = 0;
        }
        if (this.cursorToCloseOffset > 0 && this.canSendCursorIds()) {
            this.close8.doOCCA(this.cursorToClose, this.cursorToCloseOffset);
            this.lastCursorToCloseOffset = this.cursorToCloseOffset;
            this.cursorToCloseOffset = 0;
        }
        if (this.endToEndAnyChanged && this.getTTCVersion() >= 3) {
            this.oscid.doOSCID(this.endToEndHasChanged, this.endToEndValues, this.endToEndECIDSequenceNumber);
            for (i = 0; i < 6; ++i) {
                if (!this.endToEndHasChanged[i]) continue;
                this.endToEndHasChanged[i] = false;
            }
        }
        this.endToEndAnyChanged = false;
        if (!this.namespaces.isEmpty() && this.getExecutingRPCFunctionCode() != 118 && this.getExecutingRPCFunctionCode() != 115) {
            if (this.getTTCVersion() >= 4) {
                Object[] namespacesArr = this.namespaces.values().toArray();
                for (int i2 = 0; i2 < namespacesArr.length; ++i2) {
                    this.okeyval.doOKEYVAL((Namespace)namespacesArr[i2]);
                }
            }
            this.namespaces.clear();
        }
        if (this.lusOffset2 > 0) {
            for (i = 0; i < this.lusOffset2; ++i) {
                this.oxsspo.doOXSSPO(this.lusFunctionId2[i], this.lusSessionId2[i], this.lusInKeyVal2[i], this.lusInFlags2[i]);
            }
            this.lusOffset2 = 0;
        }
        if (this.isResultSetCacheEnabled && this.oqcsta != null && (cache = this.getResultSetCacheInternal()) != null && cache.needToSendStatsResetIfTrue()) {
            long blockSize = 512L;
            long cacheSize = cache.getCurrentCacheSize();
            long maxBlocks = cacheSize / blockSize;
            if (cacheSize % blockSize > 0L) {
                ++maxBlocks;
            }
            this.oqcsta.doOQCSTA(this, this.mare, blockSize, maxBlocks, maxBlocks, 0L, cache.getNumberOfCacheEntries(), cache.getInvalidatedBeforeCompletion(), cache.getCacheHits(), cache.getInvalidationCount(), cache.getInvalidatedQueryCount(), cache.getValidQueriesPurged());
            this.oqcsta.connection = null;
            this.oqcsta.meg = null;
        }
        this.sendOsesssstateFlags();
        if (!this.replayModes.contains((Object)ReplayMode.NONREQUEST) && this.oappcontreplayContextsArr != null) {
            while (this.oappcontreplayOffset < this.oappcontreplayContextsArr.length - 1 && this.oappcontreplayContextsArr[this.oappcontreplayOffset] == null) {
                ++this.oappcontreplayOffset;
            }
            if (this.oappcontreplayContextsArr[this.oappcontreplayOffset] != null && this.oappcontreplayContextsArr[this.oappcontreplayOffset].getContext() != null) {
                this.oappcontreplay.doOAPPCONTREPLAY(this.oappcontreplayContextsArr[this.oappcontreplayOffset]);
            }
            if (this.oappcontreplayOffset == this.oappcontreplayContextsArr.length - 1) {
                this.oappcontreplayContextsArr = null;
            } else {
                ++this.oappcontreplayOffset;
            }
        }
        if (!this.replayModes.contains((Object)ReplayMode.NONREQUEST) && this.sessionStateOut != null) {
            this.osesstemplate.doOSESSTEMPLATE(this.sessionStateOut);
            this.sessionStateOut = null;
        }
        if (this.isResultSetCacheEnabled && this.resultSetCache != null && (state = this.resultSetCache.getState()) == ResultSetCache.ResultSetCacheState.STARTING && this.resultSetCache.getRegistrationId() != -1L) {
            byte[] cacheId = this.resultSetCache.getCacheId();
            long registrationId = this.resultSetCache.getRegistrationId();
            this.oqcid.doOQCID(cacheId, registrationId);
        }
        if (this.shardingKey != null || this.superShardingKey != null || this.chunkName != null) {
            this.piggyBackOchunkinfo.doOCHUNKINFO(this.shardingKey, this.superShardingKey, this.chunkName, true);
            this.shardingKey = null;
            this.superShardingKey = null;
            this.chunkName = null;
        }
        this.sendOCLFEATURES();
    }

    void sendPiggyBackedMessages(boolean isClose) throws SQLException, IOException {
        this.sendPiggyBackedMessages();
        if (!isClose) {
            this.lobMsg.doFreeLobPiggyback();
        } else {
            this.lobMsg.resetLobPiggyback();
        }
    }

    private void sendOCLFEATURES() throws SQLException, IOException {
        if (this.commoncall.getFunCode() == 9 && !this.isProxySessionLogoff && this.isFeatureTrackingSupported && !this.isDatabaseShutdown) {
            if (this.isResultSetCacheEnabled) {
                this.addFeature(OracleConnection.ClientFeature.CACHED_RESULTSET);
            }
            this.oclFeatures.doOCLFEATURES();
        }
    }

    void sendOsesssstateFlags() throws IOException, SQLException {
        this.assertLockHeldByCurrentThread();
        assert (!this.replayModes.contains((Object)ReplayMode.RUNTIME_REPLAY_ENABLED) || !this.replayModes.contains((Object)ReplayMode.REPLAYING)) : "RUNTIME_REPLAY_ENABLED and REPLAYING modes cannot bet set at the same time";
        if (this.replayModes.contains((Object)ReplayMode.NONREQUEST)) {
            if (this.replayModes.contains((Object)ReplayMode.RUNTIME_REPLAY_ENABLED)) {
                if (this.osessstateFlags == -1L) {
                    this.osessstateFlags = 0L;
                }
                this.osessstateFlags |= OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NONREQUEST_CALL.getCode() | OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED.getCode();
            } else if (this.replayModes.contains((Object)ReplayMode.REPLAYING)) {
                this.osessstateFlags = OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NONREQUEST_CALL.getCode();
            }
            if (this.replayModes.contains((Object)ReplayMode.RUNTIME_OR_REPLAYING_STATIC)) {
                this.osessstateFlags |= OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC.getCode();
            }
        }
        if (this.osessstateFlags >= 0L) {
            this.osesstate.doOSESSSTATE(this.osessstateFlags, false);
        }
        this.osessstateFlags = -1L;
    }

    void closeCursor(int cursorId) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "closeCursor", "cursorId={0}. ", (String)null, (Throwable)null, (Object)cursorId);
        if (this.cursorToCloseOffset == this.cursorToClose.length) {
            int[] cursorToClose2 = new int[this.cursorToClose.length * 2];
            System.arraycopy(this.cursorToClose, 0, cursorToClose2, 0, this.cursorToClose.length);
            this.cursorToClose = cursorToClose2;
        }
        this.cursorToClose[this.cursorToCloseOffset++] = cursorId;
    }

    void closeQuery(int cursorId) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "closeQuery", "cursorId={0}. ", (String)null, (Throwable)null, (Object)cursorId);
        this.assertLockHeldByCurrentThread();
        if (this.queryToCloseOffset == this.queryToClose.length) {
            int[] queryToClose2 = new int[this.queryToClose.length * 2];
            System.arraycopy(this.queryToClose, 0, queryToClose2, 0, this.queryToClose.length);
            this.queryToClose = queryToClose2;
        }
        this.queryToClose[this.queryToCloseOffset++] = cursorId;
    }

    @Override
    void doProxySession(int type, @Blind(value=PropertiesBlinder.class) Properties prop) throws SQLException {
        try {
            String clientPassword;
            if (type == 1 && (clientPassword = prop.getProperty("PROXY_USER_PASSWORD")) != null && clientPassword.length() != 0) {
                String clientUser = prop.getProperty("PROXY_USER_NAME");
                this.auth.doOSESSKEY(clientUser, 0L);
            }
            this.auth.doOAUTH(type, prop, this.sessionId, this.serialNumber);
            int prox_session_id = this.getSessionId();
            int prox_serial_nb = this.getSerialNumber();
            this.currentSchema = null;
            this.oses.doO80SES(prox_session_id, prox_serial_nb, 1);
            this.savedUser = this.userName;
            this.userName = type == 1 ? prop.getProperty("PROXY_USER_NAME") : null;
            this.isProxy = true;
        }
        catch (IOException ioe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
        }
    }

    @Override
    void closeProxySession() throws SQLException {
        try {
            this.isProxySessionLogoff = true;
            this.commoncall.doOLOGOFF();
            this.switchFromProxySession = true;
            this.userName = this.savedUser;
            this.currentSchema = null;
        }
        catch (IOException ioe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
        }
        finally {
            this.isProxySessionLogoff = false;
        }
    }

    void updateSessionProperties(KeywordValue[] kvalArr) throws SQLException {
        if (this.sessionProperties == null) {
            this.sessionProperties = new Properties();
        }
        for (int i = 0; i < kvalArr.length; ++i) {
            int keyword = kvalArr[i].getKeyword();
            byte[] value = kvalArr[i].getBinaryValue();
            if (keyword < T4C8Oall.NLS_KEYS.length) {
                String key = T4C8Oall.NLS_KEYS[keyword];
                if (key == null) continue;
                if (value != null) {
                    this.updateSessionProperties(key, this.mare.conv.CharBytesToString(value, value.length));
                    continue;
                }
                if (kvalArr[i].getTextValue() == null) continue;
                this.updateSessionProperties(key, kvalArr[i].getTextValue().trim());
                continue;
            }
            if (keyword == 163) {
                int minute;
                int hour;
                if (value == null) continue;
                String regionName = null;
                if ((value[2] & 0xFF) > 120) {
                    int regid = (value[2] & 0x7F) << 6;
                    regionName = ZONEIDMAP.getRegion(regid += (value[3] & 0xFC) >> 2);
                    hour = (value[4] & 0xFF) - 181;
                    minute = (value[5] & 0xFF) - 60;
                } else {
                    hour = (value[4] & 0xFF) - 60;
                    minute = (value[5] & 0xFF) - 60;
                }
                String tz = regionName != null && !regionName.equals("") ? regionName : "GMT" + (hour > 0 ? "+" : "") + hour + (minute <= 9 ? ":0" : ":") + minute;
                this.updateSessionProperties("SESSION_TIME_ZONE", tz);
                this.sessionTimeZone = tz;
                continue;
            }
            if (keyword == 165 || keyword == 166 || keyword == 167) continue;
            if (keyword == 168) {
                String schema = kvalArr[i].getTextValue();
                if (schema == null) continue;
                this.currentSchema = schema.trim();
                this.updateSessionProperties("AL8KW_SCHEMA_NAME", this.currentSchema);
                continue;
            }
            if (keyword == 169) continue;
            if (keyword == 199) {
                String roleNames = kvalArr[i].getTextValue();
                if (roleNames == null) continue;
                this.updateSessionProperties("AL8KW_ENABLED_ROLE_NAMES", roleNames.trim());
                continue;
            }
            if (keyword == 171) {
                if (value == null) continue;
                this.updateSessionProperties("AL8KW_AUX_SESSSTATE", this.mare.conv.CharBytesToString(value, value.length));
                continue;
            }
            if (keyword == 175) {
                this.updateMaximumCursorCount(value == null ? null : this.mare.conv.CharBytesToString(value, value.length));
                continue;
            }
            if (keyword == 176) continue;
            if (keyword == 177) {
                long dbID = 0L;
                for (int j = 3; j >= 0; --j) {
                    dbID |= ((long)value[3 - j] & 0xFFL) << 8 * j;
                }
                String dbIDStr = String.valueOf(dbID);
                String currentDbID = this.sessionProperties.getProperty("AUTH_DB_ID");
                if (currentDbID.equals(dbIDStr)) continue;
                this.isPDBChanged = true;
                if (this.getTransactionState().contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                    this.disableCommitOptimizationOnPDBChange = true;
                }
                this.updateSessionProperties("AUTH_DB_ID", dbIDStr);
                continue;
            }
            if (keyword == 178) continue;
            if (keyword == 179) {
                if (kvalArr[i].getTextValue() == null) continue;
                this.dbName = kvalArr[i].getTextValue();
                this.updateSessionProperties("AUTH_DBNAME", this.dbName);
                continue;
            }
            if (keyword == 164) {
                if (value == null || value.length != 1) continue;
                String errOvlap = value[0] > 0 ? "TRUE" : "FALSE";
                this.updateSessionProperties("AL8KW_ERR_OVLAP", errOvlap);
                continue;
            }
            if (keyword == 172) {
                if (kvalArr[i].getTextValue() == null) continue;
                String editionStr = kvalArr[i].getTextValue();
                this.updateSessionProperties("AUTH_ORA_EDITION", editionStr);
                continue;
            }
            if (keyword == 197) {
                if (kvalArr[i].getTextValue() == null) continue;
                String containerName = kvalArr[i].getTextValue();
                this.updateSessionProperties("CONTAINER_NAME", containerName.trim());
                continue;
            }
            if (keyword == 183) {
                if (kvalArr[i].getTextValue() == null) continue;
                String svcName = kvalArr[i].getTextValue();
                this.updateSessionProperties("SERVICE_NAME", svcName.trim());
                continue;
            }
            if (keyword == 173) {
                if (kvalArr[i].getTextValue() == null) continue;
                String sqlTxlp = kvalArr[i].getTextValue();
                this.updateSessionProperties("AL8KW_SQL_TXLP", sqlTxlp);
                continue;
            }
            if (keyword == 174) {
                if (kvalArr[i].getTextValue() == null) continue;
                String fsqlSyntax = kvalArr[i].getTextValue();
                this.updateSessionProperties("AL8KW_FSQL_SNTX", fsqlSyntax);
                continue;
            }
            if (keyword == 187) {
                if (kvalArr[i].getTextValue() == null) continue;
                String archivalStr = kvalArr[i].getTextValue();
                this.updateSessionProperties("AL8KW_ROW_ARCHIVAL", archivalStr);
                continue;
            }
            if (keyword == 186) {
                if (kvalArr[i].getTextValue() == null) continue;
                String clientInfoStr = kvalArr[i].getTextValue();
                this.updateSessionProperties("AL8KW_CLIENT_INFO", clientInfoStr);
                continue;
            }
            if (keyword == 198) {
                if (kvalArr[i].getTextValue() == null) continue;
                String clientIdStr = kvalArr[i].getTextValue();
                this.updateSessionProperties("AL8KW_CLIENT_ID", clientIdStr);
                continue;
            }
            if (keyword != 200 || kvalArr[i].getBinaryValue() == null) continue;
            int rowPrefetchDirective = ByteBuffer.wrap(kvalArr[i].getBinaryValue()).getInt();
            if (!this.isRowPrefetchSetExplicitly && rowPrefetchDirective != 0) {
                this.defaultRowPrefetch = rowPrefetchDirective;
            }
            this.updateSessionProperties("AL8KW_PREFETCH_ROWS", String.valueOf(rowPrefetchDirective));
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "updateSessionProperties", "session Properties={0}. ", (String)null, (Throwable)null, (Object)this.sessionProperties);
    }

    @Override
    void onPDBChange(OracleStatement catalyst) throws SQLException {
        super.onPDBChange(catalyst);
        this.databaseUniqueIdentifier = this.sessionProperties.getProperty("AUTH_DB_ID");
        this.notify(new NTFPDBChangeEvent(this));
    }

    @Override
    protected OracleStatement getCachedStatementWithKey(String key, int statementType) throws SQLException {
        OracleStatement cachedStatement = super.getCachedStatementWithKey(key, statementType);
        if (cachedStatement instanceof T4CDirectPathPreparedStatement) {
            this.setDirectPathState((T4CDirectPathPreparedStatement)cachedStatement);
        }
        return cachedStatement;
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            PreparedStatement preparedStatement = this.prepareDirectPathInternal(schemaName, tableName, colNames, null, null);
            return preparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            PreparedStatement preparedStatement = this.prepareDirectPathInternal(schemaName, tableName, colNames, null, dpStmtProps);
            return preparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, String partitionName) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (partitionName == null || partitionName.length() == 0) {
                throw new IllegalArgumentException("Table partition name argument cannot be null or empty");
            }
            PreparedStatement preparedStatement = this.prepareDirectPathInternal(schemaName, tableName, colNames, partitionName, null);
            return preparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareDirectPath(String schemaName, String tableName, String[] colNames, String partitionName, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (partitionName == null || partitionName.length() == 0) {
                throw new IllegalArgumentException("Table partition name argument cannot be null or empty");
            }
            PreparedStatement preparedStatement = this.prepareDirectPathInternal(schemaName, tableName, colNames, partitionName, dpStmtProps);
            return preparedStatement;
        }
    }

    private PreparedStatement prepareDirectPathInternal(String schemaName, String tableName, String[] colNames, String partitionName, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps) throws SQLException {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("Table name argument cannot be null or empty");
        }
        if (colNames == null || colNames.length == 0) {
            throw new IllegalArgumentException("Column name list argument cannot be null or empty");
        }
        if (this.dppstmt != null && !this.dppstmt.isDirectPathCommitted()) {
            throw new IllegalStateException("Multiple Direct Path statements are not allowed");
        }
        if (this.getAutoCommit()) {
            throw new IllegalStateException("Auto commit should be turned OFF");
        }
        if (this.dppstmt != null && !this.dppstmt.isDirectPathClosed()) {
            this.dppstmt.close();
        }
        this.dppstmt = null;
        try {
            OracleResultSet.ResultSetType resultSetType = OracleResultSet.ResultSetType.FORWARD_READ_ONLY;
            String sql = T4CDirectPathPreparedStatement.getSQLStatement(schemaName, tableName, colNames, partitionName, this);
            if (this.statementCache != null) {
                this.dppstmt = (T4CDirectPathPreparedStatement)this.statementCache.searchImplicitCache(sql, 1, resultSetType.ordinal(), this);
                if (this.dppstmt != null) {
                    this.dppstmt.dpStmtProps = dpStmtProps;
                }
            }
            if (this.dppstmt == null) {
                this.dppstmt = new T4CDirectPathPreparedStatement(this, schemaName, tableName, colNames, partitionName, resultSetType, dpStmtProps, sql);
            }
            this.odpp.doODPP(schemaName, tableName, colNames, partitionName, dpStmtProps);
            this.setTxnMode(0);
        }
        catch (IOException ex) {
            this.dppstmt = null;
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
        catch (SQLException sqe) {
            this.dppstmt = null;
            throw sqe;
        }
        this.dppstmt.setDirectPathCursor((int)this.odpp.getO4Value(3));
        this.dppstmt.setSDBAOfBits((int)this.odpp.getO4Value(5));
        this.dppstmt.setSDBABits((int)this.odpp.getO4Value(7));
        this.dppstmt.setDBABBits((int)this.odpp.getO4Value(8));
        this.dppstmt.updateAccessors(this.odpp.getDescribedAccessors());
        this.dppstmt.setDirectPathStatus(1);
        return this.dppstmt;
    }

    void directPathLoadStream(DirectPathBufferMarshaler.BufferPlanner bufferPlanner, int _directPathCursor, int[] errorOffsets) throws SQLException {
        try {
            this.odpls.doODPLS(_directPathCursor, bufferPlanner);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
        catch (SQLException sqe) {
            if (errorOffsets != null) {
                errorOffsets[0] = this.odpls.startErrorOffset;
                errorOffsets[1] = this.odpls.endErrorOffset;
            }
            throw sqe;
        }
    }

    void directPathFinish() throws SQLException {
        if (this.dppstmt == null || !this.dppstmt.isDirectPathUncommitted()) {
            throw new IllegalStateException("Cannot finish direct path load before calling prepare!");
        }
        try {
            this.odpmop.doDPMOP(2, this.dppstmt.getDirectPathCursor(), null);
            this.dppstmt.setDirectPathStatus(3);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    void directPathAbort() throws SQLException {
        if (this.dppstmt == null || !this.dppstmt.isDirectPathUncommitted()) {
            throw new IllegalStateException("Cannot abort direct path load before calling prepare!");
        }
        try {
            this.odpmop.doDPMOP(1, this.dppstmt.getDirectPathCursor(), null);
            this.dppstmt.setDirectPathStatus(4);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    void clearDirectPathState() {
        this.dppstmt = null;
    }

    void setDirectPathState(T4CDirectPathPreparedStatement _dppstmt) {
        this.dppstmt = _dppstmt;
        if (this.dppstmt != null && this.dppstmt.isDirectPathClosed()) {
            this.dppstmt.setDirectPathStatus(3);
        }
    }

    @Override
    public byte[] doBeginSaga(String initiatorName, int timeout, String currentUser, int version, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        byte[] sagaId;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                sagaId = this.osaga.doOSAGA(opcode, flags, timeout, version, null, initiatorName, null, null, currentUser, spareNumeric, spareText);
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
        }
        return sagaId;
    }

    @Override
    public Integer doJoinSaga(String participantName, byte[] sagaId, String coordinatorName, String initiatorName, int timeout, int version, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        byte[] joinstatus;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                joinstatus = this.osaga.doOSAGA(opcode, flags, timeout, version, sagaId, initiatorName, participantName, coordinatorName, null, spareNumeric, spareText);
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
        }
        return joinstatus == null || joinstatus.length == 0 ? null : Integer.valueOf(joinstatus[0]);
    }

    @Override
    public Integer doCommitRollbackSaga(String participantName, byte[] sagaId, String currentUser, int opcode, int flags, int spareNumeric, String spareText) throws SQLException {
        byte[] sagastatus;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                sagastatus = this.osaga.doOSAGA(opcode, flags, 86400, 1, sagaId, participantName, null, null, currentUser, spareNumeric, spareText);
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
        }
        return sagastatus == null || sagastatus.length == 0 ? null : Integer.valueOf(sagastatus[0]);
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        this.requireOpenConnection();
        if (this.currentSchema == null || this.getVersionNumber() < 11100) {
            this.currentSchema = super.getCurrentSchema();
        }
        return this.currentSchema;
    }

    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        String ret = this.getServerSessionInfo().getProperty("SESSION_TIME_ZONE");
        ret = ret == null ? super.getSessionTimeZoneOffset() : this.tzToOffset(ret);
        return ret;
    }

    int getSessionId() {
        int sessionId = -1;
        String valueStr = this.sessionProperties.getProperty("AUTH_SESSION_ID");
        try {
            sessionId = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sessionId;
    }

    int getSerialNumber() {
        int serialNumber = -1;
        String valueStr = this.sessionProperties.getProperty("AUTH_SERIAL_NUM");
        try {
            serialNumber = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return serialNumber;
    }

    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        byte ret = 0;
        if (whatProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
            if (this.serverRuntimeCapabilities == null || this.serverRuntimeCapabilities.length < 6) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 256).fillInStackTrace();
            }
            ret = this.serverRuntimeCapabilities[5];
        } else if (whatProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
            if (this.serverRuntimeCapabilities == null || this.serverRuntimeCapabilities.length < 4) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 256).fillInStackTrace();
            }
            ret = this.serverRuntimeCapabilities[3];
        }
        return ret;
    }

    @Override
    public BlobDBAccess createBlobDBAccess() throws SQLException {
        return this;
    }

    @Override
    public ClobDBAccess createClobDBAccess() throws SQLException {
        return this;
    }

    @Override
    public BfileDBAccess createBfileDBAccess() throws SQLException {
        return this;
    }

    @Override
    public long length(OracleBfile bfile) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("length");
            this.assertNotNull(bfile.shareBytes(), "length");
            this.needLine();
            try {
                long l = this.bfileMsg.getLength(bfile.shareBytes());
                return l;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public long position(OracleBfile bfile, Datum bfileDatum, byte[] pattern, long start) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertNotNull(bfile.shareBytes(), "position");
            if (start < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
            }
            this.debugp(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "position", "pattern={0}, start={1}. ", null, null, () -> new Object[]{Arrays.toString(pattern), start});
            long result = LobPlsqlUtil.hasPattern(bfile, bfileDatum, pattern, start);
            long l = result = result == 0L ? -1L : result;
            return l;
        }
    }

    @Override
    public long position(OracleBfile bfile, Datum bfileDatum, Datum pattern, long start) throws SQLException {
        this.assertNotNull(bfile.shareBytes(), "position");
        if (start < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long result = LobPlsqlUtil.isSubLob(bfile, bfileDatum, pattern, start);
        result = result == 0L ? -1L : result;
        return result;
    }

    @Override
    public int getBytes(OracleBfile bfile, long pos, int length, byte[] bytes) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("getBytes");
            this.assertNotNull(bfile.shareBytes(), "getBytes");
            if (pos < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
            }
            if (length <= 0 || bytes == null) {
                int n = 0;
                return n;
            }
            if (this.pipeState != -1) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getBytes()").fillInStackTrace();
            }
            this.needLine();
            try {
                int n = (int)this.bfileMsg.read(bfile.shareBytes(), pos, length, bytes, 0);
                return n;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public String getName(OracleBfile bfile) throws SQLException {
        this.assertLoggedOn("getName");
        this.assertNotNull(bfile.shareBytes(), "getName");
        String result = LobPlsqlUtil.fileGetName(bfile);
        return result;
    }

    @Override
    public String getDirAlias(OracleBfile bfile) throws SQLException {
        this.assertLoggedOn("getDirAlias");
        this.assertNotNull(bfile.shareBytes(), "getDirAlias");
        String result = LobPlsqlUtil.fileGetDirAlias(bfile);
        return result;
    }

    @Override
    public void openFile(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("openFile");
            this.assertNotNull(bfile.shareBytes(), "openFile");
            this.needLine();
            try {
                this.bfileMsg.openLob(bfile.shareBytes(), 11);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public boolean isFileOpen(OracleBfile bfile) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("openFile");
            this.assertNotNull(bfile.shareBytes(), "openFile");
            this.needLine();
            try {
                boolean bl = this.bfileMsg.isOpenLob(bfile.shareBytes());
                return bl;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public boolean fileExists(OracleBfile bfile) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("fileExists");
            this.assertNotNull(bfile.shareBytes(), "fileExists");
            this.needLine();
            try {
                boolean bl = this.bfileMsg.doesExist(bfile.shareBytes());
                return bl;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public void closeFile(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("closeFile");
            this.assertNotNull(bfile.shareBytes(), "closeFile");
            this.needLine();
            try {
                this.bfileMsg.closeLob(bfile.shareBytes());
                this.removeBfile(bfile);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public void openLob(OracleBfile bfile, int mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("open");
            this.assertNotNull(bfile.shareBytes(), "open");
            this.needLine();
            try {
                this.bfileMsg.openLob(bfile.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public void closeLob(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("close");
            this.assertNotNull(bfile.shareBytes(), "close");
            this.needLine();
            try {
                this.bfileMsg.closeLob(bfile.shareBytes());
                this.removeBfile(bfile);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public boolean isOpenLob(OracleBfile bfile) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("isOpen");
            this.assertNotNull(bfile.shareBytes(), "isOpen");
            this.needLine();
            try {
                boolean bl = this.bfileMsg.isOpenLob(bfile.shareBytes());
                return bl;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public InputStream newInputStream(OracleBfile bfile, int chunkSize, long pos) throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "newInputStream", "chunkSize={0}, pos={1}. ", (String)null, (Throwable)null, (Object)chunkSize, (Object)pos);
        if (pos == 0L) {
            return new OracleBlobInputStream(bfile, chunkSize);
        }
        return new OracleBlobInputStream(bfile, chunkSize, pos);
    }

    @Override
    public InputStream newConversionInputStream(OracleBfile bfile, int conversionType) throws SQLException {
        this.assertNotNull(bfile.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, bfile.getBinaryStream(), conversionType, (Monitor)this.getPhysicalConnection());
        return result;
    }

    @Override
    public Reader newConversionReader(OracleBfile bfile, int conversionType) throws SQLException {
        this.assertNotNull(bfile.shareBytes(), "newConversionReader");
        OracleConversionReader result = new OracleConversionReader(this.conversion, bfile.getBinaryStream(), conversionType, this.getPhysicalConnection());
        return result;
    }

    @Override
    public long length(OracleBlob blob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("length");
            this.assertNotNull(blob.shareBytes(), "length");
            this.needLine();
            long result = 0L;
            try {
                result = this.blobMsg.getLength(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
            long l = result;
            return l;
        }
    }

    @Override
    public long position(OracleBlob blob, Datum blobDatum, byte[] pattern, long start) throws SQLException {
        this.assertLoggedOn("position");
        this.assertNotNull(blob.shareBytes(), "position");
        if (start < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long result = LobPlsqlUtil.hasPattern(blob, blobDatum, pattern, start);
        result = result == 0L ? -1L : result;
        return result;
    }

    @Override
    public long position(OracleBlob blob, Datum blobDatum, Datum pattern, long start) throws SQLException {
        this.assertLoggedOn("position");
        this.assertNotNull(blob.shareBytes(), "position");
        this.assertNotNull(pattern.shareBytes(), "position");
        if (start < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long result = LobPlsqlUtil.isSubLob(blob, blobDatum, pattern, start);
        result = result == 0L ? -1L : result;
        return result;
    }

    @Override
    public int getBytes(OracleBlob blob, long pos, int length, byte[] bytes) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("getBytes");
            this.assertNotNull(blob.shareBytes(), "getBytes");
            if (pos < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
            }
            if (this.pipeState != -1) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getBytes()").fillInStackTrace();
            }
            if (length <= 0 || bytes == null) {
                int n = 0;
                return n;
            }
            long result = 0L;
            long lobLength = -1L;
            if (blob.isActivePrefetch()) {
                result += (long)this.copyPrefetchedBlobBytes(blob, pos, length, bytes);
                lobLength = blob.lengthInternal();
            }
            if (result < (long)length && (lobLength == -1L || pos - 1L + result < lobLength)) {
                this.needLine();
                try {
                    result += this.blobMsg.read(blob.shareBytes(), pos + result, (long)length - result, bytes, (int)result);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
            }
            int n = (int)result;
            return n;
        }
    }

    private final int copyPrefetchedBlobBytes(OracleBlob blob, long pos, int length, byte[] bytes) {
        OracleLargeObject.PrefetchData<byte[]> prefetchData = blob.getPrefetchData();
        if (prefetchData != null && pos <= (long)prefetchData.length()) {
            return prefetchData.copy((int)(pos - 1L), bytes, 0, length);
        }
        return 0;
    }

    @Override
    public int putBytes(OracleBlob blob, long pos, byte[] bytes, int bytesOffset, int length) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("putBytes");
            this.assertNotNull(blob.shareBytes(), "putBytes");
            if (pos < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "putBytes()").fillInStackTrace();
            }
            if (bytes == null || length <= 0) {
                int n = 0;
                return n;
            }
            if (bytesOffset < 0 || bytesOffset + length > bytes.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.needLine();
            try {
                blob.setActivePrefetch(false);
                blob.clearCachedData();
                int n = (int)this.blobMsg.write(blob.shareBytes(), pos, bytes, bytesOffset, length);
                return n;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public int getChunkSize(OracleBlob blob) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("getChunkSize");
            this.assertNotNull(blob.shareBytes(), "getChunkSize");
            this.needLine();
            try {
                int n = (int)this.blobMsg.getChunkSize(blob.shareBytes());
                return n;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public void trim(OracleBlob blob, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("trim");
            this.assertNotNull(blob.shareBytes(), "trim");
            if (length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()").fillInStackTrace();
            }
            this.needLine();
            try {
                blob.setActivePrefetch(false);
                blob.clearCachedData();
                this.blobMsg.trim(blob.shareBytes(), length);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("createTemporaryBlob");
            this.needLine();
            BLOB result = null;
            try {
                result = (BLOB)this.blobMsg.createTemporaryLob(this, cache, duration);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
            this.addTemporaryLob(result.getInternal());
            BLOB bLOB = result;
            return bLOB;
        }
    }

    private final Long getLocatorHash(byte[] locator) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checksumEngine.reset();
            this.checksumEngine.update(locator, 10, 10);
            long checksum = this.checksumEngine.getValue();
            Long checksumLong = checksum;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getLocatorHash", "locator={0}, returns={1}. ", (String)null, (Throwable)null, (Object)locator, (Object)checksum);
            Long l = checksumLong;
            return l;
        }
    }

    @Override
    public final int decrementTempLobReferenceCount(byte[] locator) {
        if (PhysicalConnection.isValueBasedLocator(locator) || PhysicalConnection.isQuasiLocator(locator)) {
            return 0;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int remainingCnt = 0;
            if (this.enableTempLobRefCnt && locator != null && ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0)) {
                Long hashKey = this.getLocatorHash(locator);
                Integer refCnt = this.tempLobRefCount.get(hashKey);
                if (refCnt != null) {
                    remainingCnt = refCnt - 1;
                    if (remainingCnt == 0) {
                        this.tempLobRefCount.remove(hashKey);
                    } else {
                        this.tempLobRefCount.put(hashKey, remainingCnt);
                    }
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "decrementTempLobReferenceCount", "LOB ID hash={0}, to={1}. ", (String)null, (Throwable)null, (Object)hashKey, (Object)remainingCnt);
                } else {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "decrementTempLobReferenceCount", "LOB ID not found in hashtable. hash={0}. ", (String)null, (Throwable)null, (Object)hashKey);
                }
            }
            int n = remainingCnt;
            return n;
        }
    }

    @Override
    public final void incrementTempLobReferenceCount(byte[] locator) {
        if (PhysicalConnection.isValueBasedLocator(locator) || PhysicalConnection.isQuasiLocator(locator)) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.enableTempLobRefCnt && locator != null && ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0)) {
                Long hashKey = this.getLocatorHash(locator);
                Integer refCnt = this.tempLobRefCount.get(hashKey);
                if (refCnt != null) {
                    int refCntInt = refCnt;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "incrementTempLobReferenceCount", "LOB ID hash={0}, to={1}. ", (String)null, (Throwable)null, (Object)hashKey, (Object)(refCntInt + 1));
                    this.tempLobRefCount.put(hashKey, refCntInt + 1);
                } else {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "incrementTempLobReferenceCount", "LOB ID hash={0}, to=1. ", (String)null, (Throwable)null, (Object)hashKey);
                    this.tempLobRefCount.put(hashKey, 1);
                }
            }
        }
    }

    @Override
    public void freeTemporary(OracleBlob blob, Datum blobDatum, boolean fromObjectIgnore) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("freeTemporary");
            this.assertNotNull(blob.shareBytes(), "freeTemporary");
            this.needLine();
            try {
                this.blobMsg.freeTemporaryLob(blob.shareBytes());
                this.removeFromTemporaryLobs(blob);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public boolean isTemporary(OracleBlob blob) throws SQLException {
        this.assertNotNull(blob.shareBytes(), "isTemporary");
        byte[] locator = blob.shareBytes();
        return T4CConnection.isTemporary(locator);
    }

    @Override
    public short getDuration(OracleBlob blob) throws SQLException {
        this.assertNotNull(blob.shareBytes(), "getDuration");
        byte[] locator = blob.shareBytes();
        short duration = -1;
        if ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0) {
            duration = (short)(locator[22] << 8 | locator[23] & 0xFF);
        }
        return duration;
    }

    @Override
    public void openLob(OracleBlob blob, int mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("open");
            this.assertNotNull(blob.shareBytes(), "open");
            this.needLine();
            try {
                this.blobMsg.openLob(blob.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public void closeLob(OracleBlob blob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("close");
            this.assertNotNull(blob.shareBytes(), "close");
            this.needLine();
            try {
                this.blobMsg.closeLob(blob.shareBytes());
                this.removeLargeObject(blob);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public final boolean isOpenLob(OracleBlob blob) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("isOpen");
            this.assertNotNull(blob.shareBytes(), "isOpen");
            this.needLine();
            try {
                boolean bl = this.blobMsg.isOpenLob(blob.shareBytes());
                return bl;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public InputStream newInputStream(OracleBlob blob, int chunkSize, long pos) throws SQLException {
        return this.newInputStream(blob, chunkSize, pos, false);
    }

    @Override
    public InputStream newInputStream(OracleBlob blob, int chunkSize, long pos, boolean isInternal) throws SQLException {
        if (pos == 0L) {
            return new OracleBlobInputStream(blob, chunkSize, isInternal);
        }
        return new OracleBlobInputStream(blob, chunkSize, pos, isInternal);
    }

    @Override
    public InputStream newInputStream(OracleBlob blob, int chunkSize, long pos, long length) throws SQLException {
        return this.newInputStream(blob, chunkSize, pos, length, false);
    }

    @Override
    public InputStream newInputStream(OracleBlob blob, int chunkSize, long pos, long length, boolean isInternal) throws SQLException {
        return new OracleBlobInputStream(blob, chunkSize, pos, length, isInternal);
    }

    public OutputStream newOutputStream(BLOB blob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        return this.newOutputStream((OracleBlob)blob, chunkSize, pos, zeroInvalid);
    }

    @Override
    public OutputStream newOutputStream(OracleBlob blob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "newOutputStream", "chunkSize={0}, pos={1}, zeroInvalid={2}. ", (String)null, (Throwable)null, (Object)chunkSize, (Object)pos, (Object)zeroInvalid);
        if (pos == 0L) {
            if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            return new OracleBlobOutputStream(blob, chunkSize);
        }
        return new OracleBlobOutputStream(blob, chunkSize, pos);
    }

    @Override
    public InputStream newConversionInputStream(OracleBlob blob, int conversionType, boolean isInternal) throws SQLException {
        this.assertNotNull(blob.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, blob.binaryStreamValue(isInternal), conversionType, (Monitor)this.getPhysicalConnection());
        return result;
    }

    @Override
    public Reader newConversionReader(OracleBlob blob, int conversionType, boolean isInternal) throws SQLException {
        this.assertNotNull(blob.shareBytes(), "newConversionReader");
        OracleConversionReader result = new OracleConversionReader(this.conversion, blob.binaryStreamValue(isInternal), conversionType, this.getPhysicalConnection());
        return result;
    }

    @Override
    public long length(OracleClob clob) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("length");
            this.assertNotNull(clob.shareBytes(), "length");
            this.needLine();
            try {
                long l = this.clobMsg.getLength(clob.shareBytes());
                return l;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public long position(OracleClob clob, String pattern, long start) throws SQLException {
        if (pattern == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        this.assertLoggedOn("position");
        this.assertNotNull(clob.shareBytes(), "position");
        if (start < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        char[] chars = new char[pattern.length()];
        pattern.getChars(0, chars.length, chars, 0);
        long result = LobPlsqlUtil.hasPattern(clob, chars, start);
        result = result == 0L ? -1L : result;
        return result;
    }

    @Override
    public long position(OracleClob clob, OracleClob pattern, long start) throws SQLException {
        if (pattern == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        this.assertLoggedOn("position");
        this.assertNotNull(clob.shareBytes(), "position");
        this.assertNotNull(pattern.shareBytes(), "position");
        if (start < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
        }
        long result = LobPlsqlUtil.isSubLob(clob, pattern, start);
        result = result == 0L ? -1L : result;
        return result;
    }

    @Override
    public int getChars(OracleClob clob, long pos, int length, char[] chars) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("getChars");
            this.assertNotNull(clob.shareBytes(), "getChars");
            if (pos < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getChars()").fillInStackTrace();
            }
            if (this.pipeState != -1) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getChars()").fillInStackTrace();
            }
            if (length <= 0 || chars == null) {
                int n = 0;
                return n;
            }
            long result = 0L;
            long lobLength = -1L;
            if (clob.isActivePrefetch()) {
                lobLength = clob.lengthInternal();
                result += (long)this.copyPrefetchedClobChars(clob, pos, length, chars);
            }
            if (result < (long)length && (lobLength == -1L || pos - 1L + result < lobLength)) {
                this.needLine();
                try {
                    boolean isNCLOB = clob.isNCLOB();
                    result += this.clobMsg.read(clob.shareBytes(), pos + result, (long)length - result, isNCLOB, chars, (int)result);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
            }
            int n = (int)result;
            return n;
        }
    }

    private final int copyPrefetchedClobChars(OracleClob clob, long pos, int length, char[] chars) {
        OracleLargeObject.PrefetchData<char[]> prefetchedChars = clob.getPrefetchData();
        if (prefetchedChars != null && pos <= (long)prefetchedChars.length()) {
            return prefetchedChars.copy((int)pos - 1, chars, 0, length);
        }
        return 0;
    }

    @Override
    public int putChars(OracleClob clob, long pos, char[] chars, int charsOffset, int length) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("putChars");
            this.assertNotNull(clob.shareBytes(), "putChars");
            if (pos < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "putChars()").fillInStackTrace();
            }
            if (chars == null || length <= 0) {
                int n = 0;
                return n;
            }
            this.needLine();
            try {
                boolean isNCLOB = clob.isNCLOB();
                clob.setActivePrefetch(false);
                clob.clearCachedData();
                int n = (int)this.clobMsg.write(clob.shareBytes(), pos, isNCLOB, chars, charsOffset, length);
                return n;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public int getChunkSize(OracleClob clob) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("getChunkSize");
            this.assertNotNull(clob.shareBytes(), "getChunkSize");
            this.needLine();
            try {
                int n = (int)this.clobMsg.getChunkSize(clob.shareBytes());
                return n;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public void trim(OracleClob clob, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("trim");
            this.assertNotNull(clob.shareBytes(), "trim");
            if (length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()").fillInStackTrace();
            }
            this.needLine();
            try {
                clob.setActivePrefetch(false);
                clob.clearCachedData();
                this.clobMsg.trim(clob.shareBytes(), length);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("createTemporaryClob");
            if (form_of_use != 2 && form_of_use != 1) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184).fillInStackTrace();
            }
            this.needLine();
            CLOB result = null;
            try {
                result = (CLOB)this.clobMsg.createTemporaryLob(this, cache, duration, form_of_use);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
            this.addTemporaryLob(result.getInternal());
            CLOB cLOB = result;
            return cLOB;
        }
    }

    @Override
    public void freeTemporary(OracleClob clob, Datum temp_lob_datum, boolean fromObjectIgnore) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("freeTemporary");
            this.assertNotNull(clob.shareBytes(), "freeTemporary");
            this.needLine();
            try {
                this.clobMsg.freeTemporaryLob(clob.shareBytes());
                this.removeFromTemporaryLobs(clob);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public boolean isTemporary(OracleClob clob) throws SQLException {
        byte[] locator = clob.shareBytes();
        return T4CConnection.isTemporary(locator);
    }

    @Override
    public short getDuration(OracleClob clob) throws SQLException {
        this.assertNotNull(clob.shareBytes(), "getDuration");
        byte[] locator = clob.shareBytes();
        short duration = -1;
        if ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0) {
            duration = (short)(locator[22] << 8 | locator[23] & 0xFF);
        }
        return duration;
    }

    @Override
    public void openLob(OracleClob clob, int mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("open");
            this.assertNotNull(clob.shareBytes(), "open");
            this.needLine();
            try {
                this.clobMsg.openLob(clob.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public void closeLob(OracleClob clob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("close");
            this.assertNotNull(clob.shareBytes(), "close");
            this.needLine();
            try {
                this.clobMsg.closeLob(clob.shareBytes());
                this.removeLargeObject(clob);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public final boolean isOpenLob(OracleClob clob) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.assertLoggedOn("isOpen");
            this.assertNotNull(clob.shareBytes(), "isOpen");
            this.needLine();
            try {
                boolean bl = this.clobMsg.isOpenLob(clob.shareBytes());
                return bl;
            }
            catch (IOException ex) {
                try {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public InputStream newInputStream(OracleClob clob, int chunkSize, long pos) throws SQLException {
        return this.newInputStream(clob, chunkSize, pos, false);
    }

    @Override
    public InputStream newInputStream(OracleClob clob, int chunkSize, long pos, boolean isInternal) throws SQLException {
        if (pos == 0L) {
            return new OracleClobInputStream(clob, chunkSize, isInternal);
        }
        return new OracleClobInputStream(clob, chunkSize, pos, isInternal);
    }

    @Override
    public OutputStream newOutputStream(OracleClob clob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        if (pos == 0L) {
            if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            return new OracleClobOutputStream(clob, chunkSize);
        }
        return new OracleClobOutputStream(clob, chunkSize, pos);
    }

    @Override
    public Reader newReader(OracleClob clob, int chunkSize, long pos) throws SQLException {
        if (pos == 0L) {
            return new OracleClobReader(clob, chunkSize);
        }
        return new OracleClobReader(clob, chunkSize, pos);
    }

    @Override
    public Reader newReader(OracleClob clob, int chunkSize, long pos, long length) throws SQLException {
        return new OracleClobReader(clob, chunkSize, pos, length);
    }

    @Override
    public Writer newWriter(OracleClob clob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        if (pos == 0L) {
            if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            return new OracleClobWriter(clob, chunkSize);
        }
        return new OracleClobWriter(clob, chunkSize, pos);
    }

    void assertLoggedOn(String caller) throws SQLException {
        if (!this.isLoggedOn) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 430).fillInStackTrace();
        }
    }

    boolean isLoggedOn() {
        return this.isLoggedOn;
    }

    @Override
    void internalClose() throws SQLException {
        super.internalClose();
        if (this.all8 != null) {
            this.all8.definesAccessors = null;
        }
        this.isLoggedOn = false;
        try {
            if (this.net.getSessionAttributes().isConnected()) {
                this.net.disconnect();
            }
        }
        catch (Exception e) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "internalClose", null, null, e);
        }
    }

    @Override
    void doAbort() throws SQLException {
        try {
            this.net.abort();
        }
        catch (NetException ne) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne).fillInStackTrace();
        }
        catch (IOException ne) {
            this.handleIOException(ne);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne).fillInStackTrace();
        }
    }

    @Override
    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        this.initializeAutoKeyInfo(info, this.getColumnMetaData(info.getTableName()));
    }

    private T4C8Kpcdsc[] getColumnMetaData(String tableName) throws SQLException {
        try {
            return this.describeTbl.doODSYTable(tableName);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    private void initializeAutoKeyInfo(AutoKeyInfo info, T4C8Kpcdsc[] metaData) throws SQLException {
        int numColumns = metaData.length;
        info.allocateSpaceForDescribedData(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            T4C8Kpcdsc kc = metaData[i];
            info.fillDescribedData(i, kc.name_kpcdsc, kc.dty_kpcdsc, kc.size_kpcdsc, kc.isnull_kpcdsc, kc.charsetform_kpcdsc, kc.precision_kpcdsc, kc.scale_kpcdsc, kc.typnm_kpcdsc, kc.domname_kpcdsc, kc.domsch_kpcdsc, kc.getAnnotations());
        }
    }

    @Override
    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        Namespace ns = this.namespaces.get(nameSpace);
        if (ns == null) {
            ns = new Namespace(nameSpace);
            this.namespaces.put(nameSpace, ns);
        }
        ns.setAttribute(attribute, value);
    }

    @Override
    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        Namespace ns = new Namespace(nameSpace);
        ns.clear();
        this.namespaces.put(nameSpace, ns);
    }

    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        super.getPropertyForPooledConnection(pc, this.password.get());
    }

    final void getPasswordInternal(T4CXAResource caller) throws SQLException {
        caller.setPasswordInternal(this.password);
    }

    @Override
    void doEnqueue(String queueName, AQEnqueueOptions enqueueOptions, AQMessagePropertiesI prop, byte[] payloadTDO, int payloadVersion, byte[] payload, byte[][] msgId, boolean isRawPayload) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                this.needLine();
                this.aqe.doOAQEQ(queueName, enqueueOptions, prop, payload, payloadTDO, payloadVersion, isRawPayload);
                if (enqueueOptions.getRetrieveMessageId()) {
                    msgId[0] = this.aqe.getMessageId();
                }
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
        }
    }

    @Override
    boolean doDequeue(String queueName, AQDequeueOptions dequeueOptions, AQMessagePropertiesI msgProp, byte[] payloadTDO, int payloadVersion, byte[][] payload, byte[][] msgid, boolean isRawQueue) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean hasAMessageBeenDequeued = false;
            try {
                this.needLine();
                this.aqdq.doOAQDQ(queueName, dequeueOptions, payloadTDO, payloadVersion, isRawQueue, msgProp);
                payload[0] = this.aqdq.getPayload();
                msgid[0] = this.aqdq.getDequeuedMessageId();
                hasAMessageBeenDequeued = this.aqdq.hasAMessageBeenDequeued();
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
            boolean bl = hasAMessageBeenDequeued;
            return bl;
        }
    }

    @Override
    void doJMSEnqueue(String queueName, JMSEnqueueOptions jmsEnqueueOptions, AQMessagePropertiesI aqMesgPropI, JMSMessageProperties jmsProp, byte[] payloadTDO, byte[] payload, byte[][] msgId) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                this.needLine();
                this.oaqenq.doJMSEnq(queueName, jmsEnqueueOptions, aqMesgPropI, jmsProp, payloadTDO, payload);
                if (jmsEnqueueOptions.isRetrieveMessageId()) {
                    msgId[0] = this.oaqenq.getMsgId();
                }
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
        }
    }

    @Override
    void doJMSEnqueue(String queueName, JMSEnqueueOptions jmsEnqueueOptions, AQMessagePropertiesI aqMesgPropI, JMSMessageProperties jmsProp, byte[] payloadTDO, InputStream byteStream, byte[][] msgId, int blockSize) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                this.needLine();
                this.oaqenq.doJMSEnq(queueName, jmsEnqueueOptions, aqMesgPropI, jmsProp, payloadTDO, byteStream, blockSize);
                if (jmsEnqueueOptions.isRetrieveMessageId()) {
                    msgId[0] = this.oaqenq.getMsgId();
                }
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
        }
    }

    @Override
    public void jmsEnqueue(String queueName, JMSEnqueueOptions jmsEnqueueOpt, JMSMessage[] mesgs, AQMessageProperties[] aqMesgProps) throws SQLException {
        block15: {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (mesgs == null || mesgs.length <= 0) break block15;
                try {
                    AQMessagePropertiesI[] aqMesgPropsI = new AQMessagePropertiesI[aqMesgProps.length];
                    for (int i = 0; i < aqMesgProps.length; ++i) {
                        aqMesgPropsI[i] = (AQMessagePropertiesI)aqMesgProps[i];
                    }
                    this.needLine();
                    this.aqa.doJMSEnq(queueName, jmsEnqueueOpt, mesgs, aqMesgPropsI);
                }
                catch (IOException ioex) {
                    this.handleIOException(ioex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
                }
            }
        }
    }

    @Override
    public int enqueue(String queueName, AQEnqueueOptions opt, AQMessage[] mesgs) throws SQLException {
        block17: {
            Throwable throwable = null;
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (mesgs == null || mesgs.length <= 0) break block17;
                try {
                    this.needLine();
                    int n = this.aqa.doAQEnq(queueName, opt, mesgs);
                    return n;
                }
                catch (IOException ioex) {
                    try {
                        this.handleIOException(ioex);
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public AQMessage[] dequeue(String queueName, AQDequeueOptions opt, String typeName, int deqSize) throws SQLException {
        byte[] toid = null;
        int version = 1;
        TypeDescriptor sd = null;
        if ("JSON".equals(typeName)) {
            toid = TypeDescriptor.JSONTOID;
        } else if ("RAW".equals(typeName) || "SYS.RAW".equals(typeName)) {
            toid = TypeDescriptor.RAWTOID;
        } else if ("SYS.ANYDATA".equals(typeName)) {
            toid = TypeDescriptor.ANYDATATOID;
        } else if ("SYS.XMLTYPE".equals(typeName)) {
            toid = TypeDescriptor.XMLTYPETOID;
        } else {
            sd = TypeDescriptor.getTypeDescriptor(typeName, this);
            toid = ((OracleTypeADT)sd.getPickler()).getTOID();
            version = ((OracleTypeADT)sd.getPickler()).getTypeVersion();
        }
        AQMessage[] msgs = (AQMessageI[])this.dequeue(queueName, opt, toid, version, deqSize);
        if (msgs != null) {
            for (AQMessage msg : msgs) {
                ((AQMessageI)msg).setTypeName(typeName);
                ((AQMessageI)msg).setTypeDescriptor(sd);
            }
        }
        return msgs;
    }

    @Override
    public AQMessage[] dequeue(String queueName, AQDequeueOptions opt, byte[] tdo, int version, int size) throws SQLException {
        AQMessage[] mesgs;
        block15: {
            mesgs = null;
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (size <= 0) break block15;
                try {
                    AQMessagePropertiesI[] aqMesgProps = new AQMessagePropertiesI[size];
                    for (int i = 0; i < size; ++i) {
                        aqMesgProps[i] = new AQMessagePropertiesI();
                    }
                    this.needLine();
                    mesgs = this.aqa.doAQDeq(queueName, opt, tdo, version, size, aqMesgProps);
                }
                catch (IOException ioex) {
                    this.handleIOException(ioex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
                }
            }
        }
        return mesgs;
    }

    @Override
    boolean doJmsDequeue(String queueName, JMSDequeueOptions jmsDequeueOptions, AQMessagePropertiesI msgProp, JMSMessagePropertiesI jmsProp, byte[] payloadTDO, OutputStream payload, byte[][] msgid) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean hasAMessageBeenDequeued = false;
            try {
                this.needLine();
                this.oaqdeq.doJMSDeq(queueName, jmsDequeueOptions, payloadTDO, msgProp, jmsProp, payload);
                msgid[0] = this.oaqdeq.getDequeuedMessageId();
                hasAMessageBeenDequeued = this.oaqdeq.isHasAMessageBeenDequeued();
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
            boolean bl = hasAMessageBeenDequeued;
            return bl;
        }
    }

    @Override
    public JMSMessage[] jmsDequeue(String queueName, JMSDequeueOptions jmsDequeueOpt, int size) throws SQLException {
        JMSMessage[] mesgs;
        block15: {
            mesgs = null;
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                if (size <= 0) break block15;
                try {
                    AQMessagePropertiesI[] aqMesgProps = new AQMessagePropertiesI[size];
                    JMSMessagePropertiesI jmsProp = new JMSMessagePropertiesI();
                    for (int i = 0; i < size; ++i) {
                        aqMesgProps[i] = new AQMessagePropertiesI();
                    }
                    this.needLine();
                    mesgs = this.aqa.doJMSDeq(queueName, jmsDequeueOpt, size, aqMesgProps, jmsProp);
                }
                catch (IOException ioex) {
                    this.handleIOException(ioex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
                }
            }
        }
        return mesgs;
    }

    @Override
    boolean doJmsDequeue(String queueName, JMSDequeueOptions jmsDequeueOptions, AQMessagePropertiesI msgProp, JMSMessagePropertiesI jmsProp, byte[] payloadTDO, byte[][] payload, byte[][] msgid) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean hasAMessageBeenDequeued = false;
            try {
                this.needLine();
                this.oaqdeq.doJMSDeq(queueName, jmsDequeueOptions, payloadTDO, msgProp, jmsProp);
                payload[0] = this.oaqdeq.getPayload();
                msgid[0] = this.oaqdeq.getDequeuedMessageId();
                hasAMessageBeenDequeued = this.oaqdeq.isHasAMessageBeenDequeued();
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex).fillInStackTrace();
            }
            boolean bl = hasAMessageBeenDequeued;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pingDatabase(int timeout) throws SQLException {
        if (this.getLifecycle() != 1) {
            return -1;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int pingResult;
            if (this.checkAndDrain()) {
                int n = -1;
                return n;
            }
            this.requireNonNegativeTimeout(timeout);
            int existingTimeout = -1;
            int timeoutMillis = timeout * 1000;
            try {
                existingTimeout = this.net.getSocketReadTimeout();
                if (timeoutMillis < existingTimeout || existingTimeout == 0) {
                    this.net.setSocketReadTimeout(timeoutMillis);
                }
                pingResult = this.doPingDatabase();
            }
            catch (IOException ioEx) {
                pingResult = -2;
            }
            finally {
                try {
                    if (existingTimeout >= 0) {
                        this.net.setSocketReadTimeout(existingTimeout);
                    }
                }
                catch (IOException ioEx) {
                    pingResult = -2;
                }
            }
            int n = pingResult;
            return n;
        }
    }

    @Override
    int doPingDatabase() throws SQLException {
        this.assertLockHeldByCurrentThread();
        if (this.versionNumber >= 10102) {
            this.beginNonRequestCalls();
            try {
                this.needLine();
                this.oping.doOPING();
            }
            catch (SocketTimeoutException toe) {
                int n = -3;
                return n;
            }
            catch (InterruptedIOException iioe) {
                this.handleIOException(iioe);
                int n = -1;
                return n;
            }
            catch (IOException ioe) {
                int n = -1;
                return n;
            }
            catch (SQLException ioe) {
                int n = -1;
                return n;
            }
            finally {
                this.endNonRequestCalls();
            }
            return 0;
        }
        return super.doPingDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isValidLight(int timeout) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.checkAndDrain()) {
                boolean bl = false;
                return bl;
            }
            try {
                this.net.sendZDP();
            }
            catch (IOException e) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "isValidLight", "Received IOException while sending zero length NS data packet. ", null, e);
                boolean bl = false;
                if (lock != null) {
                    if (var3_3 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        lock.close();
                    }
                }
                return bl;
            }
            finally {
                this.writeBufferIsDirty = true;
            }
            boolean bl = true;
            return bl;
        }
    }

    void setNeedsToBeClosed(boolean needsToBeClosed) {
        this.needsToBeClosed = needsToBeClosed;
    }

    @Override
    boolean drainOnInbandNotification() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.needsToBeClosed) {
                this.closeConnectionSafely();
                boolean bl = true;
                return bl;
            }
            this.net.readInbandNotification();
            if (this.net.needsToBeClosed()) {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "drainOnInbandNotification", "received in-band notification, about to close connection", null, null, new Object[0]);
                this.closeConnectionSafely();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    Map<String, JMSNotificationRegistration> doRegisterJMSNotification(String[] name, Map<String, Properties> options, String selector) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    void doStartJMSNotification(NTFJMSRegistration registration) throws SQLException {
        if (registration.getState() != NotificationRegistration.RegistrationState.ACTIVE) {
            this.startOrStopJMSNotification(registration, JMSNotificationRegistration.Directive.ENABLE);
            registration.setState(NotificationRegistration.RegistrationState.ACTIVE);
        }
    }

    @Override
    void doStopJMSNotification(NTFJMSRegistration registration) throws SQLException {
        if (registration.getState() != NotificationRegistration.RegistrationState.DISABLED) {
            this.startOrStopJMSNotification(registration, JMSNotificationRegistration.Directive.DISABLE);
        }
    }

    void startOrStopJMSNotification(NTFJMSRegistration registration, JMSNotificationRegistration.Directive directive) throws SQLException {
        Long jmsRegistrationId = registration.getJMSRegistrationId();
        registration.setState(NotificationRegistration.RegistrationState.ACTIVE);
        NTFJMSConnectionGroup jmsConnectionGroup = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
        assert (jmsConnectionGroup != null) : "jmsConnectionGroup is null";
        String jmsConnectionId = registration.getJMSConnectionId();
        int[] namespaceArr = new int[]{1};
        String[] registeredAgentNameArr = new String[]{registration.getQueueName()};
        int[] payloadTypeArr = new int[]{0};
        int qosFlag = registration.getQOSFlag();
        int[] qosFlagsArr = new int[]{qosFlag};
        int[] timeoutArr = new int[]{0};
        long[] jmsRegIdArr = new long[]{jmsRegistrationId};
        int opcode = directive == JMSNotificationRegistration.Directive.DISABLE ? 5 : 4;
        try {
            this.okpn.doOKPN(opcode, 4, this.userName, jmsConnectionId, 1, namespaceArr, registeredAgentNameArr, null, payloadTypeArr, qosFlagsArr, timeoutArr, null, null, null, null, null, null, null, null, jmsRegIdArr);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    @Override
    void doUnregisterJMSNotification(NTFJMSRegistration registration) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            PhysicalConnection.ntfManager.removeRegistration(registration);
            PhysicalConnection.ntfManager.freeJdbcRegId(registration.getJdbcRegId());
            Long jmsRegistrationId = registration.getJMSRegistrationId();
            PhysicalConnection.ntfManager.removeJMSRegistrationId(jmsRegistrationId);
            registration.setState(NotificationRegistration.RegistrationState.CLOSED);
            NTFJMSConnectionGroup jmsConnectionGroup = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
            assert (jmsConnectionGroup != null) : "jmsConnectionGroup is null";
            jmsConnectionGroup.decrementNumberOfRegistrations();
            String jmsConnectionId = registration.getJMSConnectionId();
            jmsConnectionGroup.stopNTFJMSConnection(jmsConnectionId);
            int[] namespaceArr = new int[]{1};
            String[] registeredAgentNameArr = new String[]{registration.getQueueName()};
            int[] payloadTypeArr = new int[]{0};
            int qosFlag = registration.getQOSFlag();
            int[] qosFlagsArr = new int[]{qosFlag};
            int[] timeoutArr = new int[]{0};
            long[] jmsRegIdArr = new long[]{jmsRegistrationId};
            IOException unregIOExcp = null;
            try {
                this.okpn.doOKPN(2, 4, this.userName, jmsConnectionId, 1, namespaceArr, registeredAgentNameArr, null, payloadTypeArr, qosFlagsArr, timeoutArr, null, null, null, null, null, null, null, null, jmsRegIdArr);
            }
            catch (IOException ex) {
                unregIOExcp = ex;
            }
            jmsConnectionGroup.checkNCloseActiveRegistrations();
            if (unregIOExcp != null) {
                this.handleIOException(unregIOExcp);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), unregIOExcp).fillInStackTrace();
            }
        }
    }

    @Override
    void doAckJMSNtfn(ArrayList<JMSNotificationRegistration> registrationList, byte[][] lastMessageIDs, short directiveValue) throws SQLException {
        if (registrationList == null || registrationList.size() == 0) {
            return;
        }
        try {
            long[] registrationIds = new long[registrationList.size()];
            String[] queueNames = new String[registrationList.size()];
            Iterator<JMSNotificationRegistration> regIter = registrationList.iterator();
            NTFJMSRegistration ntfReg = null;
            int i = 0;
            while (regIter.hasNext()) {
                ntfReg = (NTFJMSRegistration)regIter.next();
                registrationIds[i] = ntfReg.getJMSRegistrationId();
                queueNames[i] = ntfReg.getQueueName();
                ++i;
            }
            String jmsConnectionId = ntfReg.getJMSConnectionId();
            this.kpdnrdeq.doOAQEMNDEQ(jmsConnectionId, directiveValue, lastMessageIDs, registrationIds, queueNames);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    @Override
    NTFAQRegistration[] doRegisterAQNotification(String[] name, String dcnhost, int tcpport, boolean useSSL, Properties[] options) throws SQLException {
        try (Monitor.CloseableLock lock = ntfManager.acquireCloseableLock();){
            int i;
            int nbOfRegistration = name.length;
            int[] jdbcRegIdArr = new int[nbOfRegistration];
            byte[][] contextArr = new byte[nbOfRegistration][];
            int[] namespaceArr = new int[nbOfRegistration];
            int[] payloadTypeArr = new int[nbOfRegistration];
            int[] qosFlagsArr = new int[nbOfRegistration];
            int[] timeoutArr = new int[nbOfRegistration];
            int[] dbchangeOpFilterArr = new int[nbOfRegistration];
            int[] dbchangeTxnLagArr = new int[nbOfRegistration];
            long[] dbchangeRegistrationIdArr = new long[nbOfRegistration];
            byte[] kpdnrgrpcla = new byte[nbOfRegistration];
            int[] kpdnrgrpval = new int[nbOfRegistration];
            byte[] kpdnrgrptyp = new byte[nbOfRegistration];
            TIMESTAMPTZ[] kpdnrgrpstatim = new TIMESTAMPTZ[nbOfRegistration];
            int[] kpdnrgrprepcnt = new int[nbOfRegistration];
            boolean forceFindPort = false;
            if (tcpport == 0) {
                forceFindPort = true;
                tcpport = 47632;
            }
            for (int i2 = 0; i2 < nbOfRegistration; ++i2) {
                jdbcRegIdArr[i2] = PhysicalConnection.ntfManager.getNextJdbcRegId();
                contextArr[i2] = new byte[4];
                contextArr[i2][0] = (byte)((jdbcRegIdArr[i2] & 0xFF000000) >> 24);
                contextArr[i2][1] = (byte)((jdbcRegIdArr[i2] & 0xFF0000) >> 16);
                contextArr[i2][2] = (byte)((jdbcRegIdArr[i2] & 0xFF00) >> 8);
                contextArr[i2][3] = (byte)(jdbcRegIdArr[i2] & 0xFF);
                namespaceArr[i2] = 1;
                payloadTypeArr[i2] = 23;
                if (options.length <= i2 || options[i2] == null) continue;
                if (options[i2].getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                    int n = i2;
                    qosFlagsArr[n] = qosFlagsArr[n] | 1;
                }
                if (options[i2].getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                    int n = i2;
                    qosFlagsArr[n] = qosFlagsArr[n] | 0x10;
                }
                if (options[i2].getProperty("NTF_AQ_PAYLOAD", "false").compareToIgnoreCase("true") == 0) {
                    int n = i2;
                    qosFlagsArr[n] = qosFlagsArr[n] | 2;
                }
                timeoutArr[i2] = this.readNTFtimeout(options[i2]);
            }
            this.setNtfGroupingOptions(kpdnrgrpcla, kpdnrgrpval, kpdnrgrptyp, kpdnrgrpstatim, kpdnrgrprepcnt, options);
            int[] tcpportArr = new int[]{tcpport};
            Exception[] connectionCreationExceptionArr = new Exception[1];
            Properties socketOptions = null;
            if (useSSL) {
                socketOptions = ((NSProtocol)this.net).getSocketOptions();
            }
            boolean isNewClient = PhysicalConnection.ntfManager.listenOnPortT4C(tcpportArr, forceFindPort, socketOptions, connectionCreationExceptionArr);
            tcpport = tcpportArr[0];
            String location = "(ADDRESS=(PROTOCOL=" + (useSSL ? "tcps" : "tcp") + " )(HOST=" + dcnhost + ")(PORT=" + tcpport + "))?PR=0";
            try {
                try {
                    int mod = isNewClient ? 1 : 0;
                    this.okpn.doOKPN(1, mod, this.userName, location, nbOfRegistration, namespaceArr, name, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpcla, kpdnrgrpval, kpdnrgrptyp, kpdnrgrpstatim, kpdnrgrprepcnt, dbchangeRegistrationIdArr);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                }
            }
            catch (SQLException generalEx) {
                if (isNewClient) {
                    PhysicalConnection.ntfManager.cleanListenersT4C(tcpport);
                }
                throw generalEx;
            }
            NTFAQRegistration[] registrations = new NTFAQRegistration[nbOfRegistration];
            for (i = 0; i < nbOfRegistration; ++i) {
                registrations[i] = new NTFAQRegistration(jdbcRegIdArr[i], useSSL, true, this.instanceName, this.userName, dcnhost, tcpport, options[i], name[i], this.versionNumber, connectionCreationExceptionArr);
            }
            for (i = 0; i < registrations.length; ++i) {
                PhysicalConnection.ntfManager.addRegistration(registrations[i]);
            }
            NTFAQRegistration[] nTFAQRegistrationArray = registrations;
            return nTFAQRegistrationArray;
        }
    }

    private void setNtfGroupingOptions(byte[] kpdnrgrpcla, int[] kpdnrgrpval, byte[] kpdnrgrptyp, TIMESTAMPTZ[] kpdnrgrpstatim, int[] kpdnrgrprepcnt, Properties[] options) throws SQLException {
        for (int i = 0; i < options.length; ++i) {
            String ntfGroupingClass = options[i].getProperty("NTF_GROUPING_CLASS", "NTF_GROUPING_CLASS_NONE");
            String ntfGroupingValue = options[i].getProperty("NTF_GROUPING_VALUE");
            String ntfGroupingType = options[i].getProperty("NTF_GROUPING_TYPE");
            TIMESTAMPTZ ntfGroupingStartTime = null;
            if (options[i].get("NTF_GROUPING_START_TIME") != null) {
                ntfGroupingStartTime = (TIMESTAMPTZ)options[i].get("NTF_GROUPING_START_TIME");
            }
            String ntfGroupingRepeatTime = options[i].getProperty("NTF_GROUPING_REPEAT_TIME", "NTF_GROUPING_REPEAT_FOREVER");
            if (ntfGroupingClass.compareTo("NTF_GROUPING_CLASS_TIME") != 0 && ntfGroupingClass.compareTo("NTF_GROUPING_CLASS_NONE") != 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            if (ntfGroupingClass.compareTo("NTF_GROUPING_CLASS_NONE") != 0 && this.getTTCVersion() < 5) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            if (ntfGroupingClass.compareTo("NTF_GROUPING_CLASS_TIME") != 0) continue;
            kpdnrgrpcla[i] = 1;
            kpdnrgrpval[i] = 600;
            if (ntfGroupingValue != null) {
                kpdnrgrpval[i] = Integer.parseInt(ntfGroupingValue);
            }
            kpdnrgrptyp[i] = 1;
            if (ntfGroupingType != null) {
                if (ntfGroupingType.compareTo("NTF_GROUPING_TYPE_SUMMARY") == 0) {
                    kpdnrgrptyp[i] = 1;
                } else if (ntfGroupingType.compareTo("NTF_GROUPING_TYPE_LAST") == 0) {
                    kpdnrgrptyp[i] = 2;
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
            }
            kpdnrgrpstatim[i] = ntfGroupingStartTime;
            kpdnrgrprepcnt[i] = ntfGroupingRepeatTime.compareTo("NTF_GROUPING_REPEAT_FOREVER") == 0 ? 0 : Integer.parseInt(ntfGroupingRepeatTime);
        }
    }

    @Override
    void doUnregisterAQNotification(NTFAQRegistration registration) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String host = registration.getClientHost();
            int port = registration.getClientTCPPort();
            if (host == null) {
                return;
            }
            PhysicalConnection.ntfManager.removeRegistration(registration);
            PhysicalConnection.ntfManager.freeJdbcRegId(registration.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(registration.getClientTCPPort());
            registration.setState(NotificationRegistration.RegistrationState.CLOSED);
            String location = "(ADDRESS=(PROTOCOL=" + (registration.getUseSSL() ? "tcps" : "tcp") + " )(HOST=" + host + ")(PORT=" + port + "))?PR=0";
            int[] namespaceArr = new int[]{1};
            String[] registeredAgentNameArr = new String[]{registration.getQueueName()};
            int[] payloadTypeArr = new int[]{0};
            int[] qosFlagsArr = new int[]{0};
            int[] timeoutArr = new int[]{0};
            int[] dbchangeOpFilterArr = new int[]{0};
            int[] dbchangeTxnLagArr = new int[]{0};
            long[] dbchangeRegistrationIdArr = new long[]{0L};
            byte[] kpdnrgrpcla = new byte[]{0};
            int[] kpdnrgrpval = new int[]{0};
            byte[] kpdnrgrptyp = new byte[]{0};
            TIMESTAMPTZ[] kpdnrgrpstatim = new TIMESTAMPTZ[]{null};
            int[] kpdnrgrprepcnt = new int[]{0};
            byte[][] contextArr = new byte[1][];
            int jdbcRegIdArr = registration.getJdbcRegId();
            contextArr[0] = new byte[4];
            contextArr[0][0] = (byte)((jdbcRegIdArr & 0xFF000000) >> 24);
            contextArr[0][1] = (byte)((jdbcRegIdArr & 0xFF0000) >> 16);
            contextArr[0][2] = (byte)((jdbcRegIdArr & 0xFF00) >> 8);
            contextArr[0][3] = (byte)(jdbcRegIdArr & 0xFF);
            try {
                this.okpn.doOKPN(2, 0, this.userName, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpcla, kpdnrgrpval, kpdnrgrptyp, kpdnrgrpstatim, kpdnrgrprepcnt, dbchangeRegistrationIdArr);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    long registerInbandNotification(int cacheLag, String location) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            long regid = 0L;
            int[] namespaceArr = new int[]{2};
            String[] registeredAgentNameArr = new String[1];
            int[] payloadTypeArr = new int[]{0};
            int[] qosFlagsArr = new int[]{0};
            int[] timeoutArr = new int[]{0};
            int[] dbchangeOpFilterArr = new int[]{128};
            int[] dbchangeTxnLagArr = new int[]{cacheLag};
            long[] dbchangeRegistrationIdArr = new long[]{0L};
            int jdbcRegId = PhysicalConnection.ntfManager.getNextJdbcRegId();
            byte[][] contextArr = new byte[][]{new byte[4]};
            contextArr[0][0] = (byte)((jdbcRegId & 0xFF000000) >> 24);
            contextArr[0][1] = (byte)((jdbcRegId & 0xFF0000) >> 16);
            contextArr[0][2] = (byte)((jdbcRegId & 0xFF00) >> 8);
            contextArr[0][3] = (byte)(jdbcRegId & 0xFF);
            byte[] kpdnrgrpclaArr = new byte[1];
            int[] kpdnrgrpvalArr = new int[1];
            byte[] kpdnrgrptypArr = new byte[1];
            TIMESTAMPTZ[] kpdnrgrpstatimArr = new TIMESTAMPTZ[1];
            int[] kpdnrgrprepcntArr = new int[1];
            try {
                boolean mod = false;
                this.okpn.doOKPN(1, 0, this.userName, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpclaArr, kpdnrgrpvalArr, kpdnrgrptypArr, kpdnrgrpstatimArr, kpdnrgrprepcntArr, dbchangeRegistrationIdArr);
                regid = this.okpn.getRegistrationId();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
            long l = regid;
            return l;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.CONFIG)
    NTFDCNRegistration doRegisterDatabaseChangeNotification(String string, int n, @Blind(value=PropertiesBlinder.class) Properties properties, int n2, int n3) throws SQLException {
        try {
            NTFDCNRegistration nTFDCNRegistration;
            this.debug(Level.CONFIG, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CConnection", "doRegisterDatabaseChangeNotification", "entering args ({0}, {1}, {2}, {3}, {4})", (String)null, null, new Object[]{string, n, new PropertiesBlinder().blind(properties), n2, n3});
            try (Monitor.CloseableLock lock = ntfManager.acquireCloseableLock();){
                void kpdcntxl;
                void kpdnrtmout;
                void dcnhost;
                int tcpport;
                void options;
                boolean clientInitiatedConnection = Boolean.parseBoolean(options.getProperty("DCN_CLIENT_INIT_CONNECTION", "false"));
                String clientId = null;
                int kpdcnflg = 0;
                int kpdnrqos = 0;
                boolean forceFindPort = false;
                if (tcpport == 0) {
                    forceFindPort = true;
                    tcpport = 47632;
                }
                if (options.getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                    kpdnrqos |= 1;
                }
                if (options.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                    kpdnrqos |= 0x10;
                }
                if (options.getProperty("DCN_NOTIFY_ROWIDS", "false").compareToIgnoreCase("true") == 0) {
                    kpdcnflg |= 0x10;
                }
                if (options.getProperty("DCN_QUERY_CHANGE_NOTIFICATION", "false").compareToIgnoreCase("true") == 0) {
                    kpdcnflg |= 0x20;
                }
                if (options.getProperty("DCN_BEST_EFFORT", "false").compareToIgnoreCase("true") == 0) {
                    kpdcnflg |= 0x40;
                }
                boolean ignoreInsert = false;
                boolean ignoreUpdate = false;
                boolean ignoreDelete = false;
                if (options.getProperty("DCN_IGNORE_INSERTOP", "false").compareToIgnoreCase("true") == 0) {
                    ignoreInsert = true;
                }
                if (options.getProperty("DCN_IGNORE_UPDATEOP", "false").compareToIgnoreCase("true") == 0) {
                    ignoreUpdate = true;
                }
                if (options.getProperty("DCN_IGNORE_DELETEOP", "false").compareToIgnoreCase("true") == 0) {
                    ignoreDelete = true;
                }
                if (ignoreInsert || ignoreUpdate || ignoreDelete) {
                    kpdcnflg |= 0xF;
                    if (ignoreInsert) {
                        kpdcnflg -= 2;
                    }
                    if (ignoreUpdate) {
                        kpdcnflg -= 4;
                    }
                    if (ignoreDelete) {
                        kpdcnflg -= 8;
                    }
                }
                byte[] kpdnrgrpclaArr = new byte[1];
                int[] kpdnrgrpvalArr = new int[1];
                byte[] kpdnrgrptypArr = new byte[1];
                TIMESTAMPTZ[] kpdnrgrpstatimArr = new TIMESTAMPTZ[1];
                int[] kpdnrgrprepcntArr = new int[1];
                Properties[] optionsArr = new Properties[]{options};
                this.setNtfGroupingOptions(kpdnrgrpclaArr, kpdnrgrpvalArr, kpdnrgrptypArr, kpdnrgrpstatimArr, kpdnrgrprepcntArr, optionsArr);
                int[] tcpportArr = new int[]{tcpport};
                Exception[] connectionCreationExceptionArr = new Exception[1];
                boolean isNewClient = false;
                int mode = 1;
                String location = null;
                int noOfRegistration = 1;
                NTFDCNConnectionGroup dcnConnectionGroup = null;
                if (clientInitiatedConnection) {
                    mode = 4;
                    kpdnrqos |= 8;
                    dcnConnectionGroup = PhysicalConnection.ntfManager.getDCNConnectionGroup(this.userName + this.instanceName);
                    NTFDCNConnection dcnConnection = dcnConnectionGroup.getNTFDCNConnection();
                    boolean bl = isNewClient = dcnConnection == null;
                    if (!isNewClient) {
                        clientId = location = dcnConnection.getClientId();
                    }
                } else {
                    isNewClient = PhysicalConnection.ntfManager.listenOnPortT4C(tcpportArr, forceFindPort, null, connectionCreationExceptionArr);
                    tcpport = tcpportArr[0];
                    if (!isNewClient) {
                        mode = 0;
                    }
                    location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + (String)dcnhost + ")(PORT=" + tcpport + "))?PR=0";
                }
                int[] namespaceArr = new int[]{2};
                String[] registeredAgentNameArr = new String[1];
                int[] payloadTypeArr = new int[]{23};
                int[] qosFlagsArr = new int[]{kpdnrqos};
                int[] timeoutArr = new int[]{kpdnrtmout};
                int[] dbchangeOpFilterArr = new int[]{kpdcnflg};
                int[] dbchangeTxnLagArr = new int[]{kpdcntxl};
                long[] dbchangeRegistrationIdArr = new long[]{0L};
                int jdbcRegId = PhysicalConnection.ntfManager.getNextJdbcRegId();
                byte[][] contextArr = new byte[][]{new byte[4]};
                contextArr[0][0] = (byte)((jdbcRegId & 0xFF000000) >> 24);
                contextArr[0][1] = (byte)((jdbcRegId & 0xFF0000) >> 16);
                contextArr[0][2] = (byte)((jdbcRegId & 0xFF00) >> 8);
                contextArr[0][3] = (byte)(jdbcRegId & 0xFF);
                long regid = 0L;
                try {
                    try {
                        this.okpn.doOKPN(1, mode, this.userName, location, noOfRegistration, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpclaArr, kpdnrgrpvalArr, kpdnrgrptypArr, kpdnrgrpstatimArr, kpdnrgrprepcntArr, dbchangeRegistrationIdArr, null);
                        regid = this.okpn.getRegistrationId();
                        if (clientInitiatedConnection && isNewClient) {
                            clientId = this.okpn.getJMSConnectionId();
                            if (clientId == null) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "clientID returned by server is null").fillInStackTrace();
                            }
                            ArrayList<String> listenerAddresses = this.getListenerAddressForDCN((Properties)options);
                            if (listenerAddresses == null) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "listenerAddress returned by server is null").fillInStackTrace();
                            }
                            String serviceNameSpecifiedByClient = this.net.getSessionAttributes().getcOption().service_name;
                            if (serviceNameSpecifiedByClient == null) {
                                serviceNameSpecifiedByClient = this.net.getSessionAttributes().getcOption().getOriginalConnOption().service_name;
                            }
                            if (serviceNameSpecifiedByClient == null) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 287, "No service name found, please use a service name format URL to create a connection").fillInStackTrace();
                            }
                            Properties connectionProps = this.getConnectionPropsforListenerConnection();
                            dcnConnectionGroup.startDCNListenerConnection(this.instanceName, serviceNameSpecifiedByClient, this.userName, this.password, connectionProps, listenerAddresses, clientId, 1);
                        }
                    }
                    catch (IOException ex) {
                        this.handleIOException(ex);
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                    }
                }
                catch (SQLException generalEx) {
                    if (isNewClient && !clientInitiatedConnection) {
                        PhysicalConnection.ntfManager.cleanListenersT4C(tcpport);
                    }
                    throw generalEx;
                }
                NTFDCNRegistration registration = new NTFDCNRegistration(jdbcRegId, true, this.dbName, regid, this.userName, (String)dcnhost, tcpport, (Properties)options, this.versionNumber, connectionCreationExceptionArr, contextArr, clientId, clientInitiatedConnection);
                PhysicalConnection.ntfManager.addDCNRegistration(registration);
                NTFDCNRegistration nTFDCNRegistration2 = registration;
                nTFDCNRegistration = nTFDCNRegistration2;
            }
            this.debug(Level.CONFIG, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CConnection", "doRegisterDatabaseChangeNotification", "returning {0}", (String)null, null, new Object[]{nTFDCNRegistration});
            return nTFDCNRegistration;
        }
        catch (Throwable throwable) {
            this.debug(Level.CONFIG, SecurityLabel.INTERNAL, "oracle.jdbc.driver.T4CConnection", "doRegisterDatabaseChangeNotification", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private ArrayList<String> getListenerAddressForDCN(@Blind(value=PropertiesBlinder.class) Properties options) {
        boolean useHostConnectionListener = Boolean.parseBoolean(options.getProperty("DCN_USE_HOST_CONNECTION_ADDR_INFO", "true"));
        NTAdapter ntAdapter = this.net.getSessionAttributes().getNTAdapter();
        if (useHostConnectionListener && (ntAdapter.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCP || ntAdapter.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCPS)) {
            ArrayList<String> addrList = new ArrayList<String>();
            addrList.add(((TcpNTAdapter)ntAdapter).getAddressInfo());
            return addrList;
        }
        return this.okpn.getListenerAddresses();
    }

    @Override
    void doUnregisterDatabaseChangeNotification(long registrationId, String location) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int[] namespaceArr = new int[]{2};
            String[] registeredAgentNameArr = new String[1];
            int[] payloadTypeArr = new int[]{0};
            int[] qosFlagsArr = new int[]{0};
            int[] timeoutArr = new int[]{0};
            int[] dbchangeOpFilterArr = new int[]{0};
            int[] dbchangeTxnLagArr = new int[]{0};
            byte[] kpdnrgrpclaArr = new byte[]{0};
            int[] kpdnrgrpvalArr = new int[]{0};
            byte[] kpdnrgrptypArr = new byte[]{0};
            TIMESTAMPTZ[] kpdnrgrpstatimArr = new TIMESTAMPTZ[]{null};
            int[] kpdnrgrprepcntArr = new int[]{0};
            long[] dbchangeRegistrationIdArr = new long[]{registrationId};
            byte[][] contextArr = new byte[1][];
            try {
                this.okpn.doOKPN(2, 0, null, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpclaArr, kpdnrgrpvalArr, kpdnrgrptypArr, kpdnrgrpstatimArr, kpdnrgrprepcntArr, dbchangeRegistrationIdArr);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    void doUnregisterDatabaseChangeNotification(NTFDCNRegistration dcnregistration) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            PhysicalConnection.ntfManager.removeRegistration(dcnregistration);
            PhysicalConnection.ntfManager.freeJdbcRegId(dcnregistration.getJdbcRegId());
            if (dcnregistration.isClientInitiated()) {
                NTFDCNConnectionGroup dcnGroup = PhysicalConnection.ntfManager.getDCNConnectionGroup(this.userName + this.instanceName);
                dcnGroup.stopNTFDCNConnection(dcnregistration.getClientId());
                this.doUnregisterClientInitiatedDCN(dcnregistration);
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "doUnregisterDatabaseChangeNotification", "dcnregistration id={0}, JdbcRegId={1}, client id={2}, database name={3}. ", (String)null, null, (Object)dcnregistration.getRegId(), (Object)dcnregistration.getJdbcRegId(), (Object)dcnregistration.getClientId(), (Object)dcnregistration.getDatabaseName());
            } else {
                PhysicalConnection.ntfManager.cleanListenersT4C(dcnregistration.getClientTCPPort());
                dcnregistration.setState(NotificationRegistration.RegistrationState.CLOSED);
                this.doUnregisterDatabaseChangeNotification(dcnregistration.getRegId(), "(ADDRESS=(PROTOCOL=tcp)(HOST=" + dcnregistration.getClientHost() + ")(PORT=" + dcnregistration.getClientTCPPort() + "))?PR=0");
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "doUnregisterDatabaseChangeNotification", "dcnregistration regId={0}, state={1}, JdbcRegId={2}, client id={3}, database name={4}. ", (String)null, null, (Object)dcnregistration.getRegId(), (Object)dcnregistration.getState().toString(), (Object)dcnregistration.getJdbcRegId(), (Object)dcnregistration.getClientId(), (Object)dcnregistration.getDatabaseName());
            }
        }
    }

    private void doUnregisterClientInitiatedDCN(NTFDCNRegistration dcnRegistration) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                int[] emptyInt = new int[]{0};
                byte[] emptyByte = new byte[]{0};
                TIMESTAMPTZ[] emptyTZ = new TIMESTAMPTZ[]{null};
                long[] dbchangeRegistrationIdArr = new long[]{dcnRegistration.getRegId()};
                this.okpn.doOKPN(2, 4, this.userName, dcnRegistration.getClientId(), 1, new int[]{2}, new String[1], dcnRegistration.getContext(), emptyInt, emptyInt, emptyInt, emptyInt, emptyInt, dbchangeRegistrationIdArr, emptyByte, emptyInt, emptyByte, emptyTZ, emptyInt, dbchangeRegistrationIdArr);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        return this.net.getDataIntegrityName();
    }

    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        return this.net.getEncryptionName();
    }

    @Override
    public SecurityInformation getSecurityInformation() throws SQLException {
        if (this.net != null && this.net.getSessionAttributes() != null) {
            return this.net.getSessionAttributes().getSecurityInformation();
        }
        return null;
    }

    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        return this.net.getAuthenticationAdaptorName();
    }

    @Override
    void validateConnectionProperties() throws SQLException {
        super.validateConnectionProperties();
        String pattern = ".*[\\00\\(\\)].*";
        if (this.thinVsessionOsuser != null && (this.thinVsessionOsuser.matches(pattern) || this.thinVsessionOsuser.length() > 30)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.osuser' and value is '" + this.thinVsessionOsuser + "'").fillInStackTrace();
        }
        if (this.thinVsessionTerminal != null && (this.thinVsessionTerminal.matches(pattern) || this.thinVsessionTerminal.length() > 30)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.terminal' and value is '" + this.thinVsessionTerminal + "'").fillInStackTrace();
        }
        if (this.thinVsessionMachine != null && (this.thinVsessionMachine.matches(pattern) || this.thinVsessionMachine.length() > 64)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.machine' and value is '" + this.thinVsessionMachine + "'").fillInStackTrace();
        }
        if (this.thinVsessionProgram == null) {
            this.thinVsessionProgram = GeneratedPhysicalConnection.applicationProgramName;
            if (this.thinVsessionProgram == null) {
                this.thinVsessionProgram = "JDBC Thin Client";
            }
        }
        if (this.thinVsessionProgram != null && (this.thinVsessionProgram.matches(pattern) || this.thinVsessionProgram.length() > 48)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.program' and value is '" + this.thinVsessionProgram + "'").fillInStackTrace();
        }
        if (this.localHostName == null) {
            try {
                this.localHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.localHostName = "__jdbc__";
            }
        }
        if (this.thinVsessionProcess != null && (this.thinVsessionProcess.matches(pattern) || this.thinVsessionProcess.length() > 24)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.process' and value is '" + this.thinVsessionProcess + "'").fillInStackTrace();
        }
        if (this.thinVsessionIname != null && this.thinVsessionIname.matches(pattern)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.iname' and value is '" + this.thinVsessionIname + "'").fillInStackTrace();
        }
        if (this.thinVsessionEname != null && this.thinVsessionEname.matches(pattern)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'v$session.ename' and value is '" + this.thinVsessionEname + "'").fillInStackTrace();
        }
        if (!(this.networkCompression.equals("off") || this.networkCompression.equals("on") || this.networkCompression.equals("auto"))) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'oracle.net.networkCompression' and value is '" + this.networkCompression + "'").fillInStackTrace();
        }
        if (this.networkCompressionThreshold < 200) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'oracle.net.networkCompressionThreshold' and value is '" + this.networkCompressionThreshold + "'").fillInStackTrace();
        }
        if (!this.networkCompressionLevels.equalsIgnoreCase("(high)")) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'oracle.net.networkCompressionLevels' and value is '" + this.networkCompressionLevels + "'. Only (high) is supported.").fillInStackTrace();
        }
    }

    @Override
    public byte[] createLightweightSession(String userName, KeywordValueLong[] inKeyVal, int inFlags, KeywordValueLong[][] outKeyVal, int[] outFlags) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (outKeyVal.length != 1 || outFlags.length != 1) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            byte[] ret = null;
            try {
                this.oxsscs.doOXSSCS(userName, inKeyVal, inFlags);
                ret = this.oxsscs.getSessionId();
                outKeyVal[0] = this.oxsscs.getOutKV();
                outFlags[0] = this.oxsscs.getOutFlags();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
            byte[] byArray = ret;
            return byArray;
        }
    }

    private void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSNamespace[][] returnedNamespaces, XSSecureId secureId, boolean roundTripRPC) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            XSNamespace[] ret = null;
            try {
                this.xsnsop2.doOXSNS(operationCode, sessionId, namespaces, secureId, roundTripRPC);
                if (roundTripRPC) {
                    ret = this.xsnsop2.getNamespaces();
                }
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
            if (returnedNamespaces != null && returnedNamespaces.length > 0) {
                returnedNamespaces[0] = ret;
            }
        }
    }

    @Override
    public void doXSSessionDetachOp(int opcode, byte[] sessionId, XSSecureId sidp, boolean roundTripRPC) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                this.oxsdet.doOXSDET(opcode, sessionId, sidp, roundTripRPC);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSNamespace[][] returnedNamespaces, XSSecureId secureId) throws SQLException {
        this.doXSNamespaceOp(operationCode, sessionId, namespaces, returnedNamespaces, secureId, true);
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSSecureId secureId) throws SQLException {
        this.doXSNamespaceOp(operationCode, sessionId, namespaces, null, secureId, false);
    }

    @Override
    public byte[] doXSSessionCreateOp(OracleConnection.XSSessionOperationCode opcode, XSSecureId sidp, byte[] cookie, XSPrincipal username, String tenant, XSNamespace[] namespaces, OracleConnection.XSSessionModeFlag mode, XSKeyval Kv) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] ret = null;
            try {
                this.oxscre.doOXSCRE(opcode, sidp, cookie, username, tenant, namespaces, mode, Kv);
                ret = this.oxscre.getSessionId();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
            byte[] byArray = ret;
            return byArray;
        }
    }

    @Override
    public void doXSSessionDestroyOp(byte[] sessionId, XSSecureId sidp, byte[] cookie) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                this.oxsdes.doOXSDES(sessionId, sidp, cookie);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public void doXSSessionAttachOp(int opCode, byte[] sessionId, XSSecureId sidp, byte[] cookie, XSPrincipal username, String[] disabledRoles, String[] enabledRoles, String[] externalRoles, XSNamespace[] namespaces, XSNamespace[] cacheNamespace, XSNamespace[] deleteNamespace, TIMESTAMPTZ midTierTimestamp, TIMESTAMPTZ authtime, int roleVersion, long inputFlag, XSKeyval Kv, int[] roleVersionOutput) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                this.oxsatt.doOXSATT(opCode, sessionId, sidp, cookie, username, disabledRoles, enabledRoles, externalRoles, namespaces, cacheNamespace, deleteNamespace, midTierTimestamp, authtime, roleVersion, inputFlag, Kv, roleVersionOutput);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public void doXSSessionChangeOp(OracleConnection.XSSessionSetOperationCode opCode, byte[] sessionId, XSSecureId sidp, XSSessionParameters sessParam) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                this.oxsset.doOXSSET(opCode, sessionId, sidp, (XSSessionParametersI)sessParam);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
            }
        }
    }

    @Override
    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener l, Executor e) throws SQLException {
        this.requireOpenConnection();
        NTFEventListener listener = new NTFEventListener(l);
        listener.setExecutor(e);
        try (Monitor.CloseableLock lock = this.ltxidListenersMonitor.acquireCloseableLock();){
            int length = this.ltxidListeners.length;
            for (int i = 0; i < length; ++i) {
                if (this.ltxidListeners[i].getLogicalTransactionIdEventListener() != l) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248).fillInStackTrace();
            }
            NTFEventListener[] listeners2 = new NTFEventListener[length + 1];
            System.arraycopy(this.ltxidListeners, 0, listeners2, 0, length);
            listeners2[length] = listener;
            this.ltxidListeners = listeners2;
        }
    }

    @Override
    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener l) throws SQLException {
        this.addLogicalTransactionIdEventListener(l, null);
    }

    @Override
    public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener) throws SQLException {
        try (Monitor.CloseableLock lock = this.ltxidListenersMonitor.acquireCloseableLock();){
            int i = 0;
            int length = this.ltxidListeners.length;
            for (i = 0; i < length && this.ltxidListeners[i].getLogicalTransactionIdEventListener() != listener; ++i) {
            }
            if (i == length) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249).fillInStackTrace();
            }
            NTFEventListener[] listeners2 = new NTFEventListener[length - 1];
            int offset = 0;
            for (i = 0; i < length; ++i) {
                if (this.ltxidListeners[i].getLogicalTransactionIdEventListener() == listener) continue;
                listeners2[offset++] = this.ltxidListeners[i];
            }
            this.ltxidListeners = listeners2;
        }
    }

    @Override
    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        return this.thinACCurrentLTXID;
    }

    boolean notify(final NTFLTXIDEvent event) {
        boolean listenersWereNotified = false;
        if (this.ltxidListeners != null) {
            NTFEventListener[] localListeners = this.ltxidListeners;
            int length = localListeners.length;
            if (length > 0) {
                listenersWereNotified = true;
            }
            for (int i = 0; i < length; ++i) {
                Executor exec = localListeners[i].getExecutor();
                if (exec != null) {
                    final LogicalTransactionIdEventListener l = localListeners[i].getLogicalTransactionIdEventListener();
                    exec.execute(new Runnable(){

                        @Override
                        public void run() {
                            l.onLogicalTransactionIdEvent(event);
                        }
                    });
                    continue;
                }
                localListeners[i].getLogicalTransactionIdEventListener().onLogicalTransactionIdEvent(event);
            }
        }
        return listenersWereNotified;
    }

    @Override
    public void addXSEventListener(XSEventListener l, Executor e) throws SQLException {
        this.requireOpenConnection();
        NTFEventListener listener = new NTFEventListener(l);
        listener.setExecutor(e);
        try (Monitor.CloseableLock lock = this.xsListenersMonitor.acquireCloseableLock();){
            int length = this.xsListeners.length;
            for (int i = 0; i < length; ++i) {
                if (this.xsListeners[i].getXSEventListener() != l) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248).fillInStackTrace();
            }
            NTFEventListener[] listeners2 = new NTFEventListener[length + 1];
            System.arraycopy(this.xsListeners, 0, listeners2, 0, length);
            listeners2[length] = listener;
            this.xsListeners = listeners2;
        }
    }

    @Override
    public void addXSEventListener(XSEventListener l) throws SQLException {
        this.addXSEventListener(l, null);
    }

    @Override
    public void removeXSEventListener(XSEventListener listener) throws SQLException {
        try (Monitor.CloseableLock lock = this.xsListenersMonitor.acquireCloseableLock();){
            int i = 0;
            int length = this.xsListeners.length;
            for (i = 0; i < length && this.xsListeners[i].getXSEventListener() != listener; ++i) {
            }
            if (i == length) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249).fillInStackTrace();
            }
            NTFEventListener[] listeners2 = new NTFEventListener[length - 1];
            int offset = 0;
            for (i = 0; i < length; ++i) {
                if (this.xsListeners[i].getXSEventListener() == listener) continue;
                listeners2[offset++] = this.xsListeners[i];
            }
            this.xsListeners = listeners2;
        }
    }

    @Override
    public void removeAllXSEventListener() throws SQLException {
        try (Monitor.CloseableLock lock = this.xsListenersMonitor.acquireCloseableLock();){
            NTFEventListener[] listeners2 = new NTFEventListener[]{};
            this.xsListeners = listeners2;
        }
    }

    void notify(final NTFXSEvent event) {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "DCNRegistration got an event. ", null, null);
        NTFEventListener[] localListeners = this.xsListeners;
        int length = localListeners.length;
        for (int i = 0; i < length; ++i) {
            Executor exec = localListeners[i].getExecutor();
            if (exec != null) {
                final XSEventListener l = localListeners[i].getXSEventListener();
                exec.execute(new Runnable(){

                    @Override
                    public void run() {
                        l.onXSEvent(event);
                    }
                });
                continue;
            }
            localListeners[i].getXSEventListener().onXSEvent(event);
        }
    }

    @Override
    public boolean isConnectionBigTZTC() throws SQLException {
        if (this.getLifecycle() != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        return this.hasServerCompileTimeCapability(40, 16);
    }

    final boolean hasServerCompileTimeCapability(int index, int flag) {
        boolean ret = false;
        if (this.serverCompileTimeCapabilities != null && this.serverCompileTimeCapabilities.length > index && (this.serverCompileTimeCapabilities[index] & (flag & 0xFF)) != 0) {
            ret = true;
        }
        return ret;
    }

    final byte getServerCompileTimeCapability(int index) {
        byte capability = this.serverCompileTimeCapabilities == null || this.serverCompileTimeCapabilities.length <= index ? (byte)0 : this.serverCompileTimeCapabilities[index];
        return capability;
    }

    @Override
    long doGetCurrentSCN() throws SQLException {
        return this.outScn;
    }

    @Override
    EnumSet<OracleConnection.TransactionState> doGetTransactionState() throws SQLException {
        EnumSet<OracleConnection.TransactionState> ret = EnumSet.noneOf(OracleConnection.TransactionState.class);
        if ((this.eocs & 1) != 0) {
            ret.add(OracleConnection.TransactionState.TRANSACTION_READONLY);
        }
        if ((this.eocs & 2) != 0) {
            ret.add(OracleConnection.TransactionState.TRANSACTION_STARTED);
        }
        if ((this.eocs & 4) != 0) {
            ret.add(OracleConnection.TransactionState.TRANSACTION_ENDED);
        }
        if ((this.eocs & 0x400) != 0) {
            ret.add(OracleConnection.TransactionState.TRANSACTION_INTENTION);
        }
        return ret;
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.net.isConnectionSocketKeepAlive();
    }

    @Override
    public int getEOC() throws SQLException {
        return this.eocs;
    }

    @Override
    public void setReplayOperations(EnumSet<OracleConnection.ReplayOperation> ops) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.osessstateFlags == OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END.getCode() && ops.size() == 0) {
                return;
            }
            if (this.osessstateFlags != OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END.getCode() && this.osessstateFlags != OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END.getCode() + OracleConnection.ReplayOperation.KPDSS_SESSSTATE_EXPL_BOUND.getCode()) {
                this.osessstateFlags = 0L;
            }
            Iterator it = ops.iterator();
            while (it.hasNext()) {
                this.osessstateFlags |= ((OracleConnection.ReplayOperation)((Object)it.next())).getCode();
            }
            if ((this.osessstateFlags & OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED.getCode()) != 0L) {
                this.replayModes.add(ReplayMode.RUNTIME_REPLAY_ENABLED);
            } else {
                this.replayModes.remove((Object)ReplayMode.RUNTIME_REPLAY_ENABLED);
            }
            if ((this.osessstateFlags & OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC.getCode()) != 0L) {
                this.replayModes.add(ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
            } else {
                this.replayModes.remove((Object)ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
            }
        }
    }

    @Override
    public void setReplayingMode(boolean replaying) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (replaying) {
                this.replayModes.remove((Object)ReplayMode.RUNTIME_REPLAY_ENABLED);
                this.replayModes.add(ReplayMode.REPLAYING);
            } else {
                this.replayModes.remove((Object)ReplayMode.REPLAYING);
            }
        }
    }

    @Override
    public void beginNonRequestCalls() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.replayModes.add(ReplayMode.NONREQUEST);
        }
    }

    @Override
    public void endNonRequestCalls() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.replayModes.remove((Object)ReplayMode.NONREQUEST);
        }
    }

    @Override
    public void setReplayContext(oracle.jdbc.internal.ReplayContext[] contexts) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (contexts != null) {
                this.oappcontreplayContextsArr = contexts;
                this.oappcontreplayOffset = 0;
            }
        }
    }

    @Override
    public oracle.jdbc.internal.ReplayContext[] getReplayContext() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.thinACReplayContextReceivedCurrent == 0) {
                if (this.nonRequestDisableReplayCxt != null) {
                    oracle.jdbc.internal.ReplayContext[] copy = new oracle.jdbc.internal.ReplayContext[]{this.nonRequestDisableReplayCxt};
                    this.nonRequestDisableReplayCxt = null;
                    oracle.jdbc.internal.ReplayContext[] replayContextArray = copy;
                    return replayContextArray;
                }
                oracle.jdbc.internal.ReplayContext[] copy = null;
                return copy;
            }
            oracle.jdbc.internal.ReplayContext[] copy = new oracle.jdbc.internal.ReplayContext[this.thinACReplayContextReceivedCurrent];
            System.arraycopy(this.thinACReplayContextReceived, 0, copy, 0, this.thinACReplayContextReceivedCurrent);
            this.thinACReplayContextReceivedCurrent = 0;
            oracle.jdbc.internal.ReplayContext[] replayContextArray = copy;
            return replayContextArray;
        }
    }

    @Override
    public oracle.jdbc.internal.ReplayContext getLastReplayContext() throws SQLException {
        return this.thinACLastReplayContextReceived;
    }

    @Override
    public void setLastReplayContext(oracle.jdbc.internal.ReplayContext cxt) throws SQLException {
        this.thinACLastReplayContextReceived = (ReplayContext)cxt;
    }

    @Override
    public void registerEndReplayCallback(OracleConnection.EndReplayCallback callback) throws SQLException {
        this.endReplayCallback = callback;
    }

    @Override
    public byte[] getDerivedKeyInternal(byte[] dhKey, int mode) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        return this.auth.getDerivedKeyJdbc(dhKey, mode);
    }

    @Override
    void releaseConnectionToPool() throws SQLException {
        if (this.drcpState == OracleConnection.DRCPState.DETACHED) {
            return;
        }
        this.awaitPipeline();
        this.closeStatements(true, false);
        this.releasedSessID = this.getSessionId();
        this.releasedSerial = this.getSerialNumber();
        try {
            if (this.currentlyInTransaction) {
                this.osessrls.setTTCCode((byte)3);
                this.osessrls.doRPC();
            } else {
                this.osessrls.setTTCCode((byte)26);
                this.osessrls.doOneWayRPC();
            }
            this.drcpState = OracleConnection.DRCPState.DETACHED;
            if (this.isDRCPEnabled() && !this.isClientInitiatedNTFConnection() && this.net().isTLSEnabled()) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "releaseConnectionToPool", "Initializing TLS renegotiation, it will be performed before any further roundtrips on this connection", null, null);
                this.net().getSessionAttributes().initTLSRenegotiation();
            }
        }
        catch (IOException ea) {
            this.handleIOException(ea);
        }
        catch (SQLException ea) {
            if (this.currentlyInTransaction) {
                throw ea;
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "releaseConnectionToPool", null, null, ea);
        }
    }

    @Override
    boolean reusePooledConnection() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.drcpState == OracleConnection.DRCPState.DETACHED) {
                try {
                    if (this.drcpTagName == null) {
                        boolean bl = true;
                        return bl;
                    }
                    this.osessget.doRPC();
                    this.drcpState = OracleConnection.DRCPState.ATTACHED_EXPLICIT;
                }
                catch (IOException ea) {
                    this.handleIOException(ea);
                }
            }
            if (this.getTTCVersion() >= 8) {
                boolean bl = this.osessget.returnTag != null && !T4CConnection.bit(this.osessget.sessgetflags, 1L);
                return bl;
            }
            boolean bl = !T4CConnection.bit(this.osessget.sessgetflags, 1L);
            return bl;
        }
    }

    private boolean isClientInitiatedNTFConnection() {
        return this.jmsNotificationConnection;
    }

    @Override
    public boolean isDRCPMultitagEnabled() throws SQLException {
        return this.drcpEnabled && this.useDRCPMultipletag;
    }

    @Override
    public String getDRCPReturnTag() throws SQLException {
        return this.osessget.returnTag;
    }

    @Override
    public boolean needToPurgeStatementCache() throws SQLException {
        this.requireOpenConnection();
        if (!this.drcpEnabled) {
            return false;
        }
        return T4CConnection.bit(this.ocsessret.sessretflags, 4L) || T4CConnection.bit(this.ocsessret.sessretflags, 8L) || this.getSessionId() != this.releasedSessID || this.getSerialNumber() != this.releasedSerial;
    }

    @Override
    void resetAfterReusePooledConnection() throws SQLException {
        OracleStatement executingStmt;
        if (!this.drcpEnabled) {
            return;
        }
        if (this.isPDBChanged && (executingStmt = this.getExecutingStatement()) == null) {
            this.onPDBChange(null);
            this.isPDBChanged = false;
        }
        if (this.needToPurgeStatementCache()) {
            this.clearCursorIds();
        }
        this.drcpState = OracleConnection.DRCPState.ATTACHED_IMPLICIT;
    }

    protected void clearCursorIds() {
        this.cleanStatementCache();
        OracleStatement s2 = this.statements;
        while (s2 != null) {
            if (!s2.serverCursor) {
                s2.clearCursorId();
            }
            s2 = s2.next;
        }
        this.cursorToClose = new int[4];
        this.cursorToCloseOffset = 0;
        this.lastCursorToCloseOffset = 0;
    }

    protected boolean canSendCursorIds() {
        boolean canSend = true;
        if (this.drcpEnabled && this.drcpState == OracleConnection.DRCPState.DETACHED) {
            canSend = false;
        }
        return canSend;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (!this.net.getSessionAttributes().isConnected()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        try {
            return this.net.getSocketReadTimeout();
        }
        catch (NetException ne) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne).fillInStackTrace();
        }
        catch (IOException ie) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ie).fillInStackTrace();
        }
    }

    @Override
    protected void doSetNetworkTimeout(int milliseconds) throws SQLException {
        if (!this.net.getSessionAttributes().isConnected()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        try {
            this.net.setSocketReadTimeout(milliseconds);
        }
        catch (NetException ne) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne).fillInStackTrace();
        }
        catch (IOException ie) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ie).fillInStackTrace();
        }
    }

    static final String dumpObject(Object o, String indent) {
        return T4CConnection.dumpObject(o, indent, new StringBuilder());
    }

    static final String dumpObject(Object o, String indent, StringBuilder sb) {
        Class<?> c = o.getClass();
        Field[] fields = c.getDeclaredFields();
        sb.append(indent + c.getName() + " { \n");
        for (Field f : fields) {
            if ((f.getModifiers() & 8) != 0) continue;
            f.setAccessible(true);
            try {
                sb.append(indent + "  " + f.getName() + " = ");
                Object _o = f.get(o);
                if (_o == null) {
                    sb.append("null");
                } else {
                    sb.append(_o);
                }
                sb.append("\n");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        sb.append(indent + "}\n");
        return sb.toString();
    }

    byte getNextSeqNumber() {
        if (this.currentTTCSeqNumber == 127) {
            this.currentTTCSeqNumber = 1;
            return this.currentTTCSeqNumber;
        }
        this.currentTTCSeqNumber = (byte)(this.currentTTCSeqNumber + 1);
        return this.currentTTCSeqNumber;
    }

    @Override
    public int getNegotiatedSDU() throws SQLException {
        try {
            return this.net.getNegotiatedSDU();
        }
        catch (NetException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
    }

    @Override
    public byte getNegotiatedTTCVersion() throws SQLException {
        return this.negotiatedTTCversion;
    }

    @Override
    String getAuditBanner() throws SQLException {
        this.requireOpenConnection();
        String tmpAuditBanner = this.sessionProperties.getProperty("AUTH_AUDIT_BANNER");
        return tmpAuditBanner;
    }

    @Override
    String getAccessBanner() throws SQLException {
        this.requireOpenConnection();
        String tmpAccessBanner = this.net.getAccessBanner();
        return tmpAccessBanner;
    }

    @Override
    ResultSetCache getResultSetCacheInternal() throws SQLException {
        return this.resultSetCache;
    }

    @Override
    ArrayList<Long> getResultSetCacheLocalInvalidations() {
        return this.resultSetCacheLocalInvalidations;
    }

    @Override
    public oracle.jdbc.internal.ResultSetCache getResultSetCache() throws SQLException {
        return this.resultSetCache;
    }

    final boolean isResultSetCacheActive() {
        return this.isResultSetCacheEnabled && this.resultSetCache != null && this.resultSetCache.getState() == ResultSetCache.ResultSetCacheState.STARTED;
    }

    @Override
    public boolean isServerBigSCN() throws SQLException {
        return this.isServerBigSCN;
    }

    final long getResultSetCacheVisibleSCN() {
        return this.resultSetCache.getVisibleSCN();
    }

    final void setResultSetCacheVisibleSCN(long scn) {
        this.resultSetCache.setVisibleSCN(scn);
    }

    final byte[] getResultSetCacheId() {
        return this.resultSetCache.getCacheId();
    }

    final byte[] getResultSetCacheIdAsNibbles() {
        return this.resultSetCache.getCacheIdAsNibbles();
    }

    final long getResultSetCacheRegistrationId() {
        return this.resultSetCache.getRegistrationId();
    }

    @Override
    public void setChunkInfo(OracleShardingKey shardingKey, OracleShardingKey superShardingKey, String chunkName) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (shardingKey != null) {
                this.shardingKey = ((OracleShardingKeyImpl)shardingKey).encodeKeyinB64Format();
            }
            if (superShardingKey != null) {
                this.superShardingKey = ((OracleShardingKeyImpl)superShardingKey).encodeKeyinB64Format();
            }
            if (chunkName != null) {
                this.chunkName = chunkName;
            }
        }
    }

    @Override
    public void setShardingKey(OracleShardingKey shardingKey, OracleShardingKey superShardingKey) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                String shardingKeyStr = null;
                String superShardingKeyStr = null;
                if (shardingKey != null) {
                    shardingKeyStr = ((OracleShardingKeyImpl)shardingKey).encodeKeyinB64Format();
                }
                if (superShardingKey != null) {
                    superShardingKeyStr = ((OracleShardingKeyImpl)superShardingKey).encodeKeyinB64Format();
                }
                this.ochunkinfo.doOCHUNKINFO(shardingKeyStr, superShardingKeyStr, null, false);
            }
            catch (IOException e) {
                throw (SQLException)DatabaseError.createSqlException(e).fillInStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey shardingKey, OracleShardingKey superShardingKey, int timeout) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean isValid;
            block44: {
                this.requireNonNegativeTimeout(timeout);
                if (this.getLifecycle() != 1) {
                    boolean bl = false;
                    return bl;
                }
                int existingTimeout = -1;
                int timeoutMillis = timeout * 1000;
                isValid = false;
                try {
                    existingTimeout = this.net.getSocketReadTimeout();
                    if (timeoutMillis > 0 && (timeoutMillis < existingTimeout || existingTimeout == 0)) {
                        this.net.setSocketReadTimeout(timeoutMillis);
                    }
                    String shardingKeyStr = null;
                    String superKeyStr = null;
                    if (shardingKey == null) {
                        throw new IllegalArgumentException("Shard key argument cannot be null");
                    }
                    shardingKeyStr = ((OracleShardingKeyImpl)shardingKey).encodeKeyinB64Format();
                    if (superShardingKey != null) {
                        superKeyStr = ((OracleShardingKeyImpl)superShardingKey).encodeKeyinB64Format();
                    }
                    this.ochunkinfo.doOCHUNKINFO(shardingKeyStr, superKeyStr, null, false);
                    isValid = true;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 45582 || e.getErrorCode() == 5016) {
                        isValid = false;
                        break block44;
                    }
                    throw e;
                }
                catch (SocketTimeoutException toe) {
                    isValid = false;
                }
                catch (InterruptedIOException iioe) {
                    this.handleIOException(iioe);
                    isValid = false;
                }
                catch (IOException ioEx) {
                    isValid = false;
                }
                finally {
                    try {
                        if (existingTimeout >= 0) {
                            this.net.setSocketReadTimeout(existingTimeout);
                        }
                    }
                    catch (IOException ioEx) {
                        isValid = false;
                    }
                }
            }
            boolean bl = isValid;
            return bl;
        }
    }

    private void requireNonNegativeTimeout(int timeout) throws SQLException {
        if (timeout < 0) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1728, (Object)timeout);
        }
    }

    @Override
    public void setShardingKey(OracleShardingKey shardingKey) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.setShardingKey(shardingKey, (OracleShardingKey)null);
        }
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey shardingKey, int timeout) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.setShardingKeyIfValid(shardingKey, (OracleShardingKey)null, timeout);
            return bl;
        }
    }

    private OracleStatement getExecutingStatement() {
        if (this.getExecutingRPCFunctionCode() != 94 || this.all8 == null) {
            return null;
        }
        return this.all8.oracleStatement;
    }

    @Override
    public NetStat getNetworkStat() {
        return this.net.getNetworkStat();
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this.net.isNetworkCompressionEnabled();
    }

    @Override
    public int getOutboundConnectTimeout() {
        return this.net.getOutboundConnectTimeout();
    }

    @Override
    public void beginRequest() throws SQLException {
        super.beginRequest();
        if (this.svrSupportsRequests) {
            if (this.svrSupportsExplicitRequestBit) {
                this.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_EXPL_BOUND));
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "Set BEGIN_REQUEST+EXPLICIT bits on client-side. ", null, null);
            } else {
                this.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN));
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "Set BEGIN_REQUEST bit on client-side. ", null, null);
            }
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "Server does not support request boundary, no bit set. ", null, null);
        }
    }

    @Override
    public void endRequest(boolean implicit) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (!this.isInRequest()) {
                return;
            }
            if (this.net.getSessionAttributes().isConnected()) {
                this.net.cancelTimeout();
            }
            if (this.svrSupportsRequests) {
                if (this.svrSupportsExplicitRequestBit && !implicit) {
                    this.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_EXPL_BOUND));
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Set END_REQUEST+EXPLICIT bits on client-side. ", null, null);
                } else {
                    this.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END));
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Set END_REQUEST bit on client-side. ", null, null);
                }
            } else {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Server does not support request boundary, no bit set. ", null, null);
            }
            super.endRequest(implicit);
        }
    }

    @Override
    public boolean hasNoOpenHandles() throws SQLException {
        if (!this.enableImplicitRequests) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "Implicit request support is explicitly disabled via property, returning false. ", null, null);
            return false;
        }
        if (this.pipeline != null && this.pipeline.isStarted()) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "Pipelining has started, returning false. ", null, null);
            return false;
        }
        if (this.sessionState != null && this.sessionState.isUnrestorable()) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "Current session state is unrestorable, returning false. ", null, null);
            return false;
        }
        int _txnMode = this.getTxnMode();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "txn mode={0}. ", (String)null, (Throwable)null, (Object)_txnMode);
        if (_txnMode == 1) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "Connection is still in a global txn, returning false. ", null, null);
            return false;
        }
        EnumSet<OracleConnection.TransactionState> eocs = this.getTransactionState();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "Local Txn State={0}. ", (String)null, (Throwable)null, (Object)eocs);
        if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "Connection is still in a local txn, returning false. ", null, null);
            return false;
        }
        if (this.statements != null) {
            OracleStatement stmt = this.statements;
            while (stmt != null) {
                if (!(stmt.cacheState != 3 && stmt.cacheState != 1 || this.enableSSSCursor && stmt.isSSSCursor)) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "connection still has open statements, returning false. ", null, null);
                    return false;
                }
                stmt = stmt.next;
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "connection has NO open statements. ", null, null);
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "connection has NO open statements. ", null, null);
        }
        if (this.bfileCount.get() > 0L) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "connection still has open Bfile locators, returning false. ", null, null);
            return false;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "connection has NO open Bfile locators. ", null, null);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "hasNoOpenHandles", "connection has NO open handles. ", null, null);
        return true;
    }

    @Override
    public oracle.jdbc.internal.DatabaseSessionState getDatabaseSessionState() {
        return this.sessionState.copy();
    }

    @Override
    public void setDatabaseSessionState(oracle.jdbc.internal.DatabaseSessionState newSessionState) {
        this.sessionStateOut = (DatabaseSessionState)newSessionState;
    }

    final void updateSessionState(StateSignatures stateSignatures, TemplateOverflow templateOverflow) {
        if (this.sessionState == null) {
            this.sessionState = new DatabaseSessionState();
        }
        this.sessionState.update(stateSignatures, templateOverflow);
    }

    @Override
    public void addLargeObject(OracleLargeObject lob) throws SQLException {
        this.lobCount.incrementAndGet();
    }

    @Override
    public void removeLargeObject(OracleLargeObject lob) throws SQLException {
        this.lobCount.decrementAndGet();
    }

    @Override
    public void addBfile(OracleBfile bfile) throws SQLException {
        this.bfileCount.incrementAndGet();
    }

    @Override
    public void removeBfile(OracleBfile bfile) throws SQLException {
        this.bfileCount.decrementAndGet();
    }

    void enterMarshalling() throws NetException {
        if (!this.net.getSessionAttributes().isConnected()) {
            throw new NetException(17900);
        }
        if (this.writeBufferIsDirty) {
            this.mare.clearWriteBuffer();
        }
        this.writeBufferIsDirty = true;
    }

    void exitMarshalling() {
        this.writeBufferIsDirty = false;
    }

    @Override
    public String getEncryptionProviderName() throws SQLException {
        if (this.net.getSessionAttributes().isEncryptionActive) {
            return this.net.getSessionAttributes().ano.getEncryptionProvider();
        }
        return null;
    }

    @Override
    public String getChecksumProviderName() throws SQLException {
        if (this.net.getSessionAttributes().isChecksumActive) {
            return this.net.getSessionAttributes().ano.getChecksumProvider();
        }
        return null;
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getJavaNetProperties() throws SQLException {
        return this.net.getSessionAttributes().getNetProperties();
    }

    @Override
    public String getNetConnectionId() throws SQLException {
        if (this.net != null && this.net.getSessionAttributes() != null) {
            return this.net.getSessionAttributes().getNetConnectionId();
        }
        return null;
    }

    @Override
    boolean readInbandDownNotification() {
        this.net.readInbandNotification();
        return this.net.needsToBeClosed();
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.getLifecycle() != 2 && this.getLifecycle() != 4) {
                this.awaitPipeline();
            }
            super.doClose();
        }
    }

    @Override
    boolean isShardingDriverMode() {
        return this.shardingDriverMode;
    }

    @Override
    boolean isTrueCacheDriverMode() {
        return this.tcDriverMode;
    }

    boolean isUsingCustomHostnameResolver() {
        return this.net.isUsingCustomHostnameResolver();
    }

    boolean useShardingDriverConnection() {
        return this.useShardingDriverConnection;
    }

    boolean useTrueCacheDriverConnection() {
        return this.useTrueCacheDriverConnection;
    }

    @Override
    public boolean isSSSHybrid() throws SQLException {
        return this.isHybrid;
    }

    @Override
    public void setSSSHybrid(boolean isHybrid) throws SQLException {
        this.isHybrid = isHybrid;
    }

    byte[] getOsonBytes(byte[] jsonLobLocator, long lobOffset) throws SQLException {
        int readLength;
        this.needLine();
        try {
            readLength = (int)this.jsonMsg.getLength(jsonLobLocator);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
        byte[] osonBuffer = new byte[readLength];
        this.getOsonBytes(jsonLobLocator, lobOffset, readLength, osonBuffer, 0);
        return osonBuffer;
    }

    void getOsonBytes(byte[] jsonLobLocator, long lobOffset, int readLength, byte[] osonBuffer, int osonBufferOffset) throws SQLException {
        this.needLine();
        try {
            this.jsonMsg.read(jsonLobLocator, lobOffset, readLength, osonBuffer, osonBufferOffset);
        }
        catch (IOException ex) {
            this.handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
    }

    @Override
    public void addFeature(OracleConnection.ClientFeature cf) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.doAddFeature(cf);
        }
    }

    private void doAddFeature(OracleConnection.ClientFeature cf) throws SQLException {
        this.assertLockHeldByCurrentThread();
        this.oclFeatures.add(cf);
    }

    @Override
    ByteBuffer convertClobDataInNetworkCharSet(OracleClob clob, char[] clobData, int length) throws SQLException {
        boolean varWidthChar = this.clobMsg.isLobCharsetVariableWidth(clob.shareBytes());
        int byteBufferSize = this.clobMsg.getByteBufferSizeForConversion(varWidthChar, length);
        byte[] clobDataBuffer = new byte[byteBufferSize];
        int bytesConverted = this.clobMsg.encodeNetworkCharSet(clobData, 0, length, clobDataBuffer, varWidthChar, clob.isNCLOB(), null);
        return ByteBuffer.wrap(clobDataBuffer, 0, bytesConverted);
    }

    static byte[] setupJsonQuasiLocator(long lobDataLength) {
        return T4CConnection.setupQuasiLocator(lobDataLength, (short)1, (byte)33, (byte)0, (byte)0, (short)0);
    }

    static byte[] setupClobVectorQuasiLocator(long characterLength, short characterSetId) throws SQLException {
        boolean isFixedWidth = CharacterSetMetaData.isFixedWidth(characterSetId);
        int characterWidth = CharacterSetMetaData.getRatio(characterSetId, 1);
        int bytl = isFixedWidth ? (int)characterWidth : 2;
        long dataLength = (long)bytl * characterLength;
        return T4CConnection.setupQuasiLocator(dataLength, (short)bytl, (byte)34, (byte)0, isFixedWidth || characterWidth == 1 ? (byte)0 : -128, characterSetId);
    }

    static byte[] setupQuasiLocator(long lobDataLength, short byteWidth, byte flag1, byte flag2, byte flag3, short characterSetId) {
        int locatorSize = 40;
        byte[] locator = new byte[40];
        locator[1] = 38;
        locator[3] = 4;
        locator[4] = (byte)(flag1 | 0x40);
        locator[5] = (byte)(flag2 | 8);
        locator[6] = flag3;
        locator[8] = (byte)(byteWidth >> 8 & 0xFF);
        locator[9] = (byte)(byteWidth & 0xFF);
        locator[10] = (byte)(lobDataLength >> 56 & 0xFFL);
        locator[11] = (byte)(lobDataLength >> 48 & 0xFFL);
        locator[12] = (byte)(lobDataLength >> 40 & 0xFFL);
        locator[13] = (byte)(lobDataLength >> 32 & 0xFFL);
        locator[14] = (byte)(lobDataLength >> 24 & 0xFFL);
        locator[15] = (byte)(lobDataLength >> 16 & 0xFFL);
        locator[16] = (byte)(lobDataLength >> 8 & 0xFFL);
        locator[17] = (byte)(lobDataLength & 0xFFL);
        locator[20] = (byte)(characterSetId >> 8 & 0xFF);
        locator[21] = (byte)(characterSetId & 0xFF);
        return locator;
    }

    private Properties getConnectionPropsforListenerConnection() {
        Properties connectionProps = new Properties();
        if (this.thinNetAuthenticationServices != null) {
            connectionProps.setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
        }
        if (this.thinNetAuthenticationKrb5Mutual != null) {
            connectionProps.setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
        }
        if (this.thinNetAuthenticationKrb5CcName != null) {
            connectionProps.setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
        }
        if (this.thinNetAuthenticationKrbJaasLoginModule != null) {
            connectionProps.setProperty("oracle.net.KerberosJaasLoginModule", this.thinNetAuthenticationKrbJaasLoginModule);
        }
        if (this.walletLocation != null) {
            connectionProps.setProperty("oracle.net.wallet_location", this.walletLocation);
        }
        if (this.walletPassword != null && this.walletPassword != OpaqueString.NULL) {
            connectionProps.setProperty("oracle.net.wallet_password", this.walletPassword.get());
        }
        if (this.tnsAdmin != null) {
            connectionProps.setProperty("oracle.net.tns_admin", this.tnsAdmin);
        }
        if (this.thinJavaxNetSslTruststore != null) {
            connectionProps.setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
        }
        if (this.thinJavaxNetSslTruststoretype != null) {
            connectionProps.setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
        }
        if (this.thinJavaxNetSslTruststorepassword != null && this.thinJavaxNetSslTruststorepassword != OpaqueString.NULL) {
            connectionProps.setProperty("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword.get());
        }
        if (this.thinJavaxNetSslKeystore != null) {
            connectionProps.setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
        }
        if (this.thinJavaxNetSslKeystoretype != null) {
            connectionProps.setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
        }
        if (this.thinJavaxNetSslKeystorepassword != null && this.thinJavaxNetSslKeystorepassword != OpaqueString.NULL) {
            connectionProps.setProperty("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword.get());
        }
        connectionProps.setProperty("oracle.net.keepAlive", "true");
        return connectionProps;
    }

    Pipeline pipeline() {
        return this.pipeline;
    }

    @Override
    OracleTimeout getTimeout() throws SQLException {
        if (this.pipeline.isExecuting()) {
            return this.pipeline.createTimeout();
        }
        return super.getTimeout();
    }

    @Override
    protected final void awaitPipeline() throws SQLException {
        if (this.pipeline == null) {
            return;
        }
        this.pipeline.await();
    }

    public void lastExecutedFunCode(short funCode) {
        this.lastExecutedFunCode = funCode;
    }

    static {
        int size = 0;
        try {
            size = Integer.parseInt(T4CConnection.getSystemPropertyTTCCookieCacheSize());
        }
        catch (Exception ignored) {
            size = Integer.parseInt("50");
        }
        DATABASE_NEGOTIATED_INFORMATION = new T4CTTICookieCache(size);
    }

    static enum ReplayMode {
        RUNTIME_REPLAY_ENABLED,
        RUNTIME_OR_REPLAYING_STATIC,
        NONREQUEST,
        REPLAYING;

    }

    static enum ConnectionPath {
        NORMAL,
        COOKIE,
        TTIINIT;

    }
}

