/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.jdbc.driver.parser.LexerToken;
import oracle.jdbc.driver.parser.Matrix;
import oracle.jdbc.driver.parser.ParseNode;
import oracle.jdbc.driver.parser.Parser;
import oracle.jdbc.driver.parser.RuleTuple;
import oracle.jdbc.driver.parser.Token;
import oracle.jdbc.driver.parser.util.Array;
import oracle.jdbc.driver.parser.util.Service;

public class Earley
extends Parser {
    public int identifier = -1;
    protected int string_literal = -1;
    protected int digits = -1;
    public boolean isCaseSensitive = false;
    protected PredictedTerminals[] terminalPredictions = null;
    public Map<Integer, long[]> predicts = new HashMap<Integer, long[]>();
    public boolean skipRanges = true;

    protected void initCell00(List<LexerToken> src, Matrix matrix) {
        long t1 = 0L;
        long[] content = null;
        for (int i = 0; i < this.rules.length; ++i) {
            Parser.Tuple t2 = this.rules[i];
            String head = this.allSymbols[t2.head];
            if (head.charAt(head.length() - 1) == ')') continue;
            content = Array.insert(content, Earley.makeMatrixCellElem(i, 0, t2));
        }
        matrix.initCells(src.size());
        matrix.put(0, 0, new Parser.EarleyCell(this, content));
        matrix.allXs = Array.insert(matrix.allXs, 0);
    }

    public void parse(List<LexerToken> src, Matrix m4) {
        Matrix matrix = m4;
        try {
            this.initCell00(src, matrix);
            this.predict(matrix);
            while (this.scan(matrix, src)) {
                this.complete(matrix, src.size());
                this.predict(matrix);
            }
        }
        catch (Exception e) {
            for (StackTraceElement elem : e.getStackTrace()) {
                if (!elem.toString().contains("UnitTest.assertion") && !elem.toString().contains("SqlEarley.main")) continue;
                System.err.println(e.toString());
                System.err.println("matrix.lastY=" + matrix.lastY() + ", src.size()=" + src.size());
                break;
            }
        }
    }

    @Override
    public ParseNode parse(List<LexerToken> src) {
        Matrix matrix = new Matrix(this);
        this.parse(src, matrix);
        return this.forest(src, matrix);
    }

    public Earley(RuleTuple[] originalRules) {
        this(originalRules, true);
    }

    public Earley(RuleTuple[] originalRules, boolean precomputePredictions) {
        super(originalRules);
        this.identifier = (Integer)this.symbolIndexes.get("identifier");
        try {
            this.string_literal = (Integer)this.symbolIndexes.get("string_literal");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.digits = (Integer)this.symbolIndexes.get("digits");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void precomputePredictions() {
        int before;
        Object tmp;
        HashMap<Integer, int[]> closure = new HashMap<Integer, int[]>();
        HashMap<Integer, long[]> symbolHead2rules = new HashMap<Integer, long[]>();
        for (int i = 0; i < this.rules.length; ++i) {
            tmp = (int[])closure.get(this.rules[i].head);
            long[] tmp1 = (long[])symbolHead2rules.get(this.rules[i].head);
            tmp = Array.insert((int[])tmp, this.rules[i].rhs[0]);
            tmp1 = Array.insert(tmp1, Earley.makeMatrixCellElem(i, 0, this.rules[i]));
            closure.put(this.rules[i].head, (int[])tmp);
            symbolHead2rules.put(this.rules[i].head, tmp1);
        }
        do {
            before = this.size(closure);
            tmp = closure.keySet().iterator();
            while (tmp.hasNext()) {
                int k = (Integer)tmp.next();
                int[] v = (int[])closure.get(k);
                int[] tmp2 = Array.merge(v, new int[0]);
                for (int n : v) {
                    tmp2 = Array.merge(tmp2, (int[])closure.get(n));
                }
                closure.put(k, tmp2);
            }
        } while (before != this.size(closure));
        this.terminalPredictions = new PredictedTerminals[this.allSymbols.length];
        Iterator iterator = closure.keySet().iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            long[] tmp3 = (long[])symbolHead2rules.get(k);
            for (int n : (int[])closure.get(k)) {
                tmp3 = Array.merge(tmp3, (long[])symbolHead2rules.get(n));
                String rhs0 = this.allSymbols[n];
                if (rhs0.charAt(0) == '\'') {
                    if (this.terminalPredictions[k] == null) {
                        this.terminalPredictions[k] = new PredictedTerminals();
                    }
                    this.terminalPredictions[k].add(n);
                    continue;
                }
                if (n != this.identifier && n != this.digits && n != this.string_literal) continue;
                if (this.terminalPredictions[k] == null) {
                    this.terminalPredictions[k] = new PredictedTerminals();
                }
                this.terminalPredictions[k].invalidate();
            }
            this.predicts.put(k, tmp3);
        }
    }

    private int size(Map<Integer, int[]> closure) {
        int ret = 0;
        for (int[] tmp : closure.values()) {
            ret += tmp.length;
        }
        return ret;
    }

    protected boolean scan(Matrix matrix, List<LexerToken> src) {
        int y = matrix.lastY();
        if (src.size() <= y) {
            return false;
        }
        LexerToken token = src.get(y);
        Integer suspect = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? token.content : token.content.toUpperCase()) + "'");
        boolean ret = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            int x = matrix.allXs[i];
            if (!this.scan(matrix, y, src, x, suspect)) continue;
            ret = true;
        }
        if (this.scan(matrix, y, src, y, suspect)) {
            ret = true;
        }
        return ret;
    }

    private boolean scan(Matrix matrix, int y, List<LexerToken> src, int x, Integer suspect) {
        long t1 = 0L;
        long[] content = null;
        Parser.EarleyCell candidateRules = matrix.get(x, y);
        if (candidateRules == null) {
            return false;
        }
        for (int j = 0; j < candidateRules.size(); ++j) {
            int pos = candidateRules.getPosition(j);
            int ruleNo = candidateRules.getRule(j);
            Parser.Tuple t2 = this.rules[ruleNo];
            if (t2.size() - 1 < pos || !this.isScannedSymbol(y, src, pos, t2, suspect) || !this.lookaheadOK(t2, pos + 1, matrix)) continue;
            content = Array.insert(content, Earley.makeMatrixCellElem(ruleNo, pos + 1, t2));
            if (t2.rhs.length != pos + 1) continue;
            matrix.enqueue(Service.lPair(x, t2.head));
        }
        if (content == null) {
            return false;
        }
        matrix.put(x, y + 1, new Parser.EarleyCell(this, content));
        matrix.allXs = Array.insert(matrix.allXs, x);
        return true;
    }

    protected boolean isScannedSymbol(int y, List<LexerToken> src, int pos, Parser.Tuple t2, Integer suspect) {
        int symbol = t2.content(pos);
        LexerToken token = src.get(y);
        if (symbol == this.digits && token.type == Token.DIGITS) {
            return true;
        }
        if (symbol == this.string_literal && token.type == Token.QUOTED_STRING) {
            return true;
        }
        return suspect != null && suspect == symbol || this.isIdentifier(y, src, symbol, suspect);
    }

    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        if (symbol != this.identifier) {
            return false;
        }
        LexerToken token = src.get(y);
        return token.type == Token.IDENTIFIER;
    }

    @Deprecated
    protected boolean notConfusedAsId(int symbol, int head, int pos) {
        return true;
    }

    protected void predict(Matrix matrix) {
        long t1 = 0L;
        int y = matrix.lastY();
        Parser.EarleyCell cell = matrix.get(y, y);
        if (cell == null) {
            cell = new Parser.EarleyCell(this);
        }
        HashSet<Integer> symbols = new HashSet<Integer>();
        Map<Integer, Parser.EarleyCell> xRange = matrix.getXRange(y);
        for (int mid : xRange.keySet()) {
            Parser.EarleyCell candidateRules = matrix.get(mid, y);
            for (int j = 0; j < candidateRules.size(); ++j) {
                int pos = candidateRules.getPosition(j);
                int ruleNo = candidateRules.getRule(j);
                Parser.Tuple t2 = this.rules[ruleNo];
                if (t2.size() <= pos) continue;
                int symbol = t2.content(pos);
                symbols.add(symbol);
            }
        }
        for (int symbol : symbols) {
            PredictedTerminals terminal;
            if (matrix.LAsuspect != null && (terminal = this.terminalPredictions[symbol]) != null && !terminal.matches(matrix.LAsuspect)) continue;
            long[] ls2 = this.predicts.get(symbol);
            this.merge(cell, ls2, matrix);
        }
        if (cell.size() <= 0) {
            return;
        }
        matrix.put(y, y, cell);
    }

    protected void merge(Parser.EarleyCell cell, long[] ls2, Matrix m4) {
        cell.merge(ls2);
    }

    protected void complete(Matrix matrix, int srcLength) {
        long completionCandidate;
        HashMap<Integer, Integer> skipIntervals = new HashMap<Integer, Integer>();
        while ((completionCandidate = matrix.dequeue()) != -1L) {
            int symbol = Service.lY(completionCandidate);
            int mid = Service.lX(completionCandidate);
            int y = matrix.lastY();
            int indexX = Array.indexOf(matrix.allXs, mid);
            if (matrix.allXs.length - 1 < indexX) {
                indexX = matrix.allXs.length - 1;
            }
            if (mid < matrix.allXs[indexX]) {
                // empty if block
            }
            for (int i = --indexX; 0 <= i; --i) {
                Integer predecessor;
                int x = matrix.allXs[i];
                int skipTo = y;
                long t1 = 0L;
                Parser.EarleyCell pres = matrix.get(x, mid);
                if (pres == null) continue;
                long mask = (long)symbol << 48;
                int start = Array.indexOf(pres.getContent(), 0, pres.size() - 1, mask);
                int stop = Array.indexOf(pres.getContent(), 0, pres.size() - 1, mask | 0xFFFFFFFFFFFFL) + 1;
                Parser.EarleyCell content = matrix.get(x, y);
                for (int ii = start; ii < stop && ii < pres.size(); ++ii) {
                    int symPre;
                    int dotPre = pres.getPosition(ii);
                    int rulePre = pres.getRule(ii);
                    Parser.Tuple tPre = this.rules[rulePre];
                    if (tPre.size() == dotPre || (symPre = tPre.content(dotPre)) != symbol || y < srcLength && !this.lookaheadOK(tPre, dotPre + 1, matrix)) continue;
                    if (content == null) {
                        content = new Parser.EarleyCell(this);
                    }
                    long promotedRule = Earley.makeMatrixCellElem(rulePre, dotPre + 1, tPre);
                    int before = content.size();
                    content.insertContent(promotedRule);
                    int after = content.size();
                    if (before < after) {
                        matrix.put(x, y, content);
                        if (this.skipRanges && tPre.rhs.length == dotPre + 1 && mid < skipTo && this.isOptimizable(tPre, symPre, mid, y)) {
                            skipTo = mid;
                        }
                    }
                    if (tPre.size() != dotPre + 1 || before >= after) continue;
                    matrix.enqueue(Service.lPair(x, tPre.head));
                }
                if (!this.skipRanges || x >= skipTo || skipTo >= y || (predecessor = (Integer)skipIntervals.get(x + 1)) != null && skipTo >= predecessor) continue;
                skipIntervals.put(x + 1, skipTo);
            }
        }
        Iterator iterator = skipIntervals.keySet().iterator();
        while (iterator.hasNext()) {
            int y;
            int x = (Integer)iterator.next();
            if (x >= (y = ((Integer)skipIntervals.get(x)).intValue())) continue;
            matrix.allXs = Array.delete(matrix.allXs, x, y);
        }
    }

    protected boolean isOptimizable(Parser.Tuple tuple, int preSym, int mid, int y) {
        return this.isOptimizable(tuple.head, preSym, mid, y);
    }

    protected boolean isOptimizable(int headSym, int preSym, int mid, int y) {
        return this.allSymbols[headSym].charAt(0) != '\"' && this.allSymbols[preSym].charAt(0) != '\"';
    }

    protected boolean lookaheadOK(Parser.Tuple tPre, int pos, Matrix matrix) {
        return true;
    }

    public void toString(int ruleNo, int pos, StringBuffer sb) {
        Parser.Tuple rule = this.rules[ruleNo];
        sb.append(rule.toString(pos));
    }

    public void initCell(Matrix matrix, int[] heads, int pos) {
        Parser.EarleyCell cell = new Parser.EarleyCell(this);
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Parser.Tuple t2 = this.rules[i];
            for (int h2 : heads) {
                if (t2.head != h2 || !this.lookaheadOK(t2, 0, matrix)) continue;
                cell.insertContent(Earley.makeMatrixCellElem(i, 0, t2));
                continue block0;
            }
        }
        matrix.put(pos, pos, cell);
        matrix.allXs = Array.insert(matrix.allXs, pos);
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m4, Parser.EarleyCell cell, int x, int y) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            pos = cell.getPosition(i);
            if (this.rules[rule].rhs.length != pos) continue;
            return this.tree(src, m4, x, y, rule, pos);
        }
        if (rule != -1 && pos != -1) {
            return this.tree(src, m4, x, y, rule, pos);
        }
        return null;
    }

    protected ParseNode tree(List<LexerToken> src, Matrix m4, int x, int y, int rule, int pos) {
        Parser.EarleyCell pre;
        int h2 = this.rules[rule].head;
        if (pos != 0 && (pre = m4.get(x, y - 1)) != null) {
            long demotedRule = Earley.makeMatrixCellElem(rule, pos - 1, this.rules[rule]);
            int indexOfDemotedRule = Array.indexOf(pre.getContent(), 0, pre.size() - 1, demotedRule);
            long ruleAtTheIndex = pre.content[indexOfDemotedRule];
            if (ruleAtTheIndex == demotedRule) {
                Parser.Tuple t2 = this.rules[rule];
                LexerToken token = src.get(y - 1);
                Integer suspect = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? token.content : token.content.toUpperCase()) + "'");
                if (this.isScannedSymbol(y - 1, src, pos - 1, t2, suspect)) {
                    ParseNode branch = new ParseNode(y - 1, y, this.rules[rule].rhs[pos - 1], this);
                    if (x + 1 == y) {
                        if (this.rules[rule].rhs.length == 1) {
                            branch.addContent(h2);
                        }
                        return branch;
                    }
                    int head = h2;
                    if (pos != this.rules[rule].rhs.length) {
                        head = -1;
                    }
                    ParseNode ret = new ParseNode(x, y, head, head, this);
                    ret.lft = this.tree(src, m4, x, y - 1, rule, pos - 1);
                    ret.lft.parent = ret;
                    ret.rgt = branch;
                    ret.rgt.parent = ret;
                    return ret;
                }
            }
        }
        if (pos != 0) {
            long demotedRule = Earley.makeMatrixCellElem(rule, pos - 1, this.rules[rule]);
            TreeMap cellsAtY = (TreeMap)m4.getXRange(y);
            Iterator iterator = (this.isAsc(h2) ? cellsAtY.keySet() : cellsAtY.descendingKeySet()).iterator();
            while (iterator.hasNext()) {
                Parser.EarleyCell post;
                int mid = (Integer)iterator.next();
                Parser.EarleyCell pre2 = m4.get(x, mid);
                if (pre2 == null || (post = m4.get(mid, y)) == null || pre2.content[Array.indexOf(pre2.content, 0, pre2.size() - 1, demotedRule)] != demotedRule) continue;
                for (int j = 0; j <= post.size() - 1; ++j) {
                    int rJ = post.getRule(j);
                    int pJ = post.getPosition(j);
                    if (this.rules[rJ].rhs.length != pJ || this.rules[rJ].head != this.rules[rule].rhs[pos - 1]) continue;
                    if (x != mid) {
                        ParseNode ret = new ParseNode(x, y, this.rules[rule].rhs.length != pos ? -1 : h2, this);
                        ret.lft = this.tree(src, m4, x, mid, rule, pos - 1);
                        ret.lft.parent = ret;
                        ret.rgt = this.tree(src, m4, mid, y, rJ, pJ);
                        ret.rgt.parent = ret;
                        return ret;
                    }
                    if (rJ == rule && pJ == pos) continue;
                    this.diagnose(m4, x, y);
                    ParseNode ret = this.tree(src, m4, mid, y, rJ, pJ);
                    if (this.rules[rule].rhs.length == pos) {
                        ret.addContent(h2);
                    }
                    return ret;
                }
            }
        }
        throw new AssertionError((Object)("unwind " + this.rules[rule].toString(pos) + " @[" + x + "," + y + ")"));
    }

    protected void diagnose(Matrix m4, int x, int y) {
    }

    public class PredictedTerminals
    implements Serializable {
        private boolean isValid = true;
        int[] symbols = null;

        void add(int sym) {
            if (this.isValid) {
                this.symbols = Array.insert(this.symbols, sym);
            } else {
                this.invalidate();
            }
        }

        void invalidate() {
            this.symbols = null;
            this.isValid = false;
        }

        public boolean matches(Integer lookahead) {
            if (!this.isValid) {
                return true;
            }
            if (this.symbols == null) {
                return true;
            }
            return lookahead != null && this.symbols[Array.indexOf(this.symbols, lookahead)] == lookahead;
        }

        public String toString() {
            if (!this.isValid) {
                return "*invalid*";
            }
            if (this.symbols == null) {
                return "*symbols == null*";
            }
            StringBuilder ret = new StringBuilder("{");
            for (int s2 : this.symbols) {
                ret.append(Earley.this.allSymbols[s2]);
                ret.append(',');
            }
            return ret.toString();
        }
    }
}

