/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.jdbc.driver.parser.Cell;
import oracle.jdbc.driver.parser.LexerToken;
import oracle.jdbc.driver.parser.Matrix;
import oracle.jdbc.driver.parser.ParseNode;
import oracle.jdbc.driver.parser.RuleTuple;
import oracle.jdbc.driver.parser.SqlEarley;
import oracle.jdbc.driver.parser.util.Array;

public abstract class Parser
implements Serializable {
    public String[] allSymbols = new String[0];
    public Map<String, Integer> symbolIndexes = new HashMap<String, Integer>();
    public Tuple[] rules;

    public Parser(RuleTuple[] originalRules) {
        this.extractSymbols(originalRules);
        this.rules = new Tuple[originalRules.length];
        int p = 0;
        for (RuleTuple t2 : originalRules) {
            if (t2.rhs.length == 0) {
                throw new AssertionError((Object)("empty production " + t2.toString()));
            }
            int h2 = this.symbolIndexes.get(t2.head);
            int[] rhs = new int[t2.rhs.length];
            for (int i = 0; i < rhs.length; ++i) {
                rhs[i] = this.symbolIndexes.get(t2.rhs[i]);
            }
            this.rules[p++] = new Tuple(h2, rhs);
        }
    }

    public Parser() {
    }

    protected void extractSymbols(RuleTuple[] symbolicRules) {
        TreeSet<String> tmpSymbols = new TreeSet<String>();
        String nnil = "!nil";
        if (!this.symbolIndexes.containsKey(nnil)) {
            tmpSymbols.add(nnil);
        }
        for (RuleTuple ct : symbolicRules) {
            if (ct.head == null || ct.rhs.length == 0 || ct.rhs[0] == null || ct.rhs.length > 1 && ct.rhs[1] == null) {
                throw new AssertionError((Object)("grammar has null symbols (or empty productions): " + ct.toString()));
            }
            if (!this.symbolIndexes.containsKey(ct.head)) {
                tmpSymbols.add(ct.head);
            }
            for (String s2 : ct.rhs) {
                if (this.symbolIndexes.containsKey(s2)) continue;
                if (s2.length() < 2 && this instanceof SqlEarley) {
                    throw new AssertionError((Object)("ct=" + ct.toString()));
                }
                tmpSymbols.add(s2);
            }
        }
        int k = this.allSymbols.length;
        this.allSymbols = Arrays.copyOf(this.allSymbols, this.allSymbols.length + tmpSymbols.size());
        for (String s3 : tmpSymbols) {
            this.symbolIndexes.put(s3, k);
            this.allSymbols[k] = s3;
            ++k;
        }
    }

    public boolean isTerminal(int terminal) {
        return this.allSymbols[terminal].charAt(0) == '\'';
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix) {
        return this.forest(src, matrix, false);
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix, boolean full) {
        return this.forest(src, matrix, false, null);
    }

    protected boolean isAsc(int ruleHead) {
        return false;
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix, boolean full, String input) {
        HashMap explored = new HashMap();
        try {
            int len = src.size();
            if (len == 0) {
                return new ParseNode(0, len, -1, this);
            }
            EarleyCell cell = matrix.get(0, len);
            if (cell != null && 0 < cell.size()) {
                ParseNode root = this.treeForACell(src, matrix, cell, 0, len);
                if ((root = this.replaceLeaves(root, input, src)) != null) {
                    return root;
                }
            }
            ParseNode pseudoRoot = new ParseNode(0, len, -1, this);
            int X = 0;
            int Y = matrix.lastY();
            for (int offset = 0; offset < Y; ++offset) {
                for (int t2 = 0; t2 < offset + 1; ++t2) {
                    int x = X + t2;
                    int y = Y + t2 - offset;
                    ParseNode coverX = pseudoRoot.coveredByOnTopLevel(x);
                    ParseNode coverY = pseudoRoot.coveredByOnTopLevel(y);
                    while (coverX != null || coverY != null) {
                        int delta = 0;
                        if (coverX != null) {
                            delta = coverX.to - y + 1;
                        }
                        if (coverY != null) {
                            delta = coverY.to - y + 1;
                        }
                        if (delta <= 0) break;
                        x = X + (t2 += delta);
                        y = Y + t2 - offset;
                        coverX = pseudoRoot.coveredByOnTopLevel(x);
                        coverY = pseudoRoot.coveredByOnTopLevel(y);
                    }
                    if (offset + 1 <= t2 || (cell = matrix.get(x, y)) == null) continue;
                    explored = new HashMap();
                    ParseNode node = this.treeForACell(src, matrix, cell, x, y);
                    if (node == null) continue;
                    pseudoRoot.addTopLevel(node);
                    node.parent = pseudoRoot;
                    if (full) continue;
                    pseudoRoot = this.replaceLeaves(pseudoRoot, input, src);
                    return pseudoRoot;
                }
            }
            if (full) {
                pseudoRoot = this.replaceLeaves(pseudoRoot, input, src);
                return pseudoRoot;
            }
            return new ParseNode(0, 1, -1, this);
        }
        catch (AssertionError e) {
            System.err.println("Parser.forest(): AssertionError " + ((Throwable)((Object)e)).getMessage());
            return null;
        }
    }

    protected ParseNode replaceLeaves(ParseNode root, String input, List<LexerToken> src) {
        return root;
    }

    public abstract ParseNode parse(List<LexerToken> var1);

    ParseNode treeForACell(List<LexerToken> src, Matrix m4, EarleyCell cell, int x, int y) {
        throw new AssertionError((Object)"Abstract method");
    }

    void toHtml(int ruleNo, int pos, boolean selected, int x, int mid, int y, Matrix matrix, StringBuffer sb) {
        throw new AssertionError((Object)"Abstract method");
    }

    public int getSymbol(String string) {
        try {
            return this.symbolIndexes.get(string);
        }
        catch (NullPointerException e) {
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void swapRules(String rule2, String rule3) {
        Tuple t2 = null;
        int i2 = -1;
        Tuple t3 = null;
        int i3 = -1;
        for (int i = 0; i < this.rules.length; ++i) {
            Tuple t4 = this.rules[i];
            if (rule2.equals(t4.toString())) {
                t2 = t4;
                i2 = i;
            }
            if (!rule3.equals(t4.toString())) continue;
            t3 = t4;
            i3 = i;
        }
        if (i2 == -1 || i3 == -1) {
            return;
        }
        this.rules[i2] = t3;
        this.rules[i3] = t2;
    }

    public boolean isAuxNode(int symbol) {
        return false;
    }

    protected static long makeMatrixCellElem(int rule, int pos, Tuple t2) {
        long activeVar = 0L;
        if (pos < t2.rhs.length) {
            activeVar = t2.rhs[pos];
        }
        return (long)rule << 16 | (long)pos | activeVar << 48;
    }

    public static int ruleFromEarleyCell(long code) {
        return (int)((code & 0xFFFFFFFFFFFFL) >> 16);
    }

    public static int posFromEarleyCell(long code) {
        return (int)(code & 0xFFFFL);
    }

    public class EarleyCell
    implements Cell {
        long[] content = null;
        int size = 0;

        public EarleyCell(long[] content) {
            this.content = content;
            if (content != null) {
                this.size = content.length;
            }
        }

        public EarleyCell() {
        }

        @Override
        public int getRule(int index) {
            return Parser.ruleFromEarleyCell(this.content[index]);
        }

        @Override
        public int getPosition(int index) {
            return Parser.posFromEarleyCell(this.content[index]);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long[] getContent() {
            return this.content;
        }

        @Override
        public void insertContent(long value) {
            int i;
            if (this.content == null || this.size == 0) {
                this.content = new long[1];
                this.content[0] = value;
                this.size = 1;
                return;
            }
            int index = Array.indexOf(this.content, 0, this.size, value);
            if (index < this.size && this.content[index] == value) {
                return;
            }
            long[] ret = this.content;
            if (this.content.length == this.size) {
                ret = new long[2 * this.size];
                for (i = 0; i < index; ++i) {
                    ret[i] = this.content[i];
                }
            }
            for (i = this.size; index + 1 <= i; --i) {
                ret[i] = this.content[i - 1];
            }
            ret[index] = value;
            this.content = ret;
            ++this.size;
        }

        public void merge(long[] addendum) {
            if (addendum == null) {
                return;
            }
            if (this.content == null) {
                this.content = addendum;
                this.size = addendum.length;
                return;
            }
            int m4 = this.size;
            int n = addendum.length;
            long[] tmp = new long[m4 + n];
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < m4 && j < n) {
                if (this.content[i] == addendum[j]) {
                    tmp[k++] = this.content[i++];
                    ++j;
                    continue;
                }
                if (this.content[i] < addendum[j]) {
                    tmp[k++] = this.content[i++];
                    continue;
                }
                tmp[k++] = addendum[j++];
            }
            if (i < m4) {
                for (int p = i; p < m4; ++p) {
                    tmp[k++] = this.content[p];
                }
            } else {
                for (int p = j; p < n; ++p) {
                    tmp[k++] = addendum[p];
                }
            }
            this.content = tmp;
            this.size = k;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            for (int i = 0; i < this.size(); ++i) {
                if (0 < i) {
                    sb.append(" , ");
                }
                Tuple t2 = Parser.this.rules[this.getRule(i)];
                sb.append(t2.toString(this.getPosition(i)));
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public class Tuple
    implements Comparable<Tuple>,
    Serializable {
        public int head;
        public int[] rhs;

        public Tuple(int h2, int[] r) {
            this.head = h2;
            this.rhs = r;
        }

        public int size() {
            return this.rhs.length;
        }

        public int content(int i) {
            return this.rhs[i];
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Tuple && this.compareTo((Tuple)obj) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconsistent with equals");
        }

        @Override
        public int compareTo(Tuple src) {
            if (this.head == 0 || src.head == 0) {
                throw new RuntimeException("head==0 || src.head==0");
            }
            int cmp = this.head - src.head;
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.rhs.length - src.rhs.length;
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < this.rhs.length; ++i) {
                cmp = this.rhs[i] - src.rhs[i];
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder(Parser.this.allSymbols[this.head] + ":");
            for (int i : this.rhs) {
                s2.append("  " + Parser.this.allSymbols[i]);
            }
            s2.append(";");
            return s2.toString();
        }

        public String toString(int pos) {
            StringBuilder s2 = new StringBuilder(Parser.this.allSymbols[this.head] + ":");
            for (int i = 0; i < this.rhs.length; ++i) {
                s2.append(' ');
                if (pos == i) {
                    s2.append('!');
                }
                s2.append(Parser.this.allSymbols[this.rhs[i]]);
            }
            if (pos == this.rhs.length) {
                s2.append('!');
            }
            s2.append(";");
            return s2.toString();
        }
    }
}

