/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.OracleNClob;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableClob;

@ProxyFor(value={oracle.jdbc.internal.OracleNClob.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableNClob
extends TxnReplayableClob
implements JDBCReplayable {
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableNClob";

    @Override
    @Pre
    protected void preForAll(Method m4, Object receiver, Object ... args) {
        super.preForAll(m4, receiver, args);
    }

    @Override
    @Post
    protected void postForAll(Method m4) {
        this.postForAll(m4, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m4, Object result) {
        if (result instanceof TxnReplayableBase) {
            TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m4, result);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m4, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m4, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m4, SQLException error) throws SQLException {
        return super.onErrorForAll(m4, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleNClob delegate = (oracle.jdbc.internal.OracleNClob)this.getDelegate();
        return delegate.getInternalConnection();
    }

    @Override
    protected void replugWithoutCreator(OracleConnection newConn) throws SQLException {
        oracle.jdbc.internal.OracleNClob oldDelegate = (oracle.jdbc.internal.OracleNClob)this.getDelegate();
        OracleNClob newlob = new OracleNClob(newConn, oldDelegate.getBytes());
        this.setDelegate(newlob);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "replugWithoutCreator", "On NClob {0}, replugged delegate: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), newlob});
    }
}

