/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.XMLTypeIntf;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;

@ProxyFor(value={XMLTypeIntf.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableSqlxml
extends TxnReplayableBase
implements JDBCReplayable {
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableSqlxml";

    @Override
    @Pre
    protected void preForAll(Method m4, Object receiver, Object ... args) {
        super.preForAll(m4, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="setBinaryStream", args={}), @Signature(name="setCharacterStream", args={})})
    protected void preForXMLWrites(Method m4, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "preForXMLWrites", "On {0}, DISABLE REPLAY in preForXMLWrites({1})", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), m4.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m4, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForXMLWrites", "On SQLXML {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
        }
    }

    @Override
    @Post
    protected void postForAll(Method m4) {
        this.postForAll(m4, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m4, Object result) {
        if (result instanceof TxnReplayableBase) {
            TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m4, result);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m4, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m4, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m4, SQLException error) throws SQLException {
        return super.onErrorForAll(m4, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();
}

