/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

public class ClientProfile
extends Properties {
    private static final long serialVersionUID = -4472014940429606620L;
    private static final String profile_name = "ora-net-profile";
    private static final String shared_profile_name = "ora-shared-profile";
    private final boolean isANOEnabled;
    private boolean isWeakCryptoEnabled = false;
    private boolean isServerUsingWeakCrypto = false;
    private long anoVersion = 0L;

    public ClientProfile(@Blind(value=PropertiesBlinder.class) Properties up2) {
        String passwordAuthType;
        if (up2.containsKey("oracle.net.profile")) {
            this.put("oracle.net.profile", up2.getProperty("oracle.net.profile"));
        }
        this.isServerUsingWeakCrypto = this.isWeakCryptoEnabled = Boolean.valueOf(up2.getProperty("oracle.net.allow_weak_crypto", "true")).booleanValue();
        String authServices = up2.getProperty("oracle.net.authentication_services");
        String encryptionLevel = up2.getProperty("oracle.net.encryption_client");
        String checkSumLevel = up2.getProperty("oracle.net.crypto_checksum_client");
        this.isANOEnabled = encryptionLevel != null && !encryptionLevel.equalsIgnoreCase("REJECTED") || checkSumLevel != null && !checkSumLevel.equalsIgnoreCase("REJECTED") || authServices != null && !authServices.equals(OracleConnection.CONNECTION_PROPERTY_THIN_NET_AUTHENTICATION_SERVICES_DEFAULT);
        this.put("oracle.net.authentication_services", authServices == null ? "()" : authServices);
        this.put("oracle.net.encryption_client", encryptionLevel == null ? "ACCEPTED" : encryptionLevel);
        this.put("oracle.net.crypto_checksum_client", checkSumLevel == null ? "ACCEPTED" : checkSumLevel);
        this.put("oracle.net.encryption_types_client", up2.getProperty("oracle.net.encryption_types_client", "()"));
        this.put("oracle.net.crypto_checksum_types_client", up2.getProperty("oracle.net.crypto_checksum_types_client", "()"));
        this.setProperty("oracle.net.setFIPSMode", up2.getProperty("oracle.net.setFIPSMode", "false"));
        String jaasConfigModuleName = up2.getProperty("oracle.net.KerberosJaasLoginModule");
        if (jaasConfigModuleName != null) {
            this.setProperty("oracle.net.KerberosJaasLoginModule", jaasConfigModuleName);
        }
        this.put("oracle.net.crypto_seed", up2.getProperty("oracle.net.crypto_seed", ""));
        String tmp = up2.getProperty("oracle.net.KerberosRealm");
        if (tmp != null) {
            this.put("oracle.net.KerberosRealm", tmp);
        }
        this.put("oracle.net.kerberos5_mutual_authentication", up2.getProperty("oracle.net.kerberos5_mutual_authentication", "false"));
        if (up2.getProperty("oracle.net.kerberos5_cc_name") != null) {
            this.put("oracle.net.kerberos5_cc_name", up2.getProperty("oracle.net.kerberos5_cc_name"));
        }
        if ((passwordAuthType = up2.getProperty("oracle.jdbc.passwordAuthentication")) != null && passwordAuthType.equalsIgnoreCase("KERBEROS5")) {
            if (up2.containsKey("oracle.net.kerberos5_user")) {
                this.put("oracle.net.kerberos5_user", up2.getProperty("oracle.net.kerberos5_user"));
            }
            if (up2.containsKey("oracle.net.kerberos5_password")) {
                this.put("oracle.net.kerberos5_password", up2.get("oracle.net.kerberos5_password"));
            }
        }
        if (up2.containsKey("oracle.net.radius_challenge_response_handler")) {
            this.put("oracle.net.radius_challenge_response_handler", up2.get("oracle.net.radius_challenge_response_handler"));
        }
        if (up2.containsKey("oracle.net.radius_user")) {
            this.put("oracle.net.radius_user", up2.get("oracle.net.radius_user"));
        }
        if (up2.containsKey("oracle.net.radius_password")) {
            this.put("oracle.net.radius_password", up2.get("oracle.net.radius_password"));
        }
    }

    public boolean isANOEnabled() {
        return this.isANOEnabled;
    }

    public boolean useWeakCrypto() {
        return this.isWeakCryptoEnabled && this.isServerUsingWeakCrypto;
    }

    public boolean isWeakCryptoEnabled() {
        return this.isWeakCryptoEnabled;
    }

    public void setANOVersion(long anoVersion) {
        if (this.anoVersion != 0L) {
            return;
        }
        this.anoVersion = anoVersion;
        int majorVersion = (int)(anoVersion >> 24) & 0xFF;
        int releaseUpdateRevision = (int)(anoVersion >> 12) & 0xFF;
        this.isServerUsingWeakCrypto = majorVersion < 23 && releaseUpdateRevision < 1;
    }

    public boolean isServerUsingWeakCrypto() {
        return this.isServerUsingWeakCrypto;
    }

    public String[] getAuthenticationServices() {
        return this.getServices((String)this.get("oracle.net.authentication_services"));
    }

    public String[] getEncryptionServices() {
        return this.getServices((String)this.get("oracle.net.encryption_types_client"));
    }

    public String[] getDataIntegrityServices() {
        return this.getServices((String)this.get("oracle.net.crypto_checksum_types_client"));
    }

    public String getEncryptionLevel() {
        return (String)this.get("oracle.net.encryption_client");
    }

    public int getEncryptionLevelNum() {
        return this.translateAnoValue(this.getEncryptionLevel());
    }

    public String getDataIntegrityLevel() {
        return (String)this.get("oracle.net.crypto_checksum_client");
    }

    public int getDataIntegrityLevelNum() {
        return this.translateAnoValue(this.getDataIntegrityLevel());
    }

    public boolean isFIPSMode() {
        return Boolean.valueOf(this.getProperty("oracle.net.setFIPSMode", "false"));
    }

    public void print() {
        System.out.println(" ----------------------------------------");
        System.out.println(" Displaying the content of ClientProfile ");
        System.out.println(" List:");
        this.list(System.out);
        Enumeration<?> en = this.propertyNames();
        System.out.println("Enumeration has elements ? " + en.hasMoreElements());
        int i = 0;
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            System.out.println("Key " + i + " = " + key);
            System.out.println("Value = " + this.getProperty(key));
            ++i;
        }
        System.out.println(" ----------------------------------------");
    }

    private String[] getServices(String services) {
        String mainString = this.removeParenths(services);
        StringTokenizer st = new StringTokenizer(mainString, ",");
        int tokens = st.countTokens();
        String[] items = new String[tokens];
        for (int i = 0; i < tokens; ++i) {
            items[i] = st.nextToken().trim();
        }
        return items;
    }

    private String removeParenths(String str) {
        int beginParenth = str.indexOf(40);
        int beginOffset = beginParenth == -1 ? 0 : beginParenth + 1;
        int endParenth = str.lastIndexOf(41);
        int endOffset = endParenth == -1 ? str.length() : endParenth;
        String result = str.substring(beginOffset, endOffset);
        return result.trim();
    }

    private int translateAnoValue(String level) {
        int levelNum = 0;
        if (level != null) {
            levelNum = level.equalsIgnoreCase("ACCEPTED") ? 0 : (level.equalsIgnoreCase("REQUESTED") ? 2 : (level.equalsIgnoreCase("REQUIRED") ? 3 : (level.equalsIgnoreCase("REJECTED") ? 1 : -1)));
        }
        return levelNum;
    }
}

