/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.MetricsEnabledSSLSocketFactoryWrapper;
import oracle.security.jps.service.keystore.KeyStoreServiceLoadStoreParameter;

public class CustomSSLSocketFactory {
    private static final String CLASS_NAME;
    public static final String DEFAULT_SSO_WALLET_FILE_NAME = "cwallet.sso";
    public static final String DEFAULT_PKCS12_WALLET_FILE_NAME = "ewallet.p12";
    public static final String SSO_WALLET_TYPE = "SSO";
    public static final String PKCS12_WALLET_TYPE = "PKCS12";
    public static final String PKCS11_WALLET_TYPE = "PKCS11";
    public static final String WINDOWS_MY_WALLET_TYPE = "Windows-MY";
    public static final String JKS_TYPE = "JKS";
    public static final String KSS_TYPE = "KSS";
    public static final String SUPPORTED_METHOD_TYPE = "FILE";
    private static final String SSO_FILE_EXTENSION = ".sso";
    private static final String P12_FILE_EXTENSION = ".p12";
    private static final String PFX_FILE_EXTENSION = ".pfx";
    private static final String JKS_FILE_EXTENSION = ".jks";
    private static final String KSS_URI_SCHEME = "kss://";
    private static final String DATA_URI_SCHEME = "data:";
    private static final String BASE64_EXTENSION = ";base64,";
    private static final String ORACLE_PKI_PROVIDER_CLASS = "oracle.security.pki.OraclePKIProvider";
    private static final String KSS_PROVIDER_CLASS = "oracle.security.jps.internal.keystore.provider.FarmKeyStoreProvider";
    private static final String[] SUPPORTED_HASH_ALGORITHMS;
    public static SSLSocketFactory defSSLFactory;
    public static boolean initDefFactory;
    private static final Monitor DEF_FACTORY_INIT_MONITOR;
    private static SSLContext defSSLContext;
    private static boolean initDefSSLContext;
    private static final Monitor DEF_CONTEXT_INIT_MONITOR;
    private static final SSLConfig DEF_CONTEXT_CONFIG;
    DMSFactory.DMSNoun dmsParent = null;

    private CustomSSLSocketFactory() {
    }

    public static SSLSocketFactory getSSLSocketFactory(Properties sslSocketProperties, DMSFactory.DMSNoun dmsParent) throws IOException {
        SSLConfig config = CustomSSLSocketFactory.readSSLConfig(sslSocketProperties);
        if (config.keyStore != null && config.keyStore.equalsIgnoreCase("NONE") || config.trustStore != null && config.trustStore.equalsIgnoreCase("NONE")) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        SSLContext sslContext = CustomSSLSocketFactory.getSSLContext(config);
        if (sslContext == defSSLContext) {
            if (!initDefFactory) {
                try (Monitor.CloseableLock lock = DEF_FACTORY_INIT_MONITOR.acquireCloseableLock();){
                    if (!initDefFactory) {
                        defSSLFactory = sslContext.getSocketFactory();
                        initDefFactory = true;
                    }
                }
            }
            return defSSLFactory;
        }
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        if (dmsParent != null) {
            return new MetricsEnabledSSLSocketFactoryWrapper(socketFactory, dmsParent);
        }
        return socketFactory;
    }

    public static SSLEngine getSSLSocketEngine(String host, int port, @Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) throws IOException {
        SSLEngine result = CustomSSLSocketFactory.getSSLContext(sslSocketProperties).createSSLEngine(host, port);
        result.setUseClientMode(true);
        return result;
    }

    static SSLContext getSSLContext(@Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) throws IOException {
        SSLConfig config = CustomSSLSocketFactory.readSSLConfig(sslSocketProperties);
        if (config.keyStore != null && config.keyStore.equalsIgnoreCase("NONE") || config.trustStore != null && config.trustStore.equalsIgnoreCase("NONE")) {
            try {
                return SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException nae) {
                NetException netException = new NetException(17959);
                netException.initCause(nae);
                throw netException;
            }
        }
        return CustomSSLSocketFactory.getSSLContext(config);
    }

    private static SSLContext getSSLContext(SSLConfig config) throws IOException {
        if (config.equals(DEF_CONTEXT_CONFIG)) {
            if (!initDefSSLContext) {
                try (Monitor.CloseableLock lock = DEF_CONTEXT_INIT_MONITOR.acquireCloseableLock();){
                    if (!initDefSSLContext) {
                        defSSLContext = CustomSSLSocketFactory.createSSLContext(config);
                        initDefSSLContext = true;
                    }
                }
            }
            return defSSLContext;
        }
        return CustomSSLSocketFactory.createSSLContext(config);
    }

    private static SSLContext createSSLContext(SSLConfig config) throws NetException {
        try {
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            KeyStore keyStore = null;
            if (config.keyStore != null) {
                try {
                    keyStore = CustomSSLSocketFactory.loadKeyStore(config.keyStore, config.keyStoreType, config.keyStorePassword);
                    keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(keyStore, config.keyStorePassword, config.keyManagerFacAlgo);
                }
                catch (Exception exception) {
                    throw CustomSSLSocketFactory.keyStoreFailure(exception);
                }
            }
            if (!(keyManagerArray == null || config.certificateAlias.isEmpty() && config.certificateThumbprint.isEmpty())) {
                String choosenAlias = CustomSSLSocketFactory.chooseAlias(keyStore, config);
                if (choosenAlias == null) {
                    throw new NetException(17968);
                }
                keyManagerArray = CustomSSLSocketFactory.wrapWithAliasKeyManager(keyManagerArray, choosenAlias);
            }
            if (config.trustStore != null) {
                try {
                    KeyStore trustStore = config.isCaCertsTrusted ? CustomSSLSocketFactory.mergeCaCerts(CustomSSLSocketFactory.loadKeyStore(config.trustStore, config.trustStoreType, config.trustStorePassword)) : (keyStore != null && config.isKeyStoreTrustStore() ? keyStore : CustomSSLSocketFactory.loadKeyStore(config.trustStore, config.trustStoreType, config.trustStorePassword));
                    if (config.isWallet && !CustomSSLSocketFactory.containsTrustCertificate(trustStore)) {
                        trustManagerArray = null;
                        CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "createSSLContext", "No trusted certificates found in {0}. Falling back to the JVM's default trust store.", (String)null, null, (Object)config.trustStore);
                    } else {
                        trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(trustStore, config.trustManagerFacAlgo);
                    }
                }
                catch (Exception exception) {
                    throw CustomSSLSocketFactory.trustStoreFailure(exception);
                }
            }
            SSLContext l_context = SSLContext.getInstance(config.sslContextProtocol);
            l_context.init(keyManagerArray, trustManagerArray, null);
            return l_context;
        }
        catch (Exception ex) {
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "createSSLContext", "Error in initializing ssl context {0}", (String)null, null, (Object)ex.toString());
            if (ex instanceof NetException) {
                throw (NetException)ex;
            }
            throw (NetException)new NetException(17959).initCause(ex);
        }
    }

    private static boolean containsTrustCertificate(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            return true;
        }
        return false;
    }

    private static X509ExtendedKeyManager[] wrapWithAliasKeyManager(KeyManager[] keyManagers, String alias) {
        X509ExtendedKeyManager[] newKeyManagers = new X509ExtendedKeyManager[keyManagers.length];
        for (int i = 0; i < keyManagers.length; ++i) {
            newKeyManagers[i] = new AliasKeyManager((X509KeyManager)keyManagers[i], alias);
        }
        return newKeyManagers;
    }

    private static String chooseAlias(KeyStore keyStore, SSLConfig sslConfig) throws NetException {
        try {
            String alias = sslConfig.certificateAlias.trim();
            if (!alias.isEmpty() && keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                return alias;
            }
            return CustomSSLSocketFactory.chooseAliasUsingThumbprint(keyStore, sslConfig);
        }
        catch (Exception e) {
            throw (NetException)new NetException(17959).initCause(e);
        }
    }

    private static String chooseAliasUsingThumbprint(KeyStore keyStore, SSLConfig sslConfig) throws Exception {
        String[] thumbprintConfig = CustomSSLSocketFactory.parseThumbprint(sslConfig);
        char[] pwd2 = sslConfig.keyStorePassword == null ? null : sslConfig.keyStorePassword.getChars();
        String selectedAlias = null;
        KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(pwd2);
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            KeyStore.PrivateKeyEntry pke;
            String curAlias = aliases.nextElement();
            if (!keyStore.entryInstanceOf(curAlias, KeyStore.PrivateKeyEntry.class) || !CustomSSLSocketFactory.isThumbprintMatching((pke = (KeyStore.PrivateKeyEntry)keyStore.getEntry(curAlias, pp)).getCertificate(), thumbprintConfig[0], thumbprintConfig[1])) continue;
            selectedAlias = curAlias;
            break;
        }
        if (pwd2 != null) {
            Arrays.fill(pwd2, '0');
        }
        return selectedAlias;
    }

    private static String[] parseThumbprint(SSLConfig config) {
        String thumbprint = config.certificateThumbprint.trim();
        String hashAlgo = "SHA-1";
        if (thumbprint.toUpperCase().startsWith("SHA") && thumbprint.indexOf(58) != -1) {
            int indx = thumbprint.indexOf(58);
            hashAlgo = CustomSSLSocketFactory.getHashAlgorithm(thumbprint.substring(0, indx).trim());
            thumbprint = thumbprint.substring(indx + 1).trim();
        }
        thumbprint = thumbprint.replace(":", "");
        return new String[]{hashAlgo, thumbprint};
    }

    private static String getHashAlgorithm(String algoId) {
        if (algoId.equalsIgnoreCase("SHA1")) {
            return "SHA-1";
        }
        if (algoId.equalsIgnoreCase("SHA256")) {
            return "SHA-256";
        }
        return algoId;
    }

    private static boolean isThumbprintMatching(Certificate cert, String hashAlgo, String thumbprint) throws Exception {
        if (cert != null) {
            MessageDigest md = MessageDigest.getInstance(hashAlgo);
            md.update(cert.getEncoded());
            String certHash = CustomSSLSocketFactory.toHex(md.digest());
            if (thumbprint.equalsIgnoreCase(certHash)) {
                return true;
            }
        }
        return false;
    }

    private static String toHex(byte[] hash) {
        StringBuilder hexStrBuilder = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            hexStrBuilder.append(String.format("%02X", hash[i]));
        }
        return hexStrBuilder.toString();
    }

    private static SSLConfig readSSLConfig(@Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) throws NetException {
        String walletLocation = (String)sslSocketProperties.get(5);
        SSLConfig sslConfig = walletLocation == null ? CustomSSLSocketFactory.readJavaxNetSSLConfig(sslSocketProperties) : CustomSSLSocketFactory.readWalletSSLConfig(sslSocketProperties);
        sslConfig.certificateAlias = (String)sslSocketProperties.getOrDefault((Object)29, "");
        sslConfig.certificateThumbprint = (String)sslSocketProperties.getOrDefault((Object)44, "");
        sslConfig.sslContextProtocol = (String)sslSocketProperties.getOrDefault((Object)38, "TLS");
        sslConfig.isCaCertsTrusted = Boolean.valueOf((String)sslSocketProperties.get(41));
        return sslConfig;
    }

    private static SSLConfig readJavaxNetSSLConfig(@Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) {
        SSLConfig config = new SSLConfig();
        config.keyStore = (String)sslSocketProperties.get(8);
        if (config.keyStore != null) {
            config.keyStoreType = (String)sslSocketProperties.get(9);
            if (config.keyStoreType == null) {
                config.keyStoreType = CustomSSLSocketFactory.resolveKeyStoreType(config.keyStore);
            }
            config.keyStorePassword = (OpaqueString)sslSocketProperties.get(10);
            if (config.keyStorePassword == null) {
                config.keyStorePassword = OpaqueString.NULL;
            }
            config.keyManagerFacAlgo = (String)sslSocketProperties.get(14);
            if (config.keyManagerFacAlgo == null) {
                config.keyManagerFacAlgo = Security.getProperty("ssl.keyManagerFactory.algorithm");
            }
            if (config.keyManagerFacAlgo == null) {
                config.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            }
        }
        config.trustStore = (String)sslSocketProperties.get(11);
        if (config.trustStore != null) {
            config.trustStoreType = (String)sslSocketProperties.get(12);
            if (config.trustStoreType == null) {
                config.trustStoreType = CustomSSLSocketFactory.resolveKeyStoreType(config.trustStore);
            }
            config.trustStorePassword = (OpaqueString)sslSocketProperties.get(13);
            if (config.trustStorePassword == null) {
                config.trustStorePassword = OpaqueString.NULL;
            }
            config.trustManagerFacAlgo = (String)sslSocketProperties.get(15);
            if (config.trustManagerFacAlgo == null) {
                config.trustManagerFacAlgo = Security.getProperty("ssl.trustManagerFactory.algorithm");
            }
            if (config.trustManagerFacAlgo == null) {
                config.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
            }
        }
        return config;
    }

    private static SSLConfig readWalletSSLConfig(@Blind(value=PropertiesBlinder.class) Properties sslSocketProperties) throws NetException {
        boolean isPkcs12;
        String walletDirectory;
        SSLConfig config = new SSLConfig();
        config.isWallet = true;
        boolean appendFileNameToWalletLocation = true;
        String walletLocation = (String)sslSocketProperties.get(5);
        if (walletLocation.equalsIgnoreCase("SYSTEM")) {
            config.keyStore = "NONE";
            config.trustStore = "NONE";
            return config;
        }
        if (walletLocation.startsWith("(")) {
            walletDirectory = CustomSSLSocketFactory.processWalletLocation(walletLocation);
        } else if (CustomSSLSocketFactory.isDataUri(walletLocation)) {
            walletDirectory = walletLocation;
            appendFileNameToWalletLocation = false;
        } else {
            walletDirectory = walletLocation.startsWith("file:") ? walletLocation.substring("file:".length()) : walletLocation;
            File walletFile = new File(walletDirectory);
            if (!walletFile.exists()) {
                throw new NetException(17956, "Couldn't find file at " + walletDirectory);
            }
            if (!walletFile.isDirectory()) {
                appendFileNameToWalletLocation = false;
            }
        }
        OpaqueString walletPassword = (OpaqueString)sslSocketProperties.get(16);
        boolean bl = isPkcs12 = !OpaqueString.isNull(walletPassword);
        config.keyStore = appendFileNameToWalletLocation ? walletDirectory + System.getProperty("file.separator") + (isPkcs12 ? DEFAULT_PKCS12_WALLET_FILE_NAME : DEFAULT_SSO_WALLET_FILE_NAME) : walletDirectory;
        config.keyStoreType = isPkcs12 ? PKCS12_WALLET_TYPE : SSO_WALLET_TYPE;
        config.keyStorePassword = isPkcs12 ? walletPassword : OpaqueString.EMPTY;
        config.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
        config.trustStore = config.keyStore;
        config.trustStoreType = config.keyStoreType;
        config.trustStorePassword = config.keyStorePassword;
        config.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyManager[] getKeyManagerArray(KeyStore keyStore, OpaqueString keyStorePassword, String keyManagerFacAlgo) throws GeneralSecurityException {
        CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getKeyManagerArray", "KeyManagerFactory Algorithm {0}", (String)null, null, (Object)keyManagerFacAlgo);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFacAlgo);
        char[] pw = keyStorePassword.getChars();
        try {
            keyManagerFactory.init(keyStore, pw);
            if (pw == null) return keyManagerFactory.getKeyManagers();
        }
        catch (Throwable throwable) {
            if (pw == null) throw throwable;
            for (int i = 0; i < pw.length; ++i) {
                pw[i] = '\u0000';
            }
            throw throwable;
        }
        for (int i = 0; i < pw.length; ++i) {
            pw[i] = '\u0000';
        }
        return keyManagerFactory.getKeyManagers();
    }

    private static NetException keyStoreFailure(Exception ex) {
        CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "keyStoreFailure", "Error in initializing keystore {0}", (String)null, null, (Object)ex);
        if (ex instanceof NetException) {
            return (NetException)ex;
        }
        return (NetException)new NetException(17957).initCause(ex);
    }

    public static TrustManager[] getTrustManagerArray(KeyStore trustStore, String trustManagerFacAlgo) throws GeneralSecurityException {
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getTrustManagerArray", "TrustManagerFactory Algorithm {0}", (String)null, null, (Object)trustManagerFacAlgo);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerFacAlgo);
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    private static NetException trustStoreFailure(Exception ex) {
        CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "trustStoreFailure", "Error in initializing truststore {0}", (String)null, null, (Object)ex);
        return (NetException)new NetException(17958).initCause(ex);
    }

    private static KeyStore mergeCaCerts(KeyStore trustStore) throws IOException, GeneralSecurityException {
        TrustManagerFactory caCertsTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        try {
            caCertsTrustManagerFactory.init((KeyStore)null);
        }
        catch (NullPointerException | KeyStoreException exception) {
            caCertsTrustManagerFactory.init(CustomSSLSocketFactory.loadCaCerts());
        }
        for (TrustManager trustManager : caCertsTrustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            for (X509Certificate certificate : ((X509TrustManager)trustManager).getAcceptedIssuers()) {
                String alias = certificate.getIssuerX500Principal().getName();
                if (trustStore.containsAlias(alias)) continue;
                trustStore.setCertificateEntry(alias, certificate);
            }
        }
        return trustStore;
    }

    private static KeyStore loadCaCerts() throws IOException, GeneralSecurityException {
        try {
            return CustomSSLSocketFactory.loadCaCerts(PKCS12_WALLET_TYPE, "SUN");
        }
        catch (IOException | GeneralSecurityException exception0) {
            try {
                return CustomSSLSocketFactory.loadCaCerts(JKS_TYPE, "SUN");
            }
            catch (IOException | GeneralSecurityException exception1) {
                exception1.addSuppressed(exception0);
                throw exception1;
            }
        }
    }

    private static KeyStore loadCaCerts(String type, String provider) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = Files.newInputStream(Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts"), new OpenOption[0]);){
            KeyStore cacerts = KeyStore.getInstance(type, provider);
            cacerts.load(inputStream, null);
            KeyStore keyStore = cacerts;
            return keyStore;
        }
    }

    public static String processWalletLocation(String walletLocation) throws NetException {
        String method = null;
        try {
            NVNavigator nav = new NVNavigator();
            NVPair nvpWallet = new NVFactory().createNVPair(walletLocation);
            NVPair nvpMethod = nav.findNVPair(nvpWallet, "METHOD");
            NVPair nvpMethodData = nav.findNVPair(nvpWallet, "METHOD_DATA");
            NVPair nvpDirectory = nav.findNVPair(nvpMethodData, "DIRECTORY");
            method = nvpMethod.getAtom();
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processWalletLocation", "Wallet Parameter Configuration : Method {0}, Directory {1}", (String)null, null, (Object)method, (Object)nvpDirectory.getAtom());
            if (method.equalsIgnoreCase(SUPPORTED_METHOD_TYPE)) {
                String directoryLoc = nvpDirectory.getAtom();
                return directoryLoc;
            }
            throw new NetException(17961, method);
        }
        catch (Exception ex) {
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "processWalletLocation", "Error in parsing wallet location {0}", (String)null, null, (Object)ex);
            throw (NetException)new NetException(17956).initCause(ex);
        }
    }

    private static KeyStore getKeyStoreInstance(String type) throws KeyStoreException {
        try {
            return KeyStore.getInstance(type);
        }
        catch (KeyStoreException err) {
            try {
                Provider provider = CustomSSLSocketFactory.loadKnownProvider(type);
                if (provider == null) {
                    throw err;
                }
                return KeyStore.getInstance(type, provider);
            }
            catch (Exception loadProviderError) {
                CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getKeyStoreInstance", "Failed to load a known provider for keystore type {0}, exception {1}", (String)null, null, (Object)type, (Object)loadProviderError);
                throw err;
            }
        }
    }

    private static Provider loadKnownProvider(String type) throws Exception {
        Class<?> clazz;
        String providerClass;
        Provider providerObject = null;
        switch (type.toUpperCase()) {
            case "SSO": {
                providerClass = ORACLE_PKI_PROVIDER_CLASS;
                break;
            }
            case "KSS": {
                providerClass = KSS_PROVIDER_CLASS;
                break;
            }
            default: {
                providerClass = null;
            }
        }
        if (providerClass != null && (clazz = Class.forName(providerClass)) != null && Provider.class.isAssignableFrom(clazz)) {
            providerObject = AccessController.doPrivileged(() -> (Provider)clazz.newInstance());
        }
        return providerObject;
    }

    private static String resolveKeyStoreType(String keyStorePath) {
        if (keyStorePath == null || keyStorePath.length() == 0) {
            return KeyStore.getDefaultType();
        }
        String lowerCasePath = keyStorePath.toLowerCase();
        if (CustomSSLSocketFactory.isDataUri(lowerCasePath) || lowerCasePath.endsWith(SSO_FILE_EXTENSION)) {
            return SSO_WALLET_TYPE;
        }
        if (lowerCasePath.endsWith(P12_FILE_EXTENSION) || lowerCasePath.endsWith(PFX_FILE_EXTENSION)) {
            return PKCS12_WALLET_TYPE;
        }
        if (lowerCasePath.endsWith(JKS_FILE_EXTENSION)) {
            return JKS_TYPE;
        }
        if (lowerCasePath.startsWith(KSS_URI_SCHEME)) {
            return KSS_TYPE;
        }
        return KeyStore.getDefaultType();
    }

    private static KeyStore loadKeyStore(String path, String type, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "loadKeyStore", "Keystore is {0}, KeystoreType is {1}", (String)null, null, (Object)path, (Object)type);
        KeyStore instKeyStore = CustomSSLSocketFactory.getKeyStoreInstance(type);
        if (KSS_TYPE.equals(type)) {
            CustomSSLSocketFactory.loadKSSKeyStore(instKeyStore, path, password);
        } else if (CustomSSLSocketFactory.isDataUri(path)) {
            CustomSSLSocketFactory.loadDataUriKeyStore(instKeyStore, path, password);
        } else {
            CustomSSLSocketFactory.loadFileBasedKeyStore(instKeyStore, path, password);
        }
        return instKeyStore;
    }

    private static void loadDataUriKeyStore(KeyStore keyStore, String path, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
        int index = path.indexOf(BASE64_EXTENSION);
        if (index == -1) {
            throw new NetException(17829, null, false, new Object[0]);
        }
        String base64 = path.substring(index + BASE64_EXTENSION.length());
        byte[] keyStoreArray = Base64.getDecoder().decode(base64);
        ByteArrayInputStream keyStoreStream = new ByteArrayInputStream(keyStoreArray);
        CustomSSLSocketFactory.loadKeyStore(keyStore, keyStoreStream, password);
    }

    private static void loadFileBasedKeyStore(KeyStore keyStore, String path, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream fileStream = Channels.newInputStream(FileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ));){
            CustomSSLSocketFactory.loadKeyStore(keyStore, fileStream, password);
        }
    }

    private static void loadKSSKeyStore(KeyStore keyStore, String uri, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
        final class KSSLoader {
            KSSLoader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void load(KeyStore ks, String uri, OpaqueString password) throws IOException, NoSuchAlgorithmException, CertificateException {
                KeyStoreServiceLoadStoreParameter param = new KeyStoreServiceLoadStoreParameter();
                if (!OpaqueString.isNull(password)) {
                    char[] pw = password.getChars();
                    try {
                        param.setProtectionParameter((KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(pw));
                    }
                    catch (Throwable throwable) {
                        for (int i = 0; i < pw.length; ++i) {
                            pw[i] = '\u0000';
                        }
                        throw throwable;
                    }
                    for (int i = 0; i < pw.length; ++i) {
                        pw[i] = '\u0000';
                    }
                }
                param.setKssUri(uri);
                ks.load((KeyStore.LoadStoreParameter)param);
            }
        }
        new KSSLoader().load(keyStore, uri, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadKeyStore(KeyStore keyStore, InputStream inputStream, OpaqueString password) throws NoSuchAlgorithmException, CertificateException, IOException {
        char[] pw = password.getChars();
        try {
            keyStore.load(inputStream, pw);
            if (pw == null) return;
        }
        catch (Throwable throwable) {
            if (pw == null) throw throwable;
            for (int i = 0; i < pw.length; ++i) {
                pw[i] = '\u0000';
            }
            throw throwable;
        }
        for (int i = 0; i < pw.length; ++i) {
            pw[i] = '\u0000';
        }
        return;
    }

    private static boolean isDataUri(String path) {
        return path != null && path.startsWith(DATA_URI_SCHEME);
    }

    static {
        SSLConfig systemConfig;
        CLASS_NAME = CustomSSLSocketFactory.class.getName();
        SUPPORTED_HASH_ALGORITHMS = new String[]{"SHA-1", "SHA-256", "MD5"};
        DEF_FACTORY_INIT_MONITOR = Monitor.newInstance();
        DEF_CONTEXT_INIT_MONITOR = Monitor.newInstance();
        try {
            Properties socketOptions = new Properties();
            ConnStrategy.createSocketOptions(System.getProperties(), socketOptions);
            systemConfig = CustomSSLSocketFactory.readSSLConfig(socketOptions);
        }
        catch (NetException netException) {
            systemConfig = new SSLConfig();
        }
        DEF_CONTEXT_CONFIG = systemConfig;
    }

    static class AliasKeyManager
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509KeyManager keyManager;

        AliasKeyManager(X509KeyManager keyManager, String alias) {
            this.keyManager = keyManager;
            this.alias = alias;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.chooseEngineClientAlias(keyType, issuers, null);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.chooseEngineServerAlias(keyType, issuers, null);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.alias;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return this.alias;
        }
    }

    private static final class SSLConfig {
        String keyStore;
        String keyStoreType;
        OpaqueString keyStorePassword;
        String certificateAlias;
        String certificateThumbprint;
        String keyManagerFacAlgo;
        String trustStore;
        String trustStoreType;
        OpaqueString trustStorePassword;
        String trustManagerFacAlgo;
        String sslContextProtocol;
        boolean isCaCertsTrusted;
        boolean isWallet;

        private SSLConfig() {
        }

        public boolean equals(Object other) {
            if (!(other instanceof SSLConfig)) {
                return false;
            }
            SSLConfig otherSSLConfig = (SSLConfig)other;
            return Objects.equals(this.keyStore, otherSSLConfig.keyStore) && Objects.equals(this.keyStoreType, otherSSLConfig.keyStoreType) && Objects.equals(this.keyStorePassword, otherSSLConfig.keyStorePassword) && Objects.equals(this.certificateAlias, otherSSLConfig.certificateAlias) && Objects.equals(this.keyManagerFacAlgo, otherSSLConfig.keyManagerFacAlgo) && Objects.equals(this.trustStore, otherSSLConfig.trustStore) && Objects.equals(this.trustStoreType, otherSSLConfig.trustStoreType) && Objects.equals(this.trustStorePassword, otherSSLConfig.trustStorePassword) && Objects.equals(this.trustManagerFacAlgo, otherSSLConfig.trustManagerFacAlgo) && Objects.equals(this.sslContextProtocol, otherSSLConfig.sslContextProtocol) && Objects.equals(this.isCaCertsTrusted, otherSSLConfig.isCaCertsTrusted) && Objects.equals(this.isWallet, otherSSLConfig.isWallet);
        }

        boolean isKeyStoreTrustStore() {
            return Objects.equals(this.keyStore, this.trustStore) && Objects.equals(this.keyStoreType, this.trustStoreType) && Objects.equals(this.keyStorePassword, this.trustStorePassword);
        }
    }
}

