/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleSQLOutput
implements SQLOutput,
Diagnosable {
    private StructDescriptor descriptor;
    private Object[] attributes;
    private int index;
    private oracle.jdbc.OracleConnection conn;
    private static final String CLASS_NAME = OracleSQLOutput.class.getName();

    public OracleSQLOutput(StructDescriptor descriptor, oracle.jdbc.OracleConnection conn) throws SQLException {
        this.descriptor = descriptor;
        this.attributes = new Object[descriptor.getLength()];
        this.conn = conn;
        this.index = 0;
    }

    public STRUCT getSTRUCT() throws SQLException {
        return new STRUCT(this.descriptor, (Connection)this.conn, this.attributes);
    }

    @Override
    public void writeString(String x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.attributes[this.index++] = (int)x;
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.attributes[this.index++] = (int)x;
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeLong(long x) throws SQLException {
        this.attributes[this.index++] = new Long(x);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.attributes[this.index++] = new Float(x);
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.attributes[this.index++] = new Double(x);
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        StringBuffer stringBuf = new StringBuffer();
        char[] charBuf = new char[100];
        int count = 0;
        try {
            while ((count = x.read(charBuf)) != -1) {
                stringBuf.append(charBuf, 0, count);
            }
        }
        catch (IOException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
        String s2 = stringBuf.substring(0, stringBuf.length());
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "writeCharacterStream", "Here is what will be written: {0}", (String)null, (Throwable)null, this.secure(s2));
        this.attributes[this.index++] = s2;
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        StringBuffer stringBuf = new StringBuffer();
        byte[] binaryBuf = new byte[100];
        char[] charBuf = new char[100];
        int count = 0;
        try {
            while ((count = x.read(binaryBuf)) != -1) {
                for (int i = 0; i < count; ++i) {
                    charBuf[i] = (char)binaryBuf[i];
                }
                stringBuf.append(charBuf, 0, count);
            }
        }
        catch (IOException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
        String s2 = stringBuf.substring(0, stringBuf.length());
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "writeAsciiStream", "Here is what will be written: {0}", (String)null, (Throwable)null, this.secure(s2));
        this.attributes[this.index++] = s2;
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        this.writeAsciiStream(x);
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        STRUCT s2 = null;
        if (x != null) {
            StructDescriptor desc = StructDescriptor.createDescriptor(x.getSQLTypeName(), (Connection)this.conn);
            SQLOutput sqlOutput = desc.toJdbc2SQLOutput();
            x.writeSQL(sqlOutput);
            s2 = ((OracleSQLOutput)sqlOutput).getSTRUCT();
        }
        this.writeStruct(s2);
    }

    public void writeObject(Object x) throws SQLException {
        if (x != null && x instanceof SQLData) {
            this.writeObject((SQLData)x);
        } else {
            this.attributes[this.index++] = x;
        }
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeOracleObject(Datum x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeRef(REF x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeBlob(BLOB x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeBfile(BFILE x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeClob(CLOB x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeStruct(STRUCT x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeArray(ARRAY x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeNUMBER(NUMBER x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeCHAR(CHAR x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeDATE(DATE x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeRAW(RAW x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    public void writeROWID(ROWID x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void writeNClob(NClob value) throws SQLException {
        this.writeClob(value);
    }

    @Override
    public void writeNString(String value) throws SQLException {
        this.writeString(value);
    }

    @Override
    public void writeSQLXML(SQLXML value) throws SQLException {
        this.writeObject(value);
    }

    @Override
    public void writeRowId(RowId value) throws SQLException {
        this.writeROWID((ROWID)value);
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

