/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class ProduceResponse
extends AbstractResponse {
    public static final long INVALID_OFFSET = -1L;
    private final ProduceResponseData data;

    public ProduceResponse(ProduceResponseData produceResponseData) {
        super(ApiKeys.PRODUCE);
        this.data = produceResponseData;
    }

    @Deprecated
    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses) {
        this(responses, 0, Collections.emptyList());
    }

    @Deprecated
    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses, int throttleTimeMs) {
        this(ProduceResponse.toData(responses, throttleTimeMs, Collections.emptyList()));
    }

    @Deprecated
    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses, int throttleTimeMs, List<Node> nodeEndpoints) {
        this(ProduceResponse.toData(responses, throttleTimeMs, nodeEndpoints));
    }

    private static ProduceResponseData toData(Map<TopicPartition, PartitionResponse> responses, int throttleTimeMs, List<Node> nodeEndpoints) {
        ProduceResponseData data = new ProduceResponseData().setThrottleTimeMs(throttleTimeMs);
        responses.forEach((tp, response) -> {
            ProduceResponseData.TopicProduceResponse tpr = data.responses().find(tp.topic());
            if (tpr == null) {
                tpr = new ProduceResponseData.TopicProduceResponse().setName(tp.topic());
                data.responses().add(tpr);
            }
            tpr.partitionResponses().add(new ProduceResponseData.PartitionProduceResponse().setIndex(tp.partition()).setBaseOffset(response.baseOffset).setLogStartOffset(response.logStartOffset).setLogAppendTimeMs(response.logAppendTime).setErrorMessage(response.errorMessage).setErrorCode(response.error.code()).setCurrentLeader(response.currentLeader != null ? response.currentLeader : new ProduceResponseData.LeaderIdAndEpoch()).setRecordErrors(response.recordErrors.stream().map(e -> new ProduceResponseData.BatchIndexAndErrorMessage().setBatchIndex(e.batchIndex).setBatchIndexErrorMessage(e.message)).collect(Collectors.toList())));
        });
        nodeEndpoints.forEach(endpoint -> data.nodeEndpoints().add(new ProduceResponseData.NodeEndpoint().setNodeId(endpoint.id()).setHost(endpoint.host()).setPort(endpoint.port()).setRack(endpoint.rack())));
        return data;
    }

    @Override
    public ProduceResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.data.responses().forEach(t2 -> t2.partitionResponses().forEach(p -> this.updateErrorCounts(errorCounts, Errors.forCode(p.errorCode()))));
        return errorCounts;
    }

    public static ProduceResponse parse(ByteBuffer buffer, short version) {
        return new ProduceResponse(new ProduceResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 6;
    }

    public static final class RecordError {
        public final int batchIndex;
        public final String message;

        public RecordError(int batchIndex, String message) {
            this.batchIndex = batchIndex;
            this.message = message;
        }

        public RecordError(int batchIndex) {
            this.batchIndex = batchIndex;
            this.message = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordError that = (RecordError)o;
            return this.batchIndex == that.batchIndex && Objects.equals(this.message, that.message);
        }

        public int hashCode() {
            return Objects.hash(this.batchIndex, this.message);
        }

        public String toString() {
            return "RecordError(batchIndex=" + this.batchIndex + ", message=" + (this.message == null ? "null" : "'" + this.message + "'") + ")";
        }
    }

    public static final class PartitionResponse {
        public Errors error;
        public long baseOffset;
        public long lastOffset;
        public long logAppendTime;
        public long logStartOffset;
        public List<RecordError> recordErrors;
        public String errorMessage;
        public ProduceResponseData.LeaderIdAndEpoch currentLeader;

        public PartitionResponse(Errors error) {
            this(error, -1L, -1L, -1L);
        }

        public PartitionResponse(Errors error, String errorMessage) {
            this(error, -1L, -1L, -1L, Collections.emptyList(), errorMessage);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset) {
            this(error, baseOffset, logAppendTime, logStartOffset, Collections.emptyList(), null);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset, List<RecordError> recordErrors) {
            this(error, baseOffset, logAppendTime, logStartOffset, recordErrors, null);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset, List<RecordError> recordErrors, String errorMessage) {
            this(error, baseOffset, -1L, logAppendTime, logStartOffset, recordErrors, errorMessage, new ProduceResponseData.LeaderIdAndEpoch());
        }

        public PartitionResponse(Errors error, long baseOffset, long lastOffset, long logAppendTime, long logStartOffset, List<RecordError> recordErrors, String errorMessage) {
            this(error, baseOffset, lastOffset, logAppendTime, logStartOffset, recordErrors, errorMessage, new ProduceResponseData.LeaderIdAndEpoch());
        }

        public PartitionResponse(Errors error, long baseOffset, long lastOffset, long logAppendTime, long logStartOffset, List<RecordError> recordErrors, String errorMessage, ProduceResponseData.LeaderIdAndEpoch currentLeader) {
            this.error = error;
            this.baseOffset = baseOffset;
            this.lastOffset = lastOffset;
            this.logAppendTime = logAppendTime;
            this.logStartOffset = logStartOffset;
            this.recordErrors = recordErrors;
            this.errorMessage = errorMessage;
            this.currentLeader = currentLeader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionResponse that = (PartitionResponse)o;
            return this.baseOffset == that.baseOffset && this.lastOffset == that.lastOffset && this.logAppendTime == that.logAppendTime && this.logStartOffset == that.logStartOffset && this.error == that.error && Objects.equals(this.recordErrors, that.recordErrors) && Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.currentLeader, that.currentLeader);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.error, this.baseOffset, this.lastOffset, this.logAppendTime, this.logStartOffset, this.recordErrors, this.errorMessage, this.currentLeader});
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('{');
            b.append("error: ");
            b.append((Object)this.error);
            b.append(",offset: ");
            b.append(this.baseOffset);
            b.append(",lastOffset: ");
            b.append(this.lastOffset);
            b.append(",logAppendTime: ");
            b.append(this.logAppendTime);
            b.append(", logStartOffset: ");
            b.append(this.logStartOffset);
            b.append(", recordErrors: ");
            b.append(this.recordErrors);
            b.append(", currentLeader: ");
            b.append(this.currentLeader);
            b.append(", errorMessage: ");
            if (this.errorMessage != null) {
                b.append(this.errorMessage);
            } else {
                b.append("null");
            }
            b.append('}');
            return b.toString();
        }
    }
}

