/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.telemetry.internals.MetricKey;
import org.apache.kafka.common.telemetry.internals.MetricNamingStrategy;

public class TelemetryMetricNamingConvention {
    private static final String NAME_JOINER = ".";
    private static final String TAG_JOINER = "_";
    private static final Pattern GROUP_PATTERN = Pattern.compile("\\.(metrics)");

    public static MetricNamingStrategy<MetricName> getClientTelemetryMetricNamingStrategy(final String prefix) {
        Objects.requireNonNull(prefix, "prefix cannot be null");
        return new MetricNamingStrategy<MetricName>(){

            @Override
            public MetricKey metricKey(MetricName metricName) {
                Objects.requireNonNull(metricName, "metric name cannot be null");
                return new MetricKey(TelemetryMetricNamingConvention.fullMetricName(prefix, metricName.group(), metricName.name()), Collections.unmodifiableMap(TelemetryMetricNamingConvention.cleanTags(metricName.tags())));
            }

            @Override
            public MetricKey derivedMetricKey(MetricKey key, String derivedComponent) {
                Objects.requireNonNull(derivedComponent, "derived component cannot be null");
                return new MetricKey(key.name() + TelemetryMetricNamingConvention.NAME_JOINER + derivedComponent, key.tags());
            }
        };
    }

    private static String fullMetricName(String prefix, String group, String name) {
        return prefix + NAME_JOINER + TelemetryMetricNamingConvention.cleanGroup(group) + NAME_JOINER + TelemetryMetricNamingConvention.cleanMetric(name);
    }

    private static String cleanGroup(String group) {
        group = TelemetryMetricNamingConvention.clean(group, NAME_JOINER);
        return GROUP_PATTERN.matcher(group).replaceAll("");
    }

    private static String cleanMetric(String metric) {
        return TelemetryMetricNamingConvention.clean(metric, NAME_JOINER);
    }

    private static Map<String, String> cleanTags(Map<String, String> raw) {
        return raw.entrySet().stream().collect(Collectors.toMap(s2 -> TelemetryMetricNamingConvention.clean((String)s2.getKey(), TAG_JOINER), Map.Entry::getValue));
    }

    private static String clean(String raw, String joiner) {
        Objects.requireNonNull(raw, "metric data cannot be null");
        String lowerCase = raw.toLowerCase(Locale.ROOT);
        return lowerCase.replaceAll("-", joiner);
    }
}

