/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.errors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.errors.ErrorReporter;
import org.apache.kafka.connect.runtime.errors.Stage;
import org.apache.kafka.connect.runtime.errors.WorkerErrantRecordReporter;
import org.apache.kafka.connect.source.SourceRecord;

class ProcessingContext
implements AutoCloseable {
    private Collection<ErrorReporter> reporters = Collections.emptyList();
    private ConsumerRecord<byte[], byte[]> consumedMessage;
    private SourceRecord sourceRecord;
    private Stage position;
    private Class<?> klass;
    private int attempt;
    private Throwable error;

    ProcessingContext() {
    }

    private void reset() {
        this.attempt = 0;
        this.position = null;
        this.klass = null;
        this.error = null;
    }

    public void consumerRecord(ConsumerRecord<byte[], byte[]> consumedMessage) {
        this.consumedMessage = consumedMessage;
        this.reset();
    }

    public ConsumerRecord<byte[], byte[]> consumerRecord() {
        return this.consumedMessage;
    }

    public SourceRecord sourceRecord() {
        return this.sourceRecord;
    }

    public void sourceRecord(SourceRecord record) {
        this.sourceRecord = record;
        this.reset();
    }

    public void position(Stage position) {
        this.position = position;
    }

    public Stage stage() {
        return this.position;
    }

    public Class<?> executingClass() {
        return this.klass;
    }

    public void executingClass(Class<?> klass) {
        this.klass = klass;
    }

    public void currentContext(Stage stage, Class<?> klass) {
        this.position(stage);
        this.executingClass(klass);
    }

    public Future<Void> report() {
        if (this.reporters.size() == 1) {
            return new WorkerErrantRecordReporter.ErrantRecordFuture(Collections.singletonList(this.reporters.iterator().next().report(this)));
        }
        List<Future<RecordMetadata>> futures = this.reporters.stream().map(r -> r.report(this)).filter(f -> !f.isDone()).collect(Collectors.toList());
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return new WorkerErrantRecordReporter.ErrantRecordFuture(futures);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeMessage) {
        StringBuilder builder = new StringBuilder();
        builder.append("Executing stage '");
        builder.append(this.stage().name());
        builder.append("' with class '");
        builder.append(this.executingClass() == null ? "null" : this.executingClass().getName());
        builder.append('\'');
        if (includeMessage && this.sourceRecord() != null) {
            builder.append(", where source record is = ");
            builder.append(this.sourceRecord());
        } else if (includeMessage && this.consumerRecord() != null) {
            ConsumerRecord<byte[], byte[]> msg = this.consumerRecord();
            builder.append(", where consumed record is ");
            builder.append("{topic='").append(msg.topic()).append('\'');
            builder.append(", partition=").append(msg.partition());
            builder.append(", offset=").append(msg.offset());
            if (msg.timestampType() == TimestampType.CREATE_TIME || msg.timestampType() == TimestampType.LOG_APPEND_TIME) {
                builder.append(", timestamp=").append(msg.timestamp());
                builder.append(", timestampType=").append((Object)msg.timestampType());
            }
            builder.append("}");
        }
        builder.append('.');
        return builder.toString();
    }

    public void attempt(int attempt) {
        this.attempt = attempt;
    }

    public int attempt() {
        return this.attempt;
    }

    public Throwable error() {
        return this.error;
    }

    public void error(Throwable error) {
        this.error = error;
    }

    public boolean failed() {
        return this.error() != null;
    }

    public void reporters(Collection<ErrorReporter> reporters) {
        Objects.requireNonNull(reporters);
        this.reporters = reporters;
    }

    @Override
    public void close() {
        ConnectException e = null;
        for (ErrorReporter reporter : this.reporters) {
            try {
                reporter.close();
            }
            catch (Throwable t2) {
                e = e != null ? e : new ConnectException("Failed to close all reporters");
                e.addSuppressed(t2);
            }
        }
        if (e != null) {
            throw e;
        }
    }
}

