/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import java.util.function.Function;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;

public abstract class AbstractSshFuture<T extends SshFuture>
extends AbstractLoggingBean
implements SshFuture<T> {
    protected static final Object CANCELED = new Object();
    private final Object id;

    protected AbstractSshFuture(Object id) {
        this.id = id;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public boolean await(long timeoutMillis) throws IOException {
        return this.await0(timeoutMillis, true) != null;
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false) != null;
        }
        catch (InterruptedIOException e) {
            throw this.formatExceptionMessage(msg -> new InternalError((String)msg, e), "Unexpected interrupted exception wile awaitUninterruptibly %d msec: %s", timeoutMillis, e.getMessage());
        }
    }

    protected <R> R verifyResult(Class<? extends R> expectedType, long timeout) throws IOException {
        Object value = this.await0(timeout, true);
        if (value == null) {
            throw this.formatExceptionMessage(SshException::new, "Failed to get operation result within specified timeout: %s", timeout);
        }
        Class<?> actualType = value.getClass();
        if (expectedType.isAssignableFrom(actualType)) {
            return expectedType.cast(value);
        }
        if (Throwable.class.isAssignableFrom(actualType)) {
            Throwable t2 = ExceptionUtils.peelException((Throwable)value);
            if (t2 instanceof SshException) {
                throw new SshException(((SshException)t2).getDisconnectCode(), t2.getMessage(), t2);
            }
            Throwable cause = ExceptionUtils.resolveExceptionCause(t2);
            throw this.formatExceptionMessage(msg -> new SshException((String)msg, cause), "Failed (%s) to execute: %s", t2.getClass().getSimpleName(), t2.getMessage());
        }
        throw this.formatExceptionMessage(StreamCorruptedException::new, "Unknown result type: %s", actualType.getName());
    }

    protected abstract Object await0(long var1, boolean var3) throws InterruptedIOException;

    protected SshFutureListener<T> asListener(Object o) {
        return (SshFutureListener)o;
    }

    protected void notifyListener(SshFutureListener<T> l) {
        try {
            Object arg = this.asT();
            ThreadUtils.runAsInternal(() -> {
                l.operationComplete(arg);
                return null;
            });
        }
        catch (Throwable t2) {
            this.warn("notifyListener({}) failed ({}) to invoke {}: {}", this, t2.getClass().getSimpleName(), l, t2.getMessage(), t2);
        }
    }

    protected T asT() {
        return (T)this;
    }

    protected <E extends Throwable> E formatExceptionMessage(Function<? super String, ? extends E> exceptionCreator, String format, Object ... args) {
        String messagePayload = String.format(format, args);
        String excMessage = this.getClass().getSimpleName() + "[" + this.getId() + "]: " + messagePayload;
        return (E)((Throwable)exceptionCreator.apply(excMessage));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "]";
    }
}

