/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanException;
import javax.management.ReflectionException;

public final class ExceptionUtils {
    private ExceptionUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static void rethrowAsIoException(Throwable e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new IOException(e);
    }

    public static <T extends Throwable> T accumulateException(T current, T extra) {
        if (current == null) {
            return extra;
        }
        if (extra == null || extra == current) {
            return current;
        }
        current.addSuppressed(extra);
        return current;
    }

    public static Throwable resolveExceptionCause(Throwable t2) {
        if (t2 == null) {
            return t2;
        }
        Throwable c = t2.getCause();
        if (c == null) {
            return t2;
        }
        return c;
    }

    public static Throwable peelException(Throwable t2) {
        if (t2 == null) {
            return t2;
        }
        if (t2 instanceof UndeclaredThrowableException) {
            Throwable wrapped = ((UndeclaredThrowableException)t2).getUndeclaredThrowable();
            if (wrapped != null) {
                return ExceptionUtils.peelException(wrapped);
            }
            wrapped = t2.getCause();
            if (wrapped != t2) {
                return ExceptionUtils.peelException(wrapped);
            }
        } else if (t2 instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)t2).getTargetException();
            if (target != null) {
                return ExceptionUtils.peelException(target);
            }
        } else if (t2 instanceof ReflectionException) {
            Exception target = ((ReflectionException)t2).getTargetException();
            if (target != null) {
                return ExceptionUtils.peelException(target);
            }
        } else {
            Exception target;
            if (t2 instanceof ExecutionException) {
                return ExceptionUtils.peelException(ExceptionUtils.resolveExceptionCause(t2));
            }
            if (t2 instanceof MBeanException && (target = ((MBeanException)t2).getTargetException()) != null) {
                return ExceptionUtils.peelException(target);
            }
        }
        return t2;
    }

    public static RuntimeException toRuntimeException(Throwable t2, boolean peelThrowable) {
        Throwable e;
        Throwable throwable = e = peelThrowable ? ExceptionUtils.peelException(t2) : t2;
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static RuntimeException toRuntimeException(Throwable t2) {
        return ExceptionUtils.toRuntimeException(t2, true);
    }
}

