/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingBean {
    protected final Logger log;
    private final AtomicReference<SimplifiedLog> simplifiedLog = new AtomicReference();

    protected AbstractLoggingBean() {
        this((Logger)null);
    }

    protected AbstractLoggingBean(String discriminator) {
        String name = this.getClass().getName();
        if (GenericUtils.isNotEmpty(discriminator)) {
            name = name + "[" + discriminator + "]";
        }
        this.log = LoggerFactory.getLogger(name);
    }

    protected AbstractLoggingBean(Logger logger2) {
        this.log = logger2 == null ? LoggerFactory.getLogger(this.getClass()) : logger2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimplifiedLog getSimplifiedLogger() {
        SimplifiedLog logger2;
        AtomicReference<SimplifiedLog> atomicReference = this.simplifiedLog;
        synchronized (atomicReference) {
            logger2 = this.simplifiedLog.get();
            if (logger2 == null) {
                logger2 = LoggingUtils.wrap(this.log);
            }
        }
        return logger2;
    }

    protected void debug(String message, Object o1, Object o2, Throwable t2) {
        LoggingUtils.debug(this.log, message, o1, o2, t2);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Throwable t2) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, t2);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Throwable t2) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, t2);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t2) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, o5, t2);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t2) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, o5, o6, t2);
    }

    protected void info(String message, Object o1, Object o2, Throwable t2) {
        LoggingUtils.info(this.log, message, o1, o2, t2);
    }

    protected void info(String message, Object o1, Object o2, Object o3, Throwable t2) {
        LoggingUtils.info(this.log, message, o1, o2, o3, t2);
    }

    protected void warn(String message, Object o1, Object o2, Throwable t2) {
        LoggingUtils.warn(this.log, message, o1, o2, t2);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Throwable t2) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, t2);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Throwable t2) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, t2);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t2) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, t2);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t2) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, t2);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Throwable t2) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, t2);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Throwable t2) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, o8, t2);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Throwable t2) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, o8, o9, t2);
    }

    protected void error(String message, Object o1, Object o2, Throwable t2) {
        LoggingUtils.error(this.log, message, o1, o2, t2);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Throwable t2) {
        LoggingUtils.error(this.log, message, o1, o2, o3, t2);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Throwable t2) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, t2);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t2) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, o5, t2);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t2) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, o5, o6, t2);
    }
}

