/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.topology.CacheInfo;
import org.infinispan.client.hotrod.impl.topology.ClusterInfo;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;

@NotThreadSafe
public final class TopologyInfo {
    private static final Log log = LogFactory.getLog(TopologyInfo.class, Log.class);
    private final Supplier<FailoverRequestBalancingStrategy> balancerFactory;
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();
    private final ConcurrentMap<WrappedBytes, CacheInfo> caches = new ConcurrentHashMap<WrappedBytes, CacheInfo>();
    private volatile ClusterInfo cluster;

    public TopologyInfo(Configuration configuration, ClusterInfo clusterInfo) {
        this.balancerFactory = configuration.balancingStrategyFactory();
        this.hashFactory.init(configuration);
        this.cluster = clusterInfo.withTopologyAge(0);
    }

    public Map<SocketAddress, Set<Integer>> getPrimarySegmentsByServer(byte[] cacheName) {
        WrappedByteArray key = Util.wrapBytes(cacheName);
        CacheInfo cacheInfo = (CacheInfo)this.caches.get(key);
        if (cacheInfo != null) {
            return cacheInfo.getPrimarySegments();
        }
        return Collections.emptyMap();
    }

    public List<InetSocketAddress> getServers(WrappedBytes cacheName) {
        return this.getCacheInfo(cacheName).getServers();
    }

    public Collection<InetSocketAddress> getAllServers() {
        return this.caches.values().stream().flatMap(ct -> ct.getServers().stream()).collect(Collectors.toSet());
    }

    public SegmentConsistentHash createConsistentHash(int numSegments, short hashFunctionVersion, SocketAddress[][] segmentOwners) {
        SegmentConsistentHash hash = null;
        if (hashFunctionVersion > 0) {
            hash = (SegmentConsistentHash)this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                Log.HOTROD.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(segmentOwners, numSegments);
            }
        }
        return hash;
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.hashFactory;
    }

    public CacheTopologyInfo getCacheTopologyInfo(byte[] cacheName) {
        WrappedByteArray key = Util.wrapBytes(cacheName);
        return ((CacheInfo)this.caches.get(key)).getCacheTopologyInfo();
    }

    public CacheInfo getCacheInfo(WrappedBytes cacheName) {
        return (CacheInfo)this.caches.get(cacheName);
    }

    public CacheInfo getOrCreateCacheInfo(WrappedBytes cacheName) {
        return this.caches.computeIfAbsent(cacheName, cn -> {
            ClusterInfo cluster = this.cluster;
            CacheInfo cacheInfo = new CacheInfo((WrappedBytes)cn, this.balancerFactory.get(), cluster.getTopologyAge(), cluster.getInitialServers(), cluster.getIntelligence());
            cacheInfo.updateBalancerServers();
            if (log.isTraceEnabled()) {
                log.tracef("Creating cache info %s with topology age %d", (Object)cacheInfo.getCacheName(), (Object)cluster.getTopologyAge());
            }
            return cacheInfo;
        });
    }

    public void switchCluster(ClusterInfo newCluster) {
        ClusterInfo oldCluster = this.cluster;
        int newTopologyAge = oldCluster.getTopologyAge() + 1;
        if (log.isTraceEnabled()) {
            log.tracef("Switching cluster: %s -> %s with servers %s", (Object)oldCluster.getName(), (Object)newCluster.getName(), (Object)newCluster.getInitialServers());
        }
        this.caches.forEach((name, oldCacheInfo) -> {
            CacheInfo newCacheInfo = oldCacheInfo.withNewServers(newTopologyAge, -2, newCluster.getInitialServers(), newCluster.getIntelligence());
            this.updateCacheInfo((WrappedBytes)name, (CacheInfo)oldCacheInfo, newCacheInfo);
        });
        this.cluster = newCluster.withTopologyAge(newTopologyAge);
    }

    public void reset(WrappedBytes cacheName) {
        if (log.isTraceEnabled()) {
            log.tracef("Switching to initial server list for cache %s, cluster %s", (Object)cacheName, (Object)this.cluster.getName());
        }
        CacheInfo oldCacheInfo = (CacheInfo)this.caches.get(cacheName);
        CacheInfo newCacheInfo = oldCacheInfo.withNewServers(this.cluster.getTopologyAge(), -1, this.cluster.getInitialServers(), this.cluster.getIntelligence());
        this.updateCacheInfo(cacheName, oldCacheInfo, newCacheInfo);
    }

    public ClusterInfo getCluster() {
        return this.cluster;
    }

    public int getTopologyAge() {
        return this.cluster.getTopologyAge();
    }

    public void updateCacheInfo(WrappedBytes cacheName, CacheInfo oldCacheInfo, CacheInfo newCacheInfo) {
        if (log.isTraceEnabled()) {
            log.tracef("Updating topology for %s: %s -> %s", (Object)newCacheInfo.getCacheName(), (Object)oldCacheInfo.getTopologyId(), (Object)newCacheInfo.getTopologyId());
        }
        CacheInfo existing = this.caches.put(cacheName, newCacheInfo);
        assert (existing == oldCacheInfo) : "Locking should have prevented concurrent updates";
        newCacheInfo.updateBalancerServers();
        newCacheInfo.updateClientTopologyRef();
    }

    public void forEachCache(BiConsumer<WrappedBytes, CacheInfo> action) {
        this.caches.forEach(action);
    }
}

