/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;

class SegmentKeyTracker
implements KeyTracker {
    private static final Log log = LogFactory.getLog(SegmentKeyTracker.class);
    private final AtomicReferenceArray<Set<WrappedByteArray>> keysPerSegment;
    private final SegmentConsistentHash segmentConsistentHash;
    private final DataFormat dataFormat;

    public SegmentKeyTracker(DataFormat dataFormat, SegmentConsistentHash segmentConsistentHash, Set<Integer> segments) {
        this.dataFormat = dataFormat;
        int numSegments = segmentConsistentHash.getNumSegments();
        this.keysPerSegment = new AtomicReferenceArray(numSegments);
        if (log.isTraceEnabled()) {
            log.tracef("Created SegmentKeyTracker with %d segments, filter %s", numSegments, (Object)segments);
        }
        this.segmentConsistentHash = segmentConsistentHash;
        IntStream segmentStream = segments == null ? IntStream.range(0, segmentConsistentHash.getNumSegments()) : segments.stream().mapToInt(i -> i);
        segmentStream.forEach(i -> this.keysPerSegment.set(i, new HashSet()));
    }

    @Override
    public boolean track(byte[] key, short status, ClassAllowList allowList) {
        int segment = this.dataFormat.isObjectStorage() ? this.segmentConsistentHash.getSegment(this.dataFormat.keyToObj(key, allowList)) : this.segmentConsistentHash.getSegment(key);
        Set<WrappedByteArray> keys = this.keysPerSegment.get(segment);
        if (keys == null) {
            throw new IllegalStateException("Segment " + segment + " already completed");
        }
        boolean result = keys.add(new WrappedByteArray(key));
        if (log.isTraceEnabled()) {
            log.trackingSegmentKey(Util.printArray(key), segment, !result);
        }
        return result;
    }

    @Override
    public Set<Integer> missedSegments() {
        int length = this.keysPerSegment.length();
        if (length == 0) {
            return null;
        }
        HashSet<Integer> missed = new HashSet<Integer>(length);
        for (int i = 0; i < this.keysPerSegment.length(); ++i) {
            if (this.keysPerSegment.get(i) == null) continue;
            missed.add(i);
        }
        return missed;
    }

    @Override
    public void segmentsFinished(IntSet finishedSegments) {
        if (finishedSegments != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Removing completed segments %s", (Object)finishedSegments);
            }
            finishedSegments.forEach(seg -> this.keysPerSegment.set(seg, null));
        }
    }
}

