/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientEventDispatcher;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.ClientListenerOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class AddBloomNearCacheClientListenerOperation
extends ClientListenerOperation {
    private final int bloomFilterBits;
    private final InternalRemoteCache<?, ?> remoteCache;

    protected AddBloomNearCacheClientListenerOperation(Codec codec, ChannelFactory channelFactory, String cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, ClientListenerNotifier listenerNotifier, Object listener, DataFormat dataFormat, int bloomFilterBits, InternalRemoteCache<?, ?> remoteCache) {
        this(codec, channelFactory, cacheName, clientTopology, flags, cfg, AddBloomNearCacheClientListenerOperation.generateListenerId(), listenerNotifier, listener, dataFormat, bloomFilterBits, remoteCache);
    }

    private AddBloomNearCacheClientListenerOperation(Codec codec, ChannelFactory channelFactory, String cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, byte[] listenerId, ClientListenerNotifier listenerNotifier, Object listener, DataFormat dataFormat, int bloomFilterBits, InternalRemoteCache<?, ?> remoteCache) {
        super((short)65, (short)66, codec, channelFactory, RemoteCacheManager.cacheNameBytes(cacheName), clientTopology, flags, cfg, listenerId, dataFormat, listener, cacheName, listenerNotifier, null);
        this.bloomFilterBits = bloomFilterBits;
        this.remoteCache = remoteCache;
    }

    @Override
    public AddBloomNearCacheClientListenerOperation copy() {
        return new AddBloomNearCacheClientListenerOperation(this.codec, this.channelFactory, this.cacheNameString, this.header.getClientTopology(), this.flags(), this.cfg, this.listenerId, this.listenerNotifier, this.listener, this.dataFormat(), this.bloomFilterBits, this.remoteCache);
    }

    @Override
    protected void actualExecute(Channel channel) {
        channel.pipeline().get(HeaderDecoder.class).registerOperation(channel, this);
        this.listenerNotifier.addDispatcher(ClientEventDispatcher.create(this, this.address, () -> this.cleanup(channel), this.remoteCache));
        ByteBuf buf = channel.alloc().buffer();
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.listenerId);
        this.codec.writeBloomFilter(buf, this.bloomFilterBits);
        channel.writeAndFlush(buf);
    }
}

