/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class CodecHolder {
    private static final Log log = LogFactory.getLog(CodecHolder.class);
    private final AtomicReference<Codec> codec;

    public CodecHolder(Codec configuredCodec) {
        this.codec = new AtomicReference<Codec>(configuredCodec);
    }

    public Codec getCodec() {
        return this.codec.get();
    }

    public void setCodec(Codec newCodec) {
        Codec current = this.codec.get();
        if (current.equals(newCodec)) {
            return;
        }
        log.debugf("Changing codec from %s to %s", (Object)current, (Object)newCodec);
        this.codec.compareAndSet(current, newCodec);
    }
}

