/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;

public class TxReadOnlyKeyCommand<K, V, R>
extends ReadOnlyKeyCommand<K, V, R> {
    public static final byte COMMAND_ID = 64;
    private List<Mutation<K, V, ?>> mutations;

    public TxReadOnlyKeyCommand() {
    }

    public TxReadOnlyKeyCommand(Object key, Function<EntryView.ReadEntryView<K, V>, R> f, List<Mutation<K, V, ?>> mutations, int segment, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(key, f, segment, params, keyDataConversion, valueDataConversion);
        this.mutations = mutations;
    }

    @Override
    public byte getCommandId() {
        return 64;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        MarshallUtil.marshallCollection(this.mutations, output, Mutations::writeTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.mutations = MarshallUtil.unmarshallCollection(input, ArrayList::new, Mutations::readFrom);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.mutations != null) {
            for (Mutation<K, V, ?> m4 : this.mutations) {
                m4.inject(componentRegistry);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TxReadOnlyKeyCommand{");
        sb.append("key=").append(this.key);
        sb.append(", f=").append(this.f);
        sb.append(", mutations=").append(this.mutations);
        sb.append(", params=").append(this.params);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    public List<Mutation<K, V, ?>> getMutations() {
        return this.mutations;
    }
}

