/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSetsExternalization;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;

public class IracRequestStateCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 121;
    private IntSet segments;

    public IracRequestStateCommand() {
        super(null);
    }

    public IracRequestStateCommand(ByteString cacheName) {
        super(cacheName);
    }

    public IracRequestStateCommand(ByteString cacheName, IntSet segments) {
        super(cacheName);
        this.segments = segments;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        registry.getIracManager().wired().requestState(this.getOrigin(), this.segments);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 121;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        IntSetsExternalization.writeTo(output, this.segments);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.segments = IntSetsExternalization.readFrom(input);
    }

    @Override
    public String toString() {
        return "IracRequestStateCommand{segments=" + String.valueOf(this.segments) + ", cacheName=" + String.valueOf(this.cacheName) + "}";
    }
}

