/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUID;

public class TopologyUpdateCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 95;
    private String cacheName;
    private ConsistentHash currentCH;
    private ConsistentHash pendingCH;
    private CacheTopology.Phase phase;
    private List<Address> actualMembers;
    private List<PersistentUUID> persistentUUIDs;
    private AvailabilityMode availabilityMode;
    private int rebalanceId;
    private int topologyId;
    private int viewId;

    public TopologyUpdateCommand() {
        super((byte)95);
    }

    public TopologyUpdateCommand(String cacheName, Address origin, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId) {
        super((byte)95, origin);
        this.cacheName = cacheName;
        this.topologyId = cacheTopology.getTopologyId();
        this.rebalanceId = cacheTopology.getRebalanceId();
        this.currentCH = cacheTopology.getCurrentCH();
        this.pendingCH = cacheTopology.getPendingCH();
        this.phase = cacheTopology.getPhase();
        this.availabilityMode = availabilityMode;
        this.actualMembers = cacheTopology.getActualMembers();
        this.persistentUUIDs = cacheTopology.getMembersPersistentUUIDs();
        this.viewId = viewId;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        CacheTopology topology = new CacheTopology(this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, this.phase, this.actualMembers, this.persistentUUIDs);
        return gcr.getLocalTopologyManager().handleTopologyUpdate(this.cacheName, topology, this.availabilityMode, this.viewId, this.origin);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public CacheTopology.Phase getPhase() {
        return this.phase;
    }

    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString(this.cacheName, output);
        output.writeObject(this.currentCH);
        output.writeObject(this.pendingCH);
        MarshallUtil.marshallEnum(this.phase, output);
        MarshallUtil.marshallCollection(this.actualMembers, output);
        MarshallUtil.marshallCollection(this.persistentUUIDs, output);
        MarshallUtil.marshallEnum(this.availabilityMode, output);
        output.writeInt(this.topologyId);
        output.writeInt(this.rebalanceId);
        output.writeInt(this.viewId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString(input);
        this.currentCH = (ConsistentHash)input.readObject();
        this.pendingCH = (ConsistentHash)input.readObject();
        this.phase = MarshallUtil.unmarshallEnum(input, CacheTopology.Phase::valueOf);
        this.actualMembers = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.persistentUUIDs = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.availabilityMode = MarshallUtil.unmarshallEnum(input, AvailabilityMode::valueOf);
        this.topologyId = input.readInt();
        this.rebalanceId = input.readInt();
        this.viewId = input.readInt();
    }

    public String toString() {
        return "TopologyUpdateCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", currentCH=" + String.valueOf(this.currentCH) + ", pendingCH=" + String.valueOf(this.pendingCH) + ", phase=" + String.valueOf((Object)this.phase) + ", actualMembers=" + String.valueOf(this.actualMembers) + ", persistentUUIDs=" + String.valueOf(this.persistentUUIDs) + ", availabilityMode=" + String.valueOf((Object)this.availabilityMode) + ", rebalanceId=" + this.rebalanceId + ", topologyId=" + this.topologyId + ", viewId=" + this.viewId + "}";
    }
}

