/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.ByteString;
import org.infinispan.util.TriangleFunctionsUtil;

public class PutMapBackupWriteCommand
extends BackupWriteCommand {
    public static final byte COMMAND_ID = 78;
    private Map<Object, Object> map;
    private Metadata metadata;
    private Map<Object, PrivateMetadata> internalMetadataMap;

    public PutMapBackupWriteCommand() {
        super(null);
    }

    public PutMapBackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public byte getCommandId() {
        return 78;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        this.writeBase(output);
        MarshallUtil.marshallMap(this.map, output);
        output.writeObject(this.metadata);
        MarshallUtil.marshallMap(this.internalMetadataMap, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readBase(input);
        this.map = MarshallUtil.unmarshallMap(input, HashMap::new);
        this.metadata = (Metadata)input.readObject();
        this.internalMetadataMap = MarshallUtil.unmarshallMap(input, HashMap::new);
    }

    public void setPutMapCommand(PutMapCommand command, Collection<Object> keys) {
        this.setCommonAttributesFromCommand(command);
        this.map = TriangleFunctionsUtil.filterEntries(command.getMap(), keys);
        this.metadata = command.getMetadata();
        this.internalMetadataMap = new HashMap<Object, PrivateMetadata>();
        for (Object key : this.map.keySet()) {
            this.internalMetadataMap.put(key, command.getInternalMetadata(key));
        }
    }

    @Override
    public String toString() {
        return "PutMapBackupWriteCommand{" + this.toStringFields() + "}";
    }

    @Override
    WriteCommand createWriteCommand() {
        PutMapCommand cmd = new PutMapCommand(this.map, this.metadata, this.getFlags(), this.getCommandInvocationId());
        cmd.setForwarded(true);
        this.internalMetadataMap.forEach(cmd::setInternalMetadata);
        return cmd;
    }

    @Override
    String toStringFields() {
        return super.toStringFields() + ", map=" + String.valueOf(this.map) + ", metadata=" + String.valueOf(this.metadata) + ", internalMetadata=" + String.valueOf(this.internalMetadataMap);
    }
}

