/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.ByteString;

public class SingleKeyBackupWriteCommand
extends BackupWriteCommand {
    public static final byte COMMAND_ID = 76;
    private static final Operation[] CACHED_OPERATION = Operation.values();
    private Operation operation;
    private Object key;
    private Object valueOrFunction;
    private Metadata metadata;
    private PrivateMetadata internalMetadata;

    public SingleKeyBackupWriteCommand() {
        super(null);
    }

    public SingleKeyBackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    private static Operation valueOf(int index) {
        return CACHED_OPERATION[index];
    }

    @Override
    public byte getCommandId() {
        return 76;
    }

    public void setPutKeyValueCommand(PutKeyValueCommand command) {
        this.operation = Operation.WRITE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getValue();
        this.metadata = command.getMetadata();
        this.internalMetadata = command.getInternalMetadata();
    }

    public void setIracPutKeyValueCommand(IracPutKeyValueCommand command) {
        this.operation = Operation.WRITE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getValue();
        this.metadata = command.getMetadata();
        this.internalMetadata = command.getInternalMetadata();
    }

    public void setRemoveCommand(RemoveCommand command, boolean removeExpired) {
        this.operation = removeExpired ? Operation.REMOVE_EXPIRED : Operation.REMOVE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getValue();
        this.internalMetadata = command.getInternalMetadata();
    }

    public void setReplaceCommand(ReplaceCommand command) {
        this.operation = Operation.REPLACE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getNewValue();
        this.metadata = command.getMetadata();
        this.internalMetadata = command.getInternalMetadata();
    }

    public void setComputeCommand(ComputeCommand command) {
        this.operation = command.isComputeIfPresent() ? Operation.COMPUTE_IF_PRESENT : Operation.COMPUTE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getRemappingBiFunction();
        this.metadata = command.getMetadata();
        this.internalMetadata = command.getInternalMetadata();
    }

    public void setComputeIfAbsentCommand(ComputeIfAbsentCommand command) {
        this.operation = Operation.COMPUTE_IF_ABSENT;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getMappingFunction();
        this.metadata = command.getMetadata();
        this.internalMetadata = command.getInternalMetadata();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        this.writeBase(output);
        MarshallUtil.marshallEnum(this.operation, output);
        output.writeObject(this.key);
        output.writeObject(this.internalMetadata);
        switch (this.operation.ordinal()) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                output.writeObject(this.metadata);
            }
            case 2: {
                output.writeObject(this.valueOrFunction);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readBase(input);
        this.operation = MarshallUtil.unmarshallEnum(input, SingleKeyBackupWriteCommand::valueOf);
        this.key = input.readObject();
        this.internalMetadata = (PrivateMetadata)input.readObject();
        switch (this.operation.ordinal()) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.metadata = (Metadata)input.readObject();
            }
            case 2: {
                this.valueOrFunction = input.readObject();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @Override
    public String toString() {
        return "SingleKeyBackupWriteCommand{" + this.toStringFields() + "}";
    }

    @Override
    WriteCommand createWriteCommand() {
        AbstractDataWriteCommand command;
        switch (this.operation.ordinal()) {
            case 1: {
                command = new RemoveCommand(this.key, null, false, this.segmentId, this.getFlags(), this.getCommandInvocationId());
                break;
            }
            case 0: {
                command = EnumUtil.containsAny(this.getFlags(), FlagBitSets.IRAC_UPDATE) ? new IracPutKeyValueCommand(this.key, this.segmentId, this.getCommandInvocationId(), this.valueOrFunction, this.metadata, this.internalMetadata) : new PutKeyValueCommand(this.key, this.valueOrFunction, false, false, this.metadata, this.segmentId, this.getFlags(), this.getCommandInvocationId());
                break;
            }
            case 4: {
                command = new ComputeCommand(this.key, (BiFunction)this.valueOrFunction, false, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata);
                break;
            }
            case 3: {
                command = new ReplaceCommand(this.key, null, this.valueOrFunction, false, this.metadata, this.segmentId, this.getFlags(), this.getCommandInvocationId());
                break;
            }
            case 2: {
                command = new RemoveExpiredCommand(this.key, this.valueOrFunction, null, false, this.segmentId, this.getFlags(), this.getCommandInvocationId());
                break;
            }
            case 5: {
                command = new ComputeCommand(this.key, (BiFunction)this.valueOrFunction, true, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata);
                break;
            }
            case 6: {
                command = new ComputeIfAbsentCommand(this.key, (Function)this.valueOrFunction, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operation " + String.valueOf((Object)this.operation));
            }
        }
        command.setInternalMetadata(this.internalMetadata);
        return command;
    }

    @Override
    String toStringFields() {
        return super.toStringFields() + ", operation=" + String.valueOf((Object)this.operation) + ", key=" + String.valueOf(this.key) + ", valueOrFunction=" + String.valueOf(this.valueOrFunction) + ", metadata=" + String.valueOf(this.metadata) + ", internalMetadata=" + String.valueOf(this.internalMetadata);
    }

    private static enum Operation {
        WRITE,
        REMOVE,
        REMOVE_EXPIRED,
        REPLACE,
        COMPUTE,
        COMPUTE_IF_PRESENT,
        COMPUTE_IF_ABSENT;

    }
}

