/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.triangle.FunctionalBackupWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.ByteString;

public class SingleKeyFunctionalBackupWriteCommand
extends FunctionalBackupWriteCommand {
    public static final byte COMMAND_ID = 77;
    private static final Operation[] CACHED_OPERATION = Operation.values();
    private Operation operation;
    private Object key;
    private Object value;
    private Object prevValue;
    private Metadata prevMetadata;

    public SingleKeyFunctionalBackupWriteCommand() {
        super(null);
    }

    public SingleKeyFunctionalBackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    private static Operation valueOf(int index) {
        return CACHED_OPERATION[index];
    }

    @Override
    public byte getCommandId() {
        return 77;
    }

    public void setReadWriteKeyCommand(ReadWriteKeyCommand command) {
        this.operation = Operation.READ_WRITE;
        this.setCommonFields(command);
        this.function = command.getFunction();
    }

    public void setReadWriteKeyValueCommand(ReadWriteKeyValueCommand command) {
        this.operation = Operation.READ_WRITE_KEY_VALUE;
        this.setCommonFields(command);
        this.function = command.getBiFunction();
        this.value = command.getArgument();
        this.prevValue = command.getPrevValue();
        this.prevMetadata = command.getPrevMetadata();
    }

    public void setWriteOnlyKeyValueCommand(WriteOnlyKeyValueCommand command) {
        this.operation = Operation.WRITE_ONLY_KEY_VALUE;
        this.setCommonFields(command);
        this.function = command.getBiConsumer();
        this.value = command.getArgument();
    }

    public void setWriteOnlyKeyCommand(WriteOnlyKeyCommand command) {
        this.operation = Operation.WRITE_ONLY;
        this.setCommonFields(command);
        this.function = command.getConsumer();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        this.writeBase(output);
        this.writeFunctionAndParams(output);
        MarshallUtil.marshallEnum(this.operation, output);
        output.writeObject(this.key);
        switch (this.operation.ordinal()) {
            case 0: {
                output.writeObject(this.prevValue);
                output.writeObject(this.prevMetadata);
            }
            case 2: {
                output.writeObject(this.value);
            }
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readBase(input);
        this.readFunctionAndParams(input);
        this.operation = MarshallUtil.unmarshallEnum(input, SingleKeyFunctionalBackupWriteCommand::valueOf);
        this.key = input.readObject();
        switch (this.operation.ordinal()) {
            case 0: {
                this.prevValue = input.readObject();
                this.prevMetadata = (Metadata)input.readObject();
            }
            case 2: {
                this.value = input.readObject();
            }
        }
    }

    @Override
    WriteCommand createWriteCommand() {
        switch (this.operation.ordinal()) {
            case 1: {
                return new ReadWriteKeyCommand(this.key, (Function)this.function, this.segmentId, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion);
            }
            case 0: {
                ReadWriteKeyValueCommand cmd = new ReadWriteKeyValueCommand(this.key, this.value, (BiFunction)this.function, this.segmentId, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion);
                cmd.setPrevValueAndMetadata(this.prevValue, this.prevMetadata);
                return cmd;
            }
            case 3: {
                return new WriteOnlyKeyCommand(this.key, (Consumer)this.function, this.segmentId, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion);
            }
            case 2: {
                return new WriteOnlyKeyValueCommand(this.key, this.value, (BiConsumer)this.function, this.segmentId, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion);
            }
        }
        throw new IllegalStateException("Unknown operation " + String.valueOf((Object)this.operation));
    }

    private <C extends AbstractWriteKeyCommand> void setCommonFields(C command) {
        this.setCommonAttributesFromCommand(command);
        this.setFunctionalCommand(command);
        this.key = command.getKey();
    }

    private static enum Operation {
        READ_WRITE_KEY_VALUE,
        READ_WRITE,
        WRITE_ONLY_KEY_VALUE,
        WRITE_ONLY;

    }
}

