/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class ComputeCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final int COMMAND_ID = 68;
    private BiFunction remappingBiFunction;
    private Metadata metadata;
    private boolean computeIfPresent;
    private boolean successful = true;
    private PrivateMetadata internalMetadata;

    public ComputeCommand() {
    }

    public ComputeCommand(Object key, BiFunction remappingBiFunction, boolean computeIfPresent, int segment, long flagsBitSet, CommandInvocationId commandInvocationId, Metadata metadata) {
        super(key, segment, flagsBitSet, commandInvocationId);
        this.remappingBiFunction = remappingBiFunction;
        this.computeIfPresent = computeIfPresent;
        this.metadata = metadata;
    }

    public boolean isComputeIfPresent() {
        return this.computeIfPresent;
    }

    public void setComputeIfPresent(boolean computeIfPresent) {
        this.computeIfPresent = computeIfPresent;
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.remappingBiFunction);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.isComputeIfPresent();
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public byte getCommandId() {
        return 68;
    }

    public BiFunction getRemappingBiFunction() {
        return this.remappingBiFunction;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeBoolean(this.computeIfPresent);
        output.writeObject(this.remappingBiFunction);
        UnsignedNumeric.writeUnsignedInt(output, this.segment);
        output.writeObject(this.metadata);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeObject(this.internalMetadata);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.computeIfPresent = input.readBoolean();
        this.remappingBiFunction = (BiFunction)input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt(input);
        this.metadata = (Metadata)input.readObject();
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.setFlagsBitSet(input.readLong());
        this.internalMetadata = (PrivateMetadata)input.readObject();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitComputeCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComputeCommand that = (ComputeCommand)o;
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.computeIfPresent, that.computeIfPresent)) {
            return false;
        }
        return Objects.equals(this.remappingBiFunction, that.remappingBiFunction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.computeIfPresent, this.remappingBiFunction, this.metadata);
    }

    @Override
    public String toString() {
        return "ComputeCommand{key=" + Util.toStr(this.key) + ", isComputeIfPresent=" + Util.toStr(this.computeIfPresent) + ", remappingBiFunction=" + Util.toStr(this.remappingBiFunction) + ", metadata=" + String.valueOf(this.metadata) + ", flags=" + this.printFlags() + ", successful=" + this.isSuccessful() + ", valueMatcher=" + String.valueOf((Object)this.getValueMatcher()) + ", topologyId=" + this.getTopologyId() + "}";
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.internalMetadata = internalMetadata;
    }
}

