/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.infinispan.commons.util.CloseableSpliterator;

public class FilterSpliterator<T>
implements CloseableSpliterator<T> {
    private final Spliterator<T> spliterator;
    private final Predicate<? super T> predicate;
    private final Consumer<? super T> consumer = t2 -> {
        this.current = t2;
    };
    private T current;

    public FilterSpliterator(Spliterator<T> spliterator, Predicate<? super T> predicate) {
        this.spliterator = spliterator;
        this.predicate = predicate;
    }

    @Override
    public void close() {
        if (this.spliterator instanceof CloseableSpliterator) {
            ((CloseableSpliterator)this.spliterator).close();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        while (this.spliterator.tryAdvance(this.consumer)) {
            T objectToUse = this.current;
            if (!this.predicate.test(objectToUse)) continue;
            action.accept(objectToUse);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.spliterator.forEachRemaining(e -> {
            if (this.predicate.test(e)) {
                action.accept(e);
            }
        });
    }

    @Override
    public Spliterator<T> trySplit() {
        Spliterator<T> split = this.spliterator.trySplit();
        if (split != null) {
            return new FilterSpliterator<T>(split, this.predicate);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.spliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.spliterator.characteristics() & 0xFFFFBFBF;
    }
}

