/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class AbstractStoreConfiguration
implements StoreConfiguration {
    public static final AttributeDefinition<Boolean> PURGE_ON_STARTUP = AttributeDefinition.builder(Attribute.PURGE, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Boolean> READ_ONLY = AttributeDefinition.builder(Attribute.READ_ONLY, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Boolean> WRITE_ONLY = AttributeDefinition.builder(Attribute.WRITE_ONLY, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Boolean> PRELOAD = AttributeDefinition.builder(Attribute.PRELOAD, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Boolean> SHARED = AttributeDefinition.builder(Attribute.SHARED, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Boolean> TRANSACTIONAL = AttributeDefinition.builder(Attribute.TRANSACTIONAL, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Integer> MAX_BATCH_SIZE = AttributeDefinition.builder(Attribute.MAX_BATCH_SIZE, Integer.valueOf(100)).immutable().build();
    public static final AttributeDefinition<Boolean> SEGMENTED = AttributeDefinition.builder(Attribute.SEGMENTED, Boolean.valueOf(true)).immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder(Element.PROPERTIES, null, TypedProperties.class).initializer(() -> new TypedProperties()).autoPersist(false).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> purgeOnStartup;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> ignoreModifications;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> writeOnly;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> preload;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> shared;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> transactional;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> maxBatchSize;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> segmented;
    private final org.infinispan.commons.configuration.attributes.Attribute<TypedProperties> properties;
    protected final AttributeSet attributes;
    private final AsyncStoreConfiguration async;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AbstractStoreConfiguration.class, PURGE_ON_STARTUP, READ_ONLY, WRITE_ONLY, PRELOAD, SHARED, TRANSACTIONAL, MAX_BATCH_SIZE, SEGMENTED, PROPERTIES);
    }

    public AbstractStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
        this.attributes = attributes.checkProtection();
        this.async = async;
        this.purgeOnStartup = attributes.attribute(PURGE_ON_STARTUP);
        this.ignoreModifications = attributes.attribute(READ_ONLY);
        this.writeOnly = attributes.attribute(WRITE_ONLY);
        this.preload = attributes.attribute(PRELOAD);
        this.shared = attributes.attribute(SHARED);
        this.transactional = attributes.attribute(TRANSACTIONAL);
        this.maxBatchSize = attributes.attribute(MAX_BATCH_SIZE);
        this.segmented = attributes.attribute(SEGMENTED);
        this.properties = attributes.attribute(PROPERTIES);
    }

    @Override
    public AsyncStoreConfiguration async() {
        return this.async;
    }

    @Override
    public boolean purgeOnStartup() {
        return this.purgeOnStartup.get();
    }

    @Override
    public boolean shared() {
        return this.shared.get();
    }

    @Override
    public boolean transactional() {
        return this.transactional.get();
    }

    @Override
    public int maxBatchSize() {
        return this.maxBatchSize.get();
    }

    @Override
    public boolean segmented() {
        return this.segmented.get();
    }

    @Override
    @Deprecated
    public boolean fetchPersistentState() {
        return false;
    }

    @Override
    public boolean ignoreModifications() {
        return this.ignoreModifications.get();
    }

    @Override
    public boolean writeOnly() {
        return this.writeOnly.get();
    }

    @Override
    public boolean preload() {
        return this.preload.get();
    }

    @Override
    public Properties properties() {
        return this.properties.get();
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AbstractStoreConfiguration [attributes=" + String.valueOf(this.attributes) + ", async=" + String.valueOf(this.async) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.async == null ? 0 : this.async.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AbstractStoreConfiguration other = (AbstractStoreConfiguration)obj;
        if (this.async == null ? other.async != null : !this.async.equals(other.async)) {
            return false;
        }
        if (this.attributes == null) {
            return other.attributes == null;
        }
        return this.attributes.equals(other.attributes);
    }
}

