/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractPersistenceConfigurationChildBuilder;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.util.logging.Log;

public abstract class AbstractStoreConfigurationBuilder<T extends StoreConfiguration, S extends AbstractStoreConfigurationBuilder<T, S>>
extends AbstractPersistenceConfigurationChildBuilder
implements StoreConfigurationBuilder<T, S> {
    protected final AttributeSet attributes;
    protected final AsyncStoreConfigurationBuilder<S> async;

    public AbstractStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributes) {
        super(builder);
        this.attributes = attributes;
        this.async = new AsyncStoreConfigurationBuilder(this);
    }

    public AbstractStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributes, AttributeSet asyncAttributeSet) {
        super(builder);
        this.attributes = attributes;
        this.async = new AsyncStoreConfigurationBuilder(this, asyncAttributeSet);
    }

    @Override
    public AsyncStoreConfigurationBuilder<S> async() {
        return this.async;
    }

    @Override
    @Deprecated
    public S fetchPersistentState(boolean b) {
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S ignoreModifications(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.READ_ONLY).set(b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S purgeOnStartup(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).set(b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S writeOnly(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.WRITE_ONLY).set(b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    public S properties(Properties properties) {
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set(new TypedProperties((Map<?, ?>)properties));
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S addProperty(String key, String value) {
        TypedProperties properties = this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).get();
        properties.put(key, value);
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set(properties);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S withProperties(Properties props) {
        this.attributes.attribute(AbstractStoreConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(props));
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S preload(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).set(b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S shared(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.SHARED).set(b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S transactional(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.TRANSACTIONAL).set(b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S maxBatchSize(int maxBatchSize) {
        this.attributes.attribute(AbstractStoreConfiguration.MAX_BATCH_SIZE).set(maxBatchSize);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S segmented(boolean b) {
        this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED).set(b);
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public void validate() {
        this.validate(false);
    }

    protected void validate(boolean skipClassChecks) {
        if (!skipClassChecks) {
            this.validateStoreWithAnnotations();
        }
        this.validateStoreAttributes();
    }

    private void validateStoreAttributes() {
        this.async.validate();
        boolean shared = this.attributes.attribute(AbstractStoreConfiguration.SHARED).get();
        boolean preload = this.attributes.attribute(AbstractStoreConfiguration.PRELOAD).get();
        boolean purgeOnStartup = this.attributes.attribute(AbstractStoreConfiguration.PURGE_ON_STARTUP).get();
        boolean transactional = this.attributes.attribute(AbstractStoreConfiguration.TRANSACTIONAL).get();
        boolean readOnly = this.attributes.attribute(AbstractStoreConfiguration.READ_ONLY).get();
        boolean writeOnly = this.attributes.attribute(AbstractStoreConfiguration.WRITE_ONLY).get();
        ConfigurationBuilder builder = this.getBuilder();
        if (purgeOnStartup && preload) {
            throw Log.CONFIG.preloadAndPurgeOnStartupConflict();
        }
        if (readOnly && writeOnly) {
            throw Log.CONFIG.storeBothReadAndWriteOnly();
        }
        if (readOnly && (purgeOnStartup || shared || this.persistence().passivation())) {
            throw Log.CONFIG.storeReadOnlyExceptions();
        }
        if (writeOnly && preload) {
            throw Log.CONFIG.storeWriteOnlyExceptions();
        }
        if (shared && !builder.clustering().cacheMode().isClustered()) {
            throw Log.CONFIG.sharedStoreWithLocalCache();
        }
        if (transactional && !builder.transaction().transactionMode().isTransactional()) {
            throw Log.CONFIG.transactionalStoreInNonTransactionalCache();
        }
        if (transactional && builder.persistence().passivation()) {
            throw Log.CONFIG.transactionalStoreInPassivatedCache();
        }
    }

    private void validateStoreWithAnnotations() {
        Class<?> configKlass = this.attributes.getKlass();
        if (configKlass != null && configKlass.isAnnotationPresent(ConfigurationFor.class)) {
            Class<?> storeKlass = configKlass.getAnnotation(ConfigurationFor.class).value();
            if (storeKlass.isAnnotationPresent(Store.class)) {
                Store storeProps = storeKlass.getAnnotation(Store.class);
                boolean segmented = this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED).get();
                if (segmented && !AbstractSegmentedStoreConfiguration.class.isAssignableFrom(configKlass) && !SegmentedAdvancedLoadWriteStore.class.isAssignableFrom(storeKlass) && !NonBlockingStore.class.isAssignableFrom(storeKlass)) {
                    throw Log.CONFIG.storeNotSegmented(storeKlass);
                }
                if (!storeProps.shared() && this.attributes.attribute(AbstractStoreConfiguration.SHARED).get().booleanValue()) {
                    throw Log.CONFIG.nonSharedStoreConfiguredAsShared(storeKlass.getSimpleName());
                }
            }
        } else {
            Log.CONFIG.warnConfigurationForAnnotationMissing(this.attributes.getName());
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public Builder<?> read(T template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.async.read(template.async(), combine);
        return this;
    }

    public String toString() {
        return "AbstractStoreConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + ", async=" + String.valueOf(this.async) + "]";
    }
}

