/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.Attribute;

public class AsyncStoreConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder(Attribute.ENABLED, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Integer> MODIFICATION_QUEUE_SIZE = AttributeDefinition.builder(Attribute.MODIFICATION_QUEUE_SIZE, Integer.valueOf(1024)).immutable().build();
    @Deprecated
    public static final AttributeDefinition<Integer> THREAD_POOL_SIZE = AttributeDefinition.builder(Attribute.THREAD_POOL_SIZE, Integer.valueOf(1)).immutable().build();
    public static final AttributeDefinition<Boolean> FAIL_SILENTLY = AttributeDefinition.builder(Attribute.FAIL_SILENTLY, Boolean.valueOf(false)).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> enabled;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> modificationQueueSize;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> threadPoolSize;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> failSilently;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AsyncStoreConfiguration.class, ENABLED, MODIFICATION_QUEUE_SIZE, THREAD_POOL_SIZE, FAIL_SILENTLY);
    }

    public AsyncStoreConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.modificationQueueSize = attributes.attribute(MODIFICATION_QUEUE_SIZE);
        this.threadPoolSize = attributes.attribute(THREAD_POOL_SIZE);
        this.failSilently = attributes.attribute(FAIL_SILENTLY);
    }

    public boolean enabled() {
        return this.enabled.get();
    }

    public int modificationQueueSize() {
        return this.modificationQueueSize.get();
    }

    @Deprecated
    public int threadPoolSize() {
        return this.threadPoolSize.get();
    }

    public boolean failSilently() {
        return this.failSilently.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AsyncStoreConfiguration [attributes=" + String.valueOf(this.attributes) + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncStoreConfiguration other = (AsyncStoreConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

