/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class AsyncStoreConfigurationBuilder<S>
extends AbstractStoreConfigurationChildBuilder<S>
implements Builder<AsyncStoreConfiguration> {
    private final AttributeSet attributes;

    AsyncStoreConfigurationBuilder(AbstractStoreConfigurationBuilder<? extends AbstractStoreConfiguration, ?> builder) {
        this(builder, AsyncStoreConfiguration.attributeDefinitionSet());
    }

    AsyncStoreConfigurationBuilder(AbstractStoreConfigurationBuilder<? extends AbstractStoreConfiguration, ?> builder, AttributeSet attributeSet) {
        super(builder);
        this.attributes = attributeSet;
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public AsyncStoreConfigurationBuilder<S> enable() {
        this.attributes.attribute(AsyncStoreConfiguration.ENABLED).set(true);
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> disable() {
        this.attributes.attribute(AsyncStoreConfiguration.ENABLED).set(false);
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> enabled(boolean enabled) {
        this.attributes.attribute(AsyncStoreConfiguration.ENABLED).set(enabled);
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> modificationQueueSize(int i) {
        this.attributes.attribute(AsyncStoreConfiguration.MODIFICATION_QUEUE_SIZE).set(i);
        return this;
    }

    @Deprecated
    public AsyncStoreConfigurationBuilder<S> threadPoolSize(int i) {
        this.attributes.attribute(AsyncStoreConfiguration.THREAD_POOL_SIZE).set(i);
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> failSilently(boolean failSilently) {
        this.attributes.attribute(AsyncStoreConfiguration.FAIL_SILENTLY).set(failSilently);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public AsyncStoreConfiguration create() {
        return new AsyncStoreConfiguration(this.attributes.protect());
    }

    @Override
    public AsyncStoreConfigurationBuilder<S> read(AsyncStoreConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "AsyncStoreConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

