/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class AuthorizationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthorizationConfiguration> {
    private final AttributeSet attributes = AuthorizationConfiguration.attributeDefinitionSet();

    public AuthorizationConfigurationBuilder(SecurityConfigurationBuilder securityBuilder) {
        super(securityBuilder);
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public AuthorizationConfigurationBuilder disable() {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(false);
        return this;
    }

    public AuthorizationConfigurationBuilder enable() {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(true);
        return this;
    }

    public AuthorizationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(AuthorizationConfiguration.ENABLED).set(enabled);
        return this;
    }

    public AuthorizationConfigurationBuilder role(String name) {
        Set roles = this.attributes.attribute(AuthorizationConfiguration.ROLES).get();
        roles.add(name);
        this.attributes.attribute(AuthorizationConfiguration.ROLES).set(roles);
        return this;
    }

    public AuthorizationConfigurationBuilder roles(String ... names) {
        for (String name : names) {
            this.role(name);
        }
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        GlobalAuthorizationConfiguration authorization = globalConfig.security().authorization();
        if (this.attributes.attribute(AuthorizationConfiguration.ENABLED).get().booleanValue() && !authorization.enabled()) {
            throw Log.CONFIG.globalSecurityAuthShouldBeEnabled();
        }
        Set cacheRoles = this.attributes.attribute(AuthorizationConfiguration.ROLES).get();
        HashSet<String> missingRoles = new HashSet<String>();
        for (String role : cacheRoles) {
            if (authorization.hasRole(role)) continue;
            missingRoles.add(role);
        }
        if (!missingRoles.isEmpty()) {
            throw Log.CONFIG.noSuchGlobalRoles(missingRoles);
        }
    }

    @Override
    public AuthorizationConfiguration create() {
        return new AuthorizationConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(AuthorizationConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "AuthorizationConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

