/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Objects;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class BackupForConfiguration
extends ConfigurationElement<BackupForConfiguration> {
    public static final AttributeDefinition<String> REMOTE_CACHE = AttributeDefinition.builder(Attribute.REMOTE_CACHE, null, String.class).immutable().build();
    public static final AttributeDefinition<String> REMOTE_SITE = AttributeDefinition.builder(Attribute.REMOTE_SITE, null, String.class).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(BackupForConfiguration.class, REMOTE_CACHE, REMOTE_SITE);
    }

    public BackupForConfiguration(AttributeSet attributes) {
        super(Element.BACKUP_FOR, attributes, new ConfigurationElement[0]);
    }

    public String remoteCache() {
        return this.attributes.attribute(REMOTE_CACHE).get();
    }

    public String remoteSite() {
        return this.attributes.attribute(REMOTE_SITE).get();
    }

    public boolean isBackupFor(String remoteSite, String remoteCache) {
        return Objects.equals(this.remoteSite(), remoteSite) && Objects.equals(this.remoteCache(), remoteCache);
    }
}

