/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.cache.L1ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class ClusteringConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements ClusteringConfigurationChildBuilder,
Builder<ClusteringConfiguration> {
    private final HashConfigurationBuilder hashConfigurationBuilder;
    private final L1ConfigurationBuilder l1ConfigurationBuilder;
    private final StateTransferConfigurationBuilder stateTransferConfigurationBuilder;
    private final PartitionHandlingConfigurationBuilder partitionHandlingConfigurationBuilder;
    final AttributeSet attributes = ClusteringConfiguration.attributeDefinitionSet();

    ClusteringConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.hashConfigurationBuilder = new HashConfigurationBuilder(this);
        this.l1ConfigurationBuilder = new L1ConfigurationBuilder(this);
        this.stateTransferConfigurationBuilder = new StateTransferConfigurationBuilder(this);
        this.partitionHandlingConfigurationBuilder = new PartitionHandlingConfigurationBuilder(this);
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public ClusteringConfigurationBuilder cacheMode(CacheMode cacheMode) {
        this.cacheType(cacheMode.cacheType());
        this.cacheSync(cacheMode.isSynchronous());
        return this;
    }

    public CacheMode cacheMode() {
        return CacheMode.of(this.attributes.attribute(ClusteringConfiguration.CACHE_TYPE).get(), this.attributes.attribute(ClusteringConfiguration.CACHE_SYNC).get());
    }

    public ClusteringConfigurationBuilder cacheType(CacheType type) {
        this.attributes.attribute(ClusteringConfiguration.CACHE_TYPE).set(type);
        return this;
    }

    public ClusteringConfigurationBuilder cacheSync(boolean sync) {
        this.attributes.attribute(ClusteringConfiguration.CACHE_SYNC).set(sync);
        return this;
    }

    public ClusteringConfigurationBuilder remoteTimeout(long l) {
        this.attributes.attribute(ClusteringConfiguration.REMOTE_TIMEOUT).set(l);
        return this;
    }

    public ClusteringConfigurationBuilder remoteTimeout(long l, TimeUnit unit) {
        return this.remoteTimeout(unit.toMillis(l));
    }

    public ClusteringConfigurationBuilder invalidationBatchSize(int size) {
        this.attributes.attribute(ClusteringConfiguration.INVALIDATION_BATCH_SIZE).set(size);
        return this;
    }

    public ClusteringConfigurationBuilder biasAcquisition(BiasAcquisition biasAcquisition) {
        this.attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).set(biasAcquisition);
        return this;
    }

    public ClusteringConfigurationBuilder biasLifespan(long l, TimeUnit unit) {
        this.attributes.attribute(ClusteringConfiguration.BIAS_LIFESPAN).set(unit.toMillis(l));
        return this;
    }

    @Override
    public HashConfigurationBuilder hash() {
        return this.hashConfigurationBuilder;
    }

    @Override
    public L1ConfigurationBuilder l1() {
        return this.l1ConfigurationBuilder;
    }

    @Override
    public StateTransferConfigurationBuilder stateTransfer() {
        return this.stateTransferConfigurationBuilder;
    }

    @Override
    public PartitionHandlingConfigurationBuilder partitionHandling() {
        return this.partitionHandlingConfigurationBuilder;
    }

    @Override
    public void validate() {
        for (Builder builder : Arrays.asList(this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder)) {
            builder.validate();
        }
        if (this.cacheMode().isScattered()) {
            if (this.hash().numOwners() != 1 && this.hash().isNumOwnersSet()) {
                throw Log.CONFIG.scatteredCacheNeedsSingleOwner();
            }
            this.hash().numOwners(1);
            TransactionMode transactionMode = this.transaction().transactionMode();
            if (transactionMode != null && transactionMode.isTransactional()) {
                throw Log.CONFIG.scatteredCacheIsNonTransactional();
            }
            if (this.attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).get() == BiasAcquisition.ON_READ) {
                throw new UnsupportedOperationException("Not implemented yet");
            }
        } else {
            if (this.attributes.attribute(ClusteringConfiguration.INVALIDATION_BATCH_SIZE).isModified()) {
                throw Log.CONFIG.invalidationBatchSizeAppliesOnNonScattered();
            }
            if (this.attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).isModified() || this.attributes.attribute(ClusteringConfiguration.BIAS_LIFESPAN).isModified()) {
                throw Log.CONFIG.biasedReadsAppliesOnlyToScattered();
            }
            if (this.hash().numOwners() == 1 && this.partitionHandling().whenSplit() != PartitionHandling.ALLOW_READ_WRITES) {
                throw Log.CONFIG.singleOwnerNotSetToAllowReadWrites();
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.cacheMode().isClustered() && globalConfig.transport().transport() == null && !this.builder.template()) {
            throw Log.CONFIG.missingTransportConfiguration();
        }
        for (ConfigurationChildBuilder configurationChildBuilder : Arrays.asList(this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder)) {
            configurationChildBuilder.validate(globalConfig);
        }
    }

    @Override
    public ClusteringConfiguration create() {
        return new ClusteringConfiguration(this.attributes.protect(), this.hashConfigurationBuilder.create(), this.l1ConfigurationBuilder.create(), this.stateTransferConfigurationBuilder.create(), this.partitionHandlingConfigurationBuilder.create());
    }

    public ClusteringConfigurationBuilder read(ClusteringConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.hashConfigurationBuilder.read(template.hash(), combine);
        this.l1ConfigurationBuilder.read(template.l1(), combine);
        this.stateTransferConfigurationBuilder.read(template.stateTransfer(), combine);
        this.partitionHandlingConfigurationBuilder.read(template.partitionHandling(), combine);
        return this;
    }

    public String toString() {
        return "ClusteringConfigurationBuilder [hashConfigurationBuilder=" + String.valueOf(this.hashConfigurationBuilder) + ", l1ConfigurationBuilder=" + String.valueOf(this.l1ConfigurationBuilder) + ", stateTransferConfigurationBuilder=" + String.valueOf(this.stateTransferConfigurationBuilder) + ", partitionHandlingConfigurationBuilder=" + String.valueOf(this.partitionHandlingConfigurationBuilder) + ", attributes=" + String.valueOf(this.attributes) + "]";
    }
}

