/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.QueryConfiguration;
import org.infinispan.configuration.cache.SecurityConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.StatisticsConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.UnsafeConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ParserRegistry;

public class Configuration
extends ConfigurationElement<Configuration>
implements BasicConfiguration {
    public static final AttributeDefinition<String> CONFIGURATION = AttributeDefinition.builder(Attribute.CONFIGURATION, null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> SIMPLE_CACHE = AttributeDefinition.builder(Attribute.SIMPLE_CACHE, Boolean.valueOf(false)).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> simpleCache;
    private final ClusteringConfiguration clusteringConfiguration;
    private final CustomInterceptorsConfiguration customInterceptorsConfiguration;
    private final EncodingConfiguration encodingConfiguration;
    private final ExpirationConfiguration expirationConfiguration;
    private final IndexingConfiguration indexingConfiguration;
    private final InvocationBatchingConfiguration invocationBatchingConfiguration;
    private final LockingConfiguration lockingConfiguration;
    private final MemoryConfiguration memoryConfiguration;
    private final Map<Class<?>, ?> moduleConfiguration;
    private final PersistenceConfiguration persistenceConfiguration;
    private final QueryConfiguration queryConfiguration;
    private final SecurityConfiguration securityConfiguration;
    private final SitesConfiguration sitesConfiguration;
    private final StatisticsConfiguration statisticsConfiguration;
    private final TransactionConfiguration transactionConfiguration;
    private final UnsafeConfiguration unsafeConfiguration;
    private final boolean template;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(Configuration.class, CONFIGURATION, SIMPLE_CACHE);
    }

    Configuration(boolean template, AttributeSet attributes, ClusteringConfiguration clusteringConfiguration, CustomInterceptorsConfiguration customInterceptorsConfiguration, ExpirationConfiguration expirationConfiguration, EncodingConfiguration encodingConfiguration, QueryConfiguration queryConfiguration, IndexingConfiguration indexingConfiguration, InvocationBatchingConfiguration invocationBatchingConfiguration, StatisticsConfiguration statisticsConfiguration, PersistenceConfiguration persistenceConfiguration, LockingConfiguration lockingConfiguration, SecurityConfiguration securityConfiguration, TransactionConfiguration transactionConfiguration, UnsafeConfiguration unsafeConfiguration, SitesConfiguration sitesConfiguration, MemoryConfiguration memoryConfiguration, List<?> modules) {
        super(clusteringConfiguration.cacheMode().toElement(template), attributes, clusteringConfiguration, expirationConfiguration, encodingConfiguration, queryConfiguration, indexingConfiguration, statisticsConfiguration, lockingConfiguration, transactionConfiguration, unsafeConfiguration, sitesConfiguration, memoryConfiguration);
        this.template = template;
        this.simpleCache = attributes.attribute(SIMPLE_CACHE);
        this.clusteringConfiguration = clusteringConfiguration;
        this.customInterceptorsConfiguration = customInterceptorsConfiguration;
        this.encodingConfiguration = encodingConfiguration;
        this.expirationConfiguration = expirationConfiguration;
        this.queryConfiguration = queryConfiguration;
        this.indexingConfiguration = indexingConfiguration;
        this.invocationBatchingConfiguration = invocationBatchingConfiguration;
        this.statisticsConfiguration = statisticsConfiguration;
        this.persistenceConfiguration = persistenceConfiguration;
        this.lockingConfiguration = lockingConfiguration;
        this.transactionConfiguration = transactionConfiguration;
        this.unsafeConfiguration = unsafeConfiguration;
        this.securityConfiguration = securityConfiguration;
        this.sitesConfiguration = sitesConfiguration;
        this.memoryConfiguration = memoryConfiguration;
        HashMap modulesMap = new HashMap();
        for (Object module : modules) {
            modulesMap.put(module.getClass(), module);
        }
        this.moduleConfiguration = Collections.unmodifiableMap(modulesMap);
    }

    public boolean simpleCache() {
        return this.simpleCache.get();
    }

    public ClusteringConfiguration clustering() {
        return this.clusteringConfiguration;
    }

    @Deprecated
    public CustomInterceptorsConfiguration customInterceptors() {
        return this.customInterceptorsConfiguration;
    }

    public EncodingConfiguration encoding() {
        return this.encodingConfiguration;
    }

    public ExpirationConfiguration expiration() {
        return this.expirationConfiguration;
    }

    public QueryConfiguration query() {
        return this.queryConfiguration;
    }

    public IndexingConfiguration indexing() {
        return this.indexingConfiguration;
    }

    public InvocationBatchingConfiguration invocationBatching() {
        return this.invocationBatchingConfiguration;
    }

    public StatisticsConfiguration statistics() {
        return this.statisticsConfiguration;
    }

    @Deprecated
    public JMXStatisticsConfiguration jmxStatistics() {
        return this.statistics();
    }

    public PersistenceConfiguration persistence() {
        return this.persistenceConfiguration;
    }

    public LockingConfiguration locking() {
        return this.lockingConfiguration;
    }

    public MemoryConfiguration memory() {
        return this.memoryConfiguration;
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.moduleConfiguration.get(moduleClass);
    }

    public Map<Class<?>, ?> modules() {
        return this.moduleConfiguration;
    }

    public TransactionConfiguration transaction() {
        return this.transactionConfiguration;
    }

    public UnsafeConfiguration unsafe() {
        return this.unsafeConfiguration;
    }

    public SecurityConfiguration security() {
        return this.securityConfiguration;
    }

    public SitesConfiguration sites() {
        return this.sitesConfiguration;
    }

    public boolean isTemplate() {
        return this.template;
    }

    @Override
    public String toString() {
        return "Configuration{simpleCache=" + String.valueOf(this.simpleCache.get()) + ", clustering=" + String.valueOf(this.clusteringConfiguration) + ", customInterceptors=" + String.valueOf(this.customInterceptorsConfiguration) + ", encoding=" + String.valueOf(this.encodingConfiguration) + ", expiration=" + String.valueOf(this.expirationConfiguration) + ", query=" + String.valueOf(this.queryConfiguration) + ", indexing=" + String.valueOf(this.indexingConfiguration) + ", invocationBatching=" + String.valueOf(this.invocationBatchingConfiguration) + ", locking=" + String.valueOf(this.lockingConfiguration) + ", memory=" + String.valueOf(this.memoryConfiguration) + ", modules=" + String.valueOf(this.moduleConfiguration) + ", persistence=" + String.valueOf(this.persistenceConfiguration) + ", security=" + String.valueOf(this.securityConfiguration) + ", sites=" + String.valueOf(this.sitesConfiguration) + ", statistics=" + String.valueOf(this.statisticsConfiguration) + ", transaction=" + String.valueOf(this.transactionConfiguration) + ", unsafe=" + String.valueOf(this.unsafeConfiguration) + ", template=" + this.template + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.template == that.template && Objects.equals(this.simpleCache.get(), that.simpleCache.get()) && Objects.equals(this.clusteringConfiguration, that.clusteringConfiguration) && Objects.equals(this.customInterceptorsConfiguration, that.customInterceptorsConfiguration) && Objects.equals(this.encodingConfiguration, that.encodingConfiguration) && Objects.equals(this.expirationConfiguration, that.expirationConfiguration) && Objects.equals(this.indexingConfiguration, that.indexingConfiguration) && Objects.equals(this.invocationBatchingConfiguration, that.invocationBatchingConfiguration) && Objects.equals(this.lockingConfiguration, that.lockingConfiguration) && Objects.equals(this.memoryConfiguration, that.memoryConfiguration) && Objects.equals(this.moduleConfiguration, that.moduleConfiguration) && Objects.equals(this.persistenceConfiguration, that.persistenceConfiguration) && Objects.equals(this.queryConfiguration, that.queryConfiguration) && Objects.equals(this.securityConfiguration, that.securityConfiguration) && Objects.equals(this.sitesConfiguration, that.sitesConfiguration) && Objects.equals(this.statisticsConfiguration, that.statisticsConfiguration) && Objects.equals(this.transactionConfiguration, that.transactionConfiguration) && Objects.equals(this.unsafeConfiguration, that.unsafeConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.simpleCache.get(), this.clusteringConfiguration, this.customInterceptorsConfiguration, this.encodingConfiguration, this.expirationConfiguration, this.indexingConfiguration, this.invocationBatchingConfiguration, this.lockingConfiguration, this.memoryConfiguration, this.moduleConfiguration, this.persistenceConfiguration, this.queryConfiguration, this.securityConfiguration, this.sitesConfiguration, this.statisticsConfiguration, this.transactionConfiguration, this.unsafeConfiguration, this.template);
    }

    @Override
    public boolean matches(Configuration other) {
        if (!this.simpleCache.get().equals(other.simpleCache.get())) {
            return false;
        }
        if (!this.clusteringConfiguration.matches(other.clusteringConfiguration)) {
            return false;
        }
        if (!this.customInterceptorsConfiguration.matches(other.customInterceptorsConfiguration)) {
            return false;
        }
        if (!this.encodingConfiguration.matches(other.encodingConfiguration)) {
            return false;
        }
        if (!this.expirationConfiguration.matches(other.expirationConfiguration)) {
            return false;
        }
        if (!this.indexingConfiguration.matches(other.indexingConfiguration)) {
            return false;
        }
        if (!this.invocationBatchingConfiguration.matches(other.invocationBatchingConfiguration)) {
            return false;
        }
        if (!this.lockingConfiguration.matches(other.lockingConfiguration)) {
            return false;
        }
        if (!this.memoryConfiguration.matches(other.memoryConfiguration)) {
            return false;
        }
        if (!this.persistenceConfiguration.matches(other.persistenceConfiguration)) {
            return false;
        }
        if (!this.queryConfiguration.matches(other.queryConfiguration)) {
            return false;
        }
        if (!this.securityConfiguration.matches(other.securityConfiguration)) {
            return false;
        }
        if (!this.sitesConfiguration.matches(other.sitesConfiguration)) {
            return false;
        }
        if (!this.statisticsConfiguration.matches(other.statisticsConfiguration)) {
            return false;
        }
        if (!this.transactionConfiguration.matches(other.transactionConfiguration)) {
            return false;
        }
        if (!this.unsafeConfiguration.matches(other.unsafeConfiguration)) {
            return false;
        }
        for (Map.Entry<Class<?>, ?> module : this.moduleConfiguration.entrySet()) {
            if (!other.moduleConfiguration.containsKey(module.getKey())) {
                return false;
            }
            Object thisModule = module.getValue();
            Object thatModule = other.moduleConfiguration.get(module.getKey());
            if (thisModule instanceof Matchable && !((Matchable)thisModule).matches(thatModule)) {
                return false;
            }
            if (thisModule.equals(thatModule)) continue;
            return false;
        }
        return this.attributes.matches(other.attributes);
    }

    @Override
    public String toStringConfiguration(String name) {
        ParserRegistry reg = new ParserRegistry();
        return reg.serialize(name, this);
    }
}

