/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractIndexingConfigurationChildBuilder;
import org.infinispan.configuration.cache.IndexMergeConfiguration;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;

public class IndexMergeConfigurationBuilder
extends AbstractIndexingConfigurationChildBuilder
implements Builder<IndexMergeConfiguration> {
    private final AttributeSet attributes = IndexMergeConfiguration.attributeDefinitionSet();
    private final Attribute<Integer> maxEntries = this.attributes.attribute(IndexMergeConfiguration.MAX_ENTRIES);
    private final Attribute<Integer> factor = this.attributes.attribute(IndexMergeConfiguration.FACTOR);
    private final Attribute<Integer> minSize = this.attributes.attribute(IndexMergeConfiguration.MIN_SIZE);
    private final Attribute<Integer> maxSize = this.attributes.attribute(IndexMergeConfiguration.MAX_SIZE);
    private final Attribute<Integer> maxForceSize = this.attributes.attribute(IndexMergeConfiguration.MAX_FORCED_SIZE);
    private final Attribute<Boolean> calibrateByDeletes = this.attributes.attribute(IndexMergeConfiguration.CALIBRATE_BY_DELETES);

    IndexMergeConfigurationBuilder(IndexingConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexMergeConfigurationBuilder maxEntries(int value) {
        this.maxEntries.set(value);
        return this;
    }

    public IndexMergeConfigurationBuilder factor(int value) {
        this.factor.set(value);
        return this;
    }

    public Integer factor() {
        return this.factor.get();
    }

    public IndexMergeConfigurationBuilder minSize(int value) {
        this.minSize.set(value);
        return this;
    }

    public Integer minSize() {
        return this.minSize.get();
    }

    public IndexMergeConfigurationBuilder maxSize(int value) {
        this.maxSize.set(value);
        return this;
    }

    public IndexMergeConfigurationBuilder maxForcedSize(int value) {
        this.maxForceSize.set(value);
        return this;
    }

    public IndexMergeConfigurationBuilder calibrateByDeletes(boolean value) {
        this.calibrateByDeletes.set(value);
        return this;
    }

    @Override
    public IndexMergeConfiguration create() {
        return new IndexMergeConfiguration(this.attributes.protect());
    }

    public IndexMergeConfigurationBuilder read(IndexMergeConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }
}

