/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.CollectionAttributeCopier;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexReaderConfiguration;
import org.infinispan.configuration.cache.IndexStartupMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class IndexingConfiguration
extends ConfigurationElement<IndexingConfiguration> {
    @Deprecated
    public static final AttributeDefinition<Index> INDEX = AttributeDefinition.builder(Attribute.INDEX, null, Index.class).immutable().build();
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder(Attribute.ENABLED, Boolean.valueOf(false)).immutable().build();
    @Deprecated
    public static final AttributeDefinition<Boolean> AUTO_CONFIG = AttributeDefinition.builder(Attribute.AUTO_CONFIG, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<Map<Class<?>, Class<?>>> KEY_TRANSFORMERS = AttributeDefinition.builder(Element.KEY_TRANSFORMERS, null, Map.class).copier(CollectionAttributeCopier.collectionCopier()).initializer(HashMap::new).immutable().build();
    public static final AttributeDefinition<Set<String>> INDEXED_ENTITIES = AttributeDefinition.builder(Element.INDEXED_ENTITIES, null, Set.class).copier(CollectionAttributeCopier.collectionCopier()).initializer(HashSet::new).build();
    public static final AttributeDefinition<IndexStorage> STORAGE = AttributeDefinition.builder(Attribute.STORAGE, IndexStorage.FILESYSTEM).immutable().build();
    public static final AttributeDefinition<IndexStartupMode> STARTUP_MODE = AttributeDefinition.builder(Attribute.STARTUP_MODE, IndexStartupMode.NONE).immutable().build();
    public static final AttributeDefinition<String> PATH = AttributeDefinition.builder(Attribute.PATH, null, String.class).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<TypedProperties> properties;
    private final Set<Class<?>> resolvedIndexedClasses;
    private final IndexReaderConfiguration readerConfiguration;
    private final IndexWriterConfiguration writerConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(IndexingConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), INDEX, AUTO_CONFIG, KEY_TRANSFORMERS, INDEXED_ENTITIES, ENABLED, STORAGE, STARTUP_MODE, PATH);
    }

    IndexingConfiguration(AttributeSet attributes, Set<Class<?>> resolvedIndexedClasses, IndexReaderConfiguration readerConfiguration, IndexWriterConfiguration writerConfiguration) {
        super(Element.INDEXING, attributes, new ConfigurationElement[0]);
        this.readerConfiguration = readerConfiguration;
        this.writerConfiguration = writerConfiguration;
        this.resolvedIndexedClasses = resolvedIndexedClasses;
        this.properties = this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES);
        if (this.properties.isModified()) {
            this.properties.set(Immutables.immutableTypedProperties(this.properties.get()));
        }
    }

    @Deprecated
    public TypedProperties properties() {
        return this.properties.get();
    }

    @Deprecated
    public Index index() {
        return this.attributes.attribute(INDEX).get();
    }

    public boolean enabled() {
        return this.attributes.attribute(ENABLED).get();
    }

    @Deprecated
    public boolean autoConfig() {
        return this.attributes.attribute(AUTO_CONFIG).get();
    }

    public IndexStorage storage() {
        return this.attributes.attribute(STORAGE).get();
    }

    public IndexStartupMode startupMode() {
        return this.attributes.attribute(STARTUP_MODE).get();
    }

    public String path() {
        return this.attributes.attribute(PATH).get();
    }

    public Map<Class<?>, Class<?>> keyTransformers() {
        return this.attributes.attribute(KEY_TRANSFORMERS).get();
    }

    @Deprecated
    public Set<Class<?>> indexedEntities() {
        return this.resolvedIndexedClasses;
    }

    public Set<String> indexedEntityTypes() {
        return this.attributes.attribute(INDEXED_ENTITIES).get();
    }

    @Deprecated
    public final boolean indexShareable() {
        return false;
    }

    public IndexReaderConfiguration reader() {
        return this.readerConfiguration;
    }

    public IndexWriterConfiguration writer() {
        return this.writerConfiguration;
    }

    public boolean isVolatile() {
        return this.attributes.attribute(STORAGE).get().equals((Object)IndexStorage.LOCAL_HEAP);
    }

    @Override
    public String toString() {
        return this.attributes.toString(null) + ", reader=" + String.valueOf(this.readerConfiguration) + ", writer=" + String.valueOf(this.writerConfiguration);
    }
}

