/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.concurrent.IsolationLevel;

public class LockingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<LockingConfiguration> {
    private final AttributeSet attributes = LockingConfiguration.attributeDefinitionSet();

    protected LockingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public LockingConfigurationBuilder concurrencyLevel(int i) {
        this.attributes.attribute(LockingConfiguration.CONCURRENCY_LEVEL).set(i);
        return this;
    }

    public LockingConfigurationBuilder isolationLevel(IsolationLevel isolationLevel) {
        this.attributes.attribute(LockingConfiguration.ISOLATION_LEVEL).set(isolationLevel);
        return this;
    }

    public IsolationLevel isolationLevel() {
        return this.attributes.attribute(LockingConfiguration.ISOLATION_LEVEL).get();
    }

    public LockingConfigurationBuilder lockAcquisitionTimeout(long l) {
        this.attributes.attribute(LockingConfiguration.LOCK_ACQUISITION_TIMEOUT).set(l);
        return this;
    }

    public LockingConfigurationBuilder lockAcquisitionTimeout(long l, TimeUnit unit) {
        return this.lockAcquisitionTimeout(unit.toMillis(l));
    }

    public LockingConfigurationBuilder useLockStriping(boolean b) {
        this.attributes.attribute(LockingConfiguration.USE_LOCK_STRIPING).set(b);
        return this;
    }

    @Override
    public void validate() {
        Attribute<IsolationLevel> isolationLevel = this.attributes.attribute(LockingConfiguration.ISOLATION_LEVEL);
        if (this.getBuilder().clustering().cacheMode().isClustered() && isolationLevel.get() == IsolationLevel.NONE) {
            isolationLevel.set(IsolationLevel.READ_COMMITTED);
        }
        if (isolationLevel.get() == IsolationLevel.READ_UNCOMMITTED) {
            isolationLevel.set(IsolationLevel.READ_COMMITTED);
        }
        if (isolationLevel.get() == IsolationLevel.SERIALIZABLE) {
            isolationLevel.set(IsolationLevel.REPEATABLE_READ);
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public LockingConfiguration create() {
        return new LockingConfiguration(this.attributes.protect());
    }

    public LockingConfigurationBuilder read(LockingConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.attributes) + "]";
    }
}

