/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class MemoryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<MemoryConfiguration> {
    private MemoryStorageConfigurationBuilder legacyBuilder;
    private final AttributeSet attributes;
    private final List<String> legacyAttributesUsed = new ArrayList<String>();
    private boolean newAttributesUsed = false;
    private boolean isInListener = false;

    MemoryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.legacyBuilder = new MemoryStorageConfigurationBuilder(builder);
        this.attributes = MemoryConfiguration.attributeDefinitionSet();
        this.attributes.attribute(MemoryConfiguration.STORAGE).addListener(this.nonReentrantListener((attribute, oldValue) -> this.memoryStorageAttribute(MemoryStorageConfiguration.STORAGE_TYPE).set((StorageType)((Object)((Object)attribute.get())))));
        this.attributes.attribute(MemoryConfiguration.WHEN_FULL).addListener(this.nonReentrantListener((attribute, oldValue) -> this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_STRATEGY).set((EvictionStrategy)((Object)((Object)attribute.get())))));
        this.attributes.attribute(MemoryConfiguration.MAX_COUNT).addListener(this.nonReentrantListener((attribute, oldValue) -> this.updateMaxCount((Long)attribute.get())));
        this.attributes.attribute(MemoryConfiguration.MAX_SIZE).addListener(this.nonReentrantListener((attribute, oldValue) -> this.updateMaxSize((String)attribute.get())));
        this.memoryStorageAttribute(MemoryStorageConfiguration.STORAGE_TYPE).addListener(this.nonReentrantListener((attribute, oldValue) -> this.attributes.attribute(MemoryConfiguration.STORAGE).set((StorageType)((Object)((Object)attribute.get())))));
        this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_STRATEGY).addListener(this.nonReentrantListener((attribute, oldValue) -> this.attributes.attribute(MemoryConfiguration.WHEN_FULL).set((EvictionStrategy)((Object)((Object)attribute.get())))));
        this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE).addListener(this.nonReentrantListener((attribute, oldValue) -> {
            long size = this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).get();
            if (size == -1L) {
                return;
            }
            this.updateLegacySize((EvictionType)((Object)((Object)attribute.get())), size);
        }));
        this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).addListener(this.nonReentrantListener((attribute, oldValue) -> {
            EvictionType evictionType = this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE).get();
            this.updateLegacySize(evictionType, (Long)attribute.get());
        }));
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    @Deprecated
    public MemoryStorageConfigurationBuilder legacyBuilder() {
        return this.legacyBuilder;
    }

    private <T> AttributeListener<T> nonReentrantListener(AttributeListener<T> listener) {
        return (attribute, oldValue) -> {
            if (this.isInListener) {
                return;
            }
            this.isInListener = true;
            try {
                listener.attributeChanged(attribute, oldValue);
            }
            finally {
                this.isInListener = false;
            }
        };
    }

    @Deprecated
    public MemoryConfigurationBuilder storageType(StorageType storageType) {
        return this.storage(storageType);
    }

    public MemoryConfigurationBuilder storage(StorageType storageType) {
        this.attributes.attribute(MemoryConfiguration.STORAGE).set(storageType);
        return this;
    }

    public MemoryConfigurationBuilder maxSize(String size) {
        this.newAttributesUsed = true;
        this.attributes.attribute(MemoryConfiguration.MAX_SIZE).set(size);
        return this;
    }

    public String maxSize() {
        return this.attributes.attribute(MemoryConfiguration.MAX_SIZE).get();
    }

    public MemoryConfigurationBuilder maxCount(long count) {
        this.newAttributesUsed = true;
        this.attributes.attribute(MemoryConfiguration.MAX_COUNT).set(count);
        return this;
    }

    public long maxCount() {
        return this.attributes.attribute(MemoryConfiguration.MAX_COUNT).get();
    }

    @Deprecated
    public StorageType storageType() {
        return this.storage();
    }

    public StorageType storage() {
        return this.attributes.attribute(MemoryConfiguration.STORAGE).get();
    }

    @Deprecated
    public MemoryConfigurationBuilder size(long size) {
        this.legacyAttributesUsed.add(MemoryStorageConfiguration.SIZE.name());
        this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).set(size);
        return this;
    }

    @Deprecated
    public long size() {
        return this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).get();
    }

    @Deprecated
    public MemoryConfigurationBuilder evictionType(EvictionType type) {
        this.legacyAttributesUsed.add(MemoryStorageConfiguration.EVICTION_TYPE.name());
        this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE).set(type);
        return this;
    }

    private <T> Attribute<T> memoryStorageAttribute(AttributeDefinition<T> attributeDefinition) {
        return this.legacyBuilder.attributes.attribute(attributeDefinition);
    }

    @Deprecated
    public EvictionType evictionType() {
        return this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE).get();
    }

    @Deprecated
    public MemoryConfigurationBuilder evictionStrategy(EvictionStrategy strategy) {
        return this.whenFull(strategy);
    }

    public MemoryConfigurationBuilder whenFull(EvictionStrategy strategy) {
        this.attributes.attribute(MemoryConfiguration.WHEN_FULL).set(strategy);
        return this;
    }

    public EvictionStrategy whenFull() {
        return this.attributes.attribute(MemoryConfiguration.WHEN_FULL).get();
    }

    @Deprecated
    public EvictionStrategy evictionStrategy() {
        return this.whenFull();
    }

    boolean isSizeBounded() {
        return this.maxSize() != null;
    }

    boolean isCountBounded() {
        return this.maxCount() > 0L;
    }

    private void checkBinaryRequirement() {
        boolean storageBinary;
        if (!this.storageType().canStoreReferences() && this.getBuilder().clustering().hash().groups().isEnabled()) {
            throw Log.CONFIG.groupingOnlyCompatibleWithObjectStorage(this.encoding().key().mediaType(), this.encoding().value().mediaType());
        }
        boolean bl = storageBinary = this.encoding().isStorageBinary() || !this.storageType().canStoreReferences();
        if (this.isSizeBounded() && !storageBinary) {
            throw Log.CONFIG.offHeapMemoryEvictionNotSupportedWithObject();
        }
    }

    @Override
    public void validate() {
        if (this.newAttributesUsed && !this.legacyAttributesUsed.isEmpty()) {
            throw Log.CONFIG.cannotUseDeprecatedAndReplacement(this.legacyAttributesUsed.toString());
        }
        if (this.isSizeBounded() && this.isCountBounded()) {
            throw Log.CONFIG.cannotProvideBothSizeAndCount();
        }
        EvictionStrategy strategy = this.evictionStrategy();
        if (strategy.isEnabled()) {
            TransactionConfigurationBuilder transactionConfiguration;
            TransactionMode transactionMode;
            if (!this.isCountBounded() && !this.isSizeBounded()) {
                throw Log.CONFIG.invalidEvictionSize();
            }
            if (strategy.isExceptionBased() && ((transactionMode = (transactionConfiguration = this.getBuilder().transaction()).transactionMode()) == null || !transactionMode.isTransactional() || transactionConfiguration.useSynchronization() || transactionConfiguration.use1PcForAutoCommitTransactions())) {
                throw Log.CONFIG.exceptionBasedEvictionOnlySupportedInTransactionalCaches();
            }
        } else if (this.getBuilder().persistence().passivation() && strategy != EvictionStrategy.MANUAL && !this.getBuilder().template() && !this.isSizeBounded() && !this.isCountBounded()) {
            Log.CONFIG.passivationWithoutEviction();
        }
        this.checkBinaryRequirement();
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public MemoryConfiguration create() {
        Attribute<EvictionStrategy> whenFull = this.attributes.attribute(MemoryConfiguration.WHEN_FULL);
        if (!whenFull.get().isEnabled() && (this.isSizeBounded() || this.isCountBounded())) {
            whenFull.setImplied(EvictionStrategy.REMOVE);
            if (this.isCountBounded()) {
                Log.CONFIG.debugf("Max entries configured (%d) without eviction strategy. Eviction strategy overridden to %s", this.maxCount(), (Object)whenFull.get());
            } else {
                Log.CONFIG.debugf("Max size configured (%s) without eviction strategy. Eviction strategy overridden to %s", (Object)this.maxSize(), (Object)whenFull.get());
            }
        }
        return new MemoryConfiguration(this.attributes.protect(), this.legacyBuilder.create());
    }

    public MemoryConfigurationBuilder read(MemoryConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        if (this.attributes.attribute(MemoryConfiguration.STORAGE).isModified()) {
            this.memoryStorageAttribute(MemoryStorageConfiguration.STORAGE_TYPE).set(this.storage());
        }
        if (this.attributes.attribute(MemoryConfiguration.WHEN_FULL).isModified()) {
            this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_STRATEGY).set(this.whenFull());
        }
        if (this.attributes.attribute(MemoryConfiguration.MAX_COUNT).isModified()) {
            this.updateMaxCount(this.maxCount());
        }
        if (this.attributes.attribute(MemoryConfiguration.MAX_SIZE).isModified()) {
            this.updateMaxSize(this.maxSize());
        }
        return this;
    }

    private void updateMaxSize(String maxSize) {
        Attribute<EvictionType> evictionTypeAttribute = this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE);
        if (maxSize != null && evictionTypeAttribute.get() != EvictionType.MEMORY) {
            evictionTypeAttribute.set(EvictionType.MEMORY);
        }
        if (maxSize != null || this.maxCount() == -1L) {
            long maxSizeBytes = MemoryConfiguration.maxSizeToBytes(maxSize);
            this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).set(maxSizeBytes);
        }
    }

    private void updateMaxCount(long maxCount) {
        Attribute<EvictionType> evictionTypeAttribute = this.memoryStorageAttribute(MemoryStorageConfiguration.EVICTION_TYPE);
        if (maxCount != -1L && evictionTypeAttribute.get() != EvictionType.COUNT) {
            evictionTypeAttribute.set(EvictionType.COUNT);
        }
        if (maxCount != -1L || this.maxSize() == null) {
            this.memoryStorageAttribute(MemoryStorageConfiguration.SIZE).set(maxCount);
        }
    }

    private void updateLegacySize(EvictionType type, Long size) {
        switch (type) {
            case COUNT: {
                if (this.attributes.attribute(MemoryConfiguration.MAX_SIZE).get() != null) {
                    this.attributes.attribute(MemoryConfiguration.MAX_SIZE).reset();
                }
                this.attributes.attribute(MemoryConfiguration.MAX_COUNT).set(size);
                break;
            }
            case MEMORY: {
                String maxSize;
                long maxSizeBytes;
                if (this.attributes.attribute(MemoryConfiguration.MAX_COUNT).get() != -1L) {
                    this.attributes.attribute(MemoryConfiguration.MAX_COUNT).reset();
                }
                if ((maxSizeBytes = MemoryConfiguration.maxSizeToBytes(maxSize = this.attributes.attribute(MemoryConfiguration.MAX_SIZE).get())) == size) break;
                this.attributes.attribute(MemoryConfiguration.MAX_SIZE).set(String.valueOf(size));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String toString() {
        return "MemoryConfigurationBuilder{memoryStorageConfigurationBuilder=" + String.valueOf(this.legacyBuilder) + ", attributes=" + String.valueOf(this.attributes) + "}";
    }
}

