/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.util.logging.Log;

public class SingleFileStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<SingleFileStoreConfiguration, SingleFileStoreConfigurationBuilder> {
    public SingleFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        this(builder, SingleFileStoreConfiguration.attributeDefinitionSet());
    }

    public SingleFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributeSet) {
        super(builder, attributeSet);
    }

    @Override
    public SingleFileStoreConfigurationBuilder self() {
        return this;
    }

    public SingleFileStoreConfigurationBuilder location(String location) {
        this.attributes.attribute(SingleFileStoreConfiguration.LOCATION).set(location);
        return this;
    }

    @Deprecated
    public SingleFileStoreConfigurationBuilder maxEntries(int maxEntries) {
        this.attributes.attribute(SingleFileStoreConfiguration.MAX_ENTRIES).set(maxEntries);
        return this;
    }

    public SingleFileStoreConfigurationBuilder fragmentationFactor(float fragmentationFactor) {
        this.attributes.attribute(SingleFileStoreConfiguration.FRAGMENTATION_FACTOR).set(Float.valueOf(fragmentationFactor));
        return this;
    }

    @Override
    public void validate() {
        Attribute<Boolean> segmentedAttribute = this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED);
        Attribute<Integer> maxEntriesAttribute = this.attributes.attribute(SingleFileStoreConfiguration.MAX_ENTRIES);
        if (segmentedAttribute.get().booleanValue() && maxEntriesAttribute.get() > 0) {
            throw Log.CONFIG.segmentedSingleFileStoreDoesNotSupportMaxEntries();
        }
        super.validate();
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        PersistenceUtil.validateGlobalStateStoreLocation(globalConfig, SingleFileStore.class.getSimpleName(), this.attributes.attribute(SingleFileStoreConfiguration.LOCATION));
        super.validate(globalConfig);
    }

    @Override
    public SingleFileStoreConfiguration create() {
        return new SingleFileStoreConfiguration(this.attributes.protect(), this.async.create());
    }

    @Override
    public Builder<?> read(SingleFileStoreConfiguration template, Combine combine) {
        super.read(template, combine);
        return this;
    }
}

