/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeParser;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.AttributeValidator;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.infinispan.xsite.spi.XSiteMergePolicy;

public class SitesConfiguration
extends ConfigurationElement<SitesConfiguration> {
    public static final AttributeDefinition<XSiteEntryMergePolicy> MERGE_POLICY = AttributeDefinition.builder(Attribute.MERGE_POLICY, XSiteMergePolicy.DEFAULT, XSiteEntryMergePolicy.class).copier(MergePolicyAttributeUtil.INSTANCE).parser(MergePolicyAttributeUtil.INSTANCE).serializer(MergePolicyAttributeUtil.INSTANCE).immutable().build();
    public static final AttributeDefinition<Long> MAX_CLEANUP_DELAY = AttributeDefinition.builder(Attribute.MAX_CLEANUP_DELAY, Long.valueOf(30000L)).validator(AttributeValidator.greaterThanZero(Attribute.MAX_CLEANUP_DELAY)).immutable().build();
    public static final AttributeDefinition<Integer> TOMBSTONE_MAP_SIZE = AttributeDefinition.builder(Attribute.TOMBSTONE_MAP_SIZE, Integer.valueOf(512000)).validator(AttributeValidator.greaterThanZero(Attribute.TOMBSTONE_MAP_SIZE)).immutable().build();
    private final BackupForConfiguration backupFor;
    private final List<BackupConfiguration> allBackups;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SitesConfiguration.class, MERGE_POLICY, MAX_CLEANUP_DELAY, TOMBSTONE_MAP_SIZE);
    }

    public SitesConfiguration(AttributeSet attributes, List<BackupConfiguration> allBackups, BackupForConfiguration backupFor) {
        super(Element.SITES, attributes, ConfigurationElement.list(Element.BACKUPS, allBackups), backupFor);
        this.allBackups = Collections.unmodifiableList(allBackups);
        this.backupFor = backupFor;
    }

    @Deprecated
    public boolean disableBackups() {
        return false;
    }

    public List<BackupConfiguration> allBackups() {
        return this.allBackups;
    }

    public Stream<BackupConfiguration> allBackupsStream() {
        return this.allBackups.stream();
    }

    @Deprecated
    public List<BackupConfiguration> enabledBackups() {
        return this.allBackups();
    }

    @Deprecated
    public Stream<BackupConfiguration> enabledBackupStream() {
        return this.allBackupsStream();
    }

    public BackupForConfiguration backupFor() {
        return this.backupFor;
    }

    public BackupFailurePolicy getFailurePolicy(String siteName) {
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.site().equals(siteName)) continue;
            return bc.backupFailurePolicy();
        }
        throw new IllegalStateException("There must be a site configured for " + siteName);
    }

    @Deprecated
    public boolean hasInUseBackup(String siteName) {
        return this.allBackups.stream().anyMatch(bc -> bc.site().equals(siteName));
    }

    @Deprecated
    public boolean hasEnabledBackups() {
        return this.hasBackups();
    }

    public boolean hasBackups() {
        return !this.allBackups.isEmpty();
    }

    public boolean hasSyncEnabledBackups() {
        return this.allBackupsStream().anyMatch(BackupConfiguration::isSyncBackup);
    }

    public Stream<BackupConfiguration> syncBackupsStream() {
        return this.allBackupsStream().filter(BackupConfiguration::isSyncBackup);
    }

    public boolean hasAsyncEnabledBackups() {
        return this.allBackupsStream().anyMatch(BackupConfiguration::isAsyncBackup);
    }

    public Stream<BackupConfiguration> asyncBackupsStream() {
        return this.allBackupsStream().filter(BackupConfiguration::isAsyncBackup);
    }

    @Deprecated
    public Set<String> inUseBackupSites() {
        return this.allBackups.stream().map(BackupConfiguration::site).collect(Collectors.toSet());
    }

    public XSiteEntryMergePolicy<?, ?> mergePolicy() {
        return this.attributes.attribute(MERGE_POLICY).get();
    }

    public long maxTombstoneCleanupDelay() {
        return this.attributes.attribute(MAX_CLEANUP_DELAY).get();
    }

    public int tombstoneMapSize() {
        return this.attributes.attribute(TOMBSTONE_MAP_SIZE).get();
    }

    private static enum MergePolicyAttributeUtil implements AttributeCopier<XSiteEntryMergePolicy>,
    AttributeSerializer<XSiteEntryMergePolicy>,
    AttributeParser<XSiteEntryMergePolicy>
    {
        INSTANCE;


        @Override
        public XSiteEntryMergePolicy copyAttribute(XSiteEntryMergePolicy value) {
            if (value == null) {
                return null;
            }
            if (value instanceof XSiteMergePolicy) {
                return ((XSiteMergePolicy)value).getInstance();
            }
            XSiteMergePolicy enumPolicy = XSiteMergePolicy.fromInstance(value);
            return enumPolicy == null ? (XSiteEntryMergePolicy)Util.getInstance(value.getClass()) : enumPolicy.getInstance();
        }

        @Override
        public void serialize(ConfigurationWriter writer, String name, XSiteEntryMergePolicy value) {
            XSiteMergePolicy enumPolicy = XSiteMergePolicy.fromInstance(value);
            if (enumPolicy != null) {
                writer.writeAttribute(name, enumPolicy.name());
            } else {
                INSTANCE_CLASS_NAME.serialize(writer, name, value);
            }
        }

        @Override
        public XSiteEntryMergePolicy parse(Class klass, String value) {
            return XSiteMergePolicy.instanceFromString(value, null);
        }
    }
}

